/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DSA;
import oracle.security.crypto.core.DSAParams;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.fips.KeyExportException;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class DSAPrivateKey
implements PrivateKey,
ASN1Object {
    private ASN1ObjectID a = DSA.dsaKeyOID;
    private DSAParams b;
    private BigInt c;
    private boolean d = true;
    private byte[] e;
    private ASN1Integer f;

    public DSAPrivateKey() {
    }

    public DSAPrivateKey(BigInteger bigInteger, DSAParams dSAParams) {
        this(BigInt.getInstance(bigInteger), dSAParams);
    }

    DSAPrivateKey(BigInt bigInt, DSAParams dSAParams) {
        FIPS_140_2.assertReadyState();
        this.c = bigInt;
        this.b = dSAParams;
    }

    public DSAPrivateKey(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public DSAPrivateKey(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public DSAPrivateKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public DSAPrivateKey(ASN1Sequence aSN1Sequence) throws IOException {
        this(Utils.toStream(aSN1Sequence));
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public void erase() {
        this.b = null;
        if (this.c != null) {
            this.c.erase();
            this.c = null;
        }
        this.d();
    }

    private void d() {
        if (this.e != null) {
            Utils.setArray(this.e, (byte)0);
            this.e = null;
        }
        if (this.f != null) {
            this.f.erase();
            this.f = null;
        }
    }

    public void finalize() {
        this.erase();
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        DSAPrivateKey dSAPrivateKey = new DSAPrivateKey();
        try {
            if (this.a != null) {
                dSAPrivateKey.a = new ASN1ObjectID(Utils.toStream(this.a));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        try {
            if (this.b != null) {
                dSAPrivateKey.b = new DSAParams(Utils.toStream(this.b));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key DSA parameters to stream");
        }
        if (this.c != null) {
            dSAPrivateKey.c = BigInt.getInstance(this.c);
        }
        dSAPrivateKey.d = this.d;
        return dSAPrivateKey;
    }

    public int getBitLength() {
        FIPS_140_2.assertReadyState();
        if (this.b == null || this.b.getP() == null) {
            return 0;
        }
        return this.b.getP().bitLength();
    }

    public byte[] getEncoded() {
        this.e();
        return (byte[])this.a().clone();
    }

    byte[] a() {
        FIPS_140_2.assertReadyState();
        if (this.e == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(0L));
            aSN1Sequence.addElement(this.getAlgID());
            aSN1Sequence.addElement(new ASN1OctetString(Utils.toBytes(this.b())));
            this.e = Utils.toBytes(aSN1Sequence);
        }
        return this.e;
    }

    public boolean getAllowExport() {
        return this.d;
    }

    public void setAllowExport(boolean bl) {
        this.d = bl;
    }

    private void e() {
        if (!this.getAllowExport() || !FIPS_140_2.getAllowKeyExport()) {
            throw new KeyExportException("Plaintext key export not allowed");
        }
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        ASN1Object aSN1Object2;
        FIPS_140_2.assertReadyState();
        this.erase();
        this.a = algorithmIdentifier.getOID();
        try {
            aSN1Object2 = algorithmIdentifier.getParameters();
            this.b = aSN1Object2 instanceof DSAParams ? (DSAParams)aSN1Object2 : new DSAParams((ASN1Sequence)algorithmIdentifier.getParameters());
        }
        catch (IOException iOException) {
            this.b = null;
        }
        catch (ClassCastException classCastException) {
            this.b = null;
        }
        if ((this.a.equals(AlgID.dsaOld.getOID()) || this.a.equals(AlgID.dsaWithSHA1.getOID()) && ((ASN1Sequence)aSN1Object).size() == 5) && this.b == null) {
            aSN1Object2 = (ASN1Sequence)aSN1Object;
            try {
                this.b = new DSAParams(((ASN1Integer)((ASN1Sequence)aSN1Object2).elementAt(0)).getValue(), ((ASN1Integer)((ASN1Sequence)aSN1Object2).elementAt(1)).getValue(), ((ASN1Integer)((ASN1Sequence)aSN1Object2).elementAt(2)).getValue());
                this.c = ((ASN1Integer)((ASN1Sequence)aSN1Object2).elementAt(3)).getBigIntValue();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new AlgorithmIdentifierException("CDSA contents invalid.");
            }
            catch (ClassCastException classCastException) {
                throw new AlgorithmIdentifierException("CDSA contents invalid.");
            }
        } else if (this.b != null) {
            try {
                this.c = ((ASN1Integer)aSN1Object).getBigIntValue();
            }
            catch (ClassCastException classCastException) {
                throw new InvalidInputException("Contents invalid.");
            }
        } else {
            throw new AlgorithmIdentifierException("DSA parameters missing.");
        }
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(this.a, this.b);
    }

    public ASN1Object getContents() {
        this.e();
        FIPS_140_2.assertReadyState();
        return new ASN1Integer(this.c);
    }

    ASN1Object b() {
        FIPS_140_2.assertReadyState();
        if (this.f == null) {
            this.f = new ASN1Integer(this.c);
        }
        return this.f;
    }

    public BigInteger getX() {
        this.e();
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.c.toByteArray());
    }

    BigInt c() {
        FIPS_140_2.assertReadyState();
        return this.c;
    }

    public void setParams(DSAParams dSAParams) {
        FIPS_140_2.assertReadyState();
        this.b = dSAParams;
        this.d();
    }

    public DSAParams getParams() {
        FIPS_140_2.assertReadyState();
        return this.b;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "params = {" + this.b + "}, bitLength = " + this.getBitLength();
    }

    public ASN1ObjectID getKeyAlgOID() {
        FIPS_140_2.assertReadyState();
        return this.a;
    }

    public void setKeyAlgOID(ASN1ObjectID aSN1ObjectID) {
        FIPS_140_2.assertReadyState();
        this.a = aSN1ObjectID;
        this.d();
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        ASN1Integer aSN1Integer = new ASN1Integer(aSN1SequenceInputStream);
        if (!aSN1Integer.equals(0)) {
            throw new VersionException(aSN1Integer.getValue(), 0);
        }
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1SequenceInputStream);
        ASN1Object aSN1Object = null;
        ASN1Object aSN1Object2 = ASN1Utils.inputASN1Object(aSN1SequenceInputStream);
        if (aSN1Object2 instanceof ASN1OctetString) {
            aSN1Object = ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(((ASN1OctetString)aSN1Object2).getValue()));
        } else if (aSN1Object2 instanceof ASN1Sequence) {
            aSN1Object = aSN1Object2;
        } else {
            throw new IOException("Invalid private key contents");
        }
        if (aSN1SequenceInputStream.hasMoreData()) {
            new ASN1GenericConstructed(aSN1SequenceInputStream);
        }
        aSN1SequenceInputStream.terminate();
        try {
            this.initialize(algorithmIdentifier, aSN1Object);
            if (aSN1Object instanceof ASN1Sequence) {
                ((ASN1Integer)((ASN1Sequence)aSN1Object).elementAt(3)).erase();
            } else {
                ((ASN1Integer)aSN1Object).erase();
            }
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    public int length() {
        return this.a().length;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

