/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DHParameterGenerator;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class DHParams
implements ASN1Object,
Externalizable {
    private BigInt a;
    private BigInt b;
    private BigInt c;
    private BigInt d;
    private byte[] e;
    private int f;
    private ASN1Sequence g;
    private static final BigInt h = BigInt.valueOf(1L);
    private static final BigInt i = BigInt.valueOf(2L);

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3));
    }

    DHParams(BigInt bigInt, BigInt bigInt2, BigInt bigInt3) {
        FIPS_140_2.assertReadyState();
        this.a = bigInt;
        this.b = bigInt2;
        this.c = bigInt3;
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3), BigInt.getInstance(bigInteger4));
    }

    DHParams(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, BigInt bigInt4) {
        this(bigInt, bigInt2, bigInt3);
        this.d = bigInt4;
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte[] byArray, int n) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3), byArray, n);
    }

    DHParams(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, byte[] byArray, int n) {
        this(bigInt, bigInt2, bigInt3);
        this.e = byArray;
        this.f = n;
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray, int n) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3), BigInt.getInstance(bigInteger4), byArray, n);
    }

    DHParams(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, BigInt bigInt4, byte[] byArray, int n) {
        this(bigInt, bigInt2, bigInt3, byArray, n);
        this.d = bigInt4;
    }

    public DHParams(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public BigInteger getP() {
        return new BigInteger(this.a().toByteArray());
    }

    BigInt a() {
        FIPS_140_2.assertReadyState();
        return this.a;
    }

    public BigInteger getQ() {
        return new BigInteger(this.b().toByteArray());
    }

    BigInt b() {
        FIPS_140_2.assertReadyState();
        return this.c;
    }

    public BigInteger getG() {
        return new BigInteger(this.c().toByteArray());
    }

    BigInt c() {
        FIPS_140_2.assertReadyState();
        return this.b;
    }

    public BigInteger getJ() {
        return new BigInteger(this.d().toByteArray());
    }

    BigInt d() {
        FIPS_140_2.assertReadyState();
        return this.d;
    }

    public byte[] getSeed() {
        FIPS_140_2.assertReadyState();
        return (byte[])this.e.clone();
    }

    public int getPGenCounter() {
        FIPS_140_2.assertReadyState();
        return this.f;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{p = ");
        stringBuffer.append(this.a);
        stringBuffer.append(", g = ");
        stringBuffer.append(this.b);
        stringBuffer.append(", q = ");
        stringBuffer.append(this.c);
        if (this.d != null) {
            stringBuffer.append(", j = ");
            stringBuffer.append(this.d);
        }
        if (this.e != null) {
            stringBuffer.append(",\nseed = ");
            stringBuffer.append(Utils.toHexString(this.e));
            stringBuffer.append(", pgenCounter = ");
            stringBuffer.append(this.f + " }");
        }
        return stringBuffer.toString();
    }

    public static boolean isValidParams(DHParams dHParams, int n, int n2) {
        if (n % 256 != 0 || n < 1024 || n2 < 160) {
            throw new IllegalArgumentException("Invalid parameters bit length: L=" + n + ", m=" + n2);
        }
        byte[] byArray = dHParams.getSeed();
        int n3 = dHParams.getPGenCounter();
        if (byArray == null) {
            throw new IllegalArgumentException("Missing validation parameters");
        }
        int n4 = (n + 1023) / 1024;
        if (n3 >= 4096 * n4 || n3 <= 0) {
            return false;
        }
        BigInt bigInt = dHParams.a();
        BigInt bigInt2 = dHParams.b();
        BigInt bigInt3 = dHParams.d();
        if (bigInt3 != null && (bigInt3.compareTo(i) < 0 || bigInt.compareTo(bigInt3.multiply(bigInt2).add(h)) != 0)) {
            return false;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException(algorithmIdentifierException.toString());
        }
        BigInt bigInt4 = DHParameterGenerator.a(byArray, n2, messageDigest);
        if (!bigInt4.isProbablePrime(100) || bigInt4.compareTo(bigInt2) != 0) {
            return false;
        }
        BigInt bigInt5 = null;
        int n5 = 0;
        while (!((bigInt5 = DHParameterGenerator.a(bigInt4, byArray, n5, n, n2, messageDigest)).compareTo(h.shiftLeft(n - 1)) > 0 && bigInt5.isProbablePrime(100) || ++n5 > n3)) {
        }
        if (n5 != n3 || bigInt5.compareTo(bigInt) != 0) {
            return false;
        }
        BigInt bigInt6 = dHParams.c();
        return bigInt6.compareTo(i) >= 0 && bigInt6.compareTo(bigInt5.subtract(i)) <= 0 && bigInt6.modPow(bigInt4, bigInt5).compareTo(h) == 0;
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.a = ASN1Integer.inputBigIntValue(aSN1SequenceInputStream);
        this.b = ASN1Integer.inputBigIntValue(aSN1SequenceInputStream);
        this.c = ASN1Integer.inputBigIntValue(aSN1SequenceInputStream);
        this.d = aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 2 ? ASN1Integer.inputBigIntValue(aSN1SequenceInputStream) : null;
        if (aSN1SequenceInputStream.hasMoreData()) {
            ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            this.e = ASN1BitString.inputValue(aSN1SequenceInputStream2);
            this.f = new ASN1Integer(aSN1SequenceInputStream2).intValue();
            aSN1SequenceInputStream2.terminate();
        } else {
            this.e = null;
            this.f = 0;
        }
        aSN1SequenceInputStream.terminate();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.e().output(outputStream);
    }

    private ASN1Sequence e() {
        FIPS_140_2.assertReadyState();
        if (this.g == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(this.a));
            aSN1Sequence.addElement(new ASN1Integer(this.b));
            aSN1Sequence.addElement(new ASN1Integer(this.c));
            if (this.d != null) {
                aSN1Sequence.addElement(new ASN1Integer(this.d));
            }
            if (this.e != null) {
                ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
                aSN1Sequence2.addElement(new ASN1BitString(this.e));
                aSN1Sequence2.addElement(new ASN1Integer(this.f));
                aSN1Sequence.addElement(aSN1Sequence2);
            }
            this.g = aSN1Sequence;
        }
        return this.g;
    }

    public int length() {
        return this.e().length();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

