/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Constructed;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;

public class ASN1Sequence
implements ASN1TaggedObject,
ASN1Constructed {
    private Vector a = new Vector();
    private ASN1Header b = null;
    private int c;

    public ASN1Sequence() {
    }

    public ASN1Sequence(ASN1Object aSN1Object) {
        this.addElement(aSN1Object);
    }

    public ASN1Sequence(Vector vector) {
        this.a = vector;
        this.c = 0;
        int n = this.a.size();
        for (int i2 = 0; i2 < n; ++i2) {
            this.c += ((ASN1Object)this.a.elementAt(i2)).length();
        }
    }

    public ASN1Sequence(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1Header getHeader() {
        if (this.b == null) {
            this.b = ASN1Sequence.makeHeader(this.c);
        }
        return this.b;
    }

    public Vector elements() {
        return this.a;
    }

    public int size() {
        return this.a.size();
    }

    public ASN1Object elementAt(int n) {
        return (ASN1Object)this.a.elementAt(n);
    }

    public ASN1Object firstElement() {
        return (ASN1Object)this.a.firstElement();
    }

    public ASN1Object lastElement() {
        return (ASN1Object)this.a.lastElement();
    }

    public void addElement(ASN1Object aSN1Object) {
        this.a.addElement(aSN1Object);
        this.c += aSN1Object.length();
        this.b = null;
    }

    public static ASN1Header makeHeader(int n) {
        return new ASN1Header(16, 0, 1, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SEQUENCE {");
        int n = this.a.size();
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(this.a.elementAt(i2).toString());
            if (i2 == this.a.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.a = new Vector();
        this.c = 0;
        while (aSN1SequenceInputStream.hasMoreData()) {
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(aSN1SequenceInputStream);
            this.a.addElement(aSN1Object);
            this.c += aSN1Object.length();
        }
        aSN1SequenceInputStream.terminate();
        this.b = null;
    }

    public int length() {
        return this.getHeader().totalLength();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.getHeader().output(outputStream);
        int n = this.a.size();
        for (int i2 = 0; i2 < n; ++i2) {
            ((ASN1Object)this.a.elementAt(i2)).output(outputStream);
        }
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

