/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers.table;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.ide.db.verifiers.table.AbstractIndexInfoVerifier;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;

public class EditIndexInfoVerifier
extends AbstractIndexInfoVerifier {
    public void initializeVerifier(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, SchemaObject schemaObject2) {
        super.initializeVerifier(dBObjectProvider, schemaObject, schemaObject2);
    }

    public boolean canRenameIndex(Index index) {
        return true;
    }

    public boolean canRemoveIndexes() {
        return this.isEditable();
    }

    public boolean canRemoveIndex(Index index) {
        boolean bl = false;
        HashSet<Column> hashSet = new HashSet<Column>();
        Table table = index.getTable();
        Constraint[] constraintArray = table.getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            if ("PKConstraint".equals(constraintArray[n].getConstraintType()) || "UniqueConstraint".equals(constraintArray[n].getConstraintType())) {
                hashSet.addAll(Arrays.asList(((ColumnConstraint)constraintArray[n]).getColumns()));
            }
            ++n;
        }
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        int n2 = 0;
        while (!bl && n2 < indexObjectArray.length) {
            Collection collection = ParserUtils.getColumnNames((String)indexObjectArray[n2].getSQLText());
            Iterator iterator = collection.iterator();
            while (!bl && iterator.hasNext()) {
                if (!hashSet.contains(table.getColumn((String)iterator.next()))) continue;
                bl = true;
            }
            ++n2;
        }
        return this.isEditable() && (this.isNewIndex(index) || !bl);
    }

    public boolean canReorderIndexes() {
        return this.isEditable();
    }

    public boolean canMoveIndexUp(Index index) {
        return this.isNewIndex(index);
    }

    public boolean canMoveIndexDown(Index index) {
        return this.isNewIndex(index);
    }

    public boolean canAddIndexes() {
        return this.isEditable();
    }

    public boolean canAddIndex(Index index) {
        return this.isEditable();
    }

    public boolean canEditIndex(Index index) {
        return true;
    }
}

