/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers.table;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.db.verifiers.table.AbstractColumnInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.Oracle9iR2;

public class EditColumnInfoVerifier
extends AbstractColumnInfoVerifier {
    private List _colSet;
    private Set _conColSet;
    private Set _pkColSet;

    private void $init$() {
        this._colSet = new ArrayList();
        this._conColSet = new HashSet();
        this._pkColSet = new HashSet();
    }

    public EditColumnInfoVerifier() {
        this.$init$();
    }

    public void initializeVerifier(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, SchemaObject schemaObject2) {
        super.initializeVerifier(dBObjectProvider, schemaObject, schemaObject2);
        Table table = (Table)schemaObject2;
        Column[] columnArray = table.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            this._colSet.add(columnArray[n]);
            ++n;
        }
        Constraint[] constraintArray = table.getConstraints();
        int n2 = 0;
        while (n2 < constraintArray.length) {
            Constraint constraint = constraintArray[n2];
            if (constraint instanceof ColumnConstraint) {
                Column[] columnArray2 = ((ColumnConstraint)constraint).getColumns();
                int n3 = 0;
                while (n3 < columnArray2.length) {
                    Column column = columnArray2[n3];
                    this._conColSet.add(column);
                    if (constraint instanceof PKConstraint) {
                        this._pkColSet.add(column);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public boolean canRemoveColumn(Column column) {
        return this._conColSet.contains(column) ^ true;
    }

    public boolean canMoveColumnUp(Column column) {
        return this.isNewColumn(column);
    }

    public boolean canMoveColumnDown(Column column) {
        return this.isNewColumn(column);
    }

    public boolean canChangeColumnComment(Column column) {
        return true;
    }

    public boolean canChangeColumnDefaultValue(Column column) {
        return true;
    }

    public boolean canChangeColumnNotNullState(Column column) {
        return this._pkColSet.contains(column) ^ true;
    }

    public boolean canChangeColumnType(Column column) {
        return true;
    }

    public boolean canChangeColumnSize(Column column) {
        if (!this.isNewColumn(column)) {
            try {
                DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
                DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage);
                DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute("size");
                if (dataTypeAttribute != null && dataTypeAttribute.isDeclarable() && !dataTypeAttribute.isMandatory()) {
                    boolean bl = dataTypeUsage.getAttributeValue("size") != null;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean canRenameColumn(Column column) {
        return this.getProvider() instanceof Oracle9iR2;
    }

    private boolean isNewColumn(Column column) {
        return this._colSet.contains(column) ^ true;
    }

    public void verifyColumn(Column column, Column column2) throws TraversalException {
        super.verifyColumn(column, column2);
        if (ModelUtil.areDifferent((Object)column, (Object)column2) && !this.isNewColumn(column)) {
            DataTypeUsage dataTypeUsage = column2.getDataTypeUsage();
            DataTypeUsage dataTypeUsage2 = column.getDataTypeUsage();
            DBObjectID dBObjectID = dataTypeUsage.getDataTypeID();
            DBObjectID dBObjectID2 = dataTypeUsage2.getDataTypeID();
            DataType dataType = null;
            try {
                dataType = dBObjectID == null ? null : (DataType)dBObjectID.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dataType == null) {
                throw new TraversalException(DBArb.format((int)162, (Object)column2.getName()), DBArb.getString((int)163));
            }
        }
    }
}

