/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers;

import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.AbstractSchemaObjectVerifier;
import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.db.verifiers.trigger.TriggerVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Trigger;

public class CreateTriggerVerifier
extends AbstractSchemaObjectVerifier
implements SchemaObjectInfoVerifier,
TriggerVerifier {
    private DBObjectProvider _prov;
    private Trigger _trigger;
    private boolean canChangeSchema;

    public void verifyTrigger(boolean bl) throws TraversalException {
        Schema schema = this._trigger.getSchema();
        if (schema == null) {
            throw new TraversalException(UIArb.getString(607), UIArb.getString(606), null);
        }
        Schema schema2 = this._trigger.getTableOwner();
        switch (1.$sm$oracle$javatools$db$Trigger$BaseType[this._trigger.getBaseType().ordinal()]) {
            case 1: 
            case 2: {
                if (schema2 == null) {
                    throw new TraversalException(UIArb.getString(612), UIArb.getString(606), null);
                }
                String string = this._trigger.getTableName();
                if (ModelUtil.hasLength((String)string)) break;
                throw new TraversalException(UIArb.getString(611), UIArb.getString(606), null);
            }
            case 3: {
                if (schema2 != null) break;
                throw new TraversalException(UIArb.getString(614), UIArb.getString(606), null);
            }
        }
        String[] stringArray = this._trigger.getEvents();
        if (stringArray.length == 0) {
            throw new TraversalException(UIArb.getString(613), UIArb.getString(606), null);
        }
    }

    public void initializeVerifier(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, SchemaObject schemaObject2) {
        super.initializeVerifier(dBObjectProvider, schemaObject, schemaObject2);
        this._prov = dBObjectProvider;
        this._trigger = (Trigger)schemaObject2;
        Schema schema = this._trigger.getSchema();
        Schema schema2 = null;
        try {
            Schema[] schemaArray = dBObjectProvider.listSchemas();
            int n = 0;
            while (n < schemaArray.length) {
                Schema schema3 = schemaArray[n];
                if (ModelUtil.areDifferent((Object)schema3, (Object)schema)) {
                    schema2 = schema3;
                    break;
                }
                ++n;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        this.canChangeSchema = schema2 != null ? dBObjectProvider.hasPriviledge("TRIGGER", schema2, "CREATE") : false;
    }

    public void verifyName(String string) throws TraversalException {
        if (!this._prov.isValidName("TRIGGER", string)) {
            throw new TraversalException(UIArb.format(615, string), UIArb.getString(606), null);
        }
    }

    public boolean canChangeName() {
        return true;
    }

    public boolean canChangeSchema() {
        return this.canChangeSchema;
    }

    public boolean canCreateSchema() {
        return false;
    }

    public void verifySchemaName(String string) throws TraversalException {
    }

    public void verifyObject() throws TraversalException {
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$Trigger$BaseType;

        static {
            int[] nArray = new int[Trigger.BaseType.values().length];
            $sm$oracle$javatools$db$Trigger$BaseType = nArray;
            try {
                nArray[Trigger.BaseType.TABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Trigger$BaseType[Trigger.BaseType.VIEW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Trigger$BaseType[Trigger.BaseType.SCHEMA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Trigger$BaseType[Trigger.BaseType.DATABASE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

