/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers;

import javax.swing.JComboBox;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.AbstractSchemaObjectVerifier;
import oracle.ide.db.verifiers.MViewInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.MaterializedView;

public class CreateMViewInfoVerifier
extends AbstractSchemaObjectVerifier
implements MViewInfoVerifier {
    private MaterializedView _mview;

    public CreateMViewInfoVerifier() {
    }

    public CreateMViewInfoVerifier(DBObjectProvider dBObjectProvider, MaterializedView materializedView) {
        this.initializeVerifier(dBObjectProvider, null, (SchemaObject)materializedView);
    }

    public boolean canRefreshMethod() {
        return true;
    }

    public boolean canRefreshWhen() {
        return true;
    }

    public boolean canRefreshType() {
        return true;
    }

    public boolean canRefreshStartOn() {
        return true;
    }

    public boolean canRefreshNext() {
        return true;
    }

    public boolean canRefreshUseRollback() {
        return true;
    }

    public boolean canRefreshConstraints() {
        return true;
    }

    public boolean canMVOParallel() {
        return true;
    }

    public boolean canMVOEnableCache() {
        return true;
    }

    public boolean canMVOQueryRewrite() {
        return true;
    }

    public boolean canMVOPrebuilt() {
        return true;
    }

    public boolean canUseIndex() {
        return true;
    }

    public boolean canEditQuery() {
        return true;
    }

    public boolean canEnableQueryReWrite() {
        return this.isEditable();
    }

    public boolean canChangeName() {
        return this.isEditable();
    }

    public boolean canChangeSchema() {
        return this.isEditable();
    }

    public boolean canChangeComment() {
        return this.isEditable();
    }

    public void verifyRelation() throws TraversalException {
        DBObjectProvider dBObjectProvider = this.getProvider();
        try {
            if (this.getOriginalObject() == null) {
                dBObjectProvider.validateObject((DBObject)this.getModifiedObject());
            } else {
                dBObjectProvider.validateObject((DBObject)this.getOriginalObject(), (DBObject)this.getModifiedObject());
            }
        }
        catch (ValidationException validationException) {
            throw new TraversalException(validationException.getMessage());
        }
    }

    public void verifyObject() throws TraversalException {
        this.verifyRelation();
    }

    public void initializeVerifier(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, SchemaObject schemaObject2) {
        super.initializeVerifier(dBObjectProvider, schemaObject, schemaObject2);
        this._mview = (MaterializedView)schemaObject2;
    }

    public boolean canCreateSchema() {
        return false;
    }

    public void verifySchemaName(String string) throws TraversalException {
        if (!this.isValidName(string)) {
            throw new TraversalException(UIArb.format(419, string), UIArb.getString(580), null);
        }
    }

    protected String getErrorTitle() {
        return UIArb.getString(580);
    }

    protected String getInvalidNameMessage(String string) {
        return UIArb.format(ModelUtil.hasLength((String)string) ? 578 : 581, string);
    }

    public void verifyMView(boolean bl) throws TraversalException {
        try {
            Schema schema = this._mview.getSchema();
            String string = this._mview.getName();
            if (!bl && this.getProvider().getObject("MATERIALIZED VIEW", schema, string) != null) {
                throw new TraversalException(UIArb.format(579, string), UIArb.getString(577), null);
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    public void setupRefreshCombo(JComboBox jComboBox, MaterializedView.RefreshWith refreshWith) {
        if (refreshWith == MaterializedView.RefreshWith.ROWID) {
            jComboBox.setSelectedItem(UIArb.getString(625));
        } else if (refreshWith == MaterializedView.RefreshWith.PRIMARY_KEY) {
            jComboBox.setSelectedItem(UIArb.getString(624));
        } else {
            jComboBox.setSelectedItem("");
        }
    }
}

