/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.io.IOException;
import java.net.URL;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class DatabaseIdePreferences
extends HashStructureAdapter
implements PropertyStorage {
    private URL m_url;
    private static DatabaseIdePreferences s_settings;

    private DatabaseIdePreferences(URL uRL, HashStructure hashStructure) {
        super(hashStructure);
        this.m_url = uRL;
    }

    private HashStructureIO getIO() {
        return new HashStructureIO("http://xmlns.oracle.com/ide/hash", "db-ui:settings");
    }

    private void open() throws IOException {
        if (this.m_url == null) {
            throw new IllegalStateException("Database UI Settings has no URL.");
        }
        HashStructureIO hashStructureIO = this.getIO();
        if (URLFileSystem.exists((URL)this.m_url)) {
            hashStructureIO.open(this.m_url, (Object)this._hash);
        }
    }

    void save() throws IOException {
        if (this.m_url == null) {
            throw new IllegalStateException("Database UI Settings has no URL.");
        }
        if (this._hash.isDirty()) {
            HashStructureIO hashStructureIO = this.getIO();
            hashStructureIO.save(this.m_url, (Object)this._hash);
            this._hash.markDirty(false);
        }
    }

    public HashStructure getProperties() {
        return this._hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DatabaseIdePreferences getPreferences() {
        Class<DatabaseIdePreferences> clazz = DatabaseIdePreferences.class;
        synchronized (DatabaseIdePreferences.class) {
            if (s_settings == null) {
                ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
                URL uRL = extensionRegistry.getSystemDirectory("oracle.ide.db");
                URL uRL2 = URLFactory.newURL((URL)uRL, (String)"preferences.xml");
                HashStructure hashStructure = HashStructure.newInstance();
                s_settings = new DatabaseIdePreferences(uRL2, hashStructure);
                try {
                    s_settings.open();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            // ** MonitorExit[var5] (shouldn't be in output)
            return s_settings;
        }
    }
}

