/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.io.IOException;
import oracle.ide.Addin;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.SqlNode;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Recognizer;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.ideimpl.db.ora.OracleDBEditorFactory;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class DatabaseIdeAddin
implements ShutdownHook,
Addin {
    public static final String EXTENSION_ID = "oracle.ide.db";

    public void initialize() {
        ExitCommand.addShutdownHook((ShutdownHook)this);
        Class<SqlNode> clazz = SqlNode.class;
        Recognizer.mapExtensionToClass((String)".sql", clazz);
        Recognizer.mapExtensionToClass((String)".pls", clazz);
        Recognizer.mapExtensionToClass((String)".pks", clazz);
        Recognizer.mapExtensionToClass((String)".pkb", clazz);
        Recognizer.registerDocumentInfo(clazz, (DocumentInfo)new DocumentInfo(UIArb.getString(97)));
        DialogUtil.addURLFilter((URLFilter)SqlNode.SQL_FILTER);
        String string = UIArb.getString(96);
        DialogUtil.addURLFilter((URLFilter)new DefaultURLFilter(string, new String[]{".pls", ".pks", ".pkb"}));
        DBEditorFactoryRegistry.registerDBEditorFactory(OracleDatabaseImpl.class, OracleDBEditorFactory.getInstance());
        DatabaseIdePreferences databaseIdePreferences = DatabaseIdePreferences.getPreferences();
        if (databaseIdePreferences != null) {
            GlobalSettings.initialiseInstance((PropertyStorage)databaseIdePreferences);
        }
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        DatabaseIdePreferences databaseIdePreferences = DatabaseIdePreferences.getPreferences();
        if (databaseIdePreferences != null) {
            try {
                databaseIdePreferences.save();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

