/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers.table;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.table.AbstractTableVerifier;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;

public class AbstractIndexInfoVerifier
extends AbstractTableVerifier
implements IndexInfoVerifier {
    private ArrayList m_indexSet;

    private void $init$() {
        this.m_indexSet = null;
    }

    public AbstractIndexInfoVerifier() {
        this.$init$();
    }

    public void initializeVerifier(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, SchemaObject schemaObject2) {
        super.initializeVerifier(dBObjectProvider, schemaObject, schemaObject2);
        Table table = (Table)schemaObject2;
        Index[] indexArray = table.getIndexes();
        this.m_indexSet = new ArrayList<Index>(Arrays.asList(indexArray));
    }

    protected String getErrorTitle() {
        return UIArb.format(282, this.getModifiedRelationName());
    }

    protected String getInvalidNameMessage(String string) {
        return UIArb.format(ModelUtil.hasLength((String)string) ? 283 : 284, string);
    }

    protected String getChildType() {
        return "INDEX";
    }

    public void verifyIndex(Index index, Index index2) throws TraversalException {
        try {
            this.getProvider().validateObject((DBObject)index, (DBObject)index2);
        }
        catch (ValidationException validationException) {
            this.processValidationException(validationException);
        }
    }

    public boolean canRenameIndex(Index index) {
        return this.getOriginalIndex(index) == null;
    }

    public boolean canRemoveIndexes() {
        return this.isEditable();
    }

    public boolean canRemoveIndex(Index index) {
        return this.isEditable();
    }

    public boolean canReorderIndexes() {
        return this.getOriginalRelation() == null;
    }

    public boolean canMoveIndexUp(Index index) {
        return this.getOriginalRelation() == null;
    }

    public boolean canMoveIndexDown(Index index) {
        return this.getOriginalRelation() == null;
    }

    public boolean canAddIndexes() {
        return this.getOriginalRelation() == null;
    }

    public boolean canAddIndex(Index index) {
        return this.getOriginalIndex(index) == null;
    }

    public boolean canEditIndex(Index index) {
        return true;
    }

    public boolean canAddIndexEntry(Index index) {
        int n = 32;
        if (index.getIndexType() == Index.IndexType.BITMAP) {
            n = 30;
        }
        return index.getColumnExpressions().length < n;
    }

    protected Index getOriginalIndex(Index index) {
        Index index2 = null;
        Table table = (Table)this.getOriginalRelation();
        if (index != null && table != null) {
            index2 = table.getIndex(index.getName());
        }
        return index2;
    }

    protected boolean hasNewIndex() {
        boolean bl = true;
        if (this.getOriginalRelation() != null) {
            bl = false;
            Index[] indexArray = ((Table)this.getModifiedRelation()).getIndexes();
            int n = 0;
            while (n < indexArray.length) {
                if (this.getOriginalIndex(indexArray[n]) == null) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    protected String getModifiedRelationName() {
        String string = "";
        SchemaObject schemaObject = this.getModifiedObject();
        if (schemaObject instanceof Index) {
            schemaObject = ((Index)schemaObject).getTable();
        }
        if (schemaObject != null) {
            string = schemaObject.getName();
        }
        return string;
    }

    public boolean canChangeName() {
        return true;
    }

    public boolean canChangeSchema() {
        return this.isEditable();
    }

    public boolean canCreateSchema() {
        return false;
    }

    public boolean canChangeComment() {
        return false;
    }

    public boolean canEditUniqueness(Index index) {
        return true;
    }

    public boolean canEditDomain(Index index) {
        return true;
    }

    public boolean canEditParallel(Index index) {
        return true;
    }

    public void verifySchemaName(String string) throws TraversalException {
        if (!this.isValidName(string)) {
            throw new TraversalException(UIArb.format(296, string), UIArb.getString(294), null);
        }
    }

    public void verifyObject() throws TraversalException {
    }

    protected boolean isNewIndex(Index index) {
        return this.m_indexSet.contains(index) ^ true;
    }
}

