/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.relation.AbstractRelationVerifier;
import oracle.ide.db.verifiers.table.ColumnInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle10gR2;

public abstract class AbstractColumnInfoVerifier
extends AbstractRelationVerifier
implements ColumnInfoVerifier {
    private static HashSet noDefValDataTypes = new HashSet<String>(Arrays.asList("BLOB", "BFILE", "LONG RAW", "CLOB", "NCLOB"));
    private static final String[] ORA_TYPES = new String[]{"VARCHAR2", "NUMBER", "DATE", "CLOB", "BLOB"};

    protected AbstractColumnInfoVerifier() {
    }

    public boolean canAddColumns() {
        return this.isEditable() && this.getModifiedRelation().getColumns().length < 1000;
    }

    public boolean canAddColumn(Column column) {
        return this.isEditable();
    }

    public boolean canRemoveColumns() {
        return this.isEditable();
    }

    public boolean canRemoveColumn(Column column) {
        return this.isEditable() && this.getColumnUsages(column).size() == 0;
    }

    public boolean canReorderColumns() {
        return this.isEditable();
    }

    public boolean canMoveColumnUp(Column column) {
        return this.isEditable();
    }

    public boolean canMoveColumnDown(Column column) {
        return this.isEditable();
    }

    public boolean canRenameColumn(Column column) {
        return this.isEditable();
    }

    public boolean canChangeColumnType(Column column) {
        return this.isEditable();
    }

    public boolean canChangeColumnSize(Column column) {
        return this.isEditable();
    }

    public boolean canChangeColumnNotNullState(Column column) {
        return this.isEditable();
    }

    public boolean canChangeColumnDefaultValue(Column column) {
        return this.isEditable();
    }

    public boolean canChangeColumnComment(Column column) {
        Table.TableType tableType;
        Relation relation;
        Relation relation2 = relation = column != null ? column.getRelation() : null;
        if (relation instanceof Table && Table.TableType.EXTERNAL.equals((Object)(tableType = (Table.TableType)relation.getProperty("TableType")))) {
            return false;
        }
        return this.isEditable();
    }

    public boolean canTakeDefaultValue(DataType dataType) {
        boolean bl;
        boolean bl2 = bl = dataType == null;
        if (!(bl || dataType instanceof ComplexType || noDefValDataTypes.contains(dataType.getName()))) {
            bl = true;
        }
        return bl;
    }

    public void verifyColumn(Column column, Column column2) throws TraversalException {
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (dBObjectProvider != null) {
            try {
                dBObjectProvider.validateObject((DBObject)column, (DBObject)column2);
            }
            catch (ValidationException validationException) {
                this.processValidationException(validationException);
            }
        }
    }

    protected String getErrorTitle() {
        return UIArb.getString(451);
    }

    protected String getInvalidNameMessage(String string) {
        return UIArb.format(ModelUtil.hasLength((String)string) ? 449 : 450, this.getModifiedRelation().getName(), string);
    }

    protected String getChildType() {
        return "COLUMN";
    }

    public DataType[] getPreferredTypes() {
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (dBObjectProvider instanceof BaseOracleDatabase) {
            return this.getOraclePreferredTypes();
        }
        return null;
    }

    protected final DataType[] getOraclePreferredTypes() {
        ArrayList<DataType> arrayList = new ArrayList<DataType>();
        DataTypeRegistry dataTypeRegistry = DataTypeRegistry.getInstance();
        int n = 0;
        while (n < ORA_TYPES.length) {
            DataType dataType = dataTypeRegistry.findDataType(ORA_TYPES[n], Oracle10gR2.class);
            if (dataType != null) {
                arrayList.add(dataType);
            }
            ++n;
        }
        return arrayList.toArray(new DataType[arrayList.size()]);
    }

    public DataType getDefaultType() {
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (dBObjectProvider instanceof BaseOracleDatabase) {
            return dBObjectProvider.getDataType("VARCHAR2");
        }
        if (dBObjectProvider != null) {
            return dBObjectProvider.getDataType("CHAR");
        }
        return null;
    }

    protected List getColumnUsages(Column column) {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        Relation relation = column.getRelation();
        if (relation != null) {
            Constraint[] constraintArray = relation.getConstraints();
            int n = 0;
            while (n < constraintArray.length) {
                Column[] columnArray = null;
                Constraint constraint = constraintArray[n];
                if (constraint instanceof ColumnConstraint) {
                    columnArray = ((ColumnConstraint)constraint).getColumns();
                }
                if (columnArray != null) {
                    int n2 = 0;
                    while (n2 < columnArray.length) {
                        if (column.equals((Object)columnArray[n2])) {
                            arrayList.add(constraint);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return arrayList;
    }
}

