/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers.index;

import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.AbstractSchemaObjectVerifier;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;

public class AbstractTopLevelIndexVerifier
extends AbstractSchemaObjectVerifier
implements IndexInfoVerifier {
    protected String getErrorTitle() {
        return UIArb.format(282, this.getModifiedRelationName());
    }

    protected String getInvalidNameMessage(String string) {
        return UIArb.format(ModelUtil.hasLength((String)string) ? 283 : 284, string);
    }

    protected String getChildType() {
        return "INDEX";
    }

    public void verifyRelation() {
    }

    public void verifyIndex(Index index, Index index2) throws TraversalException {
        try {
            this.getProvider().validateObject((DBObject)index, (DBObject)index2);
        }
        catch (ValidationException validationException) {
            this.processValidationException(validationException);
        }
    }

    public boolean canRenameIndex(Index index) {
        return ((Index)this.getModifiedObject()).getTable() == null;
    }

    public boolean canRemoveIndexes() {
        return false;
    }

    public boolean canRemoveIndex(Index index) {
        return false;
    }

    public boolean canReorderIndexes() {
        return false;
    }

    public boolean canMoveIndexUp(Index index) {
        return false;
    }

    public boolean canMoveIndexDown(Index index) {
        return false;
    }

    public boolean canAddIndexes() {
        return this.getOriginalTable() == null;
    }

    public boolean canAddIndex(Index index) {
        return this.getOriginalTable() == null;
    }

    public boolean canEditIndex(Index index) {
        return true;
    }

    public boolean canAddIndexEntry(Index index) {
        int n = 32;
        if (index.getIndexType() == Index.IndexType.BITMAP) {
            n = 30;
        }
        return index.getColumnExpressions().length < n;
    }

    protected String getModifiedRelationName() {
        String string = "";
        SchemaObject schemaObject = this.getModifiedObject();
        if (schemaObject != null) {
            schemaObject = ((Index)schemaObject).getTable();
        }
        if (schemaObject != null) {
            string = schemaObject.getName();
        }
        return string;
    }

    protected Table getOriginalTable() {
        Table table = null;
        Index index = (Index)this.getOriginalObject();
        if (index != null) {
            table = index.getTable();
        }
        return table;
    }

    protected Table getModifiedTable() {
        Index index = (Index)this.getModifiedObject();
        return index.getTable();
    }

    public boolean canChangeName() {
        return true;
    }

    public boolean canChangeSchema() {
        return this.canEditIndex(null);
    }

    public boolean canCreateSchema() {
        return false;
    }

    public boolean canChangeComment() {
        return false;
    }

    public boolean canEditUniqueness(Index index) {
        return true;
    }

    public boolean canEditDomain(Index index) {
        return true;
    }

    public boolean canEditParallel(Index index) {
        return true;
    }

    public void verifySchemaName(String string) throws TraversalException {
        if (!this.isValidName(string)) {
            throw new TraversalException(UIArb.format(296, string), UIArb.getString(294), null);
        }
    }

    public void verifyObject() throws TraversalException {
    }
}

