/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers;

import java.math.BigInteger;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.AbstractSchemaObjectVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.Sequence;

public class SequenceInfoVerifier
extends AbstractSchemaObjectVerifier {
    public void verifySequence() throws TraversalException {
        this.verifySchemaObject();
    }

    protected String getErrorTitle() {
        return UIArb.format(102, this.getModifiedObject().getName());
    }

    protected String getInvalidNameMessage(String string) {
        return UIArb.format(ModelUtil.hasLength((String)string) ? 104 : 103, string);
    }

    public boolean canChangeIncrement() {
        return this.isEditable();
    }

    public boolean canChangeMinValue() {
        return this.isEditable();
    }

    public boolean canChangeMaxValue() {
        return this.isEditable();
    }

    public boolean canChangeCycle() {
        return this.isEditable();
    }

    public boolean canChangeOrder() {
        return this.isEditable();
    }

    public boolean canChangeCache() {
        return this.isEditable();
    }

    public boolean canChangeCacheSize() {
        return this.isEditable();
    }

    public boolean canEditStartWith() {
        return this.getOriginalObject() == null;
    }

    public void verifyMinValue() throws TraversalException {
        Sequence sequence = (Sequence)this.getOriginalObject();
        if (sequence != null) {
            Sequence sequence2 = (Sequence)this.getModifiedObject();
            BigInteger bigInteger = sequence2.getMinValue();
            BigInteger bigInteger2 = sequence.getMinValue();
            if (bigInteger2 == null && bigInteger != null || bigInteger2 != null && bigInteger != null && bigInteger.compareTo(bigInteger2) > 0) {
                throw new TraversalException(DBArb.format((int)72, (Object)bigInteger.toString(), (Object)(bigInteger2 == null ? "NOMINVALUE" : bigInteger2.toString())), UIArb.format(102, sequence2.getName()));
            }
        }
    }

    public void verifyMaxValue() throws TraversalException {
        Sequence sequence = (Sequence)this.getOriginalObject();
        if (sequence != null) {
            Sequence sequence2 = (Sequence)this.getModifiedObject();
            BigInteger bigInteger = sequence2.getMaxValue();
            BigInteger bigInteger2 = sequence.getMaxValue();
            if (bigInteger2 == null && bigInteger != null || bigInteger2 != null && bigInteger != null && bigInteger.compareTo(bigInteger2) < 0) {
                throw new TraversalException(DBArb.format((int)73, (Object)bigInteger.toString(), (Object)(bigInteger2 == null ? "NOMAXVALUE" : bigInteger2.toString())), DBArb.format((int)102, (Object)sequence2.getName()));
            }
        }
    }
}

