/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers;

import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;

public abstract class AbstractSchemaObjectVerifier
implements SchemaObjectInfoVerifier {
    private DBObjectProvider m_prov;
    private SchemaObject m_orig;
    private SchemaObject m_change;
    private boolean m_editable;

    private void $init$() {
        this.m_editable = true;
    }

    protected AbstractSchemaObjectVerifier() {
        this.$init$();
    }

    protected String getObjectType() {
        return this.m_change == null ? (this.m_orig == null ? null : this.m_orig.getType()) : this.m_change.getType();
    }

    public void verifyName(String string) throws TraversalException {
        try {
            this.m_prov.validateName(this.getObjectType(), string);
        }
        catch (InvalidNameException invalidNameException) {
            String string2 = invalidNameException.getMessage();
            throw new TraversalException(this.getInvalidNameMessage(string) + " " + string2, this.getErrorTitle());
        }
    }

    protected void verifySchemaObject() throws TraversalException {
        try {
            if (this.m_orig == null) {
                this.m_prov.validateObject((DBObject)this.m_change);
            } else {
                this.m_prov.validateObject((DBObject)this.m_orig, (DBObject)this.m_change);
            }
        }
        catch (ValidationException validationException) {
            this.processValidationException(validationException);
        }
    }

    protected boolean isValidName(String string) {
        return this.m_prov.isValidName(this.getObjectType(), string);
    }

    protected String getInvalidNameMessage(String string) {
        return "";
    }

    protected String getErrorTitle() {
        return "";
    }

    protected void processValidationException(ValidationException validationException) throws TraversalException {
        String string = validationException.getTitle();
        throw new TraversalException(validationException.getMessage(), string == null ? this.getErrorTitle() : string);
    }

    public void initializeVerifier(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, SchemaObject schemaObject2) {
        this.m_prov = dBObjectProvider;
        this.m_orig = schemaObject;
        this.m_change = schemaObject2;
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
    }

    public SchemaObject getOriginalObject() {
        return this.m_orig;
    }

    public SchemaObject getModifiedObject() {
        return this.m_change;
    }

    protected DBObjectProvider getProvider() {
        return this.m_prov;
    }

    protected boolean isEditable() {
        return this.m_editable;
    }

    public boolean canChangeName() {
        return this.m_orig == null;
    }

    public boolean canChangeSchema() {
        return this.m_orig == null;
    }

    public boolean canCreateSchema() {
        return false;
    }

    public void verifySchemaName(String string) throws TraversalException {
    }

    public void verifyObject() throws TraversalException {
    }
}

