/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.ide.controls.JTextComponentUndoSupport;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.javatools.controls.completionfield.CompletionPopupHandler;
import oracle.javatools.controls.completionfield.CompletionTextComponent;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SynonymUsage;

public class ExpressionEditSupport
implements FieldInsightProvider,
FocusListener {
    private JTextComponentUndoSupport m_undo;
    private JTextComponent m_registeredExp;
    private CompletionPopupHandler m_handler;
    private Map m_relations;
    private Set m_objs;
    private String m_lastInserted;
    private int m_expFocus;
    private int m_sEnd;
    private static DBObjectRenderer s_rend;

    private void $init$() {
        this.m_expFocus = -1;
        this.m_sEnd = -1;
    }

    public ExpressionEditSupport(JTextComponent jTextComponent) {
        this.$init$();
        this.m_registeredExp = jTextComponent;
        this.m_registeredExp.addFocusListener(this);
        this.m_undo = new JTextComponentUndoSupport(this.m_registeredExp);
        if (jTextComponent instanceof CompletionTextComponent) {
            this.m_handler = ((CompletionTextComponent)jTextComponent).getPopupHandler();
            this.m_handler.registerInsightProvider((FieldInsightProvider)this);
            this.m_handler.setAlignWithField(false);
        }
    }

    public void addToExpressionField(String string) {
        this.m_undo.startCombiningEdits();
        this.m_registeredExp.requestFocusInWindow();
        int n = this.m_registeredExp.getCaretPosition();
        int n2 = this.m_registeredExp.getSelectionStart();
        int n3 = this.m_registeredExp.getSelectionEnd();
        try {
            Document document = this.m_registeredExp.getDocument();
            String string2 = document.getText(0, document.getLength());
            boolean bl = false;
            int n4 = string.indexOf(40);
            if (n4 >= 0) {
                if (n2 == n3) {
                    int n5 = string2.indexOf(32);
                    int n6 = string2.indexOf(40);
                    if (n5 < 0 && n6 < 0) {
                        n2 = 0;
                        n3 = document.getLength();
                    }
                }
                if (n2 != n3) {
                    document.insertString(n3, string.substring(n4 + 1), null);
                    document.insertString(n2, string.substring(0, n4 + 1), null);
                    int n7 = string.indexOf(",", n4);
                    this.m_expFocus = n7 > 0 ? n7 + n3 + 1 : string.length() + n3;
                    bl = true;
                }
            }
            if (!bl) {
                if (n2 == n3) {
                    if (string2.length() > 0 && this.partOfName(string2.charAt(n == 0 ? 0 : n - 1))) {
                        document.insertString(n, " ", null);
                        if (n != 0) {
                            ++n;
                        }
                    }
                } else {
                    document.remove(n2, n3 - n2);
                    n = this.m_registeredExp.getCaretPosition();
                }
                document.insertString(n, string, null);
                this.m_expFocus = n;
                this.m_sEnd = this.m_expFocus + (n4 > 0 ? n4 + 1 : string.length());
                bl = true;
            }
            if (!bl) {
                this.m_expFocus = -1;
                this.m_lastInserted = null;
            } else {
                this.m_lastInserted = string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_undo.commitCombinedEdit();
    }

    public void clearUndo() {
        this.m_undo.clearUndo();
    }

    public void setInsightMap(Map map) {
        this.m_relations = map;
    }

    public void setInsightObjects(Set set) {
        this.m_objs = set;
    }

    protected Object[] filter(Object[] objectArray, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            String string2 = this.convertToString(objectArray[n]);
            if (string2.toUpperCase().startsWith(string.toUpperCase())) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    private String convertToString(Object object) {
        String string = null;
        string = object instanceof AliasFragment ? ((AliasFragment)object).getName() : (object instanceof FunctionDefinition ? ((FunctionDefinition)object).getSQLText() : (object instanceof SQLFragment ? ((SQLFragment)object).getSQLText() : (object instanceof DBObject ? ((DBObject)object).getName() : String.valueOf(object))));
        return string;
    }

    private int[] lastNonAlphaNumIndex(String string, int n) {
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            if (!this.partOfName(c)) {
                return new int[]{n2, c};
            }
            --n2;
        }
        return new int[]{-1, -1};
    }

    private int nextNonAlphaNumIndex(String string, int n) {
        int n2 = n;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (!this.partOfName(c)) {
                return n2;
            }
            ++n2;
        }
        return string.length();
    }

    private boolean partOfName(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.m_expFocus >= 0) {
            if (this.m_sEnd < 0) {
                try {
                    this.m_registeredExp.setCaretPosition(this.m_expFocus);
                }
                catch (Exception exception) {}
            } else {
                try {
                    this.m_registeredExp.setSelectionStart(this.m_expFocus);
                    this.m_registeredExp.setSelectionEnd(this.m_sEnd);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_expFocus = -1;
            this.m_sEnd = -1;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public ListCellRenderer getCellRenderer() {
        return ExpressionEditSupport.getRenderer();
    }

    public boolean handlesInsight(Document document, int n) {
        return this.m_relations != null;
    }

    public Object[] getInsightData(Document document, int n) {
        Object[] objectArray = null;
        if (this.m_relations != null) {
            try {
                String string = document.getText(0, document.getLength());
                if (this.isInQuotes(string.substring(0, n))) {
                    Object[] objectArray2 = null;
                    return objectArray2;
                }
                if (string.length() > n && this.isDot(string.charAt(n))) {
                    int[] nArray = this.lastNonAlphaNumIndex(string, n);
                    String string2 = string.substring(nArray[0] + 1, n - 1);
                    objectArray = (Object[])this.m_relations.get(string2);
                } else {
                    int[] nArray = this.lastNonAlphaNumIndex(string, n);
                    String string3 = string.substring(nArray[0] + 1, n);
                    if (string3.equals(this.m_lastInserted)) {
                        this.m_lastInserted = null;
                        Object[] objectArray3 = null;
                        return objectArray3;
                    }
                    this.m_lastInserted = null;
                    Object[] objectArray4 = null;
                    if (this.isDot((char)nArray[1])) {
                        int[] nArray2 = this.lastNonAlphaNumIndex(string, nArray[0]);
                        String string4 = string.substring(nArray2[0] + 1, nArray[0]);
                        objectArray4 = (Object[])this.m_relations.get(string4);
                    } else {
                        objectArray4 = this.m_objs.toArray();
                        Arrays.sort(objectArray4, ExpressionEditSupport.getRenderer());
                    }
                    Object[] objectArray5 = objectArray = objectArray4 == null ? null : this.filter(objectArray4, string3);
                    if (objectArray != null && objectArray.length == 1 && string3.equals(this.convertToString(objectArray[0]))) {
                        objectArray = null;
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (objectArray != null && objectArray.length == 0) {
            objectArray = null;
        }
        return objectArray;
    }

    public void completeInsight(Document document, int n, Object object) {
        try {
            try {
                this.m_undo.startCombiningEdits();
                String string = document.getText(0, document.getLength());
                String string2 = this.convertToString(object);
                if (string.length() > 0) {
                    if (n > 0 && this.partOfName(string.charAt(n - 1))) {
                        int[] nArray = this.lastNonAlphaNumIndex(string, n);
                        int n2 = nArray[0];
                        if (++n2 != n) {
                            document.remove(n2, n - n2);
                            n -= n - n2;
                            string = document.getText(0, document.getLength());
                        }
                    }
                    if (string.length() > n && this.partOfName(string.charAt(n))) {
                        int n3 = this.nextNonAlphaNumIndex(string, n);
                        document.remove(n, n3 - n);
                    }
                }
                this.addToExpressionField(string2);
                this.m_expFocus = -1;
                this.m_sEnd = -1;
            }
            catch (BadLocationException badLocationException) {}
        }
        finally {
            this.m_undo.commitCombinedEdit();
        }
    }

    private boolean isDot(char c) {
        return c == '.';
    }

    private boolean isInQuotes(String string) {
        return this.hasOddNumberOf('\'', string) || this.hasOddNumberOf('\"', string);
    }

    private boolean hasOddNumberOf(char c, String string) {
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 >= 0) {
            ++n;
            n2 = string.indexOf(c, n2 + 1);
        }
        return n % 2 != 0;
    }

    public boolean isAutoPopupChar(char c) {
        if (this.isDot(c)) {
            return this.m_relations != null;
        }
        if (this.partOfName(c)) {
            return this.m_objs != null || this.m_relations != null;
        }
        return false;
    }

    public static Map createInsightMap(FromObject[] fromObjectArray) {
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        int n = 0;
        while (n < fromObjectArray.length) {
            if (fromObjectArray[n] != null) {
                String string = fromObjectArray[n].getName();
                Collection collection = ExpressionEditSupport.getColumns(fromObjectArray[n]);
                hashMap.put(string, collection.toArray());
            }
            ++n;
        }
        return hashMap;
    }

    public static Collection getColumns(FromObject fromObject) {
        TreeSet<Object> treeSet = new TreeSet<Object>(ExpressionEditSupport.getRenderer());
        if (fromObject != null) {
            SQLFragment sQLFragment = fromObject.getExpression();
            if (sQLFragment instanceof DBObjectUsage) {
                SchemaObject schemaObject;
                Relation relation = null;
                if (sQLFragment instanceof RelationUsage) {
                    DBObjectID dBObjectID = ((RelationUsage)sQLFragment).getObjectID();
                    if (dBObjectID != null) {
                        try {
                            relation = (Relation)dBObjectID.resolveID();
                        }
                        catch (DBException dBException) {}
                    }
                } else if (sQLFragment instanceof SynonymUsage && (schemaObject = ((SynonymUsage)sQLFragment).getReferencedObject()) instanceof Relation) {
                    relation = (Relation)schemaObject;
                }
                if (relation != null) {
                    Column[] columnArray = relation.getColumns();
                    int n = 0;
                    while (n < columnArray.length) {
                        treeSet.add(columnArray[n]);
                        ++n;
                    }
                }
            } else if (sQLFragment instanceof SQLQuery) {
                SelectObject[] selectObjectArray = ((SQLQuery)sQLFragment).getSelectObjects();
                int n = 0;
                while (n < selectObjectArray.length) {
                    treeSet.add(selectObjectArray[n]);
                    ++n;
                }
            } else if (sQLFragment instanceof JoinObject) {
                FromObject fromObject2 = ((JoinObject)sQLFragment).getLeftExpression();
                treeSet.addAll(ExpressionEditSupport.getColumns(fromObject2));
                FromObject fromObject3 = ((JoinObject)sQLFragment).getRightExpression();
                treeSet.addAll(ExpressionEditSupport.getColumns(fromObject3));
            }
        }
        return treeSet;
    }

    private static DBObjectRenderer getRenderer() {
        if (s_rend == null) {
            s_rend = new DBObjectRenderer();
            s_rend.setIncludeIcon(true);
        }
        return s_rend;
    }
}

