/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.view;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.CommentEditor;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.verifiers.view.ViewInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.View;
import oracle.javatools.db.sql.SQLQueryBuilder;

public class ViewInfoPanel
extends BaseInfoPanel
implements ActionListener {
    private CommentEditor m_comment;
    private JRadioButton m_readOnly;
    private JRadioButton m_checkOption;
    private JCheckBox m_restrict;
    private JCheckBox m_force;

    private void $init$() {
        this.m_comment = new CommentEditor();
        this.m_readOnly = new JRadioButton();
        this.m_checkOption = new JRadioButton();
        this.m_restrict = new JCheckBox();
        this.m_force = new JCheckBox();
    }

    public ViewInfoPanel() {
        this.$init$();
        ResourceUtils.resButton((AbstractButton)this.m_restrict, (String)UIArb.getString(161));
        ResourceUtils.resButton((AbstractButton)this.m_readOnly, (String)UIArb.getString(162));
        ResourceUtils.resButton((AbstractButton)this.m_checkOption, (String)UIArb.getString(163));
        ResourceUtils.resButton((AbstractButton)this.m_force, (String)UIArb.getString(164));
        this.setLayout(new GridBagLayout());
        this.add(this.m_restrict, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_readOnly, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 30, 5, 0), 0, 0));
        this.add(this.m_checkOption, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 30, 5, 0), 0, 0));
        this.add(this.m_force, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_comment, new GridBagConstraints(1, 10, 1, 1, 1.0, 1.0, 18, 1, new Insets(15, 0, 0, 0), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_readOnly);
        buttonGroup.add(this.m_checkOption);
        this.m_readOnly.setSelected(true);
        this.m_restrict.setSelected(false);
        this.m_readOnly.setEnabled(false);
        this.m_checkOption.setEnabled(false);
        this.m_restrict.addActionListener(this);
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        View view = (View)traversableContext.find("NewObject");
        ViewInfoVerifier viewInfoVerifier = (ViewInfoVerifier)traversableContext.find("SchemaObjectInfoVerifier");
        Schema[] schemaArray = (Schema[])traversableContext.find("SchemaList");
        SQLQueryBuilder sQLQueryBuilder = (SQLQueryBuilder)traversableContext.get("SQLQueryBuilder");
        this.init(dBObjectProvider, view, sQLQueryBuilder, viewInfoVerifier, schemaArray);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit((View)traversableContext.find("NewObject"), (Schema[])traversableContext.find("SchemaList"), traversableContext.getDirection() != 2);
    }

    protected void init(DBObjectProvider dBObjectProvider, View view, SQLQueryBuilder sQLQueryBuilder, ViewInfoVerifier viewInfoVerifier, Schema[] schemaArray) {
        super.init(dBObjectProvider, viewInfoVerifier);
        viewInfoVerifier.setBuilder(sQLQueryBuilder);
        this.m_comment.init((DBObject)view, viewInfoVerifier);
        String string = view.getQueryRestriction();
        if (string != null) {
            this.m_restrict.setSelected(true);
            this.m_readOnly.setEnabled(true);
            this.m_checkOption.setEnabled(true);
            if (string.equalsIgnoreCase("WITH READ ONLY")) {
                this.m_readOnly.setSelected(true);
            } else {
                this.m_checkOption.setSelected(true);
            }
        }
        this.m_force.setSelected(view.isForceOnCreate());
        if (viewInfoVerifier != null) {
            boolean bl = viewInfoVerifier.canChangeQueryRestriction();
            this.m_restrict.setEnabled(bl);
            this.m_readOnly.setEnabled(this.m_restrict.isSelected() && bl);
            this.m_checkOption.setEnabled(this.m_restrict.isSelected() && bl);
        }
    }

    protected void commit(View view, Schema[] schemaArray, boolean bl) throws TraversalException {
        this.m_comment.commit((DBObject)view);
        if (this.m_restrict.isSelected()) {
            view.setQueryRestriction(this.m_readOnly.isSelected() ? "WITH READ ONLY" : "WITH CHECK OPTION");
        } else {
            view.setQueryRestriction(null);
        }
        view.setForceOnCreate(this.m_force.isSelected());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_restrict) {
            if (this.m_restrict.isSelected()) {
                this.m_readOnly.setEnabled(true);
                this.m_checkOption.setEnabled(true);
            } else {
                this.m_readOnly.setEnabled(false);
                this.m_checkOption.setEnabled(false);
            }
        }
    }
}

