/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameAndSchemaAdvancedEditor;
import oracle.ide.db.panels.table.TableTypePanel;
import oracle.ide.db.verifiers.table.TableInfoVerifier;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;

public class TableInfoPanel
extends NameAndSchemaAdvancedEditor {
    private JLabel m_tableTypeLabel;
    private TableTypePanel m_tableTypePanel;

    private void $init$() {
        this.m_tableTypeLabel = new JLabel(UIArb.getString(401));
        this.m_tableTypePanel = new TableTypePanel(false);
    }

    public TableInfoPanel() {
        this.$init$();
        this.m_tableTypePanel.addActionListener(this);
    }

    private void removeTypePanel() {
        this.remove(this.m_tableTypeLabel);
        this.remove(this.m_tableTypePanel);
    }

    private void addTypePanel() {
        this.removeTypePanel();
        this.add(this.m_tableTypeLabel, new GridBagConstraints(0, 30, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.add(this.m_tableTypePanel, new GridBagConstraints(1, 30, 0, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        if (this.isAdvancedLayout() || this.isEditing()) {
            this.addTypePanel();
        }
        Table table = (Table)this.getSchemaObject();
        Table.TableType tableType = (Table.TableType)table.getProperty("TableType", (Object)Table.TableType.NORMAL);
        this.m_tableTypePanel.setTableType(tableType);
        TableInfoVerifier tableInfoVerifier = (TableInfoVerifier)traversableContext.find("SchemaObjectInfoVerifier");
        if (tableInfoVerifier != null && !tableInfoVerifier.canChangeTempState()) {
            this.m_tableTypePanel.enableAllComponents(false);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        TableInfoVerifier tableInfoVerifier = (TableInfoVerifier)traversableContext.find("SchemaObjectInfoVerifier");
        if (tableInfoVerifier != null) {
            tableInfoVerifier.verifyRelation();
        }
        try {
            this.getProvider().validateObject((DBObject)((Table)traversableContext.get("OriginalObject")), (DBObject)((Table)traversableContext.get("NewObject")));
        }
        catch (ValidationException validationException) {
            throw new TraversalException(validationException.getMessage(), validationException.getTitle());
        }
    }

    public void commit() throws TraversalException {
        super.commit();
        this.commitType();
    }

    private Table.TableType commitType() {
        Table table = (Table)this.getSchemaObject();
        Table.TableType tableType = this.m_tableTypePanel.getTableType();
        table.setProperty("TableType", (Object)tableType);
        return tableType;
    }

    protected void showSimplePanel() throws TraversalException {
        super.showSimplePanel();
        this.removeTypePanel();
    }

    protected void showAdvancedPanel() throws TraversalException {
        this.showPanelsForTableType((Table)this.getSchemaObject());
        this.addTypePanel();
    }

    private void showPanelsForTableType(Table table) throws TraversalException {
        String string;
        List<Navigable> list = this.isEditing() ? this.getPanelLibrary().getEditNavigables((DBObject)table, this.getProvider()) : this.getPanelLibrary().getCreateNavigables((DBObject)table, this.getProvider());
        Table.TableType tableType = (Table.TableType)table.getProperty("TableType");
        switch (1.$sm$oracle$javatools$db$Table$TableType[tableType.ordinal()]) {
            case 1: {
                string = "DEFAULT_PANEL";
                break;
            }
            case 2: 
            case 3: {
                string = Table.TableType.SESSION_TEMP.toString();
                break;
            }
            default: {
                string = tableType.toString();
            }
        }
        this.changePanels(string, list.toArray(new Navigable[list.size()]));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_tableTypePanel) {
            Table.TableType tableType;
            Table table = (Table)this.getSchemaObject();
            Table.TableType tableType2 = (Table.TableType)table.getProperty("TableType");
            if (tableType2 != (tableType = this.commitType())) {
                try {
                    this.showPanelsForTableType(table);
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)((Object)this));
                    table.setProperty("TableType", (Object)tableType2);
                    this.m_tableTypePanel.setTableType(tableType2);
                }
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$Table$TableType;

        static {
            int[] nArray = new int[Table.TableType.values().length];
            $sm$oracle$javatools$db$Table$TableType = nArray;
            try {
                nArray[Table.TableType.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Table$TableType[Table.TableType.TRANSACTION_TEMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Table$TableType[Table.TableType.SESSION_TEMP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

