/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.OracleStorageProperties;

public class StorageInfoPanel
extends BaseInfoPanel
implements ItemListener {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_EMBED_IN_LOB_DESCRIPTOR = 1;
    public static final String DEFAULT_OPTION = "<DEFAULT>";
    public static final OracleStorageProperties.BufferModes[] BUFFER_OPTIONS = OracleStorageProperties.BufferModes.values();
    public static final String[] LOGGING_OPTIONS = new String[]{"<DEFAULT>", "ON", "OFF"};
    private BorderLayout layMain;
    private JMultiLineLabel lblTop;
    private JPanel pnlCenter;
    private GridBagLayout layCenter;
    protected JLabel lblTablespace;
    protected JComboBox cmbTablespace;
    private JLabel lblPctFree;
    private JLabel lblPctUsed;
    private JLabel lblIniTrans;
    private JLabel lblMaxTrans;
    private StorageNumberField fldPctFree;
    private StorageNumberField fldPctUsed;
    private StorageNumberField fldIniTrans;
    private StorageNumberField fldMaxTrans;
    private JPanel pnlExtents;
    private GridBagLayout layExtents;
    private JPanel pnlFreeLists;
    private GridBagLayout layFreeLists;
    private JLabel lblInitExtents;
    private JLabel lblNextExtents;
    private JLabel lblMinExtents;
    private JLabel lblMaxExtents;
    private JLabel lblPctIncrease;
    private StorageNumberField fldInitExtents;
    private StorageNumberField fldNextExtents;
    private StorageNumberField fldMinExtents;
    private StorageNumberField fldMaxExtents;
    private StorageNumberField fldPctIncrease;
    private JComboBox cmbInitExtents;
    private JComboBox cmbNextExtents;
    private JCheckBox chkUnlimited;
    private JLabel lblFreeLists;
    private JLabel lblFreeListGroups;
    private StorageNumberField fldFreeLists;
    private StorageNumberField fldFreeListGroups;
    private JLabel lblBufferPool;
    private JComboBox cmbBufferPool;
    protected JLabel lblLogging;
    protected JComboBox cmbLogging;
    private NonNullableComboBoxModel mdlInitExtents;
    private NonNullableComboBoxModel mdlNextExtents;
    private NonNullableComboBoxModel mdlBufferPool;
    private NonNullableComboBoxModel mdlLogging;
    private NonNullableComboBoxModel mdlTablespace;
    private static final String[] EXTENTS_SIZES = new String[]{"", "K", "M"};
    private static final int K = 1024;
    private static final int M = 0x100000;

    private void $init$() {
        this.layMain = new BorderLayout();
        this.lblTop = new JMultiLineLabel();
        this.pnlCenter = null;
        this.layCenter = new GridBagLayout();
        this.lblTablespace = new JLabel();
        this.cmbTablespace = new JComboBox();
        this.lblPctFree = new JLabel();
        this.lblPctUsed = new JLabel();
        this.lblIniTrans = new JLabel();
        this.lblMaxTrans = new JLabel();
        this.fldPctFree = new StorageNumberField();
        this.fldPctUsed = new StorageNumberField();
        this.fldIniTrans = new StorageNumberField();
        this.fldMaxTrans = new StorageNumberField();
        this.pnlExtents = new JPanel();
        this.layExtents = new GridBagLayout();
        this.pnlFreeLists = new JPanel();
        this.layFreeLists = new GridBagLayout();
        this.lblInitExtents = new JLabel();
        this.lblNextExtents = new JLabel();
        this.lblMinExtents = new JLabel();
        this.lblMaxExtents = new JLabel();
        this.lblPctIncrease = new JLabel();
        this.fldInitExtents = new StorageNumberField();
        this.fldNextExtents = new StorageNumberField();
        this.fldMinExtents = new StorageNumberField();
        this.fldMaxExtents = new StorageNumberField();
        this.fldPctIncrease = new StorageNumberField();
        this.cmbInitExtents = new JComboBox();
        this.cmbNextExtents = new JComboBox();
        this.chkUnlimited = new JCheckBox();
        this.lblFreeLists = new JLabel();
        this.lblFreeListGroups = new JLabel();
        this.fldFreeLists = new StorageNumberField();
        this.fldFreeListGroups = new StorageNumberField();
        this.lblBufferPool = new JLabel();
        this.cmbBufferPool = new JComboBox();
        this.lblLogging = new JLabel();
        this.cmbLogging = new JComboBox();
        this.mdlInitExtents = new NonNullableComboBoxModel((Object[])EXTENTS_SIZES);
        this.mdlNextExtents = new NonNullableComboBoxModel((Object[])EXTENTS_SIZES);
        this.mdlBufferPool = new NonNullableComboBoxModel((Object[])BUFFER_OPTIONS);
        this.mdlLogging = new NonNullableComboBoxModel((Object[])LOGGING_OPTIONS);
    }

    public StorageInfoPanel() {
        this.$init$();
        JPanel jPanel = new JPanel();
        try {
            this.jbInit(jPanel, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.add(this.pnlCenter, "North");
    }

    public StorageInfoPanel(JPanel jPanel, int n) {
        this.$init$();
        try {
            this.jbInit(jPanel, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit(JPanel jPanel, int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        int n4 = 2;
        Insets insets = null;
        this.pnlCenter = jPanel;
        if (n == 0) {
            this.pnlCenter.setLayout(this.layCenter);
            insets = new Insets(6, 0, 0, 0);
        } else if (n == 1) {
            n2 = 3;
            n3 = 2;
            n4 = 4;
            insets = new Insets(6, 12, 0, 0);
        } else {
            throw new Exception("Invalid Layout option");
        }
        this.setLayout(this.layMain);
        this.lblTop.setPreferredAspectRatio(0.0f);
        this.lblTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        ResourceUtils.resLabel((JLabel)this.lblTablespace, (Component)this.cmbTablespace, (String)UIArb.getString(537));
        ResourceUtils.resLabel((JLabel)this.lblPctFree, (Component)((Object)this.fldPctFree), (String)UIArb.getString(538));
        this.fldPctFree.setMaximumValue(99);
        this.fldPctFree.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblPctUsed, (Component)((Object)this.fldPctUsed), (String)UIArb.getString(539));
        this.fldPctUsed.setMaximumValue(99);
        this.fldPctUsed.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblIniTrans, (Component)((Object)this.fldIniTrans), (String)UIArb.getString(540));
        this.fldIniTrans.setMaximumValue(255);
        this.fldIniTrans.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblMaxTrans, (Component)((Object)this.fldMaxTrans), (String)UIArb.getString(541));
        this.fldMaxTrans.setMaximumValue(255);
        this.fldMaxTrans.setColumns(5);
        this.pnlExtents.setLayout(this.layExtents);
        this.pnlExtents.setBorder(BorderFactory.createTitledBorder(UIArb.getString(542)));
        this.pnlFreeLists.setLayout(this.layFreeLists);
        this.pnlFreeLists.setBorder(BorderFactory.createTitledBorder(UIArb.getString(543)));
        ResourceUtils.resLabel((JLabel)this.lblInitExtents, (Component)((Object)this.fldInitExtents), (String)UIArb.getString(544));
        ResourceUtils.resLabel((JLabel)this.lblNextExtents, (Component)((Object)this.fldNextExtents), (String)UIArb.getString(546));
        ResourceUtils.resLabel((JLabel)this.lblMinExtents, (Component)((Object)this.fldMinExtents), (String)UIArb.getString(548));
        ResourceUtils.resLabel((JLabel)this.lblMaxExtents, (Component)((Object)this.fldMaxExtents), (String)UIArb.getString(549));
        ResourceUtils.resLabel((JLabel)this.lblPctIncrease, (Component)((Object)this.fldPctIncrease), (String)UIArb.getString(551));
        AccessibleContext accessibleContext = this.cmbInitExtents.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleName(UIArb.getString(545));
        }
        this.cmbInitExtents.setModel(this.mdlInitExtents);
        accessibleContext = this.cmbNextExtents.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleName(UIArb.getString(547));
        }
        this.cmbNextExtents.setModel(this.mdlNextExtents);
        ResourceUtils.resButton((AbstractButton)this.chkUnlimited, (String)UIArb.getString(550));
        this.chkUnlimited.addItemListener(this);
        ResourceUtils.resLabel((JLabel)this.lblFreeLists, (Component)((Object)this.fldFreeLists), (String)UIArb.getString(552));
        ResourceUtils.resLabel((JLabel)this.lblFreeListGroups, (Component)((Object)this.fldFreeListGroups), (String)UIArb.getString(553));
        ResourceUtils.resLabel((JLabel)this.lblBufferPool, (Component)this.cmbBufferPool, (String)UIArb.getString(554));
        ResourceUtils.resLabel((JLabel)this.lblLogging, (Component)this.cmbLogging, (String)UIArb.getString(555));
        this.cmbBufferPool.setModel(this.mdlBufferPool);
        this.cmbLogging.setModel(this.mdlLogging);
        this.add((Component)this.lblTop, "North");
        this.pnlCenter.add((Component)this.lblTablespace, new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.pnlCenter.add((Component)this.cmbTablespace, new GridBagConstraints(1, n2, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        if (n != 1) {
            this.pnlCenter.add((Component)this.lblPctFree, new GridBagConstraints(2, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 0), 0, 0));
            this.pnlCenter.add((Component)((Object)this.fldPctFree), new GridBagConstraints(3, n2, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
            this.pnlCenter.add((Component)this.lblPctUsed, new GridBagConstraints(4, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 0), 0, 0));
            this.pnlCenter.add((Component)((Object)this.fldPctUsed), new GridBagConstraints(5, n2, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        }
        this.pnlCenter.add((Component)this.lblBufferPool, new GridBagConstraints(0, n2 + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.pnlCenter.add((Component)this.cmbBufferPool, new GridBagConstraints(1, n2 + 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        if (n != 1) {
            this.pnlCenter.add((Component)this.lblIniTrans, new GridBagConstraints(2, n2 + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 0), 0, 0));
            this.pnlCenter.add((Component)((Object)this.fldIniTrans), new GridBagConstraints(3, n2 + 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
            this.pnlCenter.add((Component)this.lblMaxTrans, new GridBagConstraints(4, n2 + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 0), 0, 0));
            this.pnlCenter.add((Component)((Object)this.fldMaxTrans), new GridBagConstraints(5, n2 + 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        }
        this.pnlCenter.add((Component)this.lblLogging, new GridBagConstraints(n3, n4, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.pnlCenter.add((Component)this.cmbLogging, new GridBagConstraints(n3 + 1, n4, 1, 1, 1.0, 0.0, 11, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlFreeLists.add((Component)this.lblFreeLists, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlFreeLists.add((Component)((Object)this.fldFreeLists), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlFreeLists.add((Component)this.lblFreeListGroups, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlFreeLists.add((Component)((Object)this.fldFreeListGroups), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, 6, 32, 0), 0, 0));
        this.pnlCenter.add((Component)this.pnlFreeLists, new GridBagConstraints(0, n2 + 4, 2, 1, 1.0, 0.0, 18, 1, new Insets(6, 0, 0, 0), 0, 0));
        this.pnlExtents.add((Component)this.lblInitExtents, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldInitExtents), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlExtents.add((Component)this.cmbInitExtents, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlExtents.add((Component)this.lblNextExtents, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldNextExtents), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlExtents.add((Component)this.cmbNextExtents, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlExtents.add((Component)this.lblMinExtents, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldMinExtents), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlExtents.add((Component)this.lblPctIncrease, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 13, 0, new Insets(6, 12, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldPctIncrease), new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlExtents.add((Component)this.lblMaxExtents, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldMaxExtents), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 6, 0), 0, 0));
        this.pnlExtents.add((Component)this.chkUnlimited, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.pnlCenter.add((Component)this.pnlExtents, new GridBagConstraints(2, n2 + 4, 4, 1, 1.0, 0.0, 11, 2, new Insets(5, 10, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        Relation relation = (Relation)traversableContext.find("NewObject");
        OracleStorageProperties oracleStorageProperties = (OracleStorageProperties)relation.getProperty("OracleStorageProperties");
        StorageInfoVerifier storageInfoVerifier = (StorageInfoVerifier)traversableContext.find("StorageInfoVerifier");
        String[] stringArray = this.getTablespaces(traversableContext, dBObjectProvider);
        this.init(dBObjectProvider, oracleStorageProperties, storageInfoVerifier, stringArray);
        WizardCallbacks wizardCallbacks = traversableContext.getWizardCallbacks();
        if (wizardCallbacks != null) {
            wizardCallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            wizardCallbacks.wizardSetInitialFocus((Component)this.cmbTablespace);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Relation relation = (Relation)traversableContext.find("NewObject");
        OracleStorageProperties oracleStorageProperties = (OracleStorageProperties)relation.getProperty("OracleStorageProperties");
        if (oracleStorageProperties == null) {
            oracleStorageProperties = new OracleStorageProperties();
            relation.setProperty("OracleStorageProperties", (Object)oracleStorageProperties);
        }
        this.commit(oracleStorageProperties, traversableContext.getDirection() != 2);
    }

    protected void init(DBObjectProvider dBObjectProvider, OracleStorageProperties oracleStorageProperties, StorageInfoVerifier storageInfoVerifier, String[] stringArray) {
        super.init(dBObjectProvider, storageInfoVerifier);
        this.enableAllComponents(storageInfoVerifier, true);
        if (this.mdlTablespace == null) {
            int n = stringArray != null ? stringArray.length : 0;
            Object[] objectArray = new String[n + 1];
            objectArray[0] = DEFAULT_OPTION;
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2 + 1] = this.getExternalName(stringArray[n2]);
                ++n2;
            }
            this.mdlTablespace = new NonNullableComboBoxModel(objectArray);
            this.cmbTablespace.setModel(this.mdlTablespace);
        }
        if (oracleStorageProperties != null) {
            int n;
            int n3;
            int n4;
            int n5;
            String string = oracleStorageProperties.getTablespace();
            string = string == null ? DEFAULT_OPTION : this.getExternalName(string);
            this.cmbTablespace.setSelectedItem(string);
            this.fldPctFree.setNumber(oracleStorageProperties.getPercentFree());
            this.fldPctUsed.setNumber(oracleStorageProperties.getPercentUsed());
            this.fldIniTrans.setNumber(oracleStorageProperties.getInitrans());
            this.fldMaxTrans.setNumber(oracleStorageProperties.getMaxtrans());
            Integer n6 = oracleStorageProperties.getInitialExtent();
            string = EXTENTS_SIZES[0];
            if (n6 != null && (n5 = n6.intValue()) >= 1024 && n5 == (n4 = n5 / 1024) * 1024) {
                n5 = n4;
                string = EXTENTS_SIZES[1];
                n4 = n5 / 1024;
                if (n5 == n4 * 1024) {
                    n5 = n4;
                    string = EXTENTS_SIZES[2];
                }
                n6 = new Integer(n5);
            }
            this.fldInitExtents.setNumber(n6);
            this.cmbInitExtents.setSelectedItem(string);
            n6 = oracleStorageProperties.getNextExtent();
            string = EXTENTS_SIZES[0];
            if (n6 != null && (n3 = n6.intValue()) >= 1024 && n3 == (n = n3 / 1024) * 1024) {
                n3 = n;
                string = EXTENTS_SIZES[1];
                n = n3 / 1024;
                if (n3 == n * 1024) {
                    n3 = n;
                    string = EXTENTS_SIZES[2];
                }
                n6 = new Integer(n3);
            }
            this.fldNextExtents.setNumber(n6);
            this.cmbNextExtents.setSelectedItem(string);
            this.fldMinExtents.setNumber(oracleStorageProperties.getMinExtent());
            n6 = oracleStorageProperties.getMaxExtent();
            if (n6 != null && n6 == Integer.MAX_VALUE) {
                this.fldMaxExtents.setNumber(null);
                this.chkUnlimited.setSelected(true);
                this.fldMaxExtents.setEnabled(false);
            } else {
                this.fldMaxExtents.setNumber(n6);
                this.chkUnlimited.setSelected(false);
            }
            this.fldPctIncrease.setNumber(oracleStorageProperties.getPercentIncrease());
            this.fldFreeLists.setNumber(oracleStorageProperties.getFreelists());
            this.fldFreeListGroups.setNumber(oracleStorageProperties.getFreelistGroups());
            this.cmbBufferPool.setSelectedItem(oracleStorageProperties.getBufferMode());
            Boolean bl = oracleStorageProperties.getLogging();
            int n7 = bl == null ? 0 : (bl != false ? 1 : 2);
            this.cmbLogging.setSelectedIndex(n7);
        }
    }

    protected void commit(OracleStorageProperties oracleStorageProperties, boolean bl) throws TraversalException {
        Integer n;
        String string = (String)this.mdlTablespace.getSelectedItem();
        string = DEFAULT_OPTION.equals(string) ? null : this.getInternalName(string);
        Integer n2 = (Integer)this.fldPctFree.getNumber();
        Integer n3 = (Integer)this.fldPctUsed.getNumber();
        Integer n4 = (Integer)this.fldIniTrans.getNumber();
        Integer n5 = (Integer)this.fldMaxTrans.getNumber();
        Integer n6 = (Integer)this.fldInitExtents.getNumber();
        if (n6 != null) {
            switch (this.cmbInitExtents.getSelectedIndex()) {
                case 1: {
                    n6 = new Integer(n6 * 1024);
                    break;
                }
                case 2: {
                    n6 = new Integer(n6 * 0x100000);
                }
            }
        }
        if ((n = (Integer)this.fldNextExtents.getNumber()) != null) {
            switch (this.cmbNextExtents.getSelectedIndex()) {
                case 1: {
                    n = new Integer(n * 1024);
                    break;
                }
                case 2: {
                    n = new Integer(n * 0x100000);
                }
            }
        }
        Integer n7 = (Integer)this.fldMinExtents.getNumber();
        Integer n8 = this.chkUnlimited.isSelected() ? new Integer(Integer.MAX_VALUE) : (Integer)this.fldMaxExtents.getNumber();
        Integer n9 = (Integer)this.fldPctIncrease.getNumber();
        Integer n10 = (Integer)this.fldFreeLists.getNumber();
        Integer n11 = (Integer)this.fldFreeListGroups.getNumber();
        OracleStorageProperties.BufferModes bufferModes = (OracleStorageProperties.BufferModes)this.cmbBufferPool.getSelectedItem();
        Boolean bl2 = null;
        switch (this.cmbLogging.getSelectedIndex()) {
            case 1: {
                bl2 = Boolean.TRUE;
                break;
            }
            case 2: {
                bl2 = Boolean.FALSE;
            }
        }
        oracleStorageProperties.setTablespace(string);
        oracleStorageProperties.setPercentFree(n2);
        oracleStorageProperties.setPercentUsed(n3);
        oracleStorageProperties.setInitrans(n4);
        oracleStorageProperties.setMaxtrans(n5);
        oracleStorageProperties.setInitialExtent(n6);
        oracleStorageProperties.setNextExtent(n);
        oracleStorageProperties.setMinExtent(n7);
        oracleStorageProperties.setMaxExtent(n8);
        oracleStorageProperties.setPercentIncrease(n9);
        oracleStorageProperties.setFreelists(n10);
        oracleStorageProperties.setFreelistGroups(n11);
        oracleStorageProperties.setBufferMode(bufferModes);
        oracleStorageProperties.setLogging(bl2);
        StorageInfoVerifier storageInfoVerifier = (StorageInfoVerifier)this.getVerifier();
        if (bl && storageInfoVerifier != null) {
            storageInfoVerifier.verifyRelation();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.fldMaxExtents.setEnabled(this.chkUnlimited.isSelected() ^ true);
    }

    protected void setTopLabelText(String string) {
        this.lblTop.setText(string);
        if (string == null) {
            this.remove((Component)this.lblTop);
        }
    }

    protected void enableAllComponents(boolean bl, boolean bl2) {
        this.chkUnlimited.setEnabled(bl);
        this.cmbBufferPool.setEnabled(bl);
        this.cmbInitExtents.setEnabled(bl);
        this.cmbLogging.setEnabled(bl);
        this.cmbNextExtents.setEnabled(bl);
        this.cmbTablespace.setEnabled(bl);
        this.cmbTablespace.setEditable(this.getProvider() != null && !(this.getProvider() instanceof Database));
        this.fldFreeListGroups.setEnabled(bl);
        this.fldFreeLists.setEnabled(bl);
        this.fldIniTrans.setEnabled(bl);
        this.fldInitExtents.setEnabled(bl);
        this.fldMaxExtents.setEnabled(bl);
        this.fldMaxTrans.setEnabled(bl);
        this.fldMinExtents.setEnabled(bl);
        this.fldNextExtents.setEnabled(bl);
        this.fldPctFree.setEnabled(bl);
        this.fldPctIncrease.setEnabled(bl);
        this.fldPctUsed.setEnabled(bl);
        if (bl || bl2) {
            this.lblBufferPool.setEnabled(bl);
            this.lblFreeListGroups.setEnabled(bl);
            this.lblFreeLists.setEnabled(bl);
            this.lblIniTrans.setEnabled(bl);
            this.lblInitExtents.setEnabled(bl);
            this.lblLogging.setEnabled(bl);
            this.lblMaxExtents.setEnabled(bl);
            this.lblMaxTrans.setEnabled(bl);
            this.lblMinExtents.setEnabled(bl);
            this.lblNextExtents.setEnabled(bl);
            this.lblPctFree.setEnabled(bl);
            this.lblPctIncrease.setEnabled(bl);
            this.lblPctUsed.setEnabled(bl);
            this.lblTablespace.setEnabled(bl);
            this.pnlExtents.setEnabled(bl);
            this.pnlFreeLists.setEnabled(bl);
        }
    }

    protected void enableAllComponents(StorageInfoVerifier storageInfoVerifier, boolean bl) {
        if (storageInfoVerifier != null) {
            this.cmbTablespace.setEnabled(storageInfoVerifier.canChangeTablespace());
            this.cmbTablespace.setEditable(storageInfoVerifier.canEditTablespace());
            this.fldPctFree.setEnabled(storageInfoVerifier.canChangePercentFree());
            this.fldPctUsed.setEnabled(storageInfoVerifier.canChangePercentUsed());
            this.fldIniTrans.setEnabled(storageInfoVerifier.canChangeInitrans());
            this.fldMaxTrans.setEnabled(storageInfoVerifier.canChangeMaxtrans());
            this.fldInitExtents.setEnabled(storageInfoVerifier.canChangeInitialExtent());
            this.cmbInitExtents.setEnabled(storageInfoVerifier.canChangeInitialExtent());
            this.fldNextExtents.setEnabled(storageInfoVerifier.canChangeNextExtent());
            this.cmbNextExtents.setEnabled(storageInfoVerifier.canChangeNextExtent());
            this.fldMinExtents.setEnabled(storageInfoVerifier.canChangeMinExtent());
            this.fldMaxExtents.setEnabled(storageInfoVerifier.canChangeMaxExtent());
            this.chkUnlimited.setEnabled(storageInfoVerifier.canChangeMaxExtent());
            this.fldPctIncrease.setEnabled(storageInfoVerifier.canChangePercentIncrease());
            this.cmbLogging.setEnabled(storageInfoVerifier.canChangeLogging());
            this.fldFreeLists.setEnabled(storageInfoVerifier.canChangeFreelists());
            this.fldFreeListGroups.setEnabled(storageInfoVerifier.canChangeFreelists());
            this.cmbBufferPool.setEnabled(storageInfoVerifier.canChangeBufferMode());
            if (bl) {
                this.lblTablespace.setEnabled(storageInfoVerifier.canChangeTablespace());
                this.lblPctFree.setEnabled(storageInfoVerifier.canChangePercentFree());
                this.lblPctUsed.setEnabled(storageInfoVerifier.canChangePercentUsed());
                this.lblIniTrans.setEnabled(storageInfoVerifier.canChangeInitrans());
                this.lblMaxTrans.setEnabled(storageInfoVerifier.canChangeMaxtrans());
                this.lblInitExtents.setEnabled(storageInfoVerifier.canChangeInitialExtent());
                this.lblNextExtents.setEnabled(storageInfoVerifier.canChangeNextExtent());
                this.lblMinExtents.setEnabled(storageInfoVerifier.canChangeMinExtent());
                this.lblMaxExtents.setEnabled(storageInfoVerifier.canChangeMaxExtent());
                this.lblPctIncrease.setEnabled(storageInfoVerifier.canChangePercentIncrease());
                this.lblLogging.setEnabled(storageInfoVerifier.canChangeLogging());
                this.lblFreeLists.setEnabled(storageInfoVerifier.canChangeFreelists());
                this.lblFreeListGroups.setEnabled(storageInfoVerifier.canChangeFreelists());
                this.lblBufferPool.setEnabled(storageInfoVerifier.canChangeBufferMode());
                this.pnlExtents.setEnabled(storageInfoVerifier.canChangeInitialExtent() || storageInfoVerifier.canChangeNextExtent() || storageInfoVerifier.canChangeMinExtent() || storageInfoVerifier.canChangeMaxExtent());
                this.pnlFreeLists.setEnabled(storageInfoVerifier.canChangeFreelists());
            }
        } else {
            this.enableAllComponents(true, bl);
        }
    }

    private static class StorageNumberField
    extends NumberTextField {
        private int _maxValue;

        private void $init$() {
            this._maxValue = Integer.MAX_VALUE;
        }

        public StorageNumberField() {
            this.$init$();
            this.setDataType(Integer.class);
            this.setSigned(false);
        }

        protected boolean validateNumber(Number number) {
            return number == null || number.intValue() >= 0 && number.intValue() <= this._maxValue;
        }

        public int getMaximumValue() {
            return this._maxValue;
        }

        public void setMaximumValue(int n) {
            this._maxValue = n;
        }
    }
}

