/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.BaseConstraintPanel;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.db.verifiers.table.ColumnInfoVerifier;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.db.verifiers.table.TableInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.util.ModelUtil;

public class SimpleCreateTablePanel
extends BaseInfoPanel {
    private GridBagLayout _layoutGB;
    private SimpleTableModel _columnModel;
    private JTable _tblColumnList;
    private JButton _btnAddColumn;
    private JButton _btnRemoveColumn;
    private DBObjectProvider _prov;
    private Table _table;
    protected TableInfoVerifier _tableVerifier;
    protected ColumnInfoVerifier _columnVerifier;
    protected ConstraintsInfoVerifier _constraintVerifier;
    private ArrayList _typeArray;
    private boolean _initialized;
    public static final String HELP_SIMPLE_TABLE = "f1_createsimpletable_html";
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final Long LONG_0;

    private void $init$() {
        this._layoutGB = new GridBagLayout();
        this._columnModel = new SimpleTableModel();
        this._tblColumnList = new JTable();
        this._btnAddColumn = new JButton();
        this._btnRemoveColumn = new JButton();
        this._tableVerifier = null;
        this._columnVerifier = null;
        this._constraintVerifier = null;
        this._typeArray = new ArrayList(5);
    }

    public SimpleCreateTablePanel() {
        this.$init$();
        this._initialized = false;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layoutGB);
        this._btnAddColumn.setText(UIArb.getString(421));
        this._btnRemoveColumn.setText(UIArb.getString(422));
        this._btnAddColumn.addActionListener(new 1());
        this._btnRemoveColumn.addActionListener(new 2());
        this._tblColumnList.setModel(this._columnModel);
        TableColumn tableColumn = this._tblColumnList.getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new DefaultCellEditor(new IntegerTextField(null)));
        TableColumnModel tableColumnModel = this._tblColumnList.getColumnModel();
        TableColumn tableColumn2 = tableColumnModel.getColumn(0);
        tableColumn2.setMinWidth(110);
        tableColumn2 = tableColumnModel.getColumn(1);
        tableColumn2.setMinWidth(110);
        tableColumn2.setMaxWidth(150);
        tableColumn2 = tableColumnModel.getColumn(2);
        tableColumn2.setMinWidth(50);
        tableColumn2.setMaxWidth(60);
        tableColumn2 = tableColumnModel.getColumn(3);
        tableColumn2.setMinWidth(60);
        tableColumn2.setMaxWidth(60);
        tableColumn2 = tableColumnModel.getColumn(4);
        tableColumn2.setMinWidth(70);
        tableColumn2.setMaxWidth(70);
        JScrollPane jScrollPane = new JScrollPane(this._tblColumnList);
        this._tblColumnList.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this._tblColumnList.setSelectionMode(0);
        ColumnListCellRenderer columnListCellRenderer = new ColumnListCellRenderer();
        try {
            this._tblColumnList.setDefaultRenderer(Class.forName("java.lang.Object"), columnListCellRenderer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.add(jScrollPane, new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._btnAddColumn, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this._btnRemoveColumn, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
    }

    public void init(DBObjectProvider dBObjectProvider) {
        DataType[] dataTypeArray = dBObjectProvider.listSupportedDataTypes();
        boolean bl = false;
        int n = 0;
        while (n < dataTypeArray.length) {
            if (dataTypeArray[n] instanceof PredefinedDataType) {
                if (dataTypeArray[n].getName().equals("VARCHAR2")) {
                    if (!bl) {
                        this._typeArray.add(0, dataTypeArray[n]);
                        bl = true;
                    }
                } else if (dataTypeArray[n].getName().equals("NUMBER")) {
                    this._typeArray.add(dataTypeArray[n]);
                } else if (dataTypeArray[n].getName().equals("DATE")) {
                    this._typeArray.add(dataTypeArray[n]);
                } else if (dataTypeArray[n].getName().equals("CLOB")) {
                    this._typeArray.add(dataTypeArray[n]);
                } else if (dataTypeArray[n].getName().equals("INTEGER")) {
                    this._typeArray.add(dataTypeArray[n]);
                }
            }
            ++n;
        }
        this._initialized = true;
    }

    private void initializeVerifier(Verifier verifier) {
        if (verifier != null) {
            verifier.initializeVerifier(this._prov, null, (SchemaObject)this._table);
        }
    }

    static {
        $assertionsDisabled = SimpleCreateTablePanel.class.desiredAssertionStatus() ^ true;
        LONG_0 = new Long(0L);
    }

    public void onEntry(TraversableContext traversableContext) {
        this._prov = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        this._table = (Table)traversableContext.find("NewObject");
        if (!$assertionsDisabled && traversableContext.find("OriginalObject") != null) {
            throw new AssertionError((Object)"simple create panel shouldn't be shown in edit dialog.");
        }
        this._tableVerifier = (TableInfoVerifier)traversableContext.find("SchemaObjectInfoVerifier");
        this._columnVerifier = (ColumnInfoVerifier)traversableContext.find("ColumnInfoVerifier");
        this._constraintVerifier = (ConstraintsInfoVerifier)traversableContext.find("ConstraintsInfoVerifier");
        this.initializeVerifier(this._tableVerifier);
        this.initializeVerifier(this._columnVerifier);
        this.initializeVerifier(this._constraintVerifier);
        this.setup();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        TableCellEditor tableCellEditor = this._tblColumnList.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        int n = this._columnModel.size();
        ArrayList<Column> arrayList = new ArrayList<Column>(n);
        ArrayList<Column> arrayList2 = new ArrayList<Column>();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this._columnModel.getValueAt(n2, 0);
            DataType dataType = (DataType)this._columnModel.getValueAt(n2, 1);
            String string2 = (String)this._columnModel.getValueAt(n2, 2);
            Boolean bl = (Boolean)this._columnModel.getValueAt(n2, 3);
            Boolean bl2 = (Boolean)this._columnModel.getValueAt(n2, 4);
            String string3 = this._prov.getInternalName(string);
            Column column = this._table.getColumn(string3);
            if (column == null) {
                column = new Column(string3);
                column.setID(TemporaryObjectID.createID((DBObject)column));
            }
            column.setNotNull(bl.booleanValue());
            DataTypeUsage dataTypeUsage = dataType.createDefaultUsage();
            if ("VARCHAR2".equals(dataType.getName())) {
                dataTypeUsage.putAttributeValue("size", (Object)DataTypeHelper.toLong((Object)string2));
            } else if ("NUMBER".equals(dataType.getName()) && ModelUtil.hasLength((String)string2)) {
                dataTypeUsage.putAttributeValue("precision", (Object)DataTypeHelper.toLong((Object)string2));
                dataTypeUsage.putAttributeValue("scale", (Object)LONG_0);
            }
            column.setDataTypeUsage(dataTypeUsage);
            if (this._columnVerifier != null) {
                this._columnVerifier.verifyColumn(null, column);
            }
            arrayList.add(column);
            if (bl2.booleanValue()) {
                arrayList2.add(column);
            }
            ++n2;
        }
        this._table.setColumns(arrayList.toArray(new Column[arrayList.size()]));
        if (this._columnVerifier != null) {
            this._columnVerifier.verifyRelation();
        }
        if (arrayList2.size() > 0) {
            Constraint[] constraintArray;
            Constraint[] constraintArray2 = this._table.getConstraints();
            PKConstraint pKConstraint = null;
            boolean bl = false;
            int n3 = 0;
            while (n3 < constraintArray2.length) {
                if ("PKConstraint".equals(constraintArray2[n3].getConstraintType())) {
                    pKConstraint = (PKConstraint)constraintArray2[n3];
                    bl = true;
                }
                ++n3;
            }
            if (pKConstraint == null) {
                pKConstraint = new PKConstraint();
                String string = BaseConstraintPanel.findUniqueName((Relation)this._table, (Constraint)pKConstraint, new Constraint[0]);
                if (this._constraintVerifier != null) {
                    try {
                        this._constraintVerifier.verifyName(string);
                    }
                    catch (TraversalException traversalException) {
                        traversalException.printStackTrace();
                    }
                }
                pKConstraint.setName(string);
            }
            pKConstraint.setEnabled(true);
            pKConstraint.setID(TemporaryObjectID.createID((DBObject)pKConstraint));
            pKConstraint.setColumns(arrayList2.toArray(new Column[arrayList2.size()]));
            if (bl) {
                constraintArray = constraintArray2;
            } else {
                constraintArray = new Constraint[constraintArray2.length + 1];
                constraintArray[0] = pKConstraint;
                int n4 = 1;
                while (n4 <= constraintArray2.length) {
                    constraintArray[n4] = constraintArray2[n4 - 1];
                    ++n4;
                }
            }
            this._table.setConstraints(constraintArray);
        }
    }

    private void setup() {
        if (!this._initialized) {
            this.init(this._prov);
        }
        this._columnModel = new SimpleTableModel();
        this._tblColumnList.setModel(this._columnModel);
        TableColumn tableColumn = this._tblColumnList.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(this._typeArray.toArray())));
        Column[] columnArray = this._table.getColumns();
        if (columnArray.length == 0 && this._columnModel.size() == 0) {
            this._columnModel.addDefaultRow(0);
            this._tblColumnList.setRowSelectionInterval(0, 0);
        } else {
            Constraint[] constraintArray = this._table.getConstraints();
            PKConstraint pKConstraint = null;
            int n = 0;
            while (n < constraintArray.length) {
                if ("PKConstraint".equals(constraintArray[n].getConstraintType())) {
                    pKConstraint = (PKConstraint)constraintArray[n];
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < columnArray.length) {
                String string = columnArray[n2].getName();
                DataTypeUsage dataTypeUsage = columnArray[n2].getDataTypeUsage();
                DataType dataType = null;
                boolean bl = false;
                boolean bl2 = columnArray[n2].isNotNull();
                String string2 = "";
                try {
                    dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (dataType != null) {
                    if (dataType.getName().equals("VARCHAR2")) {
                        string2 = dataTypeUsage.getAttributeValue("size").toString();
                    } else if (dataType.getName().equals("NUMBER") && dataTypeUsage.getAttributeValue("precision") != null) {
                        string2 = dataTypeUsage.getAttributeValue("precision").toString();
                    }
                }
                if (pKConstraint != null) {
                    Column[] columnArray2 = pKConstraint.getColumns();
                    int n3 = 0;
                    while (n3 < columnArray2.length) {
                        if (columnArray2[n3].equals((Object)columnArray[n2])) {
                            bl = true;
                            bl2 = true;
                            break;
                        }
                        ++n3;
                    }
                }
                this._columnModel.addRow(n2, string, dataType, string2, bl2, bl);
                ++n2;
            }
        }
    }

    static String maS$getUniqueName(String string, DefaultListModel defaultListModel) {
        return BaseInfoPanel.getUniqueName(string, defaultListModel);
    }

    static ArrayList ra$_typeArray(SimpleCreateTablePanel simpleCreateTablePanel) {
        return simpleCreateTablePanel._typeArray;
    }

    static JTable ra$_tblColumnList(SimpleCreateTablePanel simpleCreateTablePanel) {
        return simpleCreateTablePanel._tblColumnList;
    }

    static SimpleTableModel ra$_columnModel(SimpleCreateTablePanel simpleCreateTablePanel) {
        return simpleCreateTablePanel._columnModel;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = SimpleCreateTablePanel.ra$_tblColumnList(SimpleCreateTablePanel.this).getSelectedRow();
            n = n < 0 ? SimpleCreateTablePanel.ra$_columnModel(SimpleCreateTablePanel.this).size() : ++n;
            SimpleCreateTablePanel.ra$_columnModel(SimpleCreateTablePanel.this).addDefaultRow(n);
            SimpleCreateTablePanel.ra$_tblColumnList(SimpleCreateTablePanel.this).setRowSelectionInterval(n, n);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = SimpleCreateTablePanel.ra$_tblColumnList(SimpleCreateTablePanel.this).getSelectedRow();
            if (n >= 0) {
                SimpleCreateTablePanel.ra$_columnModel(SimpleCreateTablePanel.this).deleteRow(SimpleCreateTablePanel.ra$_tblColumnList(SimpleCreateTablePanel.this).getSelectedRow());
                if (n > 0) {
                    SimpleCreateTablePanel.ra$_tblColumnList(SimpleCreateTablePanel.this).setRowSelectionInterval(n - 1, n - 1);
                } else if (SimpleCreateTablePanel.ra$_columnModel(SimpleCreateTablePanel.this).size() > 0) {
                    SimpleCreateTablePanel.ra$_tblColumnList(SimpleCreateTablePanel.this).setRowSelectionInterval(0, 0);
                }
            }
        }
    }

    private class SimpleTableModel
    extends AbstractTableModel {
        public String[] columnNames;
        private ArrayList _data;
        private DefaultListModel _mdlColumns;

        private void $init$() {
            this.columnNames = new String[]{UIArb.getString(423), UIArb.getString(424), UIArb.getString(425), UIArb.getString(426), UIArb.getString(427)};
            this._data = new ArrayList(1);
            this._mdlColumns = new DefaultListModel();
        }

        public SimpleTableModel() {
            this.$init$();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this._data.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n >= this._data.size()) {
                return null;
            }
            ArrayList arrayList = (ArrayList)this._data.get(n);
            if (n2 >= arrayList.size()) {
                return null;
            }
            return arrayList.get(n2);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 2) {
                Object object = this.getValueAt(n, 1);
                String string = object.toString();
                return string.equals("NUMBER") || string.equals("VARCHAR2");
            }
            if (n2 == 4) {
                Object object = this.getValueAt(n, 1);
                String string = object.toString();
                if (string.equals("CLOB")) {
                    return false;
                }
                if (!(string.equals("NUMBER") || string.equals("VARCHAR2") || string.equals("INTEGER") || string.equals("DATE") || string.equals("CLOB"))) {
                    return false;
                }
            } else if (n2 == 3) {
                Boolean bl = (Boolean)this.getValueAt(n, 4);
                if (bl.booleanValue()) {
                    return false;
                }
                Object object = this.getValueAt(n, 1);
                String string = object.toString();
                if (!(string.equals("NUMBER") || string.equals("VARCHAR2") || string.equals("INTEGER") || string.equals("DATE") || string.equals("CLOB"))) {
                    return false;
                }
            } else if (n2 == 1) {
                Object object = this.getValueAt(n, 1);
                String string = object.toString();
                return string.equals("NUMBER") || string.equals("VARCHAR2") || string.equals("INTEGER") || string.equals("DATE") || string.equals("CLOB");
            }
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n >= this._data.size()) {
                return;
            }
            ArrayList arrayList = (ArrayList)this._data.get(n);
            if (n2 >= arrayList.size()) {
                return;
            }
            if (n2 == 0) {
                this._mdlColumns.removeElement(arrayList.get(0));
                this._mdlColumns.addElement(object);
            }
            arrayList.set(n2, object);
            if (n2 == 1) {
                if (object.toString().equals("VARCHAR2")) {
                    arrayList.set(2, "4000");
                } else if (object.toString().equals("NUMBER")) {
                    arrayList.set(2, "");
                } else if (object.toString().equals("CLOB")) {
                    arrayList.set(4, new Boolean(false));
                    arrayList.set(2, "");
                    this.fireTableCellUpdated(n, 4);
                } else {
                    arrayList.set(2, "");
                }
                this.fireTableCellUpdated(n, 2);
            } else if (n2 == 4 && ((Boolean)object).booleanValue()) {
                arrayList.set(3, new Boolean(true));
                this.fireTableCellUpdated(n, 3);
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void addDefaultRow(int n) {
            ArrayList<Object> arrayList = new ArrayList<Object>(5);
            String string = SimpleCreateTablePanel.maS$getUniqueName("COLUMN", this._mdlColumns);
            this._mdlColumns.addElement(string);
            arrayList.add(string);
            arrayList.add(SimpleCreateTablePanel.ra$_typeArray(SimpleCreateTablePanel.this).get(0));
            arrayList.add("4000");
            arrayList.add(new Boolean(false));
            arrayList.add(new Boolean(false));
            this._data.add(n, arrayList);
            this.fireTableDataChanged();
        }

        public void addRow(int n, String string, DataType dataType, String string2, boolean bl, boolean bl2) {
            ArrayList<Object> arrayList = new ArrayList<Object>(5);
            this._mdlColumns.addElement(string);
            arrayList.add(string);
            arrayList.add(dataType);
            arrayList.add(string2);
            arrayList.add(new Boolean(bl));
            arrayList.add(new Boolean(bl2));
            this._data.add(n, arrayList);
            this.fireTableDataChanged();
        }

        public void deleteRow(int n) {
            ArrayList arrayList = (ArrayList)this._data.get(n);
            this._mdlColumns.removeElement(arrayList.get(0));
            this._data.remove(n);
            this.fireTableDataChanged();
        }

        public int size() {
            return this._data.size();
        }
    }

    private class ColumnListCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            TableModel tableModel = jTable.getModel();
            if (!jTable.isRowSelected(n)) {
                if (!tableModel.isCellEditable(n, n2)) {
                    component.setBackground(Color.lightGray);
                } else {
                    component.setBackground(Color.white);
                }
            }
            return component;
        }
    }

    private class IntegerTextField
    extends JTextField {
        static final String badchars = "`~!@#$%^&*()_+-=\\|\"':;?/>.<, ";

        public void processKeyEvent(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (Character.isLetter(c) && !keyEvent.isAltDown() || badchars.indexOf(c) > -1) {
                keyEvent.consume();
                return;
            }
            super.processKeyEvent(keyEvent);
        }

        private IntegerTextField() {
        }

        IntegerTextField(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

