/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.PartitionDefinitionPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.dialogs.MessageDialog;

public class PartitioningPanel
extends BaseInfoPanel
implements ActionListener {
    private DBObjectRenderer m_rend;
    private FSM m_fsm;
    private OracleTablePartitions.PartitionType m_lastType;
    private OracleTablePartitions.PartitionType m_lastSubtype;
    private WizardCallbacks m_wizCallbacks;
    private JLabel m_typeLabel;
    private JComboBox m_typeComboBox;
    private DefaultListModel m_colsFromModel;
    private ListPicker m_colsFromPick;
    private DefaultListModel m_colsToModel;
    private ListPicker m_colsToPick;
    private Shuttle m_colsShuttle;
    private JLabel m_subtypeLabel;
    private JComboBox m_subtypeComboBox;
    private ListPicker m_subColsFromPick;
    private DefaultListModel m_subColsToModel;
    private ListPicker m_subColsToPick;
    private Shuttle m_subColsShuttle;

    private void $init$() {
        this.m_rend = new DBObjectRenderer();
        this.m_typeLabel = new JLabel();
        this.m_typeComboBox = new JComboBox();
        this.m_colsFromModel = new DefaultListModel();
        this.m_colsFromPick = new ListPicker(new JList(this.m_colsFromModel));
        this.m_colsToModel = new DefaultListModel();
        this.m_colsToPick = new ReorderableListPicker(new JList(this.m_colsToModel));
        this.m_colsShuttle = new Shuttle();
        this.m_subtypeLabel = new JLabel();
        this.m_subtypeComboBox = new JComboBox();
        this.m_subColsFromPick = new ListPicker(new JList(this.m_colsFromModel));
        this.m_subColsToModel = new DefaultListModel();
        this.m_subColsToPick = new ReorderableListPicker(new JList(this.m_subColsToModel));
        this.m_subColsShuttle = new Shuttle();
    }

    public PartitioningPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_typeComboBox.addItem(UIArb.getString(342));
        OracleTablePartitions.PartitionType[] partitionTypeArray = OracleTablePartitions.PartitionType.values();
        int n = 0;
        while (n < partitionTypeArray.length) {
            OracleTablePartitions.PartitionType partitionType = partitionTypeArray[n];
            this.m_typeComboBox.addItem(partitionType);
            ++n;
        }
        this.m_typeComboBox.addActionListener(this);
        this.m_subtypeComboBox.addItem(UIArb.getString(342));
        this.m_subtypeComboBox.addItem(OracleTablePartitions.PartitionType.LIST);
        this.m_subtypeComboBox.addItem(OracleTablePartitions.PartitionType.HASH);
        this.m_subtypeComboBox.addActionListener(this);
        this.m_colsFromPick.getList().setCellRenderer(this.m_rend);
        this.m_colsShuttle.setFromPicker((ItemPicker)this.m_colsFromPick);
        this.m_colsToPick.getList().setCellRenderer(this.m_rend);
        this.m_colsShuttle.setToPicker((ItemPicker)this.m_colsToPick);
        this.m_subColsFromPick.getList().setCellRenderer(this.m_rend);
        this.m_subColsShuttle.setFromPicker((ItemPicker)this.m_subColsFromPick);
        this.m_subColsToPick.getList().setCellRenderer(this.m_rend);
        this.m_subColsShuttle.setToPicker((ItemPicker)this.m_subColsToPick);
        ResourceUtils.resLabel((JLabel)this.m_typeLabel, (Component)this.m_typeComboBox, (String)UIArb.getString(338));
        ResourceUtils.resLabel((JLabel)this.m_subtypeLabel, (Component)this.m_subtypeComboBox, (String)UIArb.getString(339));
        int n2 = 0;
        this.add(this.m_typeLabel, new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_typeComboBox, new GridBagConstraints(1, n2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 20), 0, 0));
        this.add((Component)this.m_colsShuttle, new GridBagConstraints(0, ++n2, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_subtypeLabel, new GridBagConstraints(0, ++n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_subtypeComboBox, new GridBagConstraints(1, n2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 20), 0, 0));
        this.add((Component)this.m_subColsShuttle, new GridBagConstraints(0, ++n2, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        Table table = (Table)traversableContext.get("NewObject");
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        String[] stringArray = this.getTablespaces(traversableContext, dBObjectProvider);
        boolean bl = traversableContext.get("OriginalObject") != null;
        this.m_wizCallbacks = traversableContext.getWizardCallbacks();
        this.init(dBObjectProvider, table, oracleTablePartitions, stringArray, bl);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        Table table = (Table)traversableContext.get("NewObject");
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        this.commit(dBObjectProvider, table, oracleTablePartitions);
    }

    private void init(DBObjectProvider dBObjectProvider, Table table, OracleTablePartitions oracleTablePartitions, String[] stringArray, boolean bl) {
        this.m_colsFromModel.removeAllElements();
        this.m_colsToModel.removeAllElements();
        this.m_subColsToModel.removeAllElements();
        Column[] columnArray = table.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            String string;
            Column column = columnArray[n];
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dataType == null) {
                if (!(column instanceof ViewColumn) || !column.getName().equals("*") && !column.getName().endsWith(".*")) {
                    this.m_colsFromModel.addElement(column);
                }
            } else if (!(dataType instanceof ComplexType || "BLOB".equalsIgnoreCase(string = dataType.getName()) || "CLOB".equalsIgnoreCase(string) || "NCLOB".equalsIgnoreCase(string))) {
                this.m_colsFromModel.addElement(column);
            }
            ++n;
        }
        if (oracleTablePartitions != null) {
            this.m_typeComboBox.setSelectedItem(oracleTablePartitions.getPartitionType());
            DBObjectID[] dBObjectIDArray = oracleTablePartitions.getPartitionColumns();
            int n2 = 0;
            while (n2 < dBObjectIDArray.length) {
                DBObjectID dBObjectID = dBObjectIDArray[n2];
                Column[] columnArray2 = table.getColumns();
                int n3 = 0;
                while (n3 < columnArray2.length) {
                    Column column = columnArray2[n3];
                    DBObjectID dBObjectID2 = column.getID();
                    if (dBObjectID2 != null && dBObjectID2.equals(dBObjectID, false)) {
                        this.m_colsFromModel.removeElement(column);
                        this.m_colsToModel.addElement(column);
                    }
                    ++n3;
                }
                ++n2;
            }
            OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
            if (oracleTablePartitions2 == null) {
                this.m_subtypeComboBox.setSelectedItem(UIArb.getString(342));
                this.enableSubpartitionShuttle(false);
            } else {
                this.m_subtypeComboBox.setSelectedItem(oracleTablePartitions2.getPartitionType());
                DBObjectID[] dBObjectIDArray2 = oracleTablePartitions2.getPartitionColumns();
                int n4 = 0;
                while (n4 < dBObjectIDArray2.length) {
                    DBObjectID dBObjectID = dBObjectIDArray2[n4];
                    Column[] columnArray3 = table.getColumns();
                    int n5 = 0;
                    while (n5 < columnArray3.length) {
                        Column column = columnArray3[n5];
                        DBObjectID dBObjectID3 = column.getID();
                        if (dBObjectID3 != null && dBObjectID3.equals(dBObjectID, false)) {
                            this.m_colsFromModel.removeElement(column);
                            this.m_subColsToModel.addElement(column);
                        }
                        ++n5;
                    }
                    ++n4;
                }
            }
        }
        if (!((Boolean)table.getProperty("PARTITIONED TABLE", (Object)Boolean.FALSE)).booleanValue()) {
            this.m_typeComboBox.setSelectedItem(UIArb.getString(342));
            this.enablePartitionShuttle(false);
            this.enableSubpartitionShuttle(false);
        }
        this.m_colsShuttle.updateUI();
        this.m_subColsShuttle.updateUI();
        if (bl && dBObjectProvider instanceof Database) {
            this.m_typeLabel.setEnabled(false);
            this.m_typeComboBox.setEnabled(false);
            this.enablePartitionShuttle(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commit(DBObjectProvider dBObjectProvider, Table table, OracleTablePartitions oracleTablePartitions) throws TraversalException {
        if (!this.m_typeComboBox.isEnabled()) return;
        boolean bl = false;
        OracleTablePartitions.PartitionType partitionType = oracleTablePartitions == null ? null : oracleTablePartitions.getPartitionType();
        Object object = this.m_typeComboBox.getSelectedItem();
        if (object instanceof OracleTablePartitions.PartitionType) {
            if (partitionType != null && partitionType != object) {
                if (!MessageDialog.confirm((Component)((Object)this), (Object)UIArb.getString(345), (String)UIArb.getString(346), null, (boolean)true)) throw new TraversalException(null);
                oracleTablePartitions = null;
                bl = true;
            }
            if (oracleTablePartitions == null) {
                oracleTablePartitions = new OracleTablePartitions();
                oracleTablePartitions.setObjectType(OracleTablePartitions.ObjectType.PARTITION);
                table.setProperty("PARTITIONED TABLE", (Object)Boolean.TRUE);
                table.setProperty("OracleTablePartitions", (Object)oracleTablePartitions);
            }
            oracleTablePartitions.setPartitionType((OracleTablePartitions.PartitionType)object);
            Enumeration enumeration = this.m_colsToModel.elements();
            DBObjectID[] dBObjectIDArray = new DBObjectID[this.m_colsToModel.size()];
            int n = 0;
            while (n < dBObjectIDArray.length) {
                Column column = (Column)enumeration.nextElement();
                dBObjectIDArray[n] = column.getID();
                if (dBObjectIDArray[n] == null) {
                    dBObjectIDArray[n] = TemporaryObjectID.createID((DBObject)column);
                    column.setID(dBObjectIDArray[n]);
                }
                ++n;
            }
            oracleTablePartitions.setPartitionColumns(dBObjectIDArray);
            OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
            Object object2 = this.m_subtypeComboBox.getSelectedItem();
            if (this.m_subtypeComboBox.isEnabled() && object2 instanceof OracleTablePartitions.PartitionType) {
                if (oracleTablePartitions2 != null && object2 != oracleTablePartitions2.getPartitionType()) {
                    if (!bl && !MessageDialog.confirm((Component)((Object)this), (Object)UIArb.getString(347), (String)UIArb.getString(348), null, (boolean)true)) throw new TraversalException(null);
                    oracleTablePartitions2 = null;
                    TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
                    if (tablePartitionArray != null) {
                        int n2 = 0;
                        while (n2 < tablePartitionArray.length) {
                            tablePartitionArray[n2].setPartitionLevelSubpartitions(null);
                            ++n2;
                        }
                    }
                }
                if (oracleTablePartitions2 == null) {
                    oracleTablePartitions2 = new OracleTablePartitions();
                    oracleTablePartitions2.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION);
                    oracleTablePartitions.setSubpartitionModel(oracleTablePartitions2);
                }
                oracleTablePartitions2.setPartitionType((OracleTablePartitions.PartitionType)object2);
                Enumeration enumeration2 = this.m_subColsToModel.elements();
                DBObjectID[] dBObjectIDArray2 = new DBObjectID[this.m_subColsToModel.size()];
                int n3 = 0;
                while (n3 < dBObjectIDArray2.length) {
                    Column column = (Column)enumeration2.nextElement();
                    dBObjectIDArray2[n3] = column.getID();
                    if (dBObjectIDArray2[n3] == null) {
                        dBObjectIDArray2[n3] = TemporaryObjectID.createID((DBObject)column);
                        column.setID(dBObjectIDArray2[n3]);
                    }
                    ++n3;
                }
                oracleTablePartitions2.setPartitionColumns(dBObjectIDArray2);
            } else {
                oracleTablePartitions2 = null;
                oracleTablePartitions.setSubpartitionModel(null);
            }
            try {
                oracleTablePartitions.validateColumns(table);
                if (oracleTablePartitions2 == null) return;
                oracleTablePartitions2.validateColumns(table);
                return;
            }
            catch (ValidationException validationException) {
                throw new TraversalException(validationException.getMessage(), validationException.getTitle());
            }
        } else {
            if (table.getProperty("PARTITIONED TABLE") == Boolean.TRUE) {
                table.setProperty("PARTITIONED TABLE", (Object)Boolean.FALSE);
            }
            table.setProperty("OracleTablePartitions", null);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_typeComboBox) {
            Object object2 = this.m_typeComboBox.getSelectedItem();
            this.enablePartitionShuttle(object2 instanceof OracleTablePartitions.PartitionType);
        } else if (object == this.m_subtypeComboBox) {
            Object object3 = this.m_subtypeComboBox.getSelectedItem();
            this.enableSubpartitionShuttle(object3 instanceof OracleTablePartitions.PartitionType);
        }
        if (this.m_wizCallbacks != null) {
            this.m_wizCallbacks.wizardUpdateExpectedTransition(this.getExitTransition());
        }
    }

    private void enablePartitionShuttle(boolean bl) {
        this.m_colsFromPick.getList().setEnabled(bl);
        this.m_colsToPick.getList().setEnabled(bl);
        this.m_colsShuttle.setEnabled(bl);
        if (bl) {
            OracleTablePartitions.PartitionType partitionType = (OracleTablePartitions.PartitionType)this.m_typeComboBox.getSelectedItem();
            bl = partitionType == OracleTablePartitions.PartitionType.RANGE;
        }
        this.m_subtypeLabel.setEnabled(bl);
        this.m_subtypeComboBox.setEnabled(bl);
        this.enableSubpartitionShuttle(bl && this.m_subtypeComboBox.getSelectedItem() instanceof OracleTablePartitions.PartitionType);
    }

    private void enableSubpartitionShuttle(boolean bl) {
        this.m_subColsFromPick.getList().setEnabled(bl);
        this.m_subColsToPick.getList().setEnabled(bl);
        this.m_subColsShuttle.setEnabled(bl);
        if (!(this.m_subtypeComboBox.getSelectedItem() instanceof OracleTablePartitions.PartitionType) && this.m_subColsToModel.size() > 0) {
            Enumeration enumeration = this.m_subColsToModel.elements();
            while (enumeration.hasMoreElements()) {
                this.m_colsFromModel.addElement(enumeration.nextElement());
            }
            this.m_subColsToModel.removeAllElements();
        }
    }

    public Object getExitTransition() {
        Object object = this.m_typeComboBox.getSelectedItem();
        if (object instanceof OracleTablePartitions.PartitionType) {
            Object object2;
            Object object3 = object2 = !this.m_subtypeComboBox.isEnabled() ? null : this.m_subtypeComboBox.getSelectedItem();
            if (this.m_fsm != null && this.m_lastType == object && this.m_lastSubtype == object2) {
                return this.m_fsm;
            }
            boolean bl = object2 instanceof OracleTablePartitions.PartitionType;
            Step[] stepArray = new Step[bl ? 2 : 1];
            int n = 0;
            if (bl) {
                stepArray[n++] = new Step(UIArb.getString(350), PartitionDefinitionPanel.class, new Class[]{Boolean.TYPE}, new Object[]{true}, null);
            }
            stepArray[n++] = new Step(UIArb.getString(349), PartitionDefinitionPanel.class, null);
            this.m_lastType = (OracleTablePartitions.PartitionType)object;
            this.m_lastSubtype = bl ? (OracleTablePartitions.PartitionType)object2 : null;
            this.m_fsm = FSMBuilder.newFSM((Step[])stepArray);
            return this.m_fsm;
        }
        return null;
    }
}

