/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.panels.table.LobDescriptorPanel;
import oracle.ide.db.panels.table.PartitionDefinitionPanel;
import oracle.ide.db.panels.table.PartitionStoragePanel;
import oracle.ide.db.panels.table.StorageInfoPanel;
import oracle.ide.db.verifiers.table.AbstractTableVerifier;
import oracle.ide.db.verifiers.table.LobParamsVerifier;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.dialogs.MessageDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionListPanel
extends JPanel
implements ListButtons.Helper,
ListSelectionListener,
ActionListener {
    private OracleTablePartitions.ObjectType m_objectType;
    private OracleTablePartitions.PartitionType m_partType;
    private OracleTablePartitions.PartitionType m_subpartType;
    protected DBObjectProvider m_pro;
    private Table m_table;
    private OracleTablePartitions m_otp;
    private String[] m_tablespaces;
    String m_parentPartitionName;
    private TablePartition m_currentPartition;
    private boolean m_editing;
    private Set<TablePartition> m_allPartitions;
    private JWrappedLabel m_descLabel;
    private JLabel m_nameLabel;
    private JTextField m_nameField;
    private DefaultListModel m_partListModel;
    private JList m_partList;
    private JLabel m_partLabel;
    private ListButtons m_partButtons;
    private JPanel m_editPanel;
    private JLabel m_valuesLabel;
    private JTextField m_valuesField;
    private JButton m_storageButton;
    private JButton m_subPartsButton;
    private JButton m_lobParametersButton;
    private final StorageInfoVerifier _editStorageInfoVerifier;
    private final StorageInfoVerifier _hashPartitionStorageInfoVerifier;
    private final LobParamsVerifier _hashPartitionLobParamsVerifier;

    private void $init$() {
        this.m_descLabel = new JWrappedLabel();
        this.m_nameLabel = new JLabel();
        this.m_nameField = new JTextField("");
        this.m_partListModel = new DefaultListModel();
        this.m_partList = new JList(this.m_partListModel);
        this.m_partLabel = new JLabel();
        this.m_partButtons = new ListButtons(this.m_partList, this);
        this.m_editPanel = new JPanel();
        this.m_valuesLabel = new JLabel();
        this.m_valuesField = new JTextField();
        this.m_storageButton = new JButton();
        this.m_subPartsButton = new JButton();
        this.m_lobParametersButton = new JButton();
        this._editStorageInfoVerifier = new EditStorageInfoVerifier(null);
        this._hashPartitionStorageInfoVerifier = new HashPartitionStorageInfoVerifier(null);
        this._hashPartitionLobParamsVerifier = new HashPartitionLobParamsVerifier(null);
    }

    public PartitionListPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_partButtons.addActionListener(this);
        this.m_partList.setSelectionMode(0);
        this.m_partList.addListSelectionListener(this);
        ResourceUtils.resLabel((JLabel)this.m_nameLabel, (Component)this.m_nameField, (String)UIArb.getString(357));
        ResourceUtils.resButton((AbstractButton)this.m_storageButton, (String)UIArb.getString(359));
        this.m_storageButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_lobParametersButton, (String)UIArb.getString(360));
        this.m_lobParametersButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_subPartsButton, (String)UIArb.getString(361));
        this.m_subPartsButton.addActionListener(this);
        int n = 0;
        this.add((Component)this.m_descLabel, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_partLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JScrollPane(this.m_partList), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_partButtons, new GridBagConstraints(1, n, 1, 1, 0.0, 1.0, 17, 3, new Insets(5, 5, 0, 5), 0, 0));
        this.m_editPanel.setLayout(new GridBagLayout());
        this.add((Component)this.m_editPanel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    private void layoutEditPanel() {
        int n = 373;
        int n2 = 351;
        OracleTablePartitions.PartitionType partitionType = this.m_partType;
        OracleTablePartitions.PartitionType partitionType2 = null;
        if (this.m_objectType != OracleTablePartitions.ObjectType.PARTITION) {
            if (this.m_objectType == OracleTablePartitions.ObjectType.SUBPARTITION || this.m_objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
                n = 375;
                n2 = 352;
            } else if (this.m_objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
                n = 374;
                n2 = 353;
            }
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)this.m_table.getProperty("OracleTablePartitions");
            partitionType = oracleTablePartitions.getPartitionType();
            partitionType2 = this.m_partType;
        }
        this.m_descLabel.setText(UIArb.format(n, partitionType, partitionType2));
        ResourceUtils.resLabel((JLabel)this.m_partLabel, (Component)this.m_partList, (String)UIArb.getString(n2));
        this.m_editPanel.removeAll();
        this.m_editPanel.setBorder(BorderFactory.createTitledBorder(this.m_objectType == OracleTablePartitions.ObjectType.PARTITION ? UIArb.getString(355) : UIArb.getString(356)));
        int n3 = 0;
        this.m_editPanel.add((Component)this.m_nameLabel, new GridBagConstraints(0, n3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.m_editPanel.add((Component)this.m_nameField, new GridBagConstraints(1, n3, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        if (this.m_partType == OracleTablePartitions.PartitionType.RANGE || this.m_partType == OracleTablePartitions.PartitionType.LIST) {
            String string = this.m_partType == OracleTablePartitions.PartitionType.RANGE ? "VALUES LESS THAN" : "VALUES";
            ResourceUtils.resLabel((JLabel)this.m_valuesLabel, (Component)this.m_valuesField, (String)UIArb.format(358, string));
            this.m_editPanel.add((Component)this.m_valuesLabel, new GridBagConstraints(0, ++n3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.m_editPanel.add((Component)this.m_valuesField, new GridBagConstraints(1, n3, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        }
        this.m_editPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, ++n3, 2, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.m_editPanel.add((Component)this.m_lobParametersButton, new GridBagConstraints(1, n3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_editPanel.add((Component)this.m_storageButton, new GridBagConstraints(2, n3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.m_subpartType != null) {
            this.m_editPanel.add((Component)this.m_subPartsButton, new GridBagConstraints(3, n3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.validate();
    }

    public void init(DBObjectProvider dBObjectProvider, OracleTablePartitions oracleTablePartitions, Table table, Set<TablePartition> set, String string, String[] stringArray, boolean bl) {
        this.m_pro = dBObjectProvider;
        this.m_otp = oracleTablePartitions;
        this.m_table = table;
        this.m_allPartitions = set;
        this.m_tablespaces = stringArray;
        this.m_parentPartitionName = string;
        this.m_editing = bl;
        TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
        OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
        this.m_subpartType = oracleTablePartitions2 == null ? null : oracleTablePartitions2.getPartitionType();
        this.m_objectType = oracleTablePartitions.getObjectType();
        this.m_partType = oracleTablePartitions.getPartitionType();
        this.m_partListModel.removeAllElements();
        if (tablePartitionArray != null) {
            int n = 0;
            while (n < tablePartitionArray.length) {
                this.m_partListModel.addElement(tablePartitionArray[n]);
                ++n;
            }
        }
        this.layoutEditPanel();
        this.initCurrentPartition();
        this.m_partButtons.enableButtons();
    }

    public TablePartition[] getPartitions() throws ValidationException {
        if (this.m_currentPartition != null) {
            this.commitCurrentPartition();
        }
        TablePartition[] tablePartitionArray = new TablePartition[this.m_partListModel.getSize()];
        Enumeration enumeration = this.m_partListModel.elements();
        int n = 0;
        while (n < tablePartitionArray.length) {
            tablePartitionArray[n] = (TablePartition)enumeration.nextElement();
            ++n;
        }
        return tablePartitionArray;
    }

    private void addPartition() {
        if (this.m_currentPartition == null || this.tryCommitCurrentPartition()) {
            this.m_currentPartition = null;
            int n = this.m_partList.getSelectedIndex();
            n = n < 0 ? this.m_partListModel.size() : n + 1;
            TablePartition tablePartition = new TablePartition(this.m_partType, this.m_objectType);
            tablePartition.setName(this.getInitialName());
            this.m_partListModel.add(n, tablePartition);
            this.m_partList.setSelectedIndex(n);
            if (this.m_partType == OracleTablePartitions.PartitionType.LIST || this.m_partType == OracleTablePartitions.PartitionType.RANGE) {
                this.m_valuesField.requestFocus();
            } else {
                this.m_nameField.requestFocus();
            }
        }
    }

    private void removePartition() {
        int n = this.m_partList.getSelectedIndex();
        if (n >= 0) {
            this.m_allPartitions.remove(this.m_currentPartition);
            this.m_currentPartition = null;
            this.m_partListModel.remove(n);
        }
    }

    private boolean tryCommitCurrentPartition() {
        try {
            this.commitCurrentPartition();
        }
        catch (ValidationException validationException) {
            MessageDialog.error((Component)this, (Object)validationException.getMessage(), (String)validationException.getTitle(), null);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private void commitCurrentPartition() throws ValidationException {
        String string = this.m_nameField.getText();
        if (ModelUtil.hasLength((String)string)) {
            this.m_pro.validateName("PARTITION", string);
            this.m_allPartitions.remove(this.m_currentPartition);
            this.m_currentPartition.setName(this.m_pro.getInternalName(string));
            this.m_allPartitions.add(this.m_currentPartition);
            this.validateNameIsUnique(this.m_currentPartition.getName());
        } else {
            if (!(this.m_pro instanceof Database)) {
                string = this.m_currentPartition.getName();
                this.m_nameField.setText(this.m_pro.getExternalName(string));
                throw new ValidationException((DBObject)this.m_table, UIArb.getString(372));
            }
            this.m_currentPartition.setName(null);
        }
        this.m_currentPartition.setValues(this.m_valuesField.getText());
        this.m_currentPartition.validate(this.m_table);
    }

    private void initCurrentPartition() {
        boolean bl;
        boolean bl2 = bl = this.m_currentPartition != null;
        if (bl) {
            String string = this.m_currentPartition.getName();
            if (ModelUtil.hasLength((String)string)) {
                this.m_nameField.setText(this.m_pro.getExternalName(string));
            } else {
                this.m_nameField.setText(null);
            }
            Object[] objectArray = this.m_currentPartition.getValues();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(objectArray[n].toString());
                if (n < objectArray.length - 1) {
                    stringBuffer.append(",");
                }
                ++n;
            }
            this.m_valuesField.setText(stringBuffer.toString());
        } else {
            this.m_nameField.setText(null);
            this.m_valuesField.setText(null);
        }
        this.m_nameField.setEnabled(bl);
        this.m_nameLabel.setEnabled(bl);
        this.m_valuesField.setEnabled(bl && this.enableValuesField());
        this.m_valuesLabel.setEnabled(bl);
        this.m_storageButton.setEnabled(bl);
        this.m_lobParametersButton.setEnabled(bl);
        this.m_subPartsButton.setEnabled(bl);
    }

    private boolean enableValuesField() {
        return (this.m_pro instanceof Database && this.m_editing && this.m_currentPartition != null && this.m_currentPartition.getPartitionType() == OracleTablePartitions.PartitionType.RANGE) ^ true;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_descLabel.setEnabled(bl);
        this.m_partLabel.setEnabled(bl);
        this.m_partList.setEnabled(bl);
        this.m_partButtons.setEnabled(bl);
        if (!bl) {
            this.m_partList.setSelectedValue(null, false);
        }
        this.initCurrentPartition();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        TablePartition tablePartition = (TablePartition)this.m_partList.getSelectedValue();
        if (this.m_currentPartition != null && this.m_currentPartition != tablePartition && !this.tryCommitCurrentPartition()) {
            this.m_partList.setSelectedValue(this.m_currentPartition, true);
            return;
        }
        this.m_currentPartition = tablePartition;
        this.initCurrentPartition();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_partButtons) {
            int n = actionEvent.getID();
            if (n == 0) {
                this.addPartition();
            } else if (n == 1) {
                this.removePartition();
            }
        } else if (object == this.m_subPartsButton) {
            if (this.m_currentPartition != null) {
                OracleTablePartitions oracleTablePartitions = this.m_currentPartition.getPartitionLevelSubpartitions();
                OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions == null ? new OracleTablePartitions(this.m_subpartType, OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) : oracleTablePartitions;
                JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)this), (String)UIArb.getString(354), (int)3);
                PartitionDefinitionPanel partitionDefinitionPanel = new PartitionDefinitionPanel();
                jEWTDialog.setContent((Component)((Object)partitionDefinitionPanel));
                jEWTDialog.setResizable(true);
                jEWTDialog.setSize(500, 300);
                if (this.tryCommitCurrentPartition()) {
                    partitionDefinitionPanel.init(this.m_pro, this.m_table, oracleTablePartitions2, this.m_allPartitions, this.m_currentPartition.getName(), this.m_tablespaces, this.m_editing);
                    1 var8_8 = new 1(this, oracleTablePartitions, oracleTablePartitions2, partitionDefinitionPanel);
                    jEWTDialog.addVetoableChangeListener((VetoableChangeListener)var8_8);
                    jEWTDialog.runDialog();
                }
            }
        } else if (object == this.m_storageButton) {
            Object object2;
            String string = this.m_objectType == OracleTablePartitions.ObjectType.PARTITION ? UIArb.getString(367) : UIArb.getString(368);
            JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)this), (String)string, (int)3);
            if (this.m_objectType == OracleTablePartitions.ObjectType.PARTITION && this.m_partType != OracleTablePartitions.PartitionType.HASH) {
                object2 = new StorageInfoPanel();
                ((StorageInfoPanel)object2).init(this.m_pro, this.m_currentPartition.getSegmentAttributes(), null, this.m_tablespaces);
                ((JComponent)object2).setPreferredSize(new Dimension(600, 200));
            } else {
                object2 = new PartitionStoragePanel();
                ((PartitionStoragePanel)object2).init(this.m_pro, this.m_currentPartition, this.m_tablespaces);
                ((JComponent)object2).setPreferredSize(new Dimension(300, 50));
            }
            jEWTDialog.setContent((Component)object2);
            jEWTDialog.setResizable(true);
            2 var12_12 = new 2(this, (JPanel)object2);
            jEWTDialog.addVetoableChangeListener((VetoableChangeListener)var12_12);
            jEWTDialog.runDialog();
        } else if (object == this.m_lobParametersButton) {
            String string = UIArb.getString(369);
            JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)this), (String)string, (int)3);
            LobDescriptorPanel lobDescriptorPanel = new LobDescriptorPanel();
            ArrayList<LOBDescriptor> arrayList = new ArrayList<LOBDescriptor>(this.m_currentPartition.getLOBDescriptors().length);
            LOBDescriptor[] lOBDescriptorArray = this.m_currentPartition.getLOBDescriptors();
            int n = 0;
            while (n < lOBDescriptorArray.length) {
                LOBDescriptor lOBDescriptor = lOBDescriptorArray[n];
                arrayList.add(lOBDescriptor);
                ++n;
            }
            lobDescriptorPanel.init(this.m_pro, this.m_table, arrayList, this.m_tablespaces, this.getLobParamsVerifier(), this.getStorageInfoVerifier());
            lobDescriptorPanel.setPreferredSize(new Dimension(600, 300));
            jEWTDialog.setContent((Component)((Object)lobDescriptorPanel));
            jEWTDialog.setResizable(true);
            3 var18_20 = new 3(this, lobDescriptorPanel, arrayList);
            jEWTDialog.addVetoableChangeListener((VetoableChangeListener)var18_20);
            jEWTDialog.runDialog();
        }
    }

    @Override
    public boolean canAdd() {
        TablePartition tablePartition;
        Object[] objectArray;
        return !this.m_editing || this.m_partType != OracleTablePartitions.PartitionType.LIST || this.m_partListModel.size() <= 0 || (objectArray = (tablePartition = (TablePartition)this.m_partListModel.get(this.m_partListModel.size() - 1)).getValues()).length != 1 || !objectArray[0].equals("DEFAULT");
    }

    @Override
    public boolean canAdd(Object object) {
        return true;
    }

    @Override
    public boolean canMoveDown(Object object) {
        return true;
    }

    @Override
    public boolean canMoveUp(Object object) {
        return true;
    }

    @Override
    public boolean canRemove() {
        if (this.m_editing && this.m_pro instanceof Database) {
            return this.m_objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE || this.m_partListModel.size() > 1 && (this.m_partType != OracleTablePartitions.PartitionType.HASH || this.m_objectType != OracleTablePartitions.ObjectType.PARTITION && this.m_objectType != OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
        }
        return true;
    }

    @Override
    public boolean canRemove(Object object) {
        return true;
    }

    @Override
    public boolean canReorder() {
        return this.m_editing ^ true;
    }

    @Override
    public String getAddTooltipText() {
        return null;
    }

    @Override
    public String getDownTooltipText() {
        return null;
    }

    @Override
    public String getRemoveTooltipText() {
        return null;
    }

    @Override
    public String getUpTooltipText() {
        return null;
    }

    private String getInitialName() {
        String string = this.m_objectType == OracleTablePartitions.ObjectType.PARTITION ? "P" : "S";
        int n = 1;
        String string2 = this.makeName(string, n);
        Set set = this.m_objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE ? this.getSubpartitionTemplateNames() : this.getPartitionNames();
        while (set.contains(string2)) {
            string2 = this.makeName(string, ++n);
        }
        return string2;
    }

    private String makeName(String string, int n) {
        String string2 = (ModelUtil.hasLength((String)this.m_parentPartitionName) ? this.m_parentPartitionName + '_' : "") + string + n;
        while (string2.length() > 30) {
            this.m_parentPartitionName = this.m_parentPartitionName.substring(0, this.m_parentPartitionName.length() - 1);
            string2 = this.m_parentPartitionName + '_' + string + n;
        }
        return string2;
    }

    private void validateNameIsUnique(String string) throws ValidationException {
        if (this.m_objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
            Set set = this.getSubpartitionTemplateNames();
            if (set.contains(string)) {
                throw new ValidationException((DBObject)this.m_table, UIArb.getString(370));
            }
        } else {
            Set set = this.getPartitionNames();
            if (set.contains(string)) {
                throw new ValidationException((DBObject)this.m_table, UIArb.getString(371));
            }
        }
    }

    private Set getSubpartitionTemplateNames() {
        Enumeration enumeration;
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration enumeration2 = enumeration = this.m_partListModel != null ? this.m_partListModel.elements() : null;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TablePartition tablePartition = (TablePartition)enumeration.nextElement();
                if (tablePartition == this.m_currentPartition) continue;
                hashSet.add(tablePartition.getName());
            }
        }
        return hashSet;
    }

    private Set getPartitionNames() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.m_allPartitions != null) {
            for (TablePartition tablePartition : this.m_allPartitions) {
                if (tablePartition == this.m_currentPartition) continue;
                hashSet.add(tablePartition.getName());
            }
        }
        return hashSet;
    }

    private StorageInfoVerifier getStorageInfoVerifier() {
        StorageInfoVerifier storageInfoVerifier;
        StorageInfoVerifier storageInfoVerifier2 = this.m_partType == OracleTablePartitions.PartitionType.HASH && this.m_objectType == OracleTablePartitions.ObjectType.PARTITION ? this._hashPartitionStorageInfoVerifier : (storageInfoVerifier = this.m_editing ? this._editStorageInfoVerifier : null);
        if (storageInfoVerifier != null) {
            storageInfoVerifier.initializeVerifier(this.m_pro, null, (SchemaObject)this.m_table);
        }
        return storageInfoVerifier;
    }

    private LobParamsVerifier getLobParamsVerifier() {
        LobParamsVerifier lobParamsVerifier;
        LobParamsVerifier lobParamsVerifier2 = lobParamsVerifier = this.m_partType == OracleTablePartitions.PartitionType.HASH && this.m_objectType == OracleTablePartitions.ObjectType.PARTITION ? this._hashPartitionLobParamsVerifier : null;
        if (lobParamsVerifier != null) {
            lobParamsVerifier.initializeVerifier(this.m_pro, null, (SchemaObject)this.m_table);
        }
        return lobParamsVerifier;
    }

    static TablePartition ra$m_currentPartition(PartitionListPanel partitionListPanel) {
        return partitionListPanel.m_currentPartition;
    }

    static Table ra$m_table(PartitionListPanel partitionListPanel) {
        return partitionListPanel.m_table;
    }

    static Set ra$m_allPartitions(PartitionListPanel partitionListPanel) {
        return partitionListPanel.m_allPartitions;
    }

    final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ OracleTablePartitions v$subparts;
        private final /* synthetic */ OracleTablePartitions v$editMe;
        private final /* synthetic */ PartitionDefinitionPanel v$panel;
        final /* synthetic */ PartitionListPanel this$0;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                try {
                    if (this.v$subparts == null) {
                        PartitionListPanel.ra$m_currentPartition(this.this$0).setPartitionLevelSubpartitions(this.v$editMe);
                    }
                    this.v$panel.commit(PartitionListPanel.ra$m_table(this.this$0), this.v$editMe, null, false);
                    PartitionListPanel.ra$m_allPartitions(this.this$0).remove(PartitionListPanel.ra$m_currentPartition(this.this$0));
                    PartitionListPanel.ra$m_currentPartition(this.this$0).validatePartitionLevelSubpartitions(PartitionListPanel.ra$m_table(this.this$0));
                }
                catch (ValidationException validationException) {
                    MessageDialog.error((Component)this.this$0, (Object)validationException.getMessage(), (String)validationException.getTitle(), null);
                    throw new PropertyVetoException(validationException.getMessage(), propertyChangeEvent);
                }
            }
        }

        public 1(PartitionListPanel partitionListPanel, OracleTablePartitions oracleTablePartitions, OracleTablePartitions oracleTablePartitions2, PartitionDefinitionPanel partitionDefinitionPanel) {
            this.v$panel = partitionDefinitionPanel;
            this.v$editMe = oracleTablePartitions2;
            this.v$subparts = oracleTablePartitions;
            this.this$0 = partitionListPanel;
        }
    }

    final class 2
    implements VetoableChangeListener {
        private final /* synthetic */ JPanel v$panel;
        final /* synthetic */ PartitionListPanel this$0;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                try {
                    if (this.v$panel instanceof StorageInfoPanel) {
                        OracleStorageProperties oracleStorageProperties = PartitionListPanel.ra$m_currentPartition(this.this$0).getSegmentAttributes();
                        if (oracleStorageProperties == null) {
                            oracleStorageProperties = new OracleStorageProperties();
                            PartitionListPanel.ra$m_currentPartition(this.this$0).setSegmentAttributes(oracleStorageProperties);
                        }
                        ((StorageInfoPanel)((Object)this.v$panel)).commit(oracleStorageProperties, true);
                        PartitionListPanel.ra$m_currentPartition(this.this$0).validateSegmentAttributes(PartitionListPanel.ra$m_table(this.this$0));
                    } else {
                        ((PartitionStoragePanel)this.v$panel).commit(this.this$0.m_pro, PartitionListPanel.ra$m_currentPartition(this.this$0), PartitionListPanel.ra$m_table(this.this$0));
                    }
                }
                catch (TraversalException traversalException) {
                    MessageDialog.error((Component)this.this$0, (Object)traversalException.getMessage(), null, null);
                    throw new PropertyVetoException(traversalException.getMessage(), propertyChangeEvent);
                }
                catch (ValidationException validationException) {
                    MessageDialog.error((Component)this.this$0, (Object)validationException.getMessage(), (String)validationException.getTitle(), null);
                    throw new PropertyVetoException(validationException.getMessage(), propertyChangeEvent);
                }
            }
        }

        public 2(PartitionListPanel partitionListPanel, JPanel jPanel) {
            this.v$panel = jPanel;
            this.this$0 = partitionListPanel;
        }
    }

    final class 3
    implements VetoableChangeListener {
        private final /* synthetic */ LobDescriptorPanel v$panel;
        private final /* synthetic */ List v$lobDescriptorList;
        final /* synthetic */ PartitionListPanel this$0;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                try {
                    this.v$panel.commit();
                    LOBDescriptor[] lOBDescriptorArray = this.v$lobDescriptorList.toArray(new LOBDescriptor[this.v$lobDescriptorList.size()]);
                    PartitionListPanel.ra$m_currentPartition(this.this$0).setLOBDescriptors(lOBDescriptorArray);
                    PartitionListPanel.ra$m_currentPartition(this.this$0).validateLOBDescriptors(PartitionListPanel.ra$m_table(this.this$0));
                }
                catch (TraversalException traversalException) {
                    MessageDialog.error((Component)this.this$0, (Object)traversalException.getMessage(), null, null);
                    throw new PropertyVetoException(traversalException.getMessage(), propertyChangeEvent);
                }
                catch (ValidationException validationException) {
                    MessageDialog.error((Component)this.this$0, (Object)validationException.getMessage(), (String)validationException.getTitle(), null);
                    throw new PropertyVetoException(validationException.getMessage(), propertyChangeEvent);
                }
            }
        }

        public 3(PartitionListPanel partitionListPanel, LobDescriptorPanel lobDescriptorPanel, List list) {
            this.v$lobDescriptorList = list;
            this.v$panel = lobDescriptorPanel;
            this.this$0 = partitionListPanel;
        }
    }

    private class HashPartitionLobParamsVerifier
    extends AbstractTableVerifier
    implements LobParamsVerifier {
        public boolean canChangeCache() {
            return false;
        }

        public boolean canChangeSegName() {
            return true;
        }

        public boolean canChangeChunk() {
            return false;
        }

        public boolean canChangePctVersion() {
            return false;
        }

        public boolean canChangeFreepools() {
            return false;
        }

        public boolean canChangeStoreInRow() {
            return false;
        }

        public boolean canChangeRetention() {
            return false;
        }

        public void checkPctVersionAndRetention(String string, boolean bl) throws TraversalException {
        }

        private HashPartitionLobParamsVerifier() {
        }

        HashPartitionLobParamsVerifier(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class HashPartitionStorageInfoVerifier
    extends AbstractTableVerifier
    implements StorageInfoVerifier {
        public boolean canChangeTablespace() {
            return PartitionListPanel.this.m_pro instanceof Oracle10g ^ true;
        }

        public boolean canEditTablespace() {
            return PartitionListPanel.this.m_pro instanceof OracleDatabase ^ true;
        }

        public boolean canChangePercentFree() {
            return false;
        }

        public boolean canChangePercentUsed() {
            return false;
        }

        public boolean canChangeInitrans() {
            return false;
        }

        public boolean canChangeMaxtrans() {
            return false;
        }

        public boolean canChangeInitialExtent() {
            return false;
        }

        public boolean canChangeNextExtent() {
            return false;
        }

        public boolean canChangeMinExtent() {
            return false;
        }

        public boolean canChangeMaxExtent() {
            return false;
        }

        public boolean canChangePercentIncrease() {
            return false;
        }

        public boolean canChangeLogging() {
            return false;
        }

        public boolean canChangeFreelists() {
            return false;
        }

        public boolean canChangeFreelistGroups() {
            return false;
        }

        public boolean canChangeBufferMode() {
            return false;
        }

        public void verifyRelation() throws TraversalException {
        }

        private HashPartitionStorageInfoVerifier() {
        }

        HashPartitionStorageInfoVerifier(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class EditStorageInfoVerifier
    extends AbstractTableVerifier
    implements StorageInfoVerifier {
        public boolean canChangeTablespace() {
            return true;
        }

        public boolean canEditTablespace() {
            return true;
        }

        public boolean canChangePercentFree() {
            return false;
        }

        public boolean canChangePercentUsed() {
            return false;
        }

        public boolean canChangeInitrans() {
            return false;
        }

        public boolean canChangeMaxtrans() {
            return false;
        }

        public boolean canChangeInitialExtent() {
            return true;
        }

        public boolean canChangeNextExtent() {
            return false;
        }

        public boolean canChangeMinExtent() {
            return false;
        }

        public boolean canChangeMaxExtent() {
            return false;
        }

        public boolean canChangePercentIncrease() {
            return false;
        }

        public boolean canChangeLogging() {
            return false;
        }

        public boolean canChangeFreelists() {
            return false;
        }

        public boolean canChangeFreelistGroups() {
            return false;
        }

        public boolean canChangeBufferMode() {
            return true;
        }

        public void verifyRelation() throws TraversalException {
        }

        private EditStorageInfoVerifier() {
        }

        EditStorageInfoVerifier(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

