/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.HashPartitionQuantityPanel;
import oracle.ide.db.panels.table.PartitionListPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionDefinitionPanel
extends BaseInfoPanel
implements ActionListener {
    private boolean m_subpartTemplates;
    private boolean m_editing;
    private boolean m_alive;
    private DBObjectProvider m_pro;
    private Table m_table;
    private OracleTablePartitions m_parts;
    private String[] m_tablespaces;
    private Set<TablePartition> m_allPartitions;
    private String m_parentPartitionName;
    private JComboBox m_hashDefinitionTypeComboBox;
    private JLabel m_hashDefinitionTypeLabel;
    private HashPartitionQuantityPanel m_hashPanel;
    private PartitionListPanel m_listPanel;

    private void $init$() {
        this.m_hashDefinitionTypeLabel = new JLabel();
    }

    public PartitionDefinitionPanel() {
        this(false);
    }

    public PartitionDefinitionPanel(boolean bl) {
        this.$init$();
        this.m_subpartTemplates = bl;
    }

    private void layoutComponents() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        if (this.m_listPanel == null) {
            this.m_listPanel = new PartitionListPanel();
        }
        this.add(this.m_listPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void layoutHashComponents(HashType hashType) {
        OracleTablePartitions.ObjectType objectType = this.m_parts.getObjectType();
        this.removeAll();
        this.setLayout(new GridBagLayout());
        if (this.m_hashDefinitionTypeComboBox == null) {
            this.m_hashDefinitionTypeComboBox = new JComboBox();
            this.m_hashDefinitionTypeComboBox.addActionListener(this);
            this.m_hashDefinitionTypeComboBox.addItem(UIArb.getString(341));
            this.m_hashDefinitionTypeComboBox.addItem(UIArb.getString(343));
            this.m_hashDefinitionTypeComboBox.addItem(UIArb.getString(344));
            ResourceUtils.resLabel((JLabel)this.m_hashDefinitionTypeLabel, (Component)this.m_hashDefinitionTypeComboBox, (String)UIArb.getString(340));
        }
        int n = hashType == HashType.INDIVIDUAL ? 343 : (hashType == HashType.QUANTITY ? 344 : 341);
        this.m_hashDefinitionTypeComboBox.setSelectedItem(UIArb.getString(n));
        JPanel jPanel = null;
        if (hashType == HashType.INDIVIDUAL) {
            if (this.m_listPanel == null) {
                this.m_listPanel = new PartitionListPanel();
            }
            jPanel = this.m_listPanel;
        } else if (hashType == HashType.QUANTITY) {
            if (this.m_hashPanel == null) {
                this.m_hashPanel = new HashPartitionQuantityPanel();
            }
            jPanel = this.m_hashPanel;
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.m_hashDefinitionTypeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.m_hashDefinitionTypeComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 5), 0, 0));
        int n2 = 0;
        this.add(jPanel2, new GridBagConstraints(0, n2, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        if (this.m_editing && this.m_pro instanceof Database && objectType != OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
            this.m_hashDefinitionTypeComboBox.setEnabled(false);
        } else {
            this.m_hashDefinitionTypeComboBox.setEnabled(true);
        }
        if (jPanel != null) {
            this.add(jPanel, new GridBagConstraints(0, ++n2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.setEnabled(true);
        }
        this.setPreferredSize(new Dimension(500, 300));
        this.validate();
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        Table table = (Table)traversableContext.get("NewObject");
        Table table2 = (Table)traversableContext.get("OriginalObject");
        String[] stringArray = this.getTablespaces(traversableContext, dBObjectProvider);
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        if (this.m_subpartTemplates) {
            OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions = oracleTablePartitions == null ? null : oracleTablePartitions.getSubpartitionModel();
        }
        if (oracleTablePartitions == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            this.init(dBObjectProvider, table, oracleTablePartitions, this.getAllPartitions(oracleTablePartitions), null, stringArray, table2 != null);
        }
    }

    private Set<TablePartition> getAllPartitions(OracleTablePartitions oracleTablePartitions) {
        HashSet<TablePartition> hashSet = new HashSet<TablePartition>();
        TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
        int n = 0;
        while (n < tablePartitionArray.length) {
            TablePartition tablePartition = tablePartitionArray[n];
            hashSet.add(tablePartition);
            if (tablePartition.getPartitionLevelSubpartitions() != null) {
                TablePartition[] tablePartitionArray2 = tablePartition.getPartitionLevelSubpartitions().getPartitions();
                int n2 = 0;
                while (n2 < tablePartitionArray2.length) {
                    TablePartition tablePartition2 = tablePartitionArray2[n2];
                    hashSet.add(tablePartition2);
                    ++n2;
                }
            }
            ++n;
        }
        return hashSet;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Table table = (Table)traversableContext.get("NewObject");
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        OracleTablePartitions oracleTablePartitions2 = null;
        if (this.m_subpartTemplates) {
            oracleTablePartitions2 = oracleTablePartitions;
            OracleTablePartitions oracleTablePartitions3 = oracleTablePartitions = oracleTablePartitions == null ? null : oracleTablePartitions.getSubpartitionModel();
        }
        if (oracleTablePartitions != null) {
            try {
                this.commit(table, oracleTablePartitions, oracleTablePartitions2, traversableContext.getDirection() != 2);
            }
            catch (ValidationException validationException) {
                throw new TraversalException(validationException.getMessage(), validationException.getTitle());
            }
        }
    }

    protected void init(DBObjectProvider dBObjectProvider, Table table, OracleTablePartitions oracleTablePartitions, Set<TablePartition> set, String string, String[] stringArray, boolean bl) {
        this.m_alive = false;
        this.m_pro = dBObjectProvider;
        this.m_table = table;
        this.m_parts = oracleTablePartitions;
        this.m_tablespaces = stringArray;
        this.m_allPartitions = set;
        this.m_parentPartitionName = string;
        this.m_editing = bl;
        if (this.m_subpartTemplates) {
            oracleTablePartitions.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE);
        }
        OracleTablePartitions.PartitionType partitionType = oracleTablePartitions.getPartitionType();
        TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
        if (partitionType == OracleTablePartitions.PartitionType.HASH) {
            if (tablePartitionArray != null && tablePartitionArray.length > 0) {
                this.layoutHashComponents(HashType.INDIVIDUAL);
                this.m_listPanel.init(this.m_pro, oracleTablePartitions, this.m_table, set, string, this.m_tablespaces, this.m_editing);
            } else if (oracleTablePartitions.getHashQuantity() != null) {
                this.layoutHashComponents(HashType.QUANTITY);
                this.m_hashPanel.init(this.m_pro, oracleTablePartitions, stringArray, this.m_editing);
            } else {
                this.layoutHashComponents(HashType.DEFAULT);
            }
            this.m_alive = true;
        } else if (partitionType == OracleTablePartitions.PartitionType.LIST || partitionType == OracleTablePartitions.PartitionType.RANGE) {
            this.layoutComponents();
            this.m_listPanel.init(this.m_pro, oracleTablePartitions, this.m_table, set, string, this.m_tablespaces, this.m_editing);
            this.m_alive = true;
        }
    }

    protected void commit(Table table, OracleTablePartitions oracleTablePartitions, OracleTablePartitions oracleTablePartitions2, boolean bl) throws ValidationException {
        if (this.m_alive) {
            OracleTablePartitions.PartitionType partitionType = oracleTablePartitions.getPartitionType();
            if (partitionType == OracleTablePartitions.PartitionType.HASH && this.getSelectedHashType() != HashType.INDIVIDUAL) {
                oracleTablePartitions.setPartitions(null);
                if (this.getSelectedHashType() == HashType.QUANTITY) {
                    this.m_hashPanel.commit(this.m_pro, table, oracleTablePartitions);
                } else {
                    oracleTablePartitions.setHashQuantity(null);
                    oracleTablePartitions.setHashQuantityTablespaces(null);
                }
            } else {
                oracleTablePartitions.setPartitions(this.m_listPanel.getPartitions());
                oracleTablePartitions.setHashQuantity(null);
                oracleTablePartitions.setHashQuantityTablespaces(null);
            }
            if (this.m_subpartTemplates) {
                oracleTablePartitions.setObjectType(oracleTablePartitions.getPartitions().length > 0 ? OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE : OracleTablePartitions.ObjectType.SUBPARTITION);
            }
            if (bl) {
                if (this.m_subpartTemplates) {
                    oracleTablePartitions2.validateSubpartitionModel(table);
                } else {
                    oracleTablePartitions.validatePartitions(table);
                }
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.m_hashPanel != null) {
            this.m_hashPanel.setEnabled(bl);
        }
        if (this.m_listPanel != null) {
            this.m_listPanel.setEnabled(bl);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != null && object == this.m_hashDefinitionTypeComboBox) {
            HashType hashType = this.getSelectedHashType();
            this.layoutHashComponents(hashType);
            if (hashType == HashType.INDIVIDUAL) {
                this.m_listPanel.init(this.m_pro, this.m_parts, this.m_table, this.m_allPartitions, this.m_parentPartitionName, this.m_tablespaces, this.m_editing);
            } else if (hashType == HashType.QUANTITY) {
                this.m_hashPanel.init(this.m_pro, this.m_parts, this.m_tablespaces, this.m_editing);
            }
            this.repaint();
        }
    }

    private HashType getSelectedHashType() {
        String string = (String)this.m_hashDefinitionTypeComboBox.getSelectedItem();
        return UIArb.getString(341).equals(string) ? HashType.DEFAULT : (UIArb.getString(344).equals(string) ? HashType.QUANTITY : HashType.INDIVIDUAL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HashType
    extends Enum<HashType> {
        private static final /* synthetic */ HashType[] $v;
        public static final /* enum */ HashType DEFAULT;
        public static final /* enum */ HashType INDIVIDUAL;
        public static final /* enum */ HashType QUANTITY;

        public static HashType valueOf(String string) {
            return Enum.valueOf(HashType.class, string);
        }

        public static final HashType[] values() {
            return (HashType[])$v.clone();
        }

        static {
            HashType[] hashTypeArray = new HashType[3];
            hashTypeArray[2] = QUANTITY = new HashType("QUANTITY", 2);
            hashTypeArray[1] = INDIVIDUAL = new HashType("INDIVIDUAL", 1);
            hashTypeArray[0] = DEFAULT = new HashType("DEFAULT", 0);
            $v = hashTypeArray;
        }

        private HashType(String string2, int n2) {
        }
    }
}

