/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.StorageInfoPanel;
import oracle.ide.db.verifiers.table.LobParamsVerifier;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleStorageProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LobDescriptorPanel
extends BaseInfoPanel
implements ActionListener {
    private StorageInfoPanel _pnlSubLobStorage;
    private JPanel _mainPanel;
    private JComboBox _cmbColumns;
    private JCheckBox _cbxStoreAsLob;
    private JComboBox _cmbCache;
    private JTextField _txtSegName;
    private NumberTextField _txtChunk;
    private NumberTextField _txtPctVersion;
    private NumberTextField _txtFreePools;
    private JCheckBox _cbxStoreInRow;
    private JCheckBox _cbxRetention;
    private JLabel _lblColumns;
    private JLabel _lblStoreAsLob;
    private JLabel _lblCache;
    private JLabel _lblSegName;
    private JLabel _lblChunk;
    private JLabel _lblPctVersion;
    private JLabel _lblFreePools;
    private Table _table;
    private Column _column;
    private LOBDescriptor _lobDescriptor;
    private List<LOBDescriptor> _lobDescriptorList;
    private String[] _tablespaces;
    private DBObjectProvider _prov;
    private LobParamsVerifier _lpVerifier;
    private StorageInfoVerifier _siVerifier;
    private String lastColSelection;
    private static final String DEFAULT = "<DEFAULT>";
    private Map<Column, StoreAsLobInfo> _colLobDescMap;
    private Set<StoreAsLobInfo> _newStoreAsLobInfo;

    private void $init$() {
        this._mainPanel = new JPanel();
        this._cmbColumns = new JComboBox();
        this._cbxStoreAsLob = new JCheckBox();
        this._cmbCache = new JComboBox();
        this._txtSegName = new JTextField();
        this._txtChunk = new NumberTextField();
        this._txtPctVersion = new NumberTextField();
        this._txtFreePools = new NumberTextField();
        this._cbxStoreInRow = new JCheckBox();
        this._cbxRetention = new JCheckBox();
        this._lblColumns = new JLabel();
        this._lblStoreAsLob = new JLabel();
        this._lblCache = new JLabel();
        this._lblSegName = new JLabel();
        this._lblChunk = new JLabel();
        this._lblPctVersion = new JLabel();
        this._lblFreePools = new JLabel();
        this._table = null;
        this._column = null;
        this._lobDescriptor = null;
        this._lobDescriptorList = null;
        this._prov = null;
        this._lpVerifier = null;
        this._siVerifier = null;
        this.lastColSelection = null;
        this._colLobDescMap = new HashMap<Column, StoreAsLobInfo>();
        this._newStoreAsLobInfo = new HashSet<StoreAsLobInfo>();
    }

    public LobDescriptorPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this._mainPanel.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this._lblColumns, (Component)this._cmbColumns, (String)UIArb.getString(697));
        ResourceUtils.resLabel((JLabel)this._lblStoreAsLob, (Component)this._cbxStoreAsLob, (String)UIArb.getString(698));
        ResourceUtils.resLabel((JLabel)this._lblSegName, (Component)this._txtSegName, (String)UIArb.getString(699));
        ResourceUtils.resButton((AbstractButton)this._cbxStoreInRow, (String)UIArb.getString(700));
        ResourceUtils.resLabel((JLabel)this._lblChunk, (Component)this._txtChunk, (String)UIArb.getString(701));
        ResourceUtils.resLabel((JLabel)this._lblPctVersion, (Component)this._txtPctVersion, (String)UIArb.getString(702));
        ResourceUtils.resLabel((JLabel)this._lblFreePools, (Component)this._txtFreePools, (String)UIArb.getString(703));
        ResourceUtils.resButton((AbstractButton)this._cbxRetention, (String)UIArb.getString(704));
        ResourceUtils.resLabel((JLabel)this._lblCache, (Component)this._cmbCache, (String)UIArb.getString(705));
        this.add(this._lblColumns, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 12, 0), 0, 0));
        this.add(this._cmbColumns, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 12, 0), 0, 0));
        this.add(this._lblStoreAsLob, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 12, 0), 0, 0));
        this.add(this._cbxStoreAsLob, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 12, 0), 0, 0));
        this.add(this._mainPanel, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._mainPanel.setBorder(BorderFactory.createTitledBorder(UIArb.getString(696)));
        this._mainPanel.add((Component)this._lblSegName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._txtSegName, new GridBagConstraints(1, 1, 1, 1, 2.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._lblPctVersion, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._txtPctVersion, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._cbxRetention, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._lblChunk, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._txtChunk, new GridBagConstraints(1, 2, 1, 1, 2.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._lblFreePools, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._txtFreePools, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._cbxStoreInRow, new GridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        this._pnlSubLobStorage = new StorageInfoPanel(this._mainPanel, 1);
        this._mainPanel.add((Component)this._lblCache, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 12, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._cmbCache, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        this._cmbCache.addItem(DEFAULT);
        this._cmbCache.addItem("NOCACHE");
        this._cmbCache.addItem("CACHE");
        this._cmbCache.addItem("CACHE READS");
        this._cmbColumns.addActionListener(this);
        this._cbxStoreAsLob.addActionListener(this);
        this._cmbCache.addActionListener(this);
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        Table table = (Table)traversableContext.find("NewObject");
        LobParamsVerifier lobParamsVerifier = (LobParamsVerifier)traversableContext.find("LobParamsVerifier");
        StorageInfoVerifier storageInfoVerifier = (StorageInfoVerifier)traversableContext.find("StorageInfoVerifier");
        String[] stringArray = this.getTablespaces(traversableContext, dBObjectProvider);
        ArrayList<LOBDescriptor> arrayList = new ArrayList<LOBDescriptor>();
        Column[] columnArray = table.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            OracleColumnProperties oracleColumnProperties = (OracleColumnProperties)columnArray[n].getProperty("OracleColumnProperties");
            if (oracleColumnProperties != null) {
                LOBDescriptor lOBDescriptor = null;
                if (LOBDescriptor.isLOBColumn((DBObjectID)columnArray[n].getID())) {
                    lOBDescriptor = oracleColumnProperties.getLOBProperties();
                } else if (LOBDescriptor.isVARRAYColumn((DBObjectID)columnArray[n].getID())) {
                    lOBDescriptor = oracleColumnProperties.getVAProperties();
                }
                if (lOBDescriptor != null) {
                    lOBDescriptor.addColumn(columnArray[n].getID());
                    arrayList.add(lOBDescriptor);
                }
            }
            ++n;
        }
        this.init(dBObjectProvider, table, arrayList, stringArray, lobParamsVerifier, storageInfoVerifier);
    }

    protected void init(DBObjectProvider dBObjectProvider, Table table, List<LOBDescriptor> list, String[] stringArray, LobParamsVerifier lobParamsVerifier, StorageInfoVerifier storageInfoVerifier) {
        super.init(dBObjectProvider, lobParamsVerifier);
        this._prov = dBObjectProvider;
        this._table = table;
        this._lobDescriptorList = list;
        this._tablespaces = stringArray;
        this._lpVerifier = lobParamsVerifier;
        this._siVerifier = storageInfoVerifier;
        ArrayList<LOBDescriptor> arrayList = new ArrayList<LOBDescriptor>();
        int n = 0;
        while (n < this._lobDescriptorList.size()) {
            arrayList.add(this._lobDescriptorList.get(n));
            ++n;
        }
        this._lobDescriptorList.removeAll(this._lobDescriptorList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n2 = 0;
        while (n2 < table.getColumns().length) {
            Column column = table.getColumns()[n2];
            if (LOBDescriptor.isLOBColumn((DBObjectID)column.getID())) {
                arrayList2.add(column.getName());
                this.initLOBDescriptor(column, false, arrayList, list);
            } else if (LOBDescriptor.isVARRAYColumn((DBObjectID)column.getID())) {
                arrayList2.add(column.getName());
                this.initLOBDescriptor(column, true, arrayList, list);
            }
            ++n2;
        }
        arrayList.removeAll(arrayList);
        this._cmbColumns.setModel(new DefaultComboBoxModel<Object>(arrayList2.toArray()));
        if (arrayList2.size() == 0) {
            this.enableAllComponents(false, true);
            return;
        }
        this.enableAllComponents(true, true);
        if (this.lastColSelection != null && arrayList2.contains(this.lastColSelection)) {
            this._cmbColumns.setSelectedItem(this.lastColSelection);
        }
        this._cmbColumns.setEnabled(true);
        this._cbxStoreAsLob.setEnabled(true);
        this.setupPanelForColumn();
    }

    private void initLOBDescriptor(Column column, boolean bl, List<LOBDescriptor> list, List<LOBDescriptor> list2) {
        OracleStorageProperties oracleStorageProperties;
        LOBDescriptor lOBDescriptor = null;
        DBObjectID dBObjectID = column.getID();
        boolean bl2 = false;
        if (dBObjectID instanceof TemporaryObjectID) {
            try {
                bl2 = ((TemporaryObjectID)dBObjectID).resolveOriginalID() == null;
            }
            catch (DBException dBException) {
                bl2 = true;
            }
        }
        for (LOBDescriptor lOBDescriptor2 : list) {
            DBObjectID[] dBObjectIDArray = lOBDescriptor2.getColumns();
            int n = 0;
            while (n < dBObjectIDArray.length) {
                if (dBObjectID.equals(dBObjectIDArray[n], false)) {
                    lOBDescriptor = lOBDescriptor2;
                    this._colLobDescMap.put(column, new StoreAsLobInfo(lOBDescriptor, bl, true, bl2));
                    list2.add(lOBDescriptor);
                    list.remove(lOBDescriptor);
                    break;
                }
                ++n;
            }
            if (lOBDescriptor != null) break;
        }
        if (lOBDescriptor == null) {
            lOBDescriptor = new LOBDescriptor();
            DBObjectID[] dBObjectIDArray = new DBObjectID[]{column.getID()};
            lOBDescriptor.setColumns(dBObjectIDArray);
            list2.add(lOBDescriptor);
            this._colLobDescMap.put(column, new StoreAsLobInfo(lOBDescriptor, bl, bl ^ true, bl2));
            LOBDescriptor lOBDescriptor3 = new LOBDescriptor();
            lOBDescriptor3.setColumns(dBObjectIDArray);
            lOBDescriptor3.setStorage(new OracleStorageProperties());
            this._newStoreAsLobInfo.add(new StoreAsLobInfo(lOBDescriptor3, bl, bl ^ true, bl2));
        }
        if ((oracleStorageProperties = lOBDescriptor.getStorage()) == null) {
            lOBDescriptor.setStorage(new OracleStorageProperties());
        }
    }

    private void setupPanelForColumn() {
        this._column = (Column)this._table.findOwnedObject("COLUMN", (String)this._cmbColumns.getSelectedItem());
        this._lobDescriptor = this._colLobDescMap.get(this._column).getLobDescriptor();
        this._cbxStoreAsLob.setSelected(this._colLobDescMap.get(this._column).isStoreAsLob());
        boolean bl = this._colLobDescMap.get(this._column).isVarray();
        this._lblStoreAsLob.setVisible(this._colLobDescMap.get(this._column).showStoreAsLobCbx());
        this._cbxStoreAsLob.setVisible(this._colLobDescMap.get(this._column).showStoreAsLobCbx());
        this._pnlSubLobStorage.init(this._prov, this._lobDescriptor.getStorage(), this._siVerifier, this._tablespaces);
        this._txtSegName.setText(this._prov.getExternalName(this._lobDescriptor.getLOBSegName()));
        this._txtChunk.setText(this.i2s(this._lobDescriptor.getChunk()));
        this._txtPctVersion.setText(this.i2s(this._lobDescriptor.getPctVersion()));
        this._txtFreePools.setText(this.i2s(this._lobDescriptor.getFreepools()));
        this._cbxStoreInRow.setSelected(this._lobDescriptor.isStorageEnabledInRow());
        this._cbxRetention.setSelected(this._lobDescriptor.isRetention());
        if (this._lobDescriptor.getCache() != null) {
            this._cmbCache.setSelectedItem(this._lobDescriptor.getCache());
        } else {
            this._cmbCache.setSelectedItem(DEFAULT);
        }
        this.enableMainComponents(this._cbxStoreAsLob.isSelected(), true);
        if (bl) {
            this._lobDescriptor.getStorage().setTablespace(null);
            this._pnlSubLobStorage.lblTablespace.setEnabled(false);
            this._pnlSubLobStorage.cmbTablespace.setEnabled(false);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Table table = (Table)traversableContext.find("NewObject");
        this.commit();
        Column[] columnArray = table.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            OracleColumnProperties oracleColumnProperties = (OracleColumnProperties)columnArray[n].getProperty("OracleColumnProperties");
            if (oracleColumnProperties != null) {
                oracleColumnProperties.setLOBProperties(null);
                oracleColumnProperties.setVAProperties(null);
            }
            for (LOBDescriptor lOBDescriptor : this._lobDescriptorList) {
                String string;
                if (lOBDescriptor.getColumns().length <= 0 || !(string = DBUtil.getDBObjectName((DBObjectID)lOBDescriptor.getColumns()[0])).equals(columnArray[n].getName())) continue;
                if (oracleColumnProperties == null) {
                    oracleColumnProperties = new OracleColumnProperties();
                    columnArray[n].setProperty("OracleColumnProperties", (Object)oracleColumnProperties);
                }
                lOBDescriptor.setColumns(null);
                if (LOBDescriptor.isLOBColumn((DBObjectID)columnArray[n].getID())) {
                    oracleColumnProperties.setLOBProperties(lOBDescriptor);
                    break;
                }
                if (!LOBDescriptor.isVARRAYColumn((DBObjectID)columnArray[n].getID())) break;
                oracleColumnProperties.setVAProperties(lOBDescriptor);
                break;
            }
            if (oracleColumnProperties != null && oracleColumnProperties.getLOBProperties() == null && oracleColumnProperties.getVAProperties() == null && oracleColumnProperties.getNestedTableProperties() == null) {
                columnArray[n].getProperties().remove(oracleColumnProperties);
            }
            ++n;
        }
    }

    protected void commit() throws TraversalException {
        this.commitLOBDescriptor();
        Collection<StoreAsLobInfo> collection = this._colLobDescMap.values();
        for (StoreAsLobInfo storeAsLobInfo : collection) {
            for (StoreAsLobInfo storeAsLobInfo2 : this._newStoreAsLobInfo) {
                if (!storeAsLobInfo2.equivalentTo(storeAsLobInfo)) continue;
                this._lobDescriptorList.remove(storeAsLobInfo.getLobDescriptor());
            }
        }
    }

    private void commitLOBDescriptor() throws TraversalException {
        if (this._lobDescriptor != null) {
            if (this._lpVerifier != null) {
                this._lpVerifier.checkPctVersionAndRetention(this._txtPctVersion.getText(), this._cbxRetention.isSelected());
            }
            this._pnlSubLobStorage.commit(this._lobDescriptor.getStorage(), false);
            this._lobDescriptor.setLOBSegName(this.s2s(this._prov.getInternalName(this._txtSegName.getText())));
            this._lobDescriptor.setChunk(this.s2i(this._txtChunk.getText()));
            this._lobDescriptor.setPctVersion(this.s2i(this._txtPctVersion.getText()));
            this._lobDescriptor.setFreepools(this.s2i(this._txtFreePools.getText()));
            this._lobDescriptor.setStorageEnabledInRow(this._cbxStoreInRow.isSelected());
            this._lobDescriptor.setRetention(this._cbxRetention.isSelected());
            String string = (String)this._cmbCache.getSelectedItem();
            this._lobDescriptor.setCache(DEFAULT.equals(string) ? null : string);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cmbColumns) {
            try {
                this.commitLOBDescriptor();
            }
            catch (TraversalException traversalException) {
                traversalException.showMessageDialog((Component)((Object)this));
                this._cmbColumns.setSelectedItem(this.lastColSelection);
                return;
            }
            this.lastColSelection = (String)this._cmbColumns.getSelectedItem();
            this.setupPanelForColumn();
        } else if (object == this._cbxStoreAsLob) {
            boolean bl = this._cbxStoreAsLob.isSelected();
            this._colLobDescMap.get(this._column).setStoreAsLob(bl);
            this.enableMainComponents(bl, true);
            if (this._colLobDescMap.get(this._column).isVarray()) {
                this._lobDescriptor.getStorage().setTablespace(null);
                this._pnlSubLobStorage.lblTablespace.setEnabled(false);
                this._pnlSubLobStorage.cmbTablespace.setEnabled(false);
            }
            if (bl && !this._lobDescriptorList.contains(this._lobDescriptor)) {
                this._lobDescriptorList.add(this._lobDescriptor);
            } else if (!bl) {
                this._lobDescriptorList.remove(this._lobDescriptor);
            }
        } else if (object == this._cmbCache) {
            this.setupLogging();
        }
    }

    protected void enableAllComponents(boolean bl, boolean bl2) {
        this._cmbColumns.setEnabled(bl);
        this._cbxStoreAsLob.setEnabled(bl);
        if (bl || bl2) {
            this._lblColumns.setEnabled(bl);
            this._lblStoreAsLob.setEnabled(bl);
        }
        this.enableMainComponents(bl, bl2);
    }

    private void enableMainComponents(boolean bl) {
        this._cmbCache.setEnabled(this._lpVerifier.canChangeCache());
        this._txtSegName.setEnabled(this._lpVerifier.canChangeSegName());
        this._txtChunk.setEnabled(this._lpVerifier.canChangeChunk());
        this._txtPctVersion.setEnabled(this._lpVerifier.canChangePctVersion());
        this._txtFreePools.setEnabled(this._lpVerifier.canChangeFreepools());
        this._cbxStoreInRow.setEnabled(this._lpVerifier.canChangeStoreInRow());
        this._cbxRetention.setEnabled(this._lpVerifier.canChangeRetention());
        if (bl) {
            this._lblCache.setEnabled(this._lpVerifier.canChangeCache());
            this._lblSegName.setEnabled(this._lpVerifier.canChangeSegName());
            this._lblChunk.setEnabled(this._lpVerifier.canChangeChunk());
            this._lblPctVersion.setEnabled(this._lpVerifier.canChangePctVersion());
            this._lblFreePools.setEnabled(this._lpVerifier.canChangeFreepools());
        }
    }

    private void enableMainComponents(boolean bl, boolean bl2) {
        if (bl && this._lpVerifier != null) {
            this.enableMainComponents(bl2);
        } else {
            this._cmbCache.setEnabled(bl);
            this._txtSegName.setEnabled(bl);
            this._txtChunk.setEnabled(bl);
            this._txtPctVersion.setEnabled(bl);
            this._txtFreePools.setEnabled(bl);
            this._cbxStoreInRow.setEnabled(bl);
            this._cbxRetention.setEnabled(bl);
            if (bl || bl2) {
                this._lblCache.setEnabled(bl);
                this._lblSegName.setEnabled(bl);
                this._lblChunk.setEnabled(bl);
                this._lblPctVersion.setEnabled(bl);
                this._lblFreePools.setEnabled(bl);
            }
            if (bl && this._siVerifier != null) {
                this._pnlSubLobStorage.enableAllComponents(this._siVerifier, bl2);
            } else {
                this._pnlSubLobStorage.enableAllComponents(bl, bl2);
            }
        }
        this.setupLogging();
    }

    private void setupLogging() {
        if (this._cmbCache.isEnabled()) {
            if (this._cmbCache.getSelectedItem().equals("NOCACHE") || this._cmbCache.getSelectedItem().equals("CACHE READS")) {
                this._pnlSubLobStorage.lblLogging.setEnabled(true);
                this._pnlSubLobStorage.cmbLogging.setEnabled(true);
            } else {
                this._pnlSubLobStorage.lblLogging.setEnabled(false);
                this._pnlSubLobStorage.cmbLogging.setEnabled(false);
                this._pnlSubLobStorage.cmbLogging.setSelectedIndex(0);
            }
        }
    }

    private String i2s(Integer n) {
        return n == null ? "" : n.toString();
    }

    private Integer s2i(String string) {
        return string == null || string.equals("") ? null : Integer.valueOf(string);
    }

    private String s2s(String string) {
        return ModelUtil.hasLength((String)string) ? string : null;
    }

    static DBObjectProvider ra$_prov(LobDescriptorPanel lobDescriptorPanel) {
        return lobDescriptorPanel._prov;
    }

    private class StoreAsLobInfo {
        private LOBDescriptor _lobDescriptor;
        private boolean _Varray;
        private boolean _storeAsLob;
        private boolean _newColumn;

        public StoreAsLobInfo(LOBDescriptor lOBDescriptor, boolean bl, boolean bl2, boolean bl3) {
            this._lobDescriptor = lOBDescriptor;
            this._Varray = bl;
            this._storeAsLob = bl2;
            this._newColumn = bl3;
        }

        public LOBDescriptor getLobDescriptor() {
            return this._lobDescriptor;
        }

        public boolean isVarray() {
            return this._Varray;
        }

        public boolean isStoreAsLob() {
            return this._storeAsLob;
        }

        public boolean showStoreAsLobCbx() {
            return this._Varray && (!(LobDescriptorPanel.ra$_prov(LobDescriptorPanel.this) instanceof OracleDatabase) || this._newColumn);
        }

        public void setLobDescriptor(LOBDescriptor lOBDescriptor) {
            this._lobDescriptor = lOBDescriptor;
        }

        public void setVarray(boolean bl) {
            this._Varray = bl;
        }

        public void setStoreAsLob(boolean bl) {
            this._storeAsLob = bl;
        }

        public boolean equivalentTo(StoreAsLobInfo storeAsLobInfo) {
            return this._storeAsLob == storeAsLobInfo._storeAsLob && this._Varray == storeAsLobInfo._Varray && this._lobDescriptor.equals((Object)storeAsLobInfo._lobDescriptor);
        }
    }
}

