/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.db.DBIcons;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.IndexEditorPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;

public class IndexPanel
extends BaseInfoPanel
implements DocumentListener,
ActionListener {
    private ArrayList m_whatsHappening;
    private JMultiLineLabel m_lblTop;
    private JList m_lstIndexes;
    private JButton m_btnAdd;
    private JButton m_btnRemove;
    private JTextField m_fldName;
    private DefaultListModel m_mdlIndexes;
    private ListSelectionListener m_mdlIndexesListSelectionListener;
    private Table m_table;
    private int m_currentSelection;
    IndexEditorPanel m_pnlDetails;
    WizardCallbacks m_callbacks;
    IndexInfoVerifier m_indexInfoVerifier;
    private static String WH_ADD_NEW_INDEX = "Add a new Index";
    private static String WH_REMOVE_AN_INDEX = "Remove an Index";
    private static String WH_EDIT_INDEX_NAME = "Edit index name";
    private static String WH_CHANGE_INDEX_SELECTION = "Change index selection";

    private void $init$() {
        this.m_whatsHappening = new ArrayList();
        this.m_lblTop = new JMultiLineLabel();
        this.m_lstIndexes = new JList();
        this.m_btnAdd = new JButton();
        this.m_btnRemove = new JButton();
        this.m_mdlIndexes = new DefaultListModel();
        this.m_currentSelection = 0;
        this.m_pnlDetails = new IndexEditorPanel();
    }

    public IndexPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.m_fldName = this.m_pnlDetails.getNameField();
        this.m_fldName.getDocument().addDocumentListener(this);
        this.m_lblTop.setText(UIArb.getString(254));
        this.m_lblTop.setPreferredAspectRatio(0.0f);
        this.m_lblTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_lstIndexes, (String)UIArb.getString(255));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.m_lstIndexes.setModel(this.m_mdlIndexes);
        this.m_lstIndexes.setSelectionMode(0);
        this.m_lstIndexes.setCellRenderer(new DBObjectRenderer());
        Insets insets = new Insets(2, 2, 2, 2);
        this.m_btnAdd.setMargin(insets);
        this.m_btnAdd.setIcon(DBIcons.getIcon(0));
        DBObjectRenderer.setToolTipText(this.m_btnAdd, UIArb.getString(264));
        this.m_btnAdd.addActionListener(this);
        this.m_btnRemove.setMargin(insets);
        this.m_btnRemove.setIcon(DBIcons.getIcon(1));
        DBObjectRenderer.setToolTipText(this.m_btnRemove, UIArb.getString(265));
        this.m_btnRemove.addActionListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.m_btnAdd, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_btnRemove, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        jScrollPane.getViewport().add((Component)this.m_lstIndexes, null);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel2.add(Box.createHorizontalStrut(150), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlDetails.setBorder(BorderFactory.createTitledBorder(UIArb.getString(270)));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.m_pnlDetails, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 24, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(jPanel3, "Center");
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_callbacks = traversableContext.getWizardCallbacks();
        this.m_indexInfoVerifier = (IndexInfoVerifier)traversableContext.find("IndexVerifier");
        this.m_pnlDetails.init((DBObjectProvider)traversableContext.find("DBObjectProvider"), (Table)traversableContext.find("NewObject"), this.m_indexInfoVerifier, this.m_callbacks, (Table)traversableContext.get("OriginalObject"), this.m_mdlIndexes.size() > 0);
        this.init((DBObjectProvider)traversableContext.find("DBObjectProvider"), (Table)traversableContext.find("NewObject"), (IndexInfoVerifier)traversableContext.find("IndexVerifier"));
        if (this.m_callbacks != null) {
            this.m_callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            if (this.m_mdlIndexes.getSize() > 0) {
                this.m_callbacks.wizardSetInitialFocus((Component)this.m_lstIndexes);
            } else {
                this.m_callbacks.wizardSetInitialFocus((Component)this.m_btnAdd);
            }
        }
        this.setInitialSelection(traversableContext.find("DefaultChild"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit((Table)traversableContext.find("OriginalObject"), (Table)traversableContext.find("NewObject"), traversableContext.getDirection() == 2);
    }

    protected void init(DBObjectProvider dBObjectProvider, Table table, IndexInfoVerifier indexInfoVerifier) {
        super.init(dBObjectProvider, indexInfoVerifier);
        this.m_table = table;
        this.m_lstIndexes.getSelectionModel().removeListSelectionListener(this.m_mdlIndexesListSelectionListener);
        this.m_mdlIndexes.removeAllElements();
        this.m_mdlIndexesListSelectionListener = new 1();
        this.m_lstIndexes.getSelectionModel().addListSelectionListener(this.m_mdlIndexesListSelectionListener);
        Index[] indexArray = table.getIndexes();
        int n = 0;
        while (n < indexArray.length) {
            this.m_mdlIndexes.addElement(indexArray[n]);
            ++n;
        }
        this.updateButtons();
        this.updateListContents(this.m_mdlIndexes);
        if (indexInfoVerifier != null) {
            boolean bl = this.m_mdlIndexes.size() > 0;
            this.m_btnAdd.setEnabled(indexInfoVerifier.canAddIndexes());
            this.m_btnRemove.setEnabled(bl && indexInfoVerifier.canRemoveIndexes());
        }
    }

    protected void commit(Table table, Table table2, boolean bl) throws TraversalException {
        this.m_pnlDetails.commit();
        int n = this.m_mdlIndexes.size();
        ArrayList<Index> arrayList = new ArrayList<Index>(n);
        int n2 = 0;
        while (n2 < n) {
            Index index = (Index)this.m_mdlIndexes.getElementAt(n2);
            arrayList.add(index);
            ++n2;
        }
        table2.setIndexes(arrayList.toArray(new Index[arrayList.size()]));
        IndexInfoVerifier indexInfoVerifier = (IndexInfoVerifier)this.getVerifier();
        if (!bl && indexInfoVerifier != null) {
            indexInfoVerifier.verifyRelation();
        }
    }

    private void setInitialSelection(Object object) {
        int n;
        int n2 = 0;
        if (object != null && (n = this.m_mdlIndexes.indexOf(object)) != -1) {
            n2 = n;
        }
        if (this.m_mdlIndexes.size() > 0) {
            this.setSelectedIndex(0);
        }
    }

    private void updateSelection(Object object) {
        if (object != this.m_pnlDetails.getIndex()) {
            try {
                this.m_pnlDetails.commit();
            }
            catch (TraversalException traversalException) {
                this.showIndexError(traversalException);
                return;
            }
            this.m_pnlDetails.updateIndexData((Index)object);
        }
        this.updateButtons();
        this.m_pnlDetails.updateButtons();
        this.m_pnlDetails.setFieldEnable(this.m_indexInfoVerifier, (Index)object, true);
    }

    private void showIndexError(TraversalException traversalException) {
        traversalException.showMessageDialog((Component)((Object)this));
        int n = this.m_lstIndexes.getSelectedIndex();
        if (n < 0 || this.m_mdlIndexes.elementAt(n).equals(this.m_mdlIndexes.elementAt(this.m_currentSelection))) {
            this.setSelectedIndex(this.m_currentSelection);
        } else if (this.m_currentSelection != n) {
            this.setSelectedIndex(this.m_pnlDetails.getIndex());
        }
    }

    private void updateButtons() {
        Index index;
        boolean bl = false;
        IndexInfoVerifier indexInfoVerifier = (IndexInfoVerifier)this.getVerifier();
        int n = this.m_lstIndexes.getSelectedIndex();
        int n2 = this.m_mdlIndexes.getSize();
        if (n != -1 && n >= n2) {
            n = n2 - 1;
        }
        Index index2 = index = n != -1 ? (Index)this.m_mdlIndexes.get(n) : null;
        if (index != null) {
            bl = indexInfoVerifier == null || indexInfoVerifier.canRemoveIndexes() && indexInfoVerifier.canRemoveIndex(index);
        }
        this.m_btnRemove.setEnabled(bl);
        this.m_btnAdd.setEnabled(indexInfoVerifier == null || indexInfoVerifier.canAddIndexes() && indexInfoVerifier.canAddIndex(index));
    }

    private void updateListContents(Object object) {
        boolean bl = this.m_mdlIndexes.getSize() > 0;
        boolean bl2 = false;
        if (this.m_mdlIndexes == object) {
            this.m_lstIndexes.setFocusable(bl);
            if (bl) {
                int n = this.m_lstIndexes.getSelectedIndex();
                int n2 = this.m_mdlIndexes.getSize();
                if (n < 0) {
                    n = 0;
                } else if (n >= n2) {
                    n = n2 - 1;
                    this.setSelectedIndex(n);
                }
                Index index = (Index)this.m_mdlIndexes.getElementAt(n);
                this.m_pnlDetails.populateColumnExpressions(index);
                bl2 = index.getColumnExpressions().length > 0;
                this.m_fldName.setEditable(true);
                this.m_fldName.setEnabled(true);
            } else {
                this.m_fldName.setEditable(false);
                this.m_fldName.setEnabled(false);
            }
        }
        if (this.m_callbacks != null) {
            Boolean bl3 = !bl || bl2;
            this.m_callbacks.wizardEnableButtons(Boolean.TRUE, bl3, bl3);
        }
    }

    private void updateIndexName() {
        if (this.m_fldName.hasFocus()) {
            this.m_pnlDetails.logActionStart(WH_EDIT_INDEX_NAME, true);
            String string = this.m_fldName.getText();
            Index index = (Index)this.m_lstIndexes.getSelectedValue();
            if (index != null) {
                index.setName(string);
                this.m_lstIndexes.repaint();
            }
            this.m_pnlDetails.populateColumnExpressions(index);
            this.m_fldName.requestFocusInWindow();
            this.m_pnlDetails.logActionEnd(WH_EDIT_INDEX_NAME);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.m_currentSelection = this.m_lstIndexes.getSelectedIndex();
        Object object = actionEvent.getSource();
        if (object == this.m_btnAdd) {
            this.m_pnlDetails.logActionStart(WH_ADD_NEW_INDEX, false);
            this.m_lstIndexes.clearSelection();
            if (this.m_lstIndexes.getSelectedValue() == null) {
                String string = IndexPanel.getUniqueName(this.m_table.getName() + "_INDEX", this.m_mdlIndexes);
                Index index = new Index(string, this.m_table);
                this.m_pnlDetails.setNewIndex(true);
                this.m_mdlIndexes.addElement(index);
                this.m_pnlDetails.populateColumnExpressions(index);
                this.setSelectedIndex(index);
                this.m_fldName.requestFocusInWindow();
            }
            this.m_pnlDetails.logActionEnd(WH_ADD_NEW_INDEX);
        } else if (object == this.m_btnRemove) {
            this.m_pnlDetails.logActionStart(WH_REMOVE_AN_INDEX, false);
            int n = this.m_lstIndexes.getSelectedIndex();
            if (n != -1) {
                this.m_table.removeIndex(this.m_pnlDetails.getIndex());
                this.m_pnlDetails.setIndex(null);
                int n2 = n == this.m_mdlIndexes.size() - 1 ? n - 1 : n + 1;
                this.setSelectedIndex(n2);
                this.m_mdlIndexes.removeElementAt(n);
                if (n2 > 0 && n2 == this.m_mdlIndexes.size()) {
                    this.setSelectedIndex(n2 - 1);
                }
                if (n2 == -1) {
                    this.updateSelection(null);
                    this.m_pnlDetails.updateIndexData(null);
                }
            }
            this.m_pnlDetails.logActionEnd(WH_REMOVE_AN_INDEX);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    private void setSelectedIndex(int n) {
        this.m_currentSelection = n;
        this.m_lstIndexes.setSelectedIndex(this.m_currentSelection);
    }

    private void setSelectedIndex(Index index) {
        this.m_lstIndexes.setSelectedValue(index, true);
        this.m_currentSelection = this.m_lstIndexes.getSelectedIndex();
    }

    static String ra$WH_CHANGE_INDEX_SELECTION() {
        return WH_CHANGE_INDEX_SELECTION;
    }

    static JList ra$m_lstIndexes(IndexPanel indexPanel) {
        return indexPanel.m_lstIndexes;
    }

    static void mav$updateSelection(IndexPanel indexPanel, Object object) {
        indexPanel.updateSelection(object);
    }

    final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            IndexPanel.this.m_pnlDetails.logActionStart(IndexPanel.ra$WH_CHANGE_INDEX_SELECTION(), true);
            IndexPanel.mav$updateSelection(IndexPanel.this, IndexPanel.ra$m_lstIndexes(IndexPanel.this).getSelectedValue());
            IndexPanel.this.m_pnlDetails.logActionEnd(IndexPanel.ra$WH_CHANGE_INDEX_SELECTION());
        }
    }
}

