/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.db.DBIcons;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.ora.NameBasedRefID;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.util.ModelUtil;

public class IndexEditorPanel
extends JPanel
implements ItemListener,
DocumentListener,
ListDataListener,
ActionListener {
    private ArrayList m_whatsHappening;
    private JLabel m_lblIndexName;
    JLabel m_lblIndexType;
    private JLabel m_lblColExprs;
    private JList m_lstColExprs;
    private JButton m_btnAddColExpr;
    private JButton m_btnRemoveColExpr;
    private JButton m_btnUpColExpr;
    private JButton m_btnDownColExpr;
    private DefaultListModel m_mdlColExprs;
    private ListSelectionListener m_mdlColExprsListSelectionListener;
    private DefaultComboBoxModel m_mdlCmbColExpr;
    private JTextField m_fldName;
    private JLabel m_lblColExpr;
    private JComboBox m_cmbColExpr;
    private JComboBox m_cmbCol;
    private JLabel m_lblAsc;
    private JComboBox m_cmbAsc;
    private DBObjectProvider m_prov;
    private Table m_table;
    private Index m_oldIndex;
    private Index m_index;
    private boolean m_isNewIndex;
    private IndexInfoVerifier m_verifier;
    private JRadioButton m_rdbNormal;
    private JRadioButton m_rdbDomain;
    private JRadioButton m_rdbNonUnique;
    private JRadioButton m_rdbUnique;
    private JRadioButton m_rdbBitmap;
    private JRadioButton m_rdbParallel;
    private JRadioButton m_rdbNoParallel;
    private JLabel m_lblParallelDegree;
    private NumberField m_txtParallelDegree;
    private JPanel m_pnlNormal;
    private JLabel m_lblCol;
    private JPanel m_pnlDomain;
    private JPanel m_pnlIndextype;
    private JComboBox m_cmbIndextype;
    private SchemaPicker m_cmbIndextypeSchema;
    private JLabel m_lblIndextypeParameters;
    private JTextArea m_txtIndextypeParameters;
    private JLabel m_lblIndextypeStatus;
    private JTextField m_txtIndextypeStatus;
    private GridBagConstraints m_gbcNormalDomain;
    WizardCallbacks m_callbacks;
    private Table m_originalTable;
    private static String WH_ADD_A_COLUMN_EXPRESSION = "Add a column expression";
    private static String WH_REMOVE_A_COLUMN_EXPRESSION = "Remove a column expression";
    private static String WH_MOVE_A_COLUMN_EXPRESSION_UP = "Move a column expression up";
    private static String WH_MOVE_A_COLUMN_EXPRESSION_DOWN = "Move a column expression down";
    private static String WH_EDIT_COLUMN_EXPRESSION = "Edit column Expression";
    private static String WH_CHANGE_COLEXPR_SELECTION = "Change column expression selection";
    private static String WH_SET_ASC_DESC = "Set the column expression order";
    private static final String[] INDEXTYPES = new String[]{"INDEXTYPE"};
    private static final int NOPARALLEL = 1;
    private static final int PARALLEL_DEFAULT = 0;

    private void $init$() {
        this.m_whatsHappening = new ArrayList();
        this.m_lblIndexName = new JLabel();
        this.m_lblIndexType = new JLabel(UIArb.getString(256));
        this.m_lblColExprs = new JLabel();
        this.m_lstColExprs = new JList();
        this.m_btnAddColExpr = new JButton();
        this.m_btnRemoveColExpr = new JButton();
        this.m_btnUpColExpr = new JButton();
        this.m_btnDownColExpr = new JButton();
        this.m_mdlColExprs = new DefaultListModel();
        this.m_mdlCmbColExpr = new DefaultComboBoxModel();
        this.m_lblColExpr = new JLabel();
        this.m_cmbColExpr = new JComboBox();
        this.m_cmbCol = new JComboBox();
        this.m_lblAsc = new JLabel();
        this.m_cmbAsc = new JComboBox();
        this.m_rdbNormal = new JRadioButton();
        this.m_rdbDomain = new JRadioButton();
        this.m_rdbNonUnique = new JRadioButton();
        this.m_rdbUnique = new JRadioButton();
        this.m_rdbBitmap = new JRadioButton();
        this.m_rdbParallel = new JRadioButton();
        this.m_rdbNoParallel = new JRadioButton();
        this.m_lblParallelDegree = new JLabel();
        this.m_txtParallelDegree = new NumberField();
        this.m_lblCol = new JLabel();
        this.m_cmbIndextype = new JComboBox();
        this.m_cmbIndextypeSchema = new SchemaPicker();
        this.m_lblIndextypeParameters = new JLabel();
        this.m_txtIndextypeParameters = new JTextArea();
        this.m_lblIndextypeStatus = new JLabel();
        this.m_txtIndextypeStatus = new JTextField();
    }

    public IndexEditorPanel() {
        this(true);
    }

    public IndexEditorPanel(boolean bl) {
        this.$init$();
        ResourceUtils.resButton((AbstractButton)this.m_rdbNormal, (String)UIArb.getString(257));
        ResourceUtils.resButton((AbstractButton)this.m_rdbDomain, (String)UIArb.getString(258));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_rdbNormal);
        buttonGroup.add(this.m_rdbDomain);
        this.m_rdbNormal.addActionListener(this);
        this.m_rdbDomain.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_rdbNonUnique, (String)UIArb.getString(261));
        ResourceUtils.resButton((AbstractButton)this.m_rdbUnique, (String)UIArb.getString(262));
        ResourceUtils.resButton((AbstractButton)this.m_rdbBitmap, (String)UIArb.getString(263));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.m_rdbNonUnique);
        buttonGroup2.add(this.m_rdbUnique);
        buttonGroup2.add(this.m_rdbBitmap);
        this.m_rdbNonUnique.setSelected(true);
        this.m_rdbNonUnique.addActionListener(this);
        this.m_rdbUnique.addActionListener(this);
        this.m_rdbBitmap.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this.m_lblColExprs, (Component)this.m_lstColExprs, (String)UIArb.getString(271));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.m_lstColExprs.setModel(this.m_mdlColExprs);
        this.m_lstColExprs.setSelectionMode(0);
        Insets insets = new Insets(2, 2, 2, 2);
        this.m_btnUpColExpr.setMargin(insets);
        this.m_btnUpColExpr.setIcon(ComponentArb.getIcon((int)0));
        this.m_btnUpColExpr.setDisabledIcon(ComponentArb.getIcon((int)2));
        DBObjectRenderer.setToolTipText(this.m_btnUpColExpr, UIArb.getString(434));
        this.m_btnUpColExpr.addActionListener(this);
        this.m_btnDownColExpr.setMargin(insets);
        this.m_btnDownColExpr.setIcon(ComponentArb.getIcon((int)1));
        this.m_btnDownColExpr.setDisabledIcon(ComponentArb.getIcon((int)3));
        DBObjectRenderer.setToolTipText(this.m_btnDownColExpr, UIArb.getString(435));
        this.m_btnDownColExpr.addActionListener(this);
        this.m_btnAddColExpr.setMargin(insets);
        this.m_btnAddColExpr.setIcon(DBIcons.getIcon(0));
        DBObjectRenderer.setToolTipText(this.m_btnAddColExpr, UIArb.getString(266));
        this.m_btnAddColExpr.addActionListener(this);
        this.m_btnRemoveColExpr.setMargin(insets);
        this.m_btnRemoveColExpr.setIcon(DBIcons.getIcon(1));
        DBObjectRenderer.setToolTipText(this.m_btnRemoveColExpr, UIArb.getString(267));
        this.m_btnRemoveColExpr.addActionListener(this);
        if (bl) {
            this.m_fldName = new JTextField();
            ResourceUtils.resLabel((JLabel)this.m_lblIndexName, (Component)this.m_fldName, (String)UIArb.getString(73));
            this.m_fldName.setColumns(30);
        }
        ResourceUtils.resLabel((JLabel)this.m_lblColExpr, (Component)this.m_cmbColExpr, (String)UIArb.getString(272));
        this.m_cmbColExpr.addItemListener(this);
        this.m_cmbColExpr.setModel(this.m_mdlCmbColExpr);
        this.m_cmbColExpr.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.m_lblAsc, (Component)this.m_cmbAsc, (String)UIArb.getString(273));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.m_btnAddColExpr, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_btnRemoveColExpr, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_btnUpColExpr, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_btnDownColExpr, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        jScrollPane.getViewport().add((Component)this.m_lstColExprs, null);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.m_lblColExprs, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel2.add(Box.createHorizontalStrut(150), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this.m_lblColExpr, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel3.add((Component)this.m_cmbColExpr, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.m_lblAsc, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 5, 0), 0, 0));
        jPanel3.add((Component)this.m_cmbAsc, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.m_pnlNormal = new JPanel(new GridBagLayout());
        this.m_pnlNormal.add((Component)this.m_rdbNonUnique, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 15), 0, 0));
        this.m_pnlNormal.add((Component)this.m_rdbUnique, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 15), 0, 0));
        this.m_pnlNormal.add((Component)this.m_rdbBitmap, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlNormal.add((Component)jPanel2, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.m_pnlNormal.add((Component)jPanel3, new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 15, 5, 5), 0, 0));
        this.m_pnlDomain = new JPanel(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_lblCol, (Component)this.m_cmbCol, (String)UIArb.getString(259));
        this.m_pnlDomain.add((Component)this.m_lblCol, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlDomain.add((Component)this.m_cmbCol, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.m_pnlIndextype = new JPanel(new GridBagLayout());
        this.m_pnlIndextype.setBorder(BorderFactory.createTitledBorder(UIArb.getString(274)));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_cmbIndextypeSchema, (String)UIArb.getString(275));
        this.m_pnlIndextype.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 12), 0, 0));
        this.m_pnlIndextype.add((Component)this.m_cmbIndextypeSchema, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_cmbIndextype, (String)UIArb.getString(276));
        this.m_pnlIndextype.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 12), 0, 0));
        this.m_pnlIndextype.add((Component)this.m_cmbIndextype, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        ResourceUtils.resLabel((JLabel)this.m_lblIndextypeParameters, (Component)this.m_txtIndextypeParameters, (String)UIArb.getString(277));
        this.m_pnlIndextype.add((Component)this.m_lblIndextypeParameters, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.m_pnlIndextype.add((Component)new JScrollPane(this.m_txtIndextypeParameters), new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlDomain.add((Component)this.m_pnlIndextype, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlDomain.add(Box.createVerticalGlue(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        if (bl) {
            this.add((Component)this.m_lblIndexName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
            this.add((Component)this.m_fldName, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        }
        this.add((Component)this.m_lblIndexType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add((Component)this.m_rdbNormal, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_rdbDomain, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_gbcNormalDomain = new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
        this.add((Component)this.m_pnlNormal, this.m_gbcNormalDomain);
        ResourceUtils.resButton((AbstractButton)this.m_rdbParallel, (String)UIArb.getString(280));
        ResourceUtils.resButton((AbstractButton)this.m_rdbNoParallel, (String)UIArb.getString(279));
        this.add((Component)this.m_rdbNoParallel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
        this.add((Component)this.m_rdbParallel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.m_lblParallelDegree, (Component)((Object)this.m_txtParallelDegree), (String)UIArb.getString(281));
        this.add((Component)this.m_lblParallelDegree, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
        this.add((Component)((Object)this.m_txtParallelDegree), new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 5, 5), 0, 0));
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.m_rdbParallel);
        buttonGroup3.add(this.m_rdbNoParallel);
        this.m_rdbNoParallel.addActionListener(this);
        this.m_rdbParallel.addActionListener(this);
        this.populateParallel(1);
    }

    protected void init(DBObjectProvider dBObjectProvider, Table table, IndexInfoVerifier indexInfoVerifier, WizardCallbacks wizardCallbacks, Table table2, boolean bl) {
        this.m_prov = dBObjectProvider;
        this.m_table = table;
        this.m_verifier = indexInfoVerifier;
        this.m_callbacks = wizardCallbacks;
        this.m_originalTable = table2;
        this.m_lstColExprs.getSelectionModel().removeListSelectionListener(this.m_mdlColExprsListSelectionListener);
        this.m_mdlColExprs.removeListDataListener(this);
        this.m_mdlColExprs.removeAllElements();
        this.m_index = null;
        this.m_mdlCmbColExpr.removeAllElements();
        this.m_mdlColExprsListSelectionListener = new 1();
        this.m_mdlColExprs.addListDataListener(this);
        this.m_cmbAsc.addActionListener(this);
        this.m_cmbAsc.setEditable(false);
        if (this.m_cmbAsc.getItemCount() == 0) {
            this.m_cmbAsc.addItem(null);
            this.m_cmbAsc.addItem("ASC");
            this.m_cmbAsc.addItem("DESC");
        }
        this.m_lstColExprs.getSelectionModel().addListSelectionListener(this.m_mdlColExprsListSelectionListener);
        this.m_cmbCol.addActionListener(this);
        this.m_cmbCol.setEditable(false);
        this.m_cmbIndextype.addActionListener(this);
        this.m_cmbIndextype.setEditable(false);
        this.m_cmbIndextypeSchema.addActionListener(this);
        this.m_cmbIndextypeSchema.setEditable(false);
        this.updateTableColumns(table);
        this.updateIndexData(null);
        this.updateColExpr(null);
        this.updateButtons();
        this.updateListContents(this.m_mdlColExprs);
        this.setFieldEnable(indexInfoVerifier, null, bl);
    }

    public void setFieldEnable(IndexInfoVerifier indexInfoVerifier, Index index, boolean bl) {
        if (indexInfoVerifier != null) {
            boolean bl2;
            boolean bl3 = bl2 = this.m_mdlColExprs.size() > 0;
            if (this.m_fldName != null) {
                this.m_lblIndexName.setEnabled(bl && indexInfoVerifier.canRenameIndex(index));
                this.m_fldName.setEnabled(bl && indexInfoVerifier.canRenameIndex(index));
            }
            this.m_lblIndexType.setEnabled(bl && indexInfoVerifier.canEditDomain(index));
            this.m_rdbDomain.setEnabled(bl && indexInfoVerifier.canEditDomain(index));
            this.m_rdbNormal.setEnabled(bl && indexInfoVerifier.canEditDomain(index));
            this.m_rdbBitmap.setEnabled(bl && indexInfoVerifier.canEditUniqueness(index));
            this.m_rdbNonUnique.setEnabled(bl && indexInfoVerifier.canEditUniqueness(index));
            this.m_rdbUnique.setEnabled(bl && indexInfoVerifier.canEditUniqueness(index));
            this.m_rdbParallel.setEnabled(bl && indexInfoVerifier.canEditParallel(index));
            this.m_rdbNoParallel.setEnabled(bl && indexInfoVerifier.canEditParallel(index));
            this.m_lblColExprs.setEnabled(bl && indexInfoVerifier.canEditIndex(index));
            this.m_btnAddColExpr.setEnabled(bl && indexInfoVerifier.canEditIndex(index));
            this.m_btnDownColExpr.setEnabled(bl && bl2 && indexInfoVerifier.canEditIndex(index));
            this.m_btnRemoveColExpr.setEnabled(bl && bl2 && indexInfoVerifier.canEditIndex(index));
            this.m_btnUpColExpr.setEnabled(bl && bl2 && indexInfoVerifier.canEditIndex(index));
            this.m_lblColExpr.setEnabled(bl2 && indexInfoVerifier.canEditIndex(index));
            this.m_cmbColExpr.setEditable(bl2 && indexInfoVerifier.canEditIndex(index));
            this.m_cmbColExpr.setEnabled(bl2 && indexInfoVerifier.canEditIndex(index));
            this.m_lblAsc.setEnabled(bl && indexInfoVerifier.canEditIndex(index) && !this.m_rdbBitmap.isSelected());
            this.m_cmbAsc.setEnabled(bl && indexInfoVerifier.canEditIndex(index) && !this.m_rdbBitmap.isSelected());
            this.m_lblCol.setEnabled(bl && indexInfoVerifier.canEditIndex(index));
            this.m_cmbCol.setEnabled(bl && indexInfoVerifier.canEditIndex(index));
        }
    }

    private void updateTableColumns(Table table) {
        this.m_cmbColExpr.removeItemListener(this);
        this.m_mdlCmbColExpr.removeAllElements();
        if (table != null) {
            Column[] columnArray = table.getColumns();
            int n = 0;
            while (n < columnArray.length) {
                Column column = columnArray[n];
                String string = column.getName();
                if (column instanceof ViewColumn && string.contains(".")) {
                    string = string.substring(string.indexOf(".") + 1);
                }
                this.m_mdlCmbColExpr.addElement(string);
                ++n;
            }
        }
        this.m_cmbColExpr.addItemListener(this);
    }

    public JTextField getNameField() {
        return this.m_fldName;
    }

    public void commit() throws TraversalException {
        if (this.m_index != null) {
            TraversalException traversalException = this.saveIndexAttributes();
            if (traversalException != null) {
                throw traversalException;
            }
            if (this.m_fldName != null) {
                this.m_index.setName(this.m_prov.getInternalName(this.m_fldName.getText()));
            }
            if (this.m_index.getIndexType() != Index.IndexType.DOMAIN) {
                this.m_index.setDomainIndextype(null);
                this.m_index.setDomainIndextypeOpStatus(null);
                this.m_index.setDomainIndextypeParameters(null);
            }
            if (this.m_verifier != null) {
                this.m_verifier.verifyIndex(this.m_oldIndex, this.m_index);
            }
        }
    }

    private TraversalException saveIndexAttributes() {
        if (this.m_index != null) {
            IndexObject[] indexObjectArray = null;
            if (this.m_rdbNormal.isSelected()) {
                this.m_index.setIndexType(Index.IndexType.NORMAL);
                if (this.m_rdbUnique.isSelected()) {
                    this.m_index.setIndexType(Index.IndexType.UNIQUE);
                } else if (this.m_rdbBitmap.isSelected()) {
                    this.m_index.setIndexType(Index.IndexType.BITMAP);
                }
                indexObjectArray = new IndexObject[this.m_mdlColExprs.size()];
                int n = 0;
                while (n < this.m_mdlColExprs.size()) {
                    indexObjectArray[n] = (IndexObject)this.m_mdlColExprs.getElementAt(n);
                    ++n;
                }
            } else {
                this.m_index.setIndexType(Index.IndexType.DOMAIN);
                this.m_index.setDomainIndextypeOpStatus("VALID");
                DBObject dBObject = (DBObject)this.m_cmbIndextype.getSelectedItem();
                if (dBObject == null) {
                    return new TraversalException(UIArb.getString(285), this.m_index.getName());
                }
                this.m_index.setDomainIndextype(dBObject.getID());
                String string = this.m_txtIndextypeParameters.getText().trim();
                this.m_index.setDomainIndextypeParameters(ModelUtil.hasLength((String)string) ? string : null);
                SimpleSQLFragment simpleSQLFragment = new SimpleSQLFragment((String)this.m_cmbCol.getSelectedItem());
                indexObjectArray = new IndexObject[]{new IndexObject((SQLFragment)simpleSQLFragment)};
            }
            this.m_index.setColumnExpressions(indexObjectArray);
            if (this.m_rdbNoParallel.isSelected()) {
                this.m_index.setParallelDegree(1);
            } else {
                Number number = this.m_txtParallelDegree.getNumber();
                if (number != null) {
                    this.m_index.setParallelDegree(number.intValue());
                } else {
                    this.m_index.setParallelDegree(0);
                }
            }
        }
        return null;
    }

    public void setIndex(Index index) {
        this.m_index = index;
        if (index != null) {
            this.populateName(index);
            this.populateIndexType(index);
        }
    }

    public void setTable(Table table) {
        if (table != this.m_table) {
            this.m_table = table;
            this.updateTableColumns(table);
        }
    }

    public Index getIndex() {
        return this.m_index;
    }

    public void updateIndexData(Index index) {
        this.m_index = index;
        if (index == null) {
            if (this.m_fldName != null) {
                this.m_fldName.setText("");
                this.m_fldName.setEnabled(false);
            }
            this.m_oldIndex = null;
        } else {
            this.m_oldIndex = this.m_isNewIndex ? null : (Index)index.copyTo(null);
            this.populateName(index);
        }
        this.populateIndexType(this.m_index);
        this.populateUniqueness(this.m_index);
        this.populateColumnExpressions(this.m_index);
        this.populateColumns(this.m_index);
        this.populateParallel(this.m_index != null ? this.m_index.getParallelDegree() : 1);
        if (this.m_fldName != null) {
            this.m_fldName.requestFocusInWindow();
        }
    }

    public void setNewIndex(boolean bl) {
        this.m_isNewIndex = bl;
        this.m_verifier.setEditable(this.m_isNewIndex);
    }

    private void switchToNormalIndex() {
        this.remove(this.m_pnlDomain);
        this.add((Component)this.m_pnlNormal, this.m_gbcNormalDomain);
        String string = (String)this.m_cmbCol.getSelectedItem();
        if (ModelUtil.hasLength((String)string)) {
            this.m_cmbColExpr.setSelectedItem(string);
        }
        this.validate();
        this.repaint();
    }

    private void switchToDomainIndex() {
        ArrayList arrayList;
        this.remove(this.m_pnlNormal);
        this.add((Component)this.m_pnlDomain, this.m_gbcNormalDomain);
        String string = (String)this.m_cmbColExpr.getSelectedItem();
        if (ModelUtil.hasLength((String)string) && (arrayList = new ArrayList(ParserUtils.getColumnNames((String)string))).size() > 0) {
            this.m_cmbCol.setSelectedItem(arrayList.get(0));
        }
        this.populateDomain(this.m_index);
        this.validate();
        this.repaint();
    }

    private void switchIndexType() {
        if (this.m_rdbNormal.isSelected()) {
            this.switchToNormalIndex();
        } else if (this.m_rdbDomain.isSelected()) {
            this.switchToDomainIndex();
        }
    }

    private void switchUnique() {
        if (this.m_rdbBitmap.isSelected()) {
            this.m_cmbAsc.setSelectedItem(null);
            this.m_cmbAsc.setEnabled(false);
        } else {
            this.m_cmbAsc.setEnabled(this.m_verifier.canEditIndex(null));
        }
    }

    private void updateColExpr(IndexObject indexObject) {
        if (indexObject == null) {
            this.m_cmbColExpr.setSelectedItem("");
            this.m_lblColExpr.setEnabled(false);
            this.m_cmbColExpr.setEnabled(false);
            this.m_cmbAsc.setSelectedItem(null);
            this.m_lblAsc.setEnabled(false);
            this.m_cmbAsc.setEnabled(false);
        } else {
            this.m_cmbColExpr.setSelectedItem(indexObject.getExpression().getSQLText());
            this.m_cmbAsc.setSelectedItem(indexObject.getOrder());
            boolean bl = this.m_verifier == null || this.m_verifier.canEditIndex(null);
            this.m_lblColExpr.setEnabled(bl);
            this.m_cmbColExpr.setEnabled(bl);
            boolean bl2 = (this.m_verifier == null || this.m_verifier.canEditIndex(null)) && !this.m_rdbBitmap.isSelected();
            this.m_lblAsc.setEnabled(bl2);
            this.m_cmbAsc.setEnabled(bl2);
        }
    }

    private void updateSelColExpr(Object object) {
        if (object != null) {
            this.m_lstColExprs.setSelectedValue(object, true);
            this.updateColExpr((IndexObject)object);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = this.m_lstColExprs.getSelectedIndex();
        IndexObject indexObject = n != -1 ? (IndexObject)this.m_mdlColExprs.get(n) : null;
        SQLFragment sQLFragment = indexObject == null ? null : indexObject.getExpression();
        String string2 = string = sQLFragment == null ? null : sQLFragment.getSQLText();
        if (string != null) {
            bl = true;
            IndexObject indexObject2 = n > 0 ? (IndexObject)this.m_mdlColExprs.get(n - 1) : null;
            IndexObject indexObject3 = n < this.m_mdlColExprs.getSize() - 1 ? (IndexObject)this.m_mdlColExprs.get(n + 1) : null;
            bl2 = indexObject2 != null;
            bl3 = indexObject3 != null;
        }
        this.m_btnRemoveColExpr.setEnabled(this.m_index != null && this.m_verifier != null && bl && this.m_verifier.canEditIndex(this.m_index));
        this.m_btnAddColExpr.setEnabled(this.m_index != null && this.m_verifier != null && this.m_verifier.canEditIndex(this.m_index) && this.m_verifier.canAddIndexEntry(this.m_index));
        this.m_btnUpColExpr.setEnabled(this.m_index != null && this.m_verifier != null && bl2 && this.m_verifier.canEditIndex(this.m_index));
        this.m_btnDownColExpr.setEnabled(this.m_index != null && this.m_verifier != null && bl3 && this.m_verifier.canEditIndex(this.m_index));
    }

    public void populateName(Index index) {
        if (this.m_fldName != null) {
            if (index != null) {
                this.m_fldName.setText(this.m_prov.getExternalName(index.getName()));
            }
            boolean bl = this.m_isNewIndex || this.m_verifier == null || this.m_verifier.canRenameIndex(index);
            this.m_fldName.setEnabled(bl);
            this.m_fldName.setEditable(bl);
        }
    }

    public void populateIndexType(Index index) {
        if (index == null) {
            this.m_rdbNormal.setSelected(true);
            this.m_rdbNormal.setEnabled(false);
            this.m_rdbDomain.setEnabled(false);
        } else {
            this.m_rdbNormal.setSelected(Index.IndexType.NORMAL == index.getIndexType());
            this.m_lblIndexType.setEnabled(this.m_verifier != null && this.m_verifier.canEditDomain(null));
            this.m_rdbDomain.setSelected(Index.IndexType.DOMAIN == index.getIndexType());
            this.m_rdbNormal.setEnabled(this.m_verifier != null && this.m_verifier.canEditDomain(null));
            this.m_rdbDomain.setEnabled(this.m_verifier != null && this.m_verifier.canEditDomain(null));
        }
        this.switchIndexType();
    }

    public void populateUniqueness(Index index) {
        if (index == null) {
            this.m_rdbNonUnique.setSelected(true);
            this.m_rdbNonUnique.setEnabled(false);
            this.m_rdbUnique.setEnabled(false);
            this.m_rdbBitmap.setEnabled(false);
        } else {
            this.m_rdbNonUnique.setSelected(Index.IndexType.NORMAL == index.getIndexType());
            this.m_rdbUnique.setSelected(Index.IndexType.UNIQUE == index.getIndexType());
            this.m_rdbBitmap.setSelected(Index.IndexType.BITMAP == index.getIndexType());
            this.m_rdbNonUnique.setEnabled(this.m_verifier != null && this.m_verifier.canEditUniqueness(null));
            this.m_rdbUnique.setEnabled(this.m_verifier != null && this.m_verifier.canEditUniqueness(null));
            this.m_rdbBitmap.setEnabled(this.m_verifier != null && this.m_verifier.canEditUniqueness(null));
        }
    }

    public void populateColumns(Index index) {
        this.m_cmbCol.removeAllItems();
        if (this.m_table != null) {
            IndexObject[] indexObjectArray;
            Column[] columnArray = this.m_table.getColumns();
            int n = 0;
            while (n < columnArray.length) {
                this.m_cmbCol.addItem(columnArray[n].getName());
                ++n;
            }
            if (index != null && (indexObjectArray = index.getColumnExpressions()) != null && indexObjectArray.length > 0) {
                IndexObject indexObject = indexObjectArray[0];
                String string = indexObject.getExpression().getSQLText();
                this.m_cmbCol.setSelectedItem(string);
            }
        }
        boolean bl = this.m_index != null && (this.m_verifier == null || this.m_verifier.canEditIndex(null));
        this.m_lblCol.setEnabled(bl);
        this.m_cmbCol.setEnabled(bl);
    }

    public void populateDomain(Index index) {
        if (index != null) {
            DBObjectID dBObjectID = index != null ? index.getDomainIndextype() : null;
            Indextype indextype = null;
            if (dBObjectID != null) {
                if (dBObjectID instanceof NameBasedRefID) {
                    NameBasedRefID nameBasedRefID = (NameBasedRefID)dBObjectID;
                    indextype = new Indextype(nameBasedRefID.getName(), new Schema(nameBasedRefID.getSchemaName()));
                    indextype.setID((DBObjectID)nameBasedRefID);
                } else {
                    try {
                        indextype = (Indextype)dBObjectID.resolveID();
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                }
            }
            Schema schema = indextype != null ? indextype.getSchema() : (index == null ? null : index.getSchema());
            this.m_cmbIndextypeSchema.removeActionListener(this);
            this.m_cmbIndextypeSchema.init(this.m_prov, schema);
            this.m_cmbIndextypeSchema.addActionListener(this);
            try {
                schema = this.m_cmbIndextypeSchema.getSchema();
            }
            catch (TraversalException traversalException) {
                // empty catch block
            }
            if (schema != null) {
                Index index2;
                try {
                    this.m_cmbIndextype.removeAllItems();
                    Indextype indextype2 = null;
                    SchemaObject[] schemaObjectArray = this.m_prov.listObjects(INDEXTYPES, schema);
                    int n = 0;
                    while (n < schemaObjectArray.length) {
                        SchemaObject schemaObject = schemaObjectArray[n];
                        this.m_cmbIndextype.addItem(schemaObject);
                        if (indextype2 == null && indextype != null && indextype.getSchema().getName().equals(schemaObject.getSchema().getName()) && indextype.getName().equals(schemaObject.getName())) {
                            indextype2 = schemaObject;
                        }
                        ++n;
                    }
                    if (indextype != null) {
                        if (indextype2 == null) {
                            this.m_cmbIndextype.addItem(indextype);
                            indextype2 = indextype;
                        }
                        this.m_cmbIndextype.setSelectedItem(indextype2);
                        if (index != null) {
                            this.m_txtIndextypeParameters.setText(index.getDomainIndextypeParameters());
                        }
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                Index index3 = index2 = this.m_originalTable != null && index != null ? this.m_originalTable.getIndex(index.getName()) : null;
                if (index2 != null && this.m_prov instanceof Database) {
                    ResourceUtils.resLabel((JLabel)this.m_lblIndextypeStatus, (Component)this.m_txtIndextypeStatus, (String)UIArb.getString(278));
                    this.m_pnlIndextype.add((Component)this.m_lblIndextypeStatus, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
                    this.m_pnlIndextype.add((Component)this.m_txtIndextypeStatus, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
                    this.m_lblIndextypeStatus.setEnabled(true);
                    this.m_txtIndextypeStatus.setEnabled(true);
                    this.m_txtIndextypeStatus.setEditable(false);
                    this.m_txtIndextypeStatus.setText(index2.getDomainIndextypeOpStatus());
                }
            }
        }
    }

    public void populateParallel(int n) {
        if (n == 1) {
            this.m_rdbNoParallel.setSelected(true);
            this.m_lblParallelDegree.setEnabled(false);
            this.m_txtParallelDegree.setEnabled(false);
        } else {
            this.m_rdbParallel.setSelected(true);
            this.m_lblParallelDegree.setEnabled(true);
            this.m_txtParallelDegree.setEnabled(true);
            if (n > 0) {
                this.m_txtParallelDegree.setText(String.valueOf(n));
            }
        }
    }

    public void populateColumnExpressions(Index index) {
        this.m_cmbColExpr.setSelectedItem(null);
        this.m_cmbAsc.setSelectedIndex(0);
        this.m_mdlColExprs.removeAllElements();
        if (index != null) {
            IndexObject[] indexObjectArray = index.getColumnExpressions();
            int n = 0;
            while (n < indexObjectArray.length) {
                this.m_mdlColExprs.addElement(indexObjectArray[n]);
                ++n;
            }
            if (indexObjectArray != null && indexObjectArray.length > 0) {
                this.m_lstColExprs.setSelectedIndex(0);
                this.updateColExpr(indexObjectArray[0]);
            }
        }
    }

    private void updateListContents(Object object) {
        boolean bl = false;
        if (this.m_mdlColExprs == object) {
            bl = this.m_mdlColExprs.getSize() > 0;
            this.m_lstColExprs.setFocusable(bl);
            boolean bl2 = bl && (this.m_verifier == null || this.m_verifier.canEditIndex(null));
            this.m_lblColExpr.setEnabled(bl2);
            this.m_cmbColExpr.setEditable(bl2);
            this.m_cmbColExpr.setEnabled(bl2);
        }
        if (this.m_callbacks != null) {
            Boolean bl3 = this.m_index == null || bl;
            this.m_callbacks.wizardEnableButtons(Boolean.TRUE, bl3, bl3);
        }
    }

    private void swap(int n, int n2) {
        Object e = this.m_mdlColExprs.getElementAt(n);
        Object e2 = this.m_mdlColExprs.getElementAt(n2);
        this.m_mdlColExprs.setElementAt(e, n2);
        this.m_mdlColExprs.setElementAt(e2, n);
    }

    private void updateIndexName() {
        this.logActionStart(WH_EDIT_COLUMN_EXPRESSION, true);
        String string = (String)this.m_cmbColExpr.getSelectedItem();
        String string2 = (String)this.m_cmbAsc.getSelectedItem();
        int n = this.m_lstColExprs.getSelectedIndex();
        if (n >= 0) {
            SQLFragment sQLFragment = OracleIndexBuilder.createExpression((String)string, (Relation)this.m_table, (DBObjectProvider)this.m_prov);
            IndexObject indexObject = new IndexObject(sQLFragment, string2);
            this.m_mdlColExprs.setElementAt(indexObject, n);
        }
        this.m_lstColExprs.repaint();
        this.logActionEnd(WH_EDIT_COLUMN_EXPRESSION);
    }

    public void logActionStart(String string, boolean bl) {
        if (bl || this.m_whatsHappening.size() != 0) {
            // empty if block
        }
        this.m_whatsHappening.add(0, string);
    }

    public void logActionEnd(String string) {
        if (this.m_whatsHappening.size() == 0) {
            // empty if block
        }
        this.m_whatsHappening.remove(0);
    }

    public int logSize() {
        return this.m_whatsHappening.size();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_rdbNonUnique || object == this.m_rdbUnique || object == this.m_rdbBitmap) {
            this.switchUnique();
            this.saveIndexAttributes();
            this.updateButtons();
        } else if (object == this.m_rdbNormal || object == this.m_rdbDomain) {
            this.switchIndexType();
        } else if (object != this.m_cmbCol) {
            if (object == this.m_cmbAsc) {
                this.logActionStart(WH_SET_ASC_DESC, true);
                if (this.logSize() == 1) {
                    this.m_cmbColExpr.requestFocusInWindow();
                }
                this.updateIndexName();
                this.logActionEnd(WH_SET_ASC_DESC);
            } else if (object == this.m_btnAddColExpr) {
                this.logActionStart(WH_ADD_A_COLUMN_EXPRESSION, false);
                this.m_lstColExprs.clearSelection();
                if (this.m_lstColExprs.getSelectedValue() == null) {
                    String string = "";
                    Column[] columnArray = this.m_table.getColumns();
                    if (columnArray.length > 0) {
                        string = columnArray[0].getName();
                        Constraint[] constraintArray = this.m_table.getConstraints();
                        int n = 0;
                        while (n < constraintArray.length) {
                            if ("PKConstraint".equals(constraintArray[n].getConstraintType())) {
                                string = ((PKConstraint)constraintArray[n]).getColumns()[0].getName();
                                break;
                            }
                            if ("UniqueConstraint".equals(constraintArray[n].getConstraintType())) {
                                string = ((UniqueConstraint)constraintArray[n]).getColumns()[0].getName();
                            }
                            ++n;
                        }
                    }
                    String string2 = string;
                    SQLFragment sQLFragment = OracleIndexBuilder.createExpression((String)string2, (Relation)this.m_table, (DBObjectProvider)this.m_prov);
                    IndexObject indexObject = new IndexObject(sQLFragment);
                    this.m_mdlColExprs.addElement(indexObject);
                    this.m_lstColExprs.setSelectedIndex(this.m_mdlColExprs.size() - 1);
                    this.m_cmbColExpr.requestFocusInWindow();
                }
                this.saveIndexAttributes();
                this.updateButtons();
                this.logActionEnd(WH_ADD_A_COLUMN_EXPRESSION);
            } else if (object == this.m_btnRemoveColExpr) {
                this.logActionStart(WH_REMOVE_A_COLUMN_EXPRESSION, false);
                int n = this.m_lstColExprs.getSelectedIndex();
                if (n != -1) {
                    int n2 = n == this.m_mdlColExprs.size() - 1 ? n - 1 : n + 1;
                    this.m_lstColExprs.setSelectedIndex(n2);
                    this.m_mdlColExprs.removeElementAt(n);
                    if (n2 == -1) {
                        this.updateSelColExpr(null);
                        this.updateColExpr(null);
                    }
                }
                this.saveIndexAttributes();
                this.updateButtons();
                this.logActionEnd(WH_REMOVE_A_COLUMN_EXPRESSION);
            } else if (object == this.m_btnUpColExpr) {
                this.logActionStart(WH_MOVE_A_COLUMN_EXPRESSION_UP, false);
                int n = this.m_lstColExprs.getSelectedIndex();
                if (n > 0) {
                    this.swap(n--, n);
                    this.m_lstColExprs.setSelectedIndex(n);
                }
                this.logActionEnd(WH_MOVE_A_COLUMN_EXPRESSION_UP);
            } else if (object == this.m_btnDownColExpr) {
                this.logActionStart(WH_MOVE_A_COLUMN_EXPRESSION_DOWN, false);
                int n = this.m_lstColExprs.getSelectedIndex();
                if (n < this.m_mdlColExprs.getSize() - 1) {
                    this.swap(n++, n);
                    this.m_lstColExprs.setSelectedIndex(n);
                }
                this.logActionEnd(WH_MOVE_A_COLUMN_EXPRESSION_DOWN);
            } else if (object == this.m_mdlColExprs) {
                this.saveIndexAttributes();
                this.updateButtons();
            } else if (object == this.m_cmbIndextypeSchema) {
                this.m_cmbIndextype.removeAllItems();
                try {
                    Schema schema = this.m_cmbIndextypeSchema.getSchema();
                    SchemaObject[] schemaObjectArray = this.m_prov.listObjects(INDEXTYPES, schema);
                    int n = 0;
                    while (n < schemaObjectArray.length) {
                        SchemaObject schemaObject = schemaObjectArray[n];
                        this.m_cmbIndextype.addItem(schemaObject);
                        ++n;
                    }
                }
                catch (DBException dBException) {
                }
                catch (TraversalException traversalException) {}
            } else if (object == this.m_rdbNoParallel) {
                this.populateParallel(1);
            } else if (object == this.m_rdbParallel) {
                String string = this.m_txtParallelDegree.getSelectedText();
                this.populateParallel(ModelUtil.hasLength((String)string) ? Integer.decode(string) : 0);
            }
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateListContents(listDataEvent.getSource());
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateListContents(listDataEvent.getSource());
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateListContents(listDataEvent.getSource());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateIndexName();
    }

    static String ra$WH_CHANGE_COLEXPR_SELECTION() {
        return WH_CHANGE_COLEXPR_SELECTION;
    }

    static JList ra$m_lstColExprs(IndexEditorPanel indexEditorPanel) {
        return indexEditorPanel.m_lstColExprs;
    }

    static void mav$updateSelColExpr(IndexEditorPanel indexEditorPanel, Object object) {
        indexEditorPanel.updateSelColExpr(object);
    }

    final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            IndexEditorPanel.this.logActionStart(IndexEditorPanel.ra$WH_CHANGE_COLEXPR_SELECTION(), true);
            IndexEditorPanel.mav$updateSelColExpr(IndexEditorPanel.this, IndexEditorPanel.ra$m_lstColExprs(IndexEditorPanel.this).getSelectedValue());
            IndexEditorPanel.this.logActionEnd(IndexEditorPanel.ra$WH_CHANGE_COLEXPR_SELECTION());
        }
    }

    private static class NumberField
    extends NumberTextField {
        public NumberField() {
            this.setDataType(Integer.class);
            this.setSigned(false);
        }

        protected String convertNumberToString(Number number) {
            return number.toString();
        }

        protected boolean validateNumber(Number number) {
            return number == null || number.intValue() > 0;
        }
    }
}

