/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.JComboCardPanel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.StorageInfoPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;

public class IOTInfoPanel
extends BaseInfoPanel
implements ActionListener {
    private DBObjectRenderer m_rend;
    private JLabel m_incColLabel;
    private JComboBox m_incColComboBox;
    private JCheckBox m_keyCompCheckBox;
    private NumberTextField m_keyCompField;
    private JLabel m_pctLabel;
    private NumberTextField m_pctField;
    private JCheckBox m_mappingCheckBox;
    private JCheckBox m_overflowCheckBox;
    private StorageInfoPanel m_overflowPropsPanel;

    private void $init$() {
        this.m_rend = new DBObjectRenderer();
        this.m_incColLabel = new JLabel();
        this.m_incColComboBox = new JComboBox();
        this.m_keyCompCheckBox = new JCheckBox();
        this.m_keyCompField = new NumberTextField();
        this.m_pctLabel = new JLabel();
        this.m_pctField = new NumberTextField();
        this.m_mappingCheckBox = new JCheckBox();
        this.m_overflowCheckBox = new JCheckBox();
        this.m_overflowPropsPanel = new StorageInfoPanel();
    }

    public IOTInfoPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.m_incColComboBox.setRenderer(this.m_rend);
        this.m_keyCompField.setDecimal(false);
        this.m_keyCompField.setSigned(false);
        this.m_overflowPropsPanel.setTopLabelText(null);
        this.m_overflowCheckBox.addActionListener(this);
        this.m_keyCompCheckBox.addActionListener(this);
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_incColLabel, (Component)this.m_incColComboBox, (String)UIArb.getString(330));
        DBObjectRenderer.setToolTipText(this.m_incColLabel, UIArb.getString(331));
        ResourceUtils.resButton((AbstractButton)this.m_keyCompCheckBox, (String)UIArb.getString(333));
        ResourceUtils.resButton((AbstractButton)this.m_overflowCheckBox, (String)UIArb.getString(335));
        ResourceUtils.resButton((AbstractButton)this.m_mappingCheckBox, (String)UIArb.getString(334));
        ResourceUtils.resLabel((JLabel)this.m_pctLabel, (Component)this.m_pctField, (String)UIArb.getString(332));
        int n = 0;
        int n2 = 0;
        this.add(this.m_keyCompCheckBox, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_keyCompField, new GridBagConstraints(n++, n2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_pctLabel, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_pctField, new GridBagConstraints(n++, n2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 20), 0, 0));
        this.add(this.m_mappingCheckBox, new GridBagConstraints(n++, n2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.m_incColLabel, new GridBagConstraints(0, ++n2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_incColComboBox, new GridBagConstraints(1, n2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 5), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, n2, 1, 1, 1.0, 0.0, 17, 21, new Insets(0, 10, 0, 0), 0, 0));
        jPanel2.add((Component)((Object)this.m_overflowPropsPanel), new GridBagConstraints(0, ++n2, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 0, 0), 0, 0));
        JComboCardPanel jComboCardPanel = new JComboCardPanel(new JLabel(), (JComponent)this.m_overflowCheckBox);
        jComboCardPanel.showSubPanel((JComponent)jPanel2);
        this.add((Component)jComboCardPanel, new GridBagConstraints(0, ++n2, 0, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        Table table = (Table)traversableContext.get("NewObject");
        Table table2 = (Table)traversableContext.get("OriginalObject");
        StorageInfoVerifier storageInfoVerifier = (StorageInfoVerifier)traversableContext.find("StorageInfoVerifier");
        String[] stringArray = this.getTablespaces(traversableContext, dBObjectProvider);
        OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties = (OracleIndexOrganizedTableProperties)table.getProperty("OracleIndexOrganizedTableProperties");
        this.init(dBObjectProvider, table, oracleIndexOrganizedTableProperties, storageInfoVerifier, stringArray, table2 != null);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        Table table = (Table)traversableContext.get("NewObject");
        OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties = (OracleIndexOrganizedTableProperties)table.getProperty("OracleIndexOrganizedTableProperties");
        if (oracleIndexOrganizedTableProperties == null) {
            oracleIndexOrganizedTableProperties = new OracleIndexOrganizedTableProperties();
            table.setProperty("OracleIndexOrganizedTableProperties", (Object)oracleIndexOrganizedTableProperties);
        }
        this.commit(dBObjectProvider, table, oracleIndexOrganizedTableProperties);
    }

    private void init(DBObjectProvider dBObjectProvider, Table table, OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties, StorageInfoVerifier storageInfoVerifier, String[] stringArray, boolean bl) {
        this.initDynamicControls(table);
        this.m_overflowPropsPanel.init(dBObjectProvider, oracleIndexOrganizedTableProperties == null ? null : oracleIndexOrganizedTableProperties.getOverflowProperties(), storageInfoVerifier, stringArray);
        if (oracleIndexOrganizedTableProperties != null) {
            this.m_mappingCheckBox.setSelected(oracleIndexOrganizedTableProperties.isMapped());
            this.m_pctField.setNumber((Number)oracleIndexOrganizedTableProperties.getPctThreshold());
            Integer n = oracleIndexOrganizedTableProperties.getKeyCompression();
            this.m_keyCompCheckBox.setSelected(n != null);
            this.m_keyCompCheckBox.setEnabled(true);
            this.m_keyCompField.setNumber(n == null || n == 0 ? null : n);
            this.m_keyCompField.setEnabled(n != null);
            DBObjectID dBObjectID = oracleIndexOrganizedTableProperties.getIncludeColumn();
            if (dBObjectID != null) {
                try {
                    Column column = (Column)dBObjectID.resolveID();
                    if (column != null) {
                        this.m_incColComboBox.setSelectedItem(column);
                        if (bl && dBObjectProvider instanceof Database) {
                            this.m_incColComboBox.removeItem(" ");
                        }
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            if (oracleIndexOrganizedTableProperties.isOverflowable()) {
                this.m_overflowCheckBox.setSelected(true);
                this.overflowEnable(true);
                if (bl && dBObjectProvider instanceof Database) {
                    this.m_overflowCheckBox.setEnabled(false);
                }
            } else {
                this.m_overflowCheckBox.setSelected(false);
                this.overflowEnable(false);
            }
        } else {
            this.m_keyCompCheckBox.setSelected(false);
            this.m_keyCompCheckBox.setEnabled(true);
            this.m_keyCompField.setEnabled(false);
            this.m_overflowCheckBox.setSelected(true);
            this.overflowEnable(true);
        }
    }

    private void commit(DBObjectProvider dBObjectProvider, Table table, OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties) throws TraversalException {
        Object object = this.m_incColComboBox.getSelectedItem();
        if (object instanceof Column) {
            DBObjectID dBObjectID = ((Column)object).getID();
            if (dBObjectID == null) {
                dBObjectID = TemporaryObjectID.createID((DBObject)((Column)object));
                ((Column)object).setID(dBObjectID);
            }
            oracleIndexOrganizedTableProperties.setIncludeColumn(dBObjectID);
        } else {
            oracleIndexOrganizedTableProperties.setIncludeColumn(null);
        }
        oracleIndexOrganizedTableProperties.setMapped(this.m_mappingCheckBox.isSelected());
        if (this.m_keyCompCheckBox.isSelected()) {
            Number number = this.m_keyCompField.getNumber();
            if (number == null) {
                number = 0;
                PKConstraint pKConstraint = this.getPK(table);
                if (pKConstraint != null) {
                    number = pKConstraint.getColumns().length - 1;
                }
            }
            oracleIndexOrganizedTableProperties.setKeyCompression(Integer.valueOf(number.intValue()));
        } else {
            oracleIndexOrganizedTableProperties.setKeyCompression(null);
        }
        Number number = this.m_pctField.getNumber();
        oracleIndexOrganizedTableProperties.setPctThreshold(number == null ? null : new Integer(number.intValue()));
        oracleIndexOrganizedTableProperties.setOverflowable(this.m_overflowCheckBox.isSelected());
        OracleStorageProperties oracleStorageProperties = oracleIndexOrganizedTableProperties.getOverflowProperties();
        if (oracleStorageProperties == null && this.m_overflowCheckBox.isSelected()) {
            oracleStorageProperties = new OracleStorageProperties();
            oracleIndexOrganizedTableProperties.setOverflowProperties(oracleStorageProperties);
        }
        if (oracleStorageProperties != null) {
            this.m_overflowPropsPanel.commit(oracleStorageProperties, true);
        }
        try {
            oracleIndexOrganizedTableProperties.validate(table);
        }
        catch (ValidationException validationException) {
            throw new TraversalException(validationException.getMessage(), validationException.getTitle());
        }
    }

    private void initDynamicControls(Table table) {
        ArrayList<Column> arrayList = new ArrayList<Column>(Arrays.asList(table.getColumns()));
        boolean bl = false;
        Constraint[] constraintArray = table.getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            Constraint constraint = constraintArray[n];
            if (constraint instanceof PKConstraint) {
                List<Column> list = Arrays.asList(((PKConstraint)constraint).getColumns());
                bl = list.size() > 1;
                Iterator<Column> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Column column = iterator.next();
                    if (!iterator.hasNext()) continue;
                    arrayList.remove(column);
                }
                break;
            }
            ++n;
        }
        this.m_incColComboBox.removeAllItems();
        this.m_incColComboBox.addItem(" ");
        for (Column column : arrayList) {
            this.m_incColComboBox.addItem(column);
        }
        this.m_keyCompCheckBox.setSelected(bl);
        this.m_keyCompCheckBox.setEnabled(bl);
        this.m_keyCompField.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_overflowCheckBox) {
            this.overflowEnable(this.m_overflowCheckBox.isSelected());
        } else if (object == this.m_keyCompCheckBox) {
            this.m_keyCompField.setEnabled(this.m_keyCompCheckBox.isSelected());
        }
    }

    private void overflowEnable(boolean bl) {
        this.m_overflowPropsPanel.enableAllComponents(bl, true);
        this.m_incColLabel.setEnabled(bl);
        this.m_incColComboBox.setEnabled(bl);
        if (!bl) {
            // empty if block
        }
    }

    private PKConstraint getPK(Table table) {
        if (table != null) {
            Constraint[] constraintArray = table.getConstraints();
            int n = 0;
            while (n < constraintArray.length) {
                Constraint constraint = constraintArray[n];
                if (constraint instanceof PKConstraint) {
                    return (PKConstraint)constraint;
                }
                ++n;
            }
        }
        return null;
    }
}

