/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import oracle.ide.Ide;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.table.BaseConstraintPanel;
import oracle.ide.db.panels.table.ConstraintPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;

public class FKPanel
extends JPanel
implements ActionListener,
ConstraintPanel {
    private static final String[] ON_DELETE_LABELS = new String[]{"RESTRICT", "CASCADE", "SET NULL"};
    private GridBagLayout layMain;
    private JLabel lblRefSchema;
    private JLabel lblRefTable;
    private JLabel lblRefCon;
    private JComboBox cmbRefSchema;
    private JComboBox cmbRefTable;
    private JComboBox cmbRefCon;
    protected JPanel pnlColumns;
    private GridBagLayout layColumns;
    private JLabel lblColAssoc;
    private JScrollPane scrColumns;
    private JTable tblColumns;
    private JLabel lblDelete;
    private JComboBox cmbDelete;
    private JPanel pnlRef;
    private DBObjectRenderer renderer;
    private TableColumn colLocal;
    private TableColumn colRef;
    private DefaultTableColumnModel mdlCols;
    private DefaultListSelectionModel mdlSel;
    private DefaultComboBoxModel mdlTblCols;
    private JComboBox cmbTblCols;
    private DefaultCellEditor edTblCols;
    private NonNullableComboBoxModel mdlDelete;
    private ColumnsModel mdlColumns;
    private JCheckBox chkEnabled;
    private GridBagLayout gridBagLayout1;
    private JLabel lblName;
    private JTextField fldName;
    private HashMap _tableMap;
    private HashMap _conMap;
    protected DBObjectProvider _prov;
    private boolean _modifiable;
    private Schema _currSchema;
    private Table _table;
    private String _currTableName;
    protected FKConstraint _con;
    private Constraint[] _otherCons;
    private ConstraintsInfoVerifier _verifier;
    private HashMap m_loadingSchemas;
    private HashMap m_loadingTables;

    private void $init$() {
        this.layMain = new GridBagLayout();
        this.lblRefSchema = new JLabel();
        this.lblRefTable = new JLabel();
        this.lblRefCon = new JLabel();
        this.cmbRefSchema = new JComboBox();
        this.cmbRefTable = new JComboBox();
        this.cmbRefCon = new JComboBox();
        this.pnlColumns = new JPanel();
        this.layColumns = new GridBagLayout();
        this.lblColAssoc = new JLabel();
        this.scrColumns = new JScrollPane();
        this.tblColumns = new JTable();
        this.lblDelete = new JLabel();
        this.cmbDelete = new JComboBox();
        this.pnlRef = new JPanel();
        this.renderer = new DBObjectRenderer();
        this.colLocal = new TableColumn(0);
        this.colRef = new TableColumn(1);
        this.mdlCols = new DefaultTableColumnModel();
        this.mdlSel = new DefaultListSelectionModel();
        this.cmbTblCols = new JComboBox();
        this.edTblCols = new DefaultCellEditor(this.cmbTblCols);
        this.mdlDelete = new NonNullableComboBoxModel((Object[])ON_DELETE_LABELS);
        this.mdlColumns = new ColumnsModel();
        this.chkEnabled = new JCheckBox();
        this.gridBagLayout1 = new GridBagLayout();
        this.lblName = new JLabel();
        this.fldName = new JTextField();
        this._tableMap = new HashMap();
        this._conMap = new HashMap();
        this.m_loadingSchemas = new HashMap();
        this.m_loadingTables = new HashMap();
    }

    public FKPanel() {
        this.$init$();
        try {
            this.jbInit();
            this._updateEnabledState(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layMain);
        ResourceUtils.resLabel((JLabel)this.lblRefSchema, (Component)this.cmbRefSchema, (String)UIArb.getString(491));
        ResourceUtils.resLabel((JLabel)this.lblRefTable, (Component)this.cmbRefTable, (String)UIArb.getString(492));
        ResourceUtils.resLabel((JLabel)this.lblRefCon, (Component)this.cmbRefCon, (String)UIArb.getString(493));
        this.cmbRefSchema.addActionListener(this);
        this.cmbRefTable.addActionListener(this);
        this.cmbRefCon.addActionListener(this);
        this.cmbRefSchema.setRenderer(this.renderer);
        this.cmbRefCon.setRenderer(this.renderer);
        this.cmbTblCols.setRenderer(this.renderer);
        ResourceUtils.resButton((AbstractButton)this.chkEnabled, (String)UIArb.getString(483));
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.fldName, (String)UIArb.getString(73));
        this.renderer.setNullLabel(UIArb.getString(32));
        ResourceUtils.resLabel((JLabel)this.lblColAssoc, (Component)this.tblColumns, (String)UIArb.getString(494));
        this.pnlColumns.setLayout(this.layColumns);
        this.colLocal.setHeaderValue(UIArb.getString(495));
        this.colLocal.setCellEditor(this.edTblCols);
        this.colLocal.setCellRenderer(this.renderer);
        this._setColRefTableName(null);
        this.colRef.setCellRenderer(this.renderer);
        this.pnlRef.setLayout(this.gridBagLayout1);
        this.mdlCols.addColumn(this.colLocal);
        this.mdlCols.addColumn(this.colRef);
        ResourceUtils.resLabel((JLabel)this.lblDelete, (Component)this.cmbDelete, (String)UIArb.getString(498));
        this.cmbDelete.setModel(this.mdlDelete);
        this.tblColumns.setModel(this.mdlColumns);
        this.tblColumns.setColumnModel(this.mdlCols);
        this.scrColumns.getViewport().add((Component)this.tblColumns, null);
        this.pnlColumns.add((Component)this.lblColAssoc, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlColumns.add((Component)this.scrColumns, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlColumns.add((Component)this.lblDelete, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlColumns.add((Component)this.cmbDelete, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.add((Component)this.pnlColumns, new GridBagConstraints(0, 30, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlRef.add((Component)this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 12), 0, 0));
        this.pnlRef.add((Component)this.fldName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.pnlRef.add((Component)this.chkEnabled, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 5, 0), 0, 0));
        this.pnlRef.add((Component)this.lblRefSchema, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.pnlRef.add((Component)this.cmbRefSchema, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlRef.add((Component)this.lblRefTable, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.pnlRef.add((Component)this.cmbRefTable, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.pnlRef.add((Component)this.lblRefCon, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.pnlRef.add((Component)this.cmbRefCon, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlRef, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void init(Namespace namespace) throws TraversalException {
        this._prov = (DBObjectProvider)namespace.find("DBObjectProvider");
        this._table = (Table)namespace.find("NewObject");
        this._con = (FKConstraint)namespace.find("Con");
        this._modifiable = (Boolean)namespace.find("Modifiable");
        this._otherCons = (Constraint[])namespace.find("otherCons");
        this._verifier = (ConstraintsInfoVerifier)namespace.find("ConstraintsInfoVerifier");
        if (this.isPukkaConstraint()) {
            Schema schema = this._table.getSchema();
            String string = this._table.getName();
            if (ModelUtil.areDifferent((Object)string, (Object)this._currTableName) || ModelUtil.areDifferent((Object)schema, (Object)this._currSchema)) {
                this._tableMap.remove(schema);
                String string2 = this._currSchema + "." + this._currTableName;
                this._conMap.remove(string2);
            }
            this._currSchema = schema;
            this._currTableName = string;
            this.renderer.setNullLabel(UIArb.getString(32));
        } else {
            this._currSchema = new Schema();
            this._currTableName = null;
            this.renderer.setNullLabel("");
        }
        String string = this._currSchema + "." + this._currTableName;
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel();
        Constraint[] constraintArray = this._table.getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            if ("PKConstraint".equals(constraintArray[n].getConstraintType()) || "UniqueConstraint".equals(constraintArray[n].getConstraintType())) {
                nonNullableComboBoxModel.addElement(constraintArray[n]);
            }
            ++n;
        }
        this._conMap.put(string, nonNullableComboBoxModel);
        this._updateEnabledState(this._modifiable && this.isPukkaConstraint());
        Object[] objectArray = this._table.getColumns();
        this.mdlTblCols = new NonNullableComboBoxModel(objectArray);
        this.cmbTblCols.setModel(this.mdlTblCols);
        Object[] objectArray2 = (Schema[])namespace.find("SchemaList");
        objectArray2 = (Schema[])FKPanel.insert(this._currSchema, objectArray2);
        this.cmbRefSchema.setModel(new NonNullableComboBoxModel(objectArray2));
        this._initConstraint();
    }

    protected boolean isPukkaConstraint() {
        DBObjectID dBObjectID;
        boolean bl;
        boolean bl2 = bl = this._con != null;
        if (bl && (dBObjectID = this._con.getReferenceID()) != null) {
            try {
                DBObject dBObject = dBObjectID.resolveID();
                bl = dBObject != null;
            }
            catch (DBException dBException) {
                bl = false;
            }
        }
        return bl;
    }

    private void _initConstraint() throws TraversalException {
        UniqueConstraint uniqueConstraint;
        String string = "";
        boolean bl = false;
        DBObject dBObject = null;
        Column[] columnArray = new Column[]{};
        int n = 0;
        if (this._con != null) {
            string = this._prov.getExternalName(this._con.getName());
        }
        if (this.isPukkaConstraint()) {
            bl = this._con.isEnabled();
            try {
                DBObjectID dBObjectID = this._con.getReferenceID();
                if (dBObjectID != null) {
                    dBObject = dBObjectID.resolveID();
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
            columnArray = this._con.getColumns();
            n = this._con.getDeleteMode();
        }
        this.fldName.setText(string);
        this.chkEnabled.setSelected(bl);
        this.mdlDelete.setSelectedItem((Object)ON_DELETE_LABELS[n]);
        Schema schema = null;
        String string2 = null;
        String string3 = null;
        UniqueConstraint uniqueConstraint2 = uniqueConstraint = dBObject instanceof UniqueConstraint ? (UniqueConstraint)dBObject : null;
        if (uniqueConstraint != null) {
            Relation relation = uniqueConstraint.getRelation();
            schema = relation.getSchema();
            string2 = relation.getName();
            string3 = uniqueConstraint.getName();
        }
        Schema schema2 = schema != null ? schema : this._currSchema;
        this.cmbRefSchema.setSelectedItem(schema2);
        if (schema2 != null && this.m_loadingSchemas.containsKey(schema2.getName())) {
            throw new TraversalException(null);
        }
        if (string2 != null) {
            this.cmbRefTable.setSelectedItem(string2);
        } else {
            this._setColRefTableName((String)this.cmbRefTable.getSelectedItem());
        }
        if (string3 != null) {
            this._selectConstraint(string3);
        }
        int n2 = 0;
        while (n2 < columnArray.length) {
            this.mdlColumns.setValueAt(columnArray[n2], n2, 0);
            ++n2;
        }
    }

    public void commit() throws TraversalException {
        if (this.isPukkaConstraint()) {
            String string = null;
            DBObjectID dBObjectID = this._con.getReferenceID();
            if (dBObjectID != null) {
                try {
                    Relation relation;
                    DBObject dBObject = dBObjectID.resolveID();
                    if (dBObject instanceof UniqueConstraint && (relation = ((UniqueConstraint)dBObject).getRelation()) != null) {
                        string = relation.getName();
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            String string2 = this.fldName.getText();
            UniqueConstraint uniqueConstraint = (UniqueConstraint)this.cmbRefCon.getSelectedItem();
            if (uniqueConstraint == null) {
                if (string == null) {
                    string = this._currTableName;
                }
                if (string2.startsWith(BaseConstraintPanel.getDefaultFKBaseName(this._currTableName, string))) {
                    string2 = BaseConstraintPanel.findUniqueName((Relation)this._table, (Constraint)this._con, this._otherCons);
                }
                this._con.setReferenceID(null);
            } else {
                String string3;
                Relation relation = uniqueConstraint.getRelation();
                String string4 = string3 = relation != null ? relation.getName() : this._currTableName;
                if (ModelUtil.areDifferent((Object)string, (Object)string3) && string2.startsWith(BaseConstraintPanel.getDefaultFKBaseName(this._currTableName, string))) {
                    string2 = BaseConstraintPanel.findUniqueName(BaseConstraintPanel.getDefaultFKBaseName(this._currTableName, string3), (Constraint)this._con, this._otherCons);
                }
                this._con.setReferenceID(uniqueConstraint.getID());
            }
            if (this._verifier != null) {
                this._verifier.verifyName(string2);
            }
            this._con.setName(this._prov.getInternalName(string2));
            this.fldName.setText(string2);
            this._con.setEnabled(this.chkEnabled.isSelected());
            Column[] columnArray = this.mdlColumns.getTableColumns();
            this._con.setColumns(columnArray);
            this._con.setDeleteMode(this.cmbDelete.getSelectedIndex());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cmbRefSchema) {
            this._updateSelectedSchema((Schema)this.cmbRefSchema.getSelectedItem());
        } else if (object == this.cmbRefTable) {
            this._updateSelectedTable((String)this.cmbRefTable.getSelectedItem());
        } else if (object == this.cmbRefCon) {
            UniqueConstraint uniqueConstraint = (UniqueConstraint)this.cmbRefCon.getSelectedItem();
            this.mdlColumns.init(this.mdlTblCols, uniqueConstraint);
        }
    }

    private void _updateSelectedSchema(Schema schema) {
        if (schema != null) {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this._tableMap.get(schema);
            if (defaultComboBoxModel == null) {
                if (schema.getName() == null) {
                    defaultComboBoxModel = new NonNullableComboBoxModel();
                    this._tableMap.put(schema, defaultComboBoxModel);
                } else {
                    this.loadTables(schema);
                    defaultComboBoxModel = (DefaultComboBoxModel)this._tableMap.get(schema);
                    if (defaultComboBoxModel == null) {
                        defaultComboBoxModel = new NonNullableComboBoxModel();
                    }
                }
            }
            this.cmbRefTable.setModel(defaultComboBoxModel);
            this.cmbRefTable.setSelectedIndex(defaultComboBoxModel.getSize() > 0 ? 0 : -1);
        }
    }

    private void _updateSelectedTable(String string) {
        Schema schema = (Schema)this.cmbRefSchema.getSelectedItem();
        String string2 = string == null ? "" : schema + "." + string;
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this._conMap.get(string2);
        if (defaultComboBoxModel == null) {
            Table table = null;
            if (string != null) {
                try {
                    table = (Table)this._prov.getObject("TABLE", schema, string);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            if (table != null) {
                this.loadConstraints(table, string2);
                defaultComboBoxModel = (DefaultComboBoxModel)this._conMap.get(string2);
            }
            if (defaultComboBoxModel == null) {
                defaultComboBoxModel = new NonNullableComboBoxModel();
            }
        }
        this.cmbRefCon.setModel(defaultComboBoxModel);
        this.cmbRefCon.setSelectedIndex(defaultComboBoxModel.getSize() > 0 ? 0 : -1);
        this._setColRefTableName(string);
    }

    private void _setColRefTableName(String string) {
        String string2 = string != null ? UIArb.format(497, string) : UIArb.getString(496);
        this.colRef.setHeaderValue(string2);
        this.repaint();
    }

    private void _selectConstraint(String string) {
        if (string != null) {
            int n = this.cmbRefCon.getItemCount() - 1;
            while (n >= 0) {
                UniqueConstraint uniqueConstraint = (UniqueConstraint)this.cmbRefCon.getItemAt(n);
                if (string.equals(uniqueConstraint.getName())) {
                    this.cmbRefCon.setSelectedIndex(n);
                    break;
                }
                --n;
            }
        }
    }

    private void _updateEnabledState(boolean bl) {
        this.fldName.setEnabled(bl);
        this.chkEnabled.setEnabled(bl);
        this.cmbRefSchema.setEnabled(bl);
        this.cmbRefTable.setEnabled(bl);
        this.cmbRefCon.setEnabled(bl);
        this.cmbDelete.setEnabled(bl);
    }

    private void loadTables(Schema schema) {
        if (!this.m_loadingSchemas.containsKey(schema.getName())) {
            TableLoader tableLoader = new TableLoader(schema);
            this.m_loadingSchemas.put(schema.getName(), tableLoader);
            tableLoader.execute();
        } else {
            TableLoader tableLoader = (TableLoader)this.m_loadingSchemas.get(schema.getName());
            if (tableLoader != null) {
                tableLoader.execute();
            }
        }
    }

    private void loadConstraints(Table table, String string) {
        if (!this.m_loadingTables.containsKey(string)) {
            ConstraintLoader constraintLoader = new ConstraintLoader(table, string);
            this.m_loadingTables.put(string, constraintLoader);
            constraintLoader.execute();
        } else {
            ConstraintLoader constraintLoader = (ConstraintLoader)this.m_loadingTables.get(string);
            if (constraintLoader != null) {
                constraintLoader.execute();
            }
        }
    }

    private static Object[] insert(Object object, Object[] objectArray) {
        Arrays.sort(objectArray);
        int n = Arrays.binarySearch(objectArray, object);
        if (n < 0) {
            int n2 = -(n + 1);
            int n3 = objectArray.length + 1;
            Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n3);
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
            objectArray2[n2] = object;
            System.arraycopy(objectArray, n2, objectArray2, n2 + 1, objectArray.length - n2);
            objectArray = objectArray2;
        }
        return objectArray;
    }

    static boolean ra$_modifiable(FKPanel fKPanel) {
        return fKPanel._modifiable;
    }

    static HashMap ra$m_loadingSchemas(FKPanel fKPanel) {
        return fKPanel.m_loadingSchemas;
    }

    static Schema ra$_currSchema(FKPanel fKPanel) {
        return fKPanel._currSchema;
    }

    static String ra$_currTableName(FKPanel fKPanel) {
        return fKPanel._currTableName;
    }

    static Object[] maS$insert(Object object, Object[] objectArray) {
        return FKPanel.insert(object, objectArray);
    }

    static HashMap ra$_tableMap(FKPanel fKPanel) {
        return fKPanel._tableMap;
    }

    static HashMap ra$m_loadingTables(FKPanel fKPanel) {
        return fKPanel.m_loadingTables;
    }

    static HashMap ra$_conMap(FKPanel fKPanel) {
        return fKPanel._conMap;
    }

    private class ColumnsModel
    extends AbstractTableModel {
        private Column[] _cols;
        private Column[] _refCols;
        private UniqueConstraint _con;

        private void $init$() {
            this._cols = new Column[0];
            this._refCols = new Column[0];
        }

        public ColumnsModel() {
            this.$init$();
        }

        public void init(DefaultComboBoxModel defaultComboBoxModel, UniqueConstraint uniqueConstraint) {
            this._refCols = uniqueConstraint != null ? uniqueConstraint.getColumns() : new Column[]{};
            this._cols = new Column[this._refCols.length];
            Column column = (Column)defaultComboBoxModel.getElementAt(0);
            int n = 0;
            while (n < this._refCols.length) {
                this._cols[n] = column;
                ++n;
            }
            this.fireTableDataChanged();
        }

        public Column[] getTableColumns() {
            return this._cols;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this._cols[n];
                }
                case 1: {
                    return this._refCols[n];
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0 && n < this._cols.length) {
                this._cols[n] = (Column)object;
                this.fireTableCellUpdated(n, n2);
            }
        }

        public int getRowCount() {
            return this._cols.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public boolean isCellEditable(int n, int n2) {
            return FKPanel.ra$_modifiable(FKPanel.this) && n2 == 0;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return UIArb.getString(495);
                }
                case 1: {
                    return UIArb.getString(496);
                }
            }
            return null;
        }

        public Class getColumnClass(int n) {
            return Column.class;
        }
    }

    private class TableLoader
    implements Runnable {
        private Schema m_schema;
        private ProgressBar m_bar;

        public TableLoader() {
        }

        public TableLoader(Schema schema) {
            this.m_schema = schema;
        }

        public void execute() {
            if (FKPanel.this._prov instanceof Database) {
                this.m_bar = new ProgressBar((Component)Ide.getMainWindow(), UIArb.getString(184), (Runnable)this, true);
                this.m_bar.start(UIArb.getString(185), this.m_schema.getName());
            } else {
                this.m_bar = null;
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProgressBar progressBar = this.m_bar;
            TableLoader tableLoader = this;
            synchronized (tableLoader) {
                if (FKPanel.ra$m_loadingSchemas(FKPanel.this).containsKey(this.m_schema.getName())) {
                    try {
                        Object[] objectArray = FKPanel.this._prov.listObjects("TABLE", this.m_schema);
                        if (ModelUtil.areEqual((Object)this.m_schema, (Object)FKPanel.ra$_currSchema(FKPanel.this))) {
                            objectArray = (String[])FKPanel.maS$insert(FKPanel.ra$_currTableName(FKPanel.this), objectArray);
                        }
                        FKPanel.ra$_tableMap(FKPanel.this).put(this.m_schema, new NonNullableComboBoxModel(objectArray));
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                    FKPanel.ra$m_loadingSchemas(FKPanel.this).remove(this.m_schema.getName());
                }
                if (progressBar != null) {
                    progressBar.setDoneStatus();
                }
            }
        }
    }

    private class ConstraintLoader
    implements Runnable {
        private String m_key;
        private Table m_table;
        private ProgressBar m_bar;

        public ConstraintLoader() {
        }

        public ConstraintLoader(Table table, String string) {
            this.m_table = table;
            this.m_key = string;
        }

        public void execute() {
            if (FKPanel.this._prov instanceof Database) {
                this.m_bar = new ProgressBar((Component)Ide.getMainWindow(), UIArb.getString(184), (Runnable)this, true);
                this.m_bar.start(UIArb.getString(185), this.m_key);
            } else {
                this.m_bar = null;
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProgressBar progressBar = this.m_bar;
            ConstraintLoader constraintLoader = this;
            synchronized (constraintLoader) {
                if (FKPanel.ra$m_loadingTables(FKPanel.this).containsKey(this.m_key)) {
                    Constraint[] constraintArray = this.m_table.getConstraints();
                    NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel();
                    int n = 0;
                    while (n < constraintArray.length) {
                        String string = constraintArray[n].getConstraintType();
                        if ("UniqueConstraint".equals(string) || "PKConstraint".equals(string)) {
                            nonNullableComboBoxModel.addElement(constraintArray[n]);
                        }
                        ++n;
                    }
                    FKPanel.ra$_conMap(FKPanel.this).put(this.m_key, nonNullableComboBoxModel);
                    FKPanel.ra$m_loadingTables(FKPanel.this).remove(this.m_key);
                }
                if (progressBar != null) {
                    progressBar.setDoneStatus();
                }
            }
        }
    }
}

