/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.ide.db.DBIcons;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.ora.NameBasedRefID;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalTablePropPanel
extends BaseInfoPanel
implements ListSelectionListener,
ActionListener {
    private DBObjectRenderer m_rend;
    private boolean m_editing;
    private List<Directory> m_dirs;
    private boolean m_popDirs;
    private JLabel m_driverLabel;
    private JComboBox m_driverComboBox;
    private JLabel m_defDirLabel;
    private JComboBox m_defDirComboBox;
    private JLabel m_projColLabel;
    private JComboBox m_projColComboBox;
    private JLabel m_rejectLabel;
    private JTextField m_rejectField;
    private JCheckBox m_usingClobCheckBox;
    private JLabel m_accessLabel;
    private JTextArea m_accessText;
    private JLabel m_locLabel;
    private LocationTableModel m_locTableModel;
    private JTable m_locTable;
    private JButton m_addLocButton;
    private JButton m_delLocButton;
    private static final Schema SCHEMA_SYS = new Schema("SYS");

    private void $init$() {
        this.m_rend = new DBObjectRenderer();
        this.m_driverLabel = new JLabel();
        this.m_driverComboBox = new JComboBox();
        this.m_defDirLabel = new JLabel();
        this.m_defDirComboBox = new JComboBox();
        this.m_projColLabel = new JLabel();
        this.m_projColComboBox = new JComboBox();
        this.m_rejectLabel = new JLabel();
        this.m_rejectField = new JTextField();
        this.m_usingClobCheckBox = new JCheckBox();
        this.m_accessLabel = new JLabel();
        this.m_accessText = new JTextArea();
        this.m_locLabel = new JLabel();
        this.m_locTableModel = new LocationTableModel();
        this.m_locTable = new JTable(this.m_locTableModel);
        this.m_addLocButton = new JButton();
        this.m_delLocButton = new JButton();
    }

    public ExternalTablePropPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_driverLabel, (Component)this.m_driverComboBox, (String)UIArb.getString(318));
        ResourceUtils.resLabel((JLabel)this.m_defDirLabel, (Component)this.m_defDirComboBox, (String)UIArb.getString(320));
        ResourceUtils.resLabel((JLabel)this.m_rejectLabel, (Component)this.m_rejectField, (String)UIArb.getString(321));
        ResourceUtils.resLabel((JLabel)this.m_projColLabel, (Component)this.m_projColComboBox, (String)UIArb.getString(325));
        ResourceUtils.resLabel((JLabel)this.m_accessLabel, (Component)this.m_accessText, (String)UIArb.getString(323));
        ResourceUtils.resButton((AbstractButton)this.m_usingClobCheckBox, (String)UIArb.getString(324));
        ResourceUtils.resLabel((JLabel)this.m_locLabel, (Component)this.m_locTable, (String)UIArb.getString(322));
        Dimension dimension = new Dimension(28, 25);
        Insets insets = new Insets(5, 5, 5, 5);
        this.m_addLocButton.setPreferredSize(dimension);
        this.m_addLocButton.setMargin(insets);
        this.m_addLocButton.setIcon(DBIcons.getIcon(0));
        this.m_addLocButton.addActionListener(this);
        this.m_delLocButton.setPreferredSize(dimension);
        this.m_delLocButton.setMargin(insets);
        this.m_delLocButton.setIcon(DBIcons.getIcon(1));
        this.m_delLocButton.addActionListener(this);
        this.m_delLocButton.setEnabled(false);
        this.m_defDirComboBox.setRenderer(this.m_rend);
        this.m_locTable.setSelectionMode(0);
        this.m_locTable.getSelectionModel().addListSelectionListener(this);
        this.m_locTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        int n = 0;
        int n2 = 0;
        this.add(this.m_defDirLabel, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_defDirComboBox, new GridBagConstraints(n2++, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add(this.m_rejectLabel, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_rejectField, new GridBagConstraints(n2++, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        n2 = 0;
        this.add(this.m_driverLabel, new GridBagConstraints(n2++, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_driverComboBox, new GridBagConstraints(n2++, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add(this.m_projColLabel, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_projColComboBox, new GridBagConstraints(n2++, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add(this.m_accessLabel, new GridBagConstraints(0, ++n, 4, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.add(this.m_usingClobCheckBox, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 25, 0, 5), 0, 0));
        this.add(new JScrollPane(this.m_accessText), new GridBagConstraints(0, ++n, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        JPanel jPanel = new JPanel();
        this.layoutLocationComponents(jPanel);
        this.add(jPanel, new GridBagConstraints(0, ++n, 4, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        OracleExternalTableProperties.ProjectColumn[] projectColumnArray = OracleExternalTableProperties.ProjectColumn.values();
        int n3 = 0;
        while (n3 < projectColumnArray.length) {
            OracleExternalTableProperties.ProjectColumn projectColumn = projectColumnArray[n3];
            this.m_projColComboBox.addItem(projectColumn);
            ++n3;
        }
        this.m_driverComboBox.addItem("ORACLE_LOADER");
        this.m_driverComboBox.addItem("ORACLE_DATAPUMP");
        this.m_rejectField.setText("0");
    }

    private void layoutLocationComponents(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.m_locLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 5), 0, 0));
        jPanel.add((Component)new JScrollPane(this.m_locTable), new GridBagConstraints(0, 1, 1, 1, 2.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this.m_addLocButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        jPanel2.add((Component)this.m_delLocButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        jPanel2.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.1, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        Table table = (Table)traversableContext.get("NewObject");
        boolean bl = traversableContext.get("OriginalObject") != null;
        OracleExternalTableProperties oracleExternalTableProperties = (OracleExternalTableProperties)table.getProperty("OracleExternalTableProperties");
        this.init(dBObjectProvider, table, oracleExternalTableProperties, bl);
    }

    private void init(DBObjectProvider dBObjectProvider, Table table, OracleExternalTableProperties oracleExternalTableProperties, boolean bl) {
        super.init(dBObjectProvider, null);
        this.m_editing = bl;
        this.populateDirectories();
        this.enablePropertiesWidgets(true);
        if (!(dBObjectProvider instanceof Database)) {
            this.m_defDirComboBox.setEditable(true);
        }
        if (oracleExternalTableProperties != null) {
            this.m_driverComboBox.setSelectedItem(oracleExternalTableProperties.getAccessDriverType());
            this.m_rejectField.setText(oracleExternalTableProperties.getRejectLimit());
            this.m_usingClobCheckBox.setSelected(oracleExternalTableProperties.isAccessUsingClob());
            Object object = oracleExternalTableProperties.getAccessParameters();
            this.m_accessText.setText(object == null ? null : object.toString());
            this.m_locTableModel.setLocations(oracleExternalTableProperties.getLocationSpecifiers());
            String string = DBUtil.getDBObjectName((DBObjectID)oracleExternalTableProperties.getDefaultDirectory());
            this.m_defDirComboBox.setSelectedItem(dBObjectProvider.getExternalName(string));
            if (this.m_editing) {
                this.m_projColComboBox.setSelectedItem(oracleExternalTableProperties.getProjectColumn());
            }
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        Table table = (Table)traversableContext.get("NewObject");
        OracleExternalTableProperties oracleExternalTableProperties = (OracleExternalTableProperties)table.getProperty("OracleExternalTableProperties");
        if (oracleExternalTableProperties == null) {
            oracleExternalTableProperties = new OracleExternalTableProperties();
            table.setProperty("OracleExternalTableProperties", (Object)oracleExternalTableProperties);
        }
        this.commit(dBObjectProvider, table, oracleExternalTableProperties, traversableContext.getDirection() != 2);
    }

    protected List<Directory> getDirectories() {
        return this.m_dirs;
    }

    private void commit(DBObjectProvider dBObjectProvider, Table table, OracleExternalTableProperties oracleExternalTableProperties, boolean bl) throws TraversalException {
        String string;
        if (this.m_locTable.getCellEditor() != null) {
            this.m_locTable.getCellEditor().stopCellEditing();
        }
        oracleExternalTableProperties.setAccessDriverType((String)this.m_driverComboBox.getSelectedItem());
        oracleExternalTableProperties.setRejectLimit(this.m_rejectField.getText());
        oracleExternalTableProperties.setAccessUsingClob(this.m_usingClobCheckBox.isSelected());
        String string2 = this.m_accessText.getText();
        if (ModelUtil.hasLength((String)string2)) {
            oracleExternalTableProperties.setAccessParameters((Object)string2);
        } else {
            oracleExternalTableProperties.setAccessParameters(null);
        }
        Object object = this.m_defDirComboBox.getSelectedItem();
        String string3 = string = object != null ? dBObjectProvider.getInternalName((String)object) : null;
        if (string != null) {
            oracleExternalTableProperties.setDefaultDirectory((DBObjectID)new NameBasedRefID(SCHEMA_SYS, string));
        }
        oracleExternalTableProperties.setLocationSpecifiers(this.m_locTableModel.getLocations());
        if (this.m_editing) {
            oracleExternalTableProperties.setProjectColumn((OracleExternalTableProperties.ProjectColumn)this.m_projColComboBox.getSelectedItem());
        }
        if (bl && (Table.TableType)table.getProperty("TableType") == Table.TableType.EXTERNAL) {
            try {
                oracleExternalTableProperties.validate(table);
            }
            catch (ValidationException validationException) {
                throw new TraversalException(validationException.getMessage(), validationException.getTitle());
            }
        }
    }

    private void populateDirectories() {
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (this.m_dirs == null && dBObjectProvider != null) {
            this.m_popDirs = false;
            ArrayList<Directory> arrayList = new ArrayList<Directory>();
            try {
                SchemaObject[] schemaObjectArray = dBObjectProvider.listObjects(new String[]{"DIRECTORY"}, new Schema("SYS"));
                if (schemaObjectArray != null) {
                    int n = 0;
                    while (n < schemaObjectArray.length) {
                        arrayList.add((Directory)schemaObjectArray[n]);
                        ++n;
                    }
                }
                this.m_dirs = arrayList;
            }
            catch (DBException dBException) {
                DBExceptionDialog.showErrorDialog((Component)((Object)this), UIArb.getString(316), dBException);
            }
        }
        if (this.m_dirs != null && !this.m_popDirs) {
            JComboBox<String> jComboBox = new JComboBox<String>();
            jComboBox.addItem(UIArb.getString(326));
            jComboBox.setRenderer(this.m_rend);
            if (!(this.getProvider() instanceof Database)) {
                jComboBox.setEditable(true);
            }
            this.m_defDirComboBox.removeAllItems();
            for (Directory directory : this.m_dirs) {
                String string = dBObjectProvider.getExternalName(directory.getName());
                this.m_defDirComboBox.addItem(string);
                jComboBox.addItem(string);
            }
            TableColumn tableColumn = this.m_locTable.getColumn(UIArb.getString(327));
            tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
            this.m_popDirs = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_addLocButton) {
            int n = this.m_locTable.getSelectedRow() + 1;
            if (n == 0) {
                n = this.m_locTableModel.getRowCount();
            }
            this.m_locTableModel.addLocation(n, new OracleExternalTableProperties.LocationSpecifier());
            this.m_locTable.setRowSelectionInterval(n, n);
        } else if (object == this.m_delLocButton) {
            int n = this.m_locTable.getSelectedRow();
            this.m_locTableModel.removeLocation(n);
            int n2 = this.m_locTableModel.getRowCount();
            if (n >= n2) {
                if (n2 > 0) {
                    this.m_locTable.setRowSelectionInterval(n2 - 1, n2 - 1);
                }
            } else {
                this.m_locTable.setRowSelectionInterval(n, n);
            }
        }
    }

    private void enablePropertiesWidgets(boolean bl) {
        boolean bl2 = !this.m_editing || this.m_editing && !(this.getProvider() instanceof Database);
        this.m_driverLabel.setEnabled(bl && bl2);
        this.m_driverComboBox.setEnabled(bl && bl2);
        this.m_rejectLabel.setEnabled(bl);
        this.m_rejectField.setEnabled(bl);
        this.m_accessLabel.setEnabled(bl);
        this.m_accessText.setEnabled(bl);
        this.m_defDirLabel.setEnabled(bl);
        this.m_defDirComboBox.setEnabled(bl);
        this.m_locLabel.setEnabled(bl);
        this.m_locTable.setEnabled(bl);
        this.m_addLocButton.setEnabled(bl);
        this.m_delLocButton.setEnabled(bl);
        if (bl) {
            this.valueChanged(null);
        }
        boolean bl3 = this.getProvider() instanceof Oracle10g || !(this.getProvider() instanceof Database);
        this.m_projColLabel.setEnabled(this.m_editing && bl && bl3);
        this.m_projColComboBox.setEnabled(this.m_editing && bl && bl3);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.m_locTable.getSelectedRow();
        this.m_delLocButton.setEnabled(n >= 0 && n < this.m_locTableModel.getRowCount());
    }

    static DBObjectProvider mav$getProvider(ExternalTablePropPanel externalTablePropPanel) {
        return externalTablePropPanel.getProvider();
    }

    static Schema ra$SCHEMA_SYS() {
        return SCHEMA_SYS;
    }

    private class LocationTableModel
    extends AbstractTableModel {
        private List<OracleExternalTableProperties.LocationSpecifier> m_locs;

        private void $init$() {
            this.m_locs = new ArrayList<OracleExternalTableProperties.LocationSpecifier>();
        }

        public LocationTableModel() {
            this.$init$();
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.m_locs.size();
        }

        public Object getValueAt(int n, int n2) {
            OracleExternalTableProperties.LocationSpecifier locationSpecifier = this.m_locs.get(n);
            if (locationSpecifier != null) {
                switch (n2) {
                    case 0: {
                        String string = DBUtil.getDBObjectName((DBObjectID)locationSpecifier.getDirectory());
                        if (ModelUtil.hasLength((String)string)) {
                            return ExternalTablePropPanel.mav$getProvider(ExternalTablePropPanel.this).getExternalName(string);
                        }
                        return UIArb.getString(326);
                    }
                    case 1: {
                        return locationSpecifier.getSpecifier();
                    }
                }
            }
            return null;
        }

        public void addLocation(OracleExternalTableProperties.LocationSpecifier locationSpecifier) {
            this.m_locs.add(locationSpecifier);
            int n = this.m_locs.size();
            this.fireTableRowsInserted(n - 1, n - 1);
        }

        public void addLocation(int n, OracleExternalTableProperties.LocationSpecifier locationSpecifier) {
            this.m_locs.add(n, locationSpecifier);
            this.fireTableRowsInserted(n, n);
        }

        public OracleExternalTableProperties.LocationSpecifier removeLocation(int n) {
            OracleExternalTableProperties.LocationSpecifier locationSpecifier = this.m_locs.remove(n);
            if (locationSpecifier != null) {
                this.fireTableRowsDeleted(n, n);
            }
            return locationSpecifier;
        }

        public void removeAllLocations() {
            this.m_locs.clear();
            this.fireTableDataChanged();
        }

        public OracleExternalTableProperties.LocationSpecifier[] getLocations() {
            return this.m_locs.toArray(new OracleExternalTableProperties.LocationSpecifier[this.m_locs.size()]);
        }

        public void setLocations(OracleExternalTableProperties.LocationSpecifier[] locationSpecifierArray) {
            this.m_locs.clear();
            if (locationSpecifierArray != null) {
                OracleExternalTableProperties.LocationSpecifier[] locationSpecifierArray2 = locationSpecifierArray;
                int n = 0;
                while (n < locationSpecifierArray2.length) {
                    OracleExternalTableProperties.LocationSpecifier locationSpecifier = locationSpecifierArray2[n];
                    this.m_locs.add(locationSpecifier);
                    ++n;
                }
            }
            this.fireTableDataChanged();
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return UIArb.getString(327);
                }
            }
            return UIArb.getString(328);
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            OracleExternalTableProperties.LocationSpecifier locationSpecifier = this.m_locs.get(n);
            switch (n2) {
                case 0: {
                    if (object == UIArb.getString(326)) {
                        locationSpecifier.setDirectory(null);
                    } else if (object instanceof Directory) {
                        locationSpecifier.setDirectory(((Directory)object).getID());
                    } else if (object instanceof String) {
                        String string = ExternalTablePropPanel.mav$getProvider(ExternalTablePropPanel.this).getInternalName((String)object);
                        locationSpecifier.setDirectory((DBObjectID)new NameBasedRefID(ExternalTablePropPanel.ra$SCHEMA_SYS(), string));
                    }
                    return;
                }
                case 1: {
                    locationSpecifier.setSpecifier((String)object);
                    return;
                }
            }
        }
    }
}

