/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.ora.ddlgen.OracleTriggerDDLGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnSequencePanel
extends BaseInfoPanel
implements ActionListener {
    private JLabel _lblColumns;
    private JLabel _lblSequence;
    private JLabel _lblTrigger;
    private JComboBox _cmbColumns;
    private JTextField _txtTrigger;
    private JPanel _sequencePanel;
    private JRadioButton _btnNone;
    private JRadioButton _btnExistingSequence;
    private JRadioButton _btnNewSequence;
    private JComboBox _cmbExistingSequence;
    private JTextField _txtNewSequence;
    private boolean _editing;
    private Table _table;
    private Column _lastColSelection;
    private String[] _existingSequenceNames;
    private List<String> _sessionTriggerNames;
    private static final String COMMA_SPACE = ", ";
    private static final String NEXTVAL = ".NEXTVAL";
    private static final String CURRVAL = ".CURRVAL";
    private static final String NEW = ":NEW.";
    private static final String INTO = " INTO ";
    private static final String TRIGGER_PROLOG = "BEGIN\n  SELECT ";
    private static final String TRIGGER_EPILOG = " FROM DUAL;\nEND;\n";

    public ColumnSequencePanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this._sequencePanel.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this._btnNone, (String)UIArb.getString(711));
        ResourceUtils.resButton((AbstractButton)this._btnExistingSequence, (String)UIArb.getString(712));
        ResourceUtils.resButton((AbstractButton)this._btnNewSequence, (String)UIArb.getString(713));
        ResourceUtils.resLabel((JLabel)this._lblColumns, (Component)this._cmbColumns, (String)UIArb.getString(708));
        ResourceUtils.resLabel((JLabel)this._lblSequence, (Component)this._sequencePanel, (String)UIArb.getString(709));
        ResourceUtils.resLabel((JLabel)this._lblTrigger, (Component)this._txtTrigger, (String)UIArb.getString(710));
        int n = 0;
        this.add(this._lblColumns, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this._cmbColumns, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 20), 0, 0));
        this.add(this._lblSequence, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this._btnNone, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this._btnExistingSequence, new GridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this._cmbExistingSequence, new GridBagConstraints(2, n, 1, 1, 2.0, 0.0, 17, 2, new Insets(5, 0, 0, 30), 0, 0));
        this.add(this._btnNewSequence, new GridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this._txtNewSequence, new GridBagConstraints(2, n, 1, 1, 2.0, 0.0, 17, 2, new Insets(5, 0, 0, 30), 0, 0));
        this.add(this._lblTrigger, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this._txtTrigger, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 20), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, ++n, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this._cmbColumns.addActionListener(this);
        this._txtNewSequence.addActionListener(this);
        this._cmbExistingSequence.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._btnNone);
        buttonGroup.add(this._btnExistingSequence);
        buttonGroup.add(this._btnNewSequence);
        this._btnNone.setSelected(true);
        this._btnNone.addActionListener(this);
        this._btnExistingSequence.addActionListener(this);
        this._btnNewSequence.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cmbColumns) {
            try {
                this.commit();
            }
            catch (TraversalException traversalException) {
                traversalException.showMessageDialog((Component)this._cmbColumns);
                this._cmbColumns.setSelectedItem(this._lastColSelection);
                return;
            }
            this.setupPanelForColumn();
        } else if (object == this._btnNone) {
            this._cmbExistingSequence.setEnabled(false);
            this._txtNewSequence.setEnabled(false);
            this._txtTrigger.setEnabled(false);
        } else if (object == this._btnExistingSequence) {
            this._cmbExistingSequence.setEnabled(true);
            this._txtNewSequence.setEnabled(false);
            this.setTriggerText();
        } else if (object == this._btnNewSequence) {
            this._txtNewSequence.setEnabled(true);
            if (!ModelUtil.hasLength((String)this._txtNewSequence.getText())) {
                this._txtNewSequence.setText(this.getUniqueName("SEQUENCE"));
            }
            this._cmbExistingSequence.setEnabled(false);
            this.setTriggerText();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        Table table = (Table)traversableContext.find("NewObject");
        this._editing = traversableContext.get("OriginalObject") != null;
        this.init(dBObjectProvider, table);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit();
        traversableContext.put("NewSecondaryDBObjects", (Object)this.getSecondaryObjects());
    }

    private SchemaObject[] getSecondaryObjects() {
        HashMap<String, DBObject> hashMap = new HashMap<String, DBObject>();
        HashMap<String, List<Column>> hashMap2 = new HashMap<String, List<Column>>();
        Column[] columnArray = this._table.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            DBObjectID dBObjectID;
            Column column = columnArray[n];
            DBObjectID dBObjectID2 = (DBObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE");
            if (dBObjectID2 != null) {
                try {
                    String string;
                    DBObject dBObject = dBObjectID2.resolveID();
                    String string2 = string = dBObject != null ? dBObject.getName() : null;
                    if (!this.isExistingSequence(string) || !(this.getProvider() instanceof Database)) {
                        DBObject dBObject2 = (DBObject)hashMap.get(string);
                        if (dBObject2 != null) {
                            column.setProperty("AUTO_GENERATED_SEQUENCE", (Object)dBObject2.getID());
                        } else {
                            hashMap.put(dBObject.getName(), dBObject);
                        }
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            if ((dBObjectID = (DBObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER")) != null) {
                try {
                    DBObject dBObject = dBObjectID.resolveID();
                    ArrayList<Column> arrayList = (ArrayList<Column>)hashMap2.get(dBObject.getName());
                    if (arrayList != null) {
                        arrayList.add(column);
                    } else {
                        arrayList = new ArrayList<Column>();
                        arrayList.add(column);
                        hashMap2.put(dBObject.getName(), arrayList);
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            ++n;
        }
        Set<Trigger> set = this.createTriggers(hashMap2);
        if (hashMap.size() > 0 || set.size() > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.addAll(hashMap.values());
            arrayList.addAll(set);
            return arrayList.toArray(new SchemaObject[arrayList.size()]);
        }
        return null;
    }

    private Set<Trigger> createTriggers(Map<String, List<Column>> map) {
        HashSet<Trigger> hashSet = new HashSet<Trigger>();
        for (String string : map.keySet()) {
            HashMap<DBObjectID, ArrayList<Column>> hashMap = new HashMap<DBObjectID, ArrayList<Column>>();
            for (Column column : map.get(string)) {
                DBObjectID dBObjectID = (DBObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE");
                ArrayList<Column> arrayList = (ArrayList<Column>)hashMap.get(dBObjectID);
                if (arrayList != null) {
                    arrayList.add(column);
                    continue;
                }
                arrayList = new ArrayList<Column>();
                arrayList.add(column);
                hashMap.put(dBObjectID, arrayList);
            }
            Trigger trigger = new Trigger(this._table.getSchema(), string);
            trigger.setTableName(this._table.getName());
            trigger.setTableOwner(this._table.getSchema());
            trigger.setStatementLevel(false);
            trigger.setBaseType(Trigger.BaseType.TABLE);
            trigger.setTiming(Trigger.Timing.BEFORE);
            trigger.setEvents(new String[]{"INSERT"});
            try {
                Trigger trigger2 = (Trigger)this.getProvider().getObject("TRIGGER", this._table.getSchema(), string);
                if (trigger2 != null) {
                    trigger.setID(trigger2.getID());
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (trigger.getID() == null) {
                trigger.setID(TemporaryObjectID.createID((DBObject)trigger));
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (DBObjectID dBObjectID : hashMap.keySet()) {
                String string2 = this.getProvider().getExternalName(DBUtil.getDBObjectName((DBObjectID)dBObjectID));
                int n = 0;
                for (Column column : (List)hashMap.get(dBObjectID)) {
                    column.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", (Object)trigger.getID());
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(COMMA_SPACE);
                        stringBuffer2.append(COMMA_SPACE);
                    }
                    stringBuffer.append(string2).append(n++ == 0 ? NEXTVAL : CURRVAL);
                    stringBuffer2.append(NEW).append(this.getProvider().getExternalName(column.getName()));
                }
            }
            StringBuffer stringBuffer3 = new StringBuffer(TRIGGER_PROLOG).append(stringBuffer).append(INTO).append(stringBuffer2).append(TRIGGER_EPILOG);
            trigger.setCode(stringBuffer3.toString());
            OracleTriggerDDLGenerator oracleTriggerDDLGenerator = new OracleTriggerDDLGenerator(this.getProvider());
            trigger.setSource(oracleTriggerDDLGenerator.getCreateDDL((SchemaObject)trigger, true, false).stripPrompts().getDdl());
            hashSet.add(trigger);
        }
        return hashSet;
    }

    private void init(DBObjectProvider dBObjectProvider, Table table) {
        super.init(dBObjectProvider, null);
        this._table = table;
        this._existingSequenceNames = this.getSequenceNames(table.getSchema());
        this._cmbExistingSequence.setModel(new DefaultComboBoxModel<String>(this._existingSequenceNames));
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Column[] columnArray = table.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            Column column = columnArray[n];
            try {
                DBObject dBObject = column.getDataTypeUsage().getDataTypeID().resolveID();
                if (dBObject instanceof NumericDataType || dBObject instanceof CharacterDataType) {
                    String string;
                    arrayList.add(column);
                    DBObjectID dBObjectID = (DBObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER");
                    if (dBObjectID != null && ModelUtil.hasLength((String)(string = DBUtil.getDBObjectName((DBObjectID)dBObjectID))) && !this._sessionTriggerNames.contains(string)) {
                        this._sessionTriggerNames.add(string);
                    }
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
            ++n;
        }
        this._cmbColumns.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        if (arrayList.size() == 0) {
            this.enableAllComponents(false, true);
            return;
        }
        if (this._lastColSelection != null && arrayList.contains(this._lastColSelection)) {
            this._cmbColumns.setSelectedItem(this._lastColSelection);
        }
        this._cmbColumns.setEnabled(true);
        this.setupPanelForColumn();
    }

    private void commit() throws TraversalException {
        if (this._btnNone.isSelected()) {
            this._lastColSelection.setProperty("AUTO_GENERATED_SEQUENCE", null);
            this._lastColSelection.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", null);
        } else {
            DBObjectID dBObjectID;
            String string;
            String string2 = this.getInternalName(this._txtTrigger.getText(), "TRIGGER");
            if (!string2.equals(string = DBUtil.getDBObjectName((DBObjectID)(dBObjectID = (DBObjectID)this._lastColSelection.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER"))))) {
                if (!this._sessionTriggerNames.contains(string2)) {
                    try {
                        this.getProvider().validateUniqueName("TRIGGER", (DBObject)this._table.getSchema(), string2);
                        this._sessionTriggerNames.add(string2);
                    }
                    catch (NameInUseException nameInUseException) {
                        throw new TraversalException(nameInUseException.getMessage());
                    }
                }
                Trigger trigger = new Trigger(this._table.getSchema(), string2);
                trigger.setID(TemporaryObjectID.createID((DBObject)trigger));
                this._lastColSelection.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", (Object)trigger.getID());
            }
            if (this._btnNewSequence.isSelected()) {
                String string3 = this.getInternalName(this._txtNewSequence.getText(), "SEQUENCE");
                try {
                    if (this._table.getName().equals(string3)) {
                        throw new NameInUseException((DBObject)this._table);
                    }
                    this.getProvider().validateUniqueName("SEQUENCE", (DBObject)this._table.getSchema(), string3);
                }
                catch (NameInUseException nameInUseException) {
                    throw new TraversalException(nameInUseException.getMessage());
                }
                Sequence sequence = new Sequence(string3, this._table.getSchema());
                sequence.setID(TemporaryObjectID.createID((DBObject)sequence));
                this._lastColSelection.setProperty("AUTO_GENERATED_SEQUENCE", (Object)sequence.getID());
            } else {
                try {
                    String string4 = (String)this._cmbExistingSequence.getSelectedItem();
                    SchemaObject schemaObject = this.getProvider().getObject("SEQUENCE", this._table.getSchema(), string4);
                    this._lastColSelection.setProperty("AUTO_GENERATED_SEQUENCE", (Object)schemaObject.getID());
                }
                catch (DBException dBException) {
                    throw new TraversalException(dBException.getMessage());
                }
            }
        }
    }

    private String getInternalName(String string, String string2) throws TraversalException {
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(UIArb.getString("TRIGGER".equals(string2) ? 714 : 715));
        }
        String string3 = this.getProvider().getInternalName(string, string2);
        try {
            this.getProvider().validateName(string2, string3);
        }
        catch (InvalidNameException invalidNameException) {
            throw new TraversalException(string2 + " : " + invalidNameException.getMessage());
        }
        return string3;
    }

    private String[] getSequenceNames(Schema schema) {
        try {
            String[] stringArray = this.getProvider().listObjects("SEQUENCE", schema);
            return stringArray;
        }
        catch (DBException dBException) {
            return null;
        }
    }

    private void setupPanelForColumn() {
        this._lastColSelection = (Column)this._cmbColumns.getSelectedItem();
        this.enableAllComponents(true, true);
        DBObjectID dBObjectID = (DBObjectID)this._lastColSelection.getProperty("AUTO_GENERATED_SEQUENCE");
        if (dBObjectID != null) {
            String string = null;
            try {
                DBObject dBObject = dBObjectID.resolveID();
                string = dBObject != null ? dBObject.getName() : null;
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (this.isExistingSequence(string)) {
                this._btnExistingSequence.setSelected(true);
                this._cmbExistingSequence.setSelectedItem(string);
                this._txtNewSequence.setEnabled(false);
                this._txtNewSequence.setText("");
            } else {
                this._btnNewSequence.setSelected(true);
                this._txtNewSequence.setText(this.getProvider().getExternalName(string));
                this._cmbExistingSequence.setEnabled(false);
            }
            this.setTriggerText();
        } else {
            this._btnNone.setSelected(true);
            this._cmbExistingSequence.setEnabled(false);
            this._txtNewSequence.setText("");
            this._txtNewSequence.setEnabled(false);
            this._txtTrigger.setText("");
            this._txtTrigger.setEnabled(false);
        }
    }

    private void setTriggerText() {
        String string = this._txtTrigger.getText();
        this._txtTrigger.setEnabled(true);
        DBObjectID dBObjectID = (DBObjectID)this._lastColSelection.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER");
        if (dBObjectID != null) {
            try {
                DBObject dBObject = dBObjectID.resolveID();
                string = dBObject != null ? this.getProvider().getExternalName(dBObject.getName()) : null;
            }
            catch (DBException dBException) {}
        } else if (!ModelUtil.hasLength((String)this._txtTrigger.getText())) {
            string = !this._sessionTriggerNames.isEmpty() ? this._sessionTriggerNames.get(0) : this.getUniqueName("TRIGGER");
        }
        this._txtTrigger.setText(string);
    }

    protected void enableAllComponents(boolean bl, boolean bl2) {
        this._cmbColumns.setEnabled(bl);
        this._btnNone.setEnabled(bl);
        this._btnNewSequence.setEnabled(bl);
        this._btnExistingSequence.setEnabled(bl);
        this._txtTrigger.setEnabled(bl);
        this._sequencePanel.setEnabled(bl);
        this._cmbExistingSequence.setEnabled(bl);
        this._txtNewSequence.setEnabled(bl);
        if (bl || bl2) {
            this._lblColumns.setEnabled(bl);
            this._lblSequence.setEnabled(bl);
            this._lblTrigger.setEnabled(bl);
        }
    }

    private String getUniqueName(String string) {
        String string2;
        String string3 = null;
        String string4 = this._table.getName();
        String string5 = "SEQUENCE".equals(string) ? "SEQ" : "TRG";
        int n = string4.length() > 25 ? 25 : string4.length();
        do {
            string2 = this._table.getName().substring(0, n--) + '_' + string5;
        } while (ModelUtil.hasLength((String)(string3 = this.getProvider().getUniqueName(string, (DBObject)this._table.getSchema(), string2))) && string3.length() > 30);
        string3 = string3 != null ? this.getProvider().getExternalName(string3) : null;
        return string3;
    }

    private boolean isExistingSequence(String string) {
        String[] stringArray = this._existingSequenceNames;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void $init$() {
        this._lblColumns = new JLabel();
        this._lblSequence = new JLabel();
        this._lblTrigger = new JLabel();
        this._cmbColumns = new JComboBox();
        this._txtTrigger = new JTextField();
        this._sequencePanel = new JPanel();
        this._btnNone = new JRadioButton();
        this._btnExistingSequence = new JRadioButton();
        this._btnNewSequence = new JRadioButton();
        this._cmbExistingSequence = new JComboBox();
        this._txtNewSequence = new JTextField();
        this._lastColSelection = null;
        this._sessionTriggerNames = new ArrayList<String>();
    }
}

