/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.db.DBIcons;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.ColumnEditorPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.ColumnInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;

public class ColumnInfoPanel
extends BaseInfoPanel
implements DocumentListener,
ListDataListener,
ListSelectionListener,
ActionListener {
    private JList lstColumns;
    private DefaultListModel mdlColumns;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnUp;
    private JButton btnDown;
    private ColumnEditorPanel pnlColumn;
    private DataType _defaultType;
    private Relation _relation;
    private Column _col;
    private WizardCallbacks _callbacks;
    private int _currentSelection;

    private void $init$() {
        this.lstColumns = new JList();
        this.mdlColumns = new DefaultListModel();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.pnlColumn = new ColumnEditorPanel();
        this._currentSelection = 0;
    }

    public ColumnInfoPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.lstColumns, (String)UIArb.getString(431));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.lstColumns.setModel(this.mdlColumns);
        this.lstColumns.setSelectionMode(2);
        this.lstColumns.setCellRenderer(new DBObjectRenderer());
        Dimension dimension = new Dimension(28, 25);
        this.btnUp.setPreferredSize(dimension);
        this.btnUp.setIcon(ComponentArb.getIcon((int)0));
        this.btnUp.setDisabledIcon(ComponentArb.getIcon((int)2));
        DBObjectRenderer.setToolTipText(this.btnUp, UIArb.getString(434));
        this.btnUp.addActionListener(this);
        this.btnDown.setPreferredSize(dimension);
        this.btnDown.setIcon(ComponentArb.getIcon((int)1));
        this.btnDown.setDisabledIcon(ComponentArb.getIcon((int)3));
        DBObjectRenderer.setToolTipText(this.btnDown, UIArb.getString(435));
        this.btnDown.addActionListener(this);
        this.btnAdd.setPreferredSize(dimension);
        this.btnAdd.setIcon(DBIcons.getIcon(0));
        DBObjectRenderer.setToolTipText(this.btnAdd, UIArb.getString(432));
        this.btnAdd.addActionListener(this);
        this.btnRemove.setPreferredSize(dimension);
        this.btnRemove.setIcon(DBIcons.getIcon(1));
        DBObjectRenderer.setToolTipText(this.btnRemove, UIArb.getString(433));
        this.btnRemove.addActionListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.btnAdd, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.btnRemove, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.btnUp, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(15, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.btnDown, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        jScrollPane.getViewport().add((Component)this.lstColumns, null);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(5, 5, 0, 0), 0, 0));
        jPanel2.add(Box.createHorizontalStrut(140), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.pnlColumn, new GridBagConstraints(2, 0, 1, 2, 2.0, 1.0, 13, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.setLayout(new BorderLayout(0, 0));
        this.add(jPanel2, "Center");
    }

    public void onEntry(TraversableContext traversableContext) {
        WizardCallbacks wizardCallbacks = traversableContext.getWizardCallbacks();
        this.init((DBObjectProvider)traversableContext.find("DBObjectProvider"), (Relation)traversableContext.find("NewObject"), (ColumnInfoVerifier)traversableContext.find("ColumnInfoVerifier"), wizardCallbacks);
        if (wizardCallbacks != null) {
            if (this.mdlColumns.getSize() > 0) {
                wizardCallbacks.wizardSetInitialFocus((Component)this.lstColumns);
            } else {
                wizardCallbacks.wizardSetInitialFocus((Component)this.btnAdd);
            }
        }
        this.setInitialSelection(traversableContext.find("DefaultChild"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit((Relation)traversableContext.find("OriginalObject"), (Relation)traversableContext.find("NewObject"), traversableContext.getDirection() == 2);
    }

    protected void init(DBObjectProvider dBObjectProvider, Relation relation, ColumnInfoVerifier columnInfoVerifier, WizardCallbacks wizardCallbacks) {
        super.init(dBObjectProvider, columnInfoVerifier);
        this._relation = relation;
        if (relation.getColumns().length == 0) {
            Column column = new Column("COLUMN1");
            DataType dataType = null;
            DataType dataType2 = null;
            DataType[] dataTypeArray = dBObjectProvider.listSupportedDataTypes();
            int n = 0;
            while (n < dataTypeArray.length) {
                DataType dataType3 = dataTypeArray[n];
                if (dataType3.getName().equals("CHAR")) {
                    dataType = dataType3;
                } else if (dataType3.getName().equals("VARCHAR2")) {
                    dataType2 = dataType3;
                    break;
                }
                ++n;
            }
            if (dataType2 == null) {
                dataType2 = dataType;
            }
            if (dataType2 != null) {
                column.setDataTypeUsage(dataType2.createDefaultUsage());
                column.setID(TemporaryObjectID.createID((DBObject)column));
                relation.addColumn(column);
            }
        }
        this.lstColumns.getSelectionModel().removeListSelectionListener(this);
        this.mdlColumns.removeListDataListener(this);
        this.mdlColumns.removeAllElements();
        this.mdlColumns.clear();
        this._col = null;
        this._callbacks = wizardCallbacks;
        this._defaultType = columnInfoVerifier.getDefaultType();
        this.pnlColumn.init(dBObjectProvider, relation.getSchema(), columnInfoVerifier);
        this.mdlColumns.addListDataListener(this);
        this.lstColumns.getSelectionModel().addListSelectionListener(this);
        this._updateColumnData(null);
        Column[] columnArray = relation.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            this.mdlColumns.addElement(columnArray[n]);
            ++n;
        }
        this._updateButtons();
        this._updateListContents();
    }

    protected void commit(Relation relation, Relation relation2, boolean bl) throws TraversalException {
        if (this._col != null) {
            this._commitColumnChanges(this._col);
        }
        int n = this.mdlColumns.size();
        ArrayList<Column> arrayList = new ArrayList<Column>(n);
        int n2 = 0;
        while (n2 < n) {
            Column column = (Column)this.mdlColumns.getElementAt(n2);
            arrayList.add(column);
            ++n2;
        }
        relation2.setColumns(arrayList.toArray(new Column[arrayList.size()]));
        ColumnInfoVerifier columnInfoVerifier = (ColumnInfoVerifier)this.getVerifier();
        if (!bl && columnInfoVerifier != null) {
            columnInfoVerifier.verifyRelation();
        }
    }

    private void setInitialSelection(Object object) {
        int n;
        int n2 = 0;
        if (object != null && (n = this.mdlColumns.indexOf(object)) != -1) {
            n2 = n;
        }
        if (this.mdlColumns.size() > 0) {
            this.setSelectedColumn(0);
        }
    }

    private void _commitColumnChanges(Column column) throws TraversalException {
        this.pnlColumn.commit(column);
        this.pnlColumn.getNameField().getDocument().removeDocumentListener(this);
    }

    private void _updateColumnData(Column column) {
        this._col = column;
        this.pnlColumn.setColumn(column);
        if (column != null) {
            this.pnlColumn.getNameField().getDocument().addDocumentListener(this);
        }
        this.validate();
        this.repaint();
    }

    private void _updateSelection(Object object) {
        if (object != this._col) {
            if (this._col != null) {
                try {
                    this._commitColumnChanges(this._col);
                }
                catch (TraversalException traversalException) {
                    this.showColumnError(traversalException);
                    return;
                }
            }
            this._updateColumnData((Column)object);
        }
        this._updateButtons();
    }

    private void showColumnError(TraversalException traversalException) {
        traversalException.showMessageDialog((Component)((Object)this));
        int n = this.lstColumns.getSelectedIndex();
        if (n < 0 || this.mdlColumns.elementAt(n).equals(this.mdlColumns.elementAt(this._currentSelection))) {
            this.setSelectedColumn(this._currentSelection);
        } else if (this._currentSelection != n) {
            this.setSelectedColumn(this._col);
        }
    }

    private void _updateButtons() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ColumnInfoVerifier columnInfoVerifier = (ColumnInfoVerifier)this.getVerifier();
        int n = this.lstColumns.getSelectedIndex();
        Column column = n != -1 ? (Column)this.mdlColumns.get(n) : null;
        int[] nArray = this.lstColumns.getSelectedIndices();
        if (nArray.length == 1) {
            if (column != null) {
                bl = columnInfoVerifier == null || columnInfoVerifier.canRemoveColumns() && columnInfoVerifier.canRemoveColumn(column);
                Column column2 = n > 0 ? (Column)this.mdlColumns.get(n - 1) : null;
                Column column3 = n < this.mdlColumns.getSize() - 1 ? (Column)this.mdlColumns.get(n + 1) : null;
                bl2 = column2 != null && (columnInfoVerifier == null || columnInfoVerifier.canReorderColumns() && columnInfoVerifier.canMoveColumnUp(column) && columnInfoVerifier.canMoveColumnDown(column2));
                bl3 = column3 != null && (columnInfoVerifier == null || columnInfoVerifier.canReorderColumns() && columnInfoVerifier.canMoveColumnDown(column) && columnInfoVerifier.canMoveColumnUp(column3));
            }
        } else if (nArray.length > 1) {
            bl = true;
            if (columnInfoVerifier != null) {
                int n2 = 0;
                while (bl && n2 < nArray.length) {
                    Column column4 = (Column)this.mdlColumns.get(nArray[n2]);
                    bl = columnInfoVerifier.canRemoveColumns() && columnInfoVerifier.canRemoveColumn(column4);
                    ++n2;
                }
            }
        }
        this.btnRemove.setEnabled(bl);
        this.btnUp.setEnabled(bl2);
        this.btnDown.setEnabled(bl3);
        this.btnAdd.setEnabled(columnInfoVerifier == null || columnInfoVerifier.canAddColumns() && columnInfoVerifier.canAddColumn(column));
    }

    private void _updateListContents() {
        boolean bl = this.mdlColumns.getSize() > 0;
        this.lstColumns.setFocusable(bl);
        if (this._callbacks != null) {
            Boolean bl2 = bl;
            this._callbacks.wizardEnableButtons(Boolean.TRUE, bl2, bl2);
        }
    }

    private void _swap(int n, int n2) {
        Object e = this.mdlColumns.getElementAt(n);
        Object e2 = this.mdlColumns.getElementAt(n2);
        this.mdlColumns.setElementAt(e, n2);
        this.mdlColumns.setElementAt(e2, n);
    }

    private void _updateColumnName() {
        if (this._col != null) {
            String string = this.pnlColumn.getNameField().getText();
            this._col.setName(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        this._currentSelection = this.lstColumns.getSelectedIndex();
        if (object == this.btnAdd) {
            int n2 = this.lstColumns.getSelectedIndex();
            this.lstColumns.clearSelection();
            if (this.lstColumns.getSelectedValue() == null) {
                Column column;
                int n3;
                boolean bl;
                String string = ColumnInfoPanel.getUniqueName("COLUMN", this.mdlColumns);
                Column column2 = new Column(string);
                column2.setID(TemporaryObjectID.createID((DBObject)column2));
                this._relation.addColumn(column2);
                column2.setDataTypeUsage(this._defaultType.createDefaultUsage());
                ColumnInfoVerifier columnInfoVerifier = (ColumnInfoVerifier)this.getVerifier();
                boolean bl2 = bl = n2 >= 0 && (columnInfoVerifier == null || columnInfoVerifier.canReorderColumns());
                if (bl && n2 < (n3 = this.mdlColumns.getSize()) - 1 && !columnInfoVerifier.canMoveColumnDown(column = (Column)this.mdlColumns.getElementAt(n2))) {
                    bl = false;
                }
                if (bl) {
                    this.mdlColumns.insertElementAt(column2, n2 + 1);
                } else {
                    this.mdlColumns.addElement(column2);
                }
                this.setSelectedColumn(column2);
                this.pnlColumn.getNameField().requestFocusInWindow();
            }
        } else if (object == this.btnRemove) {
            Object[] objectArray = this.lstColumns.getSelectedValues();
            if (objectArray != null && objectArray.length > 0) {
                this._relation.removeColumn(this._col);
                this._col = null;
                int n4 = this.lstColumns.getSelectedIndex();
                int n5 = 0;
                while (n5 < objectArray.length) {
                    this.mdlColumns.removeElement(objectArray[n5]);
                    ++n5;
                }
                int n6 = this.mdlColumns.size() - 1;
                int n7 = n4 >= n6 ? n6 : n4;
                this.setSelectedColumn(n7);
                if (n7 == -1) {
                    this._updateSelection(null);
                    this._updateColumnData(null);
                }
            }
        } else if (object == this.btnUp) {
            int n8 = this.lstColumns.getSelectedIndex();
            if (n8 > 0) {
                this._swap(n8--, n8);
                this.setSelectedColumn(n8);
            }
        } else if (object == this.btnDown && (n = this.lstColumns.getSelectedIndex()) < this.mdlColumns.getSize() - 1) {
            this._swap(n++, n);
            this.setSelectedColumn(n);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray = this.lstColumns.getSelectedValues();
        if (objectArray.length == 1) {
            this._updateSelection(this.lstColumns.getSelectedValue());
        } else {
            this._updateSelection(null);
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this._updateListContents();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this._updateListContents();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this._updateListContents();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this._updateColumnName();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this._updateColumnName();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this._updateColumnName();
    }

    private void setSelectedColumn(int n) {
        this._currentSelection = n;
        this.lstColumns.setSelectedIndex(this._currentSelection);
    }

    private void setSelectedColumn(Column column) {
        this.lstColumns.setSelectedValue(column, true);
        this._currentSelection = this.lstColumns.getSelectedIndex();
    }
}

