/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.ConstraintPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;

public abstract class BaseConstraintPanel
extends BaseInfoPanel {
    private JPanel pnlList;
    private ConstraintPanel pnlDetail;
    private GridBagLayout layList;
    private GridBagLayout layMain;
    private JLabel lblConstraints;
    private JScrollPane scrConstraints;
    private JButton btnAdd;
    private JButton btnRemove;
    private JList lstConstraints;
    private JPanel pnlButtons;
    private GridLayout layButtons;
    private EventHandler _handler;
    private DBObjectRenderer renderer;
    private DefaultListModel _mdlCons;
    private Relation _relation;
    private Namespace _cNamespace;
    private Constraint _con;
    private Constraint _selectedCon;
    private boolean _isNewConstraint;
    private int _currentSelection;
    private List _consList;
    private static final int MAXLEN = 30;
    private static Map s_postfixes = new HashMap();

    private void $init$() {
        this.pnlList = new JPanel();
        this.pnlDetail = this.getDetailPanel();
        this.layList = new GridBagLayout();
        this.layMain = new GridBagLayout();
        this.lblConstraints = new JLabel();
        this.scrConstraints = new JScrollPane();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.lstConstraints = new JList();
        this.pnlButtons = new JPanel();
        this.layButtons = new GridLayout();
        this._handler = new EventHandler(null);
        this.renderer = this.getRenderer();
        this._mdlCons = new DefaultListModel();
        this._isNewConstraint = false;
        this._currentSelection = 0;
        this._consList = new ArrayList();
    }

    public BaseConstraintPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        int n;
        this._cNamespace = new Namespace((Namespace)traversableContext);
        WizardCallbacks wizardCallbacks = traversableContext.getWizardCallbacks();
        if (wizardCallbacks != null) {
            wizardCallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        }
        this.init((DBObjectProvider)traversableContext.find("DBObjectProvider"), (ConstraintsInfoVerifier)traversableContext.find("ConstraintsInfoVerifier"));
        this._relation = (Relation)traversableContext.find("NewObject");
        this._updateDetailPanel();
        ConstraintsInfoVerifier constraintsInfoVerifier = (ConstraintsInfoVerifier)this.getVerifier();
        this.btnAdd.setEnabled(constraintsInfoVerifier == null || constraintsInfoVerifier.canAddConstraints());
        this._consList = new ArrayList<Constraint>(Arrays.asList(this._relation.getConstraints()));
        Constraint[] constraintArray = this.findSupportedConstraints(this._relation);
        this._mdlCons.clear();
        int n2 = 0;
        while (n2 < constraintArray.length) {
            this._mdlCons.addElement(constraintArray[n2]);
            this._consList.remove(constraintArray[n2]);
            ++n2;
        }
        int n3 = 0;
        Object object = traversableContext.find("DefaultChild");
        if (object != null && (n = this._mdlCons.indexOf(object)) != -1) {
            n3 = n;
        }
        if (constraintArray.length > 0) {
            this.setSelectedConstraint(n3);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        boolean bl = traversableContext.getDirection() == 2;
        this._commitDetail(true);
        Constraint[] constraintArray = this._consList.toArray(new Constraint[this._consList.size()]);
        Constraint[] constraintArray2 = this._getConstraintsFromList();
        Constraint[] constraintArray3 = new Constraint[constraintArray.length + constraintArray2.length];
        System.arraycopy(constraintArray, 0, constraintArray3, 0, constraintArray.length);
        System.arraycopy(constraintArray2, 0, constraintArray3, constraintArray.length, constraintArray2.length);
        this._relation.setConstraints(constraintArray3);
        this._con = null;
    }

    private Constraint[] _getConstraintsFromList() {
        Object[] objectArray = new Constraint[this._mdlCons.getSize()];
        this._mdlCons.copyInto(objectArray);
        return objectArray;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layMain);
        this.pnlList.setLayout(this.layList);
        ResourceUtils.resLabel((JLabel)this.lblConstraints, (Component)this.lstConstraints, (String)this.getListLabel());
        ResourceUtils.resButton((AbstractButton)this.btnAdd, (String)UIArb.getString(484));
        this.btnAdd.addActionListener(this._handler);
        ResourceUtils.resButton((AbstractButton)this.btnRemove, (String)UIArb.getString(485));
        this.btnRemove.addActionListener(this._handler);
        this.lstConstraints.setVisibleRowCount(4);
        this.lstConstraints.setSelectionMode(0);
        this.lstConstraints.setModel(this._mdlCons);
        this.lstConstraints.addListSelectionListener(this._handler);
        this.lstConstraints.setCellRenderer(this.renderer);
        this.pnlButtons.setLayout(this.layButtons);
        this.layButtons.setColumns(1);
        this.layButtons.setRows(2);
        this.layButtons.setVgap(5);
        this.pnlList.add((Component)this.lblConstraints, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scrConstraints.getViewport().add((Component)this.lstConstraints, null);
        this.pnlList.add((Component)this.scrConstraints, new GridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlButtons.add((Component)this.btnAdd, null);
        this.pnlButtons.add((Component)this.btnRemove, null);
        this.pnlList.add((Component)this.pnlButtons, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.pnlList, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((JPanel)((Object)this.pnlDetail), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
    }

    protected abstract ConstraintPanel getDetailPanel();

    protected abstract String getConstraintType();

    protected abstract String getListLabel();

    protected final Constraint createNewConstraint() {
        String string = this.getConstraintType();
        Object object = "PKConstraint".equals(string) ? new PKConstraint() : ("FKConstraint".equals(string) ? new FKConstraint() : ("CheckConstraint".equals(string) ? new CheckConstraint() : new UniqueConstraint()));
        object.setID(TemporaryObjectID.createID((DBObject)object));
        this._isNewConstraint = true;
        object.setRelation(this._relation);
        return object;
    }

    protected Constraint[] findSupportedConstraints(Relation relation) {
        String string = this.getConstraintType();
        Constraint[] constraintArray = relation.getConstraints();
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        int n = 0;
        while (n < constraintArray.length) {
            if (string.equals(constraintArray[n].getConstraintType())) {
                arrayList.add(constraintArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Constraint[arrayList.size()]);
    }

    protected DBObjectRenderer getRenderer() {
        return new DBObjectRenderer();
    }

    private void _updateDetailPanel() {
        ConstraintsInfoVerifier constraintsInfoVerifier = (ConstraintsInfoVerifier)this.getVerifier();
        boolean bl = this._con != null && (constraintsInfoVerifier == null || constraintsInfoVerifier.canRemoveConstraints() && constraintsInfoVerifier.canRemoveConstraint(this._con));
        this.btnRemove.setEnabled(bl);
        boolean bl2 = this._con != null && (constraintsInfoVerifier == null || constraintsInfoVerifier.canModifyConstraint(this._con));
        this._cNamespace.put("Con", (Object)this._con);
        this._cNamespace.put("Modifiable", (Object)bl2);
        this._cNamespace.put("otherCons", (Object)this._getConstraintsFromList());
        this._cNamespace.put("constraintPanel", (Object)this);
        try {
            this.pnlDetail.init(this._cNamespace);
        }
        catch (TraversalException traversalException) {
            this._con = null;
            this.lstConstraints.clearSelection();
        }
    }

    private void _showConstraintError(TraversalException traversalException) {
        traversalException.showMessageDialog((Component)((Object)this));
        int n = this.lstConstraints.getSelectedIndex();
        if (n < 0 || this._mdlCons.elementAt(n).equals(this._mdlCons.elementAt(this._currentSelection))) {
            this.setSelectedConstraint(this._currentSelection);
        } else if (this._currentSelection != n) {
            this.setSelectedConstraint(this._con);
        }
    }

    private void _updateSelection() {
        Constraint constraint = (Constraint)this.lstConstraints.getSelectedValue();
        if (constraint != this._con) {
            try {
                this._commitDetail(true);
                this._con = constraint;
                if (this._con == null || this._isNewConstraint) {
                    this._selectedCon = null;
                    this._isNewConstraint = false;
                } else {
                    this._selectedCon = (Constraint)constraint.copyTo(null);
                }
                this._updateDetailPanel();
            }
            catch (TraversalException traversalException) {
                this._showConstraintError(traversalException);
            }
        }
        ConstraintsInfoVerifier constraintsInfoVerifier = (ConstraintsInfoVerifier)this.getVerifier();
        boolean bl = constraint != null && (constraintsInfoVerifier == null || constraintsInfoVerifier.canRemoveConstraints() && constraintsInfoVerifier.canRemoveConstraint(constraint));
        this.btnRemove.setEnabled(bl);
    }

    private void _commitDetail(boolean bl) throws TraversalException {
        if (this._con != null) {
            ConstraintsInfoVerifier constraintsInfoVerifier;
            this.pnlDetail.commit();
            if (bl && (constraintsInfoVerifier = (ConstraintsInfoVerifier)this.getVerifier()) != null) {
                constraintsInfoVerifier.verifyConstraint(this._selectedCon, this._con);
            }
        }
    }

    public static String findUniqueName(Relation relation, Constraint constraint, Constraint[] constraintArray) {
        String string = BaseConstraintPanel.getDefaultBaseName(relation.getName(), constraint.getConstraintType());
        Constraint[] constraintArray2 = relation.getConstraints();
        if (constraintArray.length > 0) {
            Constraint[] constraintArray3 = constraintArray2;
            constraintArray2 = new Constraint[constraintArray3.length + constraintArray.length];
            System.arraycopy(constraintArray3, 0, constraintArray2, 0, constraintArray3.length);
            System.arraycopy(constraintArray, 0, constraintArray2, constraintArray3.length, constraintArray.length);
        }
        return BaseConstraintPanel.findUniqueName(string, constraint, constraintArray2);
    }

    static {
        s_postfixes.put("PKConstraint", "_PK");
        s_postfixes.put("UniqueConstraint", "_UK");
        s_postfixes.put("FKConstraint", "_FK");
        s_postfixes.put("CheckConstraint", "_CHK");
    }

    public static String getDefaultBaseName(String string, String string2) {
        String string3 = string == null ? "" : string;
        String string4 = (String)s_postfixes.get(string2);
        int n = 30 - string4.length() - 2;
        return string3.length() > n ? string3.substring(0, n) + string4 : string3 + string4;
    }

    public static String getDefaultFKBaseName(String string, String string2) {
        return string2 != null ? BaseConstraintPanel.getDefaultBaseName(string + "_" + string2, "FKConstraint") : BaseConstraintPanel.getDefaultBaseName(string, "FKConstraint");
    }

    public static String findUniqueName(String string, Constraint constraint, Constraint[] constraintArray) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < constraintArray.length) {
            if (constraint != constraintArray[n]) {
                hashSet.add(constraintArray[n].getName());
            }
            ++n;
        }
        String string2 = null;
        int n2 = 1;
        while (string2 == null) {
            string2 = 1 == n2 && constraint instanceof PKConstraint ? string : string + n2++;
            if (!hashSet.contains(string2)) continue;
            string2 = null;
        }
        return string2;
    }

    private void setSelectedConstraint(int n) {
        this._currentSelection = n;
        this.lstConstraints.setSelectedIndex(this._currentSelection);
    }

    private void setSelectedConstraint(Constraint constraint) {
        this.lstConstraints.setSelectedValue(constraint, true);
        this._currentSelection = this.lstConstraints.getSelectedIndex();
    }

    protected void constraintChanged(Constraint constraint) {
        if (this._con == null) {
            this._con = constraint;
        }
    }

    static JList ra$lstConstraints(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel.lstConstraints;
    }

    static void wa$_currentSelection(BaseConstraintPanel baseConstraintPanel, int n) {
        baseConstraintPanel._currentSelection = n;
    }

    static JButton ra$btnAdd(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel.btnAdd;
    }

    static void mav$_commitDetail(BaseConstraintPanel baseConstraintPanel, boolean bl) {
        baseConstraintPanel._commitDetail(bl);
    }

    static Relation ra$_relation(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel._relation;
    }

    static Constraint[] mav$_getConstraintsFromList(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel._getConstraintsFromList();
    }

    static DefaultListModel ra$_mdlCons(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel._mdlCons;
    }

    static void mav$setSelectedConstraint(BaseConstraintPanel baseConstraintPanel, int n) {
        baseConstraintPanel.setSelectedConstraint(n);
    }

    static void mav$_showConstraintError(BaseConstraintPanel baseConstraintPanel, TraversalException traversalException) {
        baseConstraintPanel._showConstraintError(traversalException);
    }

    static JButton ra$btnRemove(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel.btnRemove;
    }

    static Constraint ra$_con(BaseConstraintPanel baseConstraintPanel) {
        return baseConstraintPanel._con;
    }

    static void wa$_con(BaseConstraintPanel baseConstraintPanel, Constraint constraint) {
        baseConstraintPanel._con = constraint;
    }

    static void mav$_updateDetailPanel(BaseConstraintPanel baseConstraintPanel) {
        baseConstraintPanel._updateDetailPanel();
    }

    static void mav$_updateSelection(BaseConstraintPanel baseConstraintPanel) {
        baseConstraintPanel._updateSelection();
    }

    private final class EventHandler
    implements ListDataListener,
    ActionListener,
    ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                BaseConstraintPanel.mav$_updateSelection(BaseConstraintPanel.this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            BaseConstraintPanel.wa$_currentSelection(BaseConstraintPanel.this, BaseConstraintPanel.ra$lstConstraints(BaseConstraintPanel.this).getSelectedIndex());
            Object object = actionEvent.getSource();
            if (object == BaseConstraintPanel.ra$btnAdd(BaseConstraintPanel.this)) {
                try {
                    BaseConstraintPanel.mav$_commitDetail(BaseConstraintPanel.this, true);
                    Constraint constraint = BaseConstraintPanel.this.createNewConstraint();
                    constraint.setEnabled(true);
                    constraint.setName(BaseConstraintPanel.findUniqueName(BaseConstraintPanel.ra$_relation(BaseConstraintPanel.this), constraint, BaseConstraintPanel.mav$_getConstraintsFromList(BaseConstraintPanel.this)));
                    BaseConstraintPanel.ra$_relation(BaseConstraintPanel.this).addConstraint(constraint);
                    BaseConstraintPanel.ra$_mdlCons(BaseConstraintPanel.this).addElement(constraint);
                    int n2 = BaseConstraintPanel.ra$_mdlCons(BaseConstraintPanel.this).indexOf(constraint);
                    BaseConstraintPanel.mav$setSelectedConstraint(BaseConstraintPanel.this, n2);
                }
                catch (TraversalException traversalException) {
                    BaseConstraintPanel.mav$_showConstraintError(BaseConstraintPanel.this, traversalException);
                }
            } else if (object == BaseConstraintPanel.ra$btnRemove(BaseConstraintPanel.this) && (n = BaseConstraintPanel.ra$lstConstraints(BaseConstraintPanel.this).getSelectedIndex()) != -1) {
                BaseConstraintPanel.ra$_relation(BaseConstraintPanel.this).removeConstraint(BaseConstraintPanel.ra$_con(BaseConstraintPanel.this));
                BaseConstraintPanel.wa$_con(BaseConstraintPanel.this, null);
                int n3 = n == BaseConstraintPanel.ra$_mdlCons(BaseConstraintPanel.this).size() - 1 ? n - 1 : n + 1;
                BaseConstraintPanel.mav$setSelectedConstraint(BaseConstraintPanel.this, n3);
                BaseConstraintPanel.ra$_mdlCons(BaseConstraintPanel.this).remove(n);
                if (n3 == -1) {
                    BaseConstraintPanel.mav$_updateDetailPanel(BaseConstraintPanel.this);
                }
            }
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        private EventHandler() {
        }

        EventHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

