/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ide.db.panels.sql.WhereEditor;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.WhereObject;

public class WhereObjectPanel
extends BaseSQLQueryBuilderPanel {
    private JWrappedLabel m_desc;
    private JLabel m_labelWHERE;
    private JWrappedLabel m_usages;
    private JPanel m_wherePanel;
    private SQLQueryBuilder m_builder;
    private boolean m_incUsages;
    private String m_cachedWhereText;
    private Map m_cachedFKUsages;
    private WhereEditor m_whereEditor;

    private void $init$() {
        this.m_desc = new JWrappedLabel(UIArb.getString(194));
        this.m_labelWHERE = new JLabel();
        this.m_usages = new JWrappedLabel();
        this.m_whereEditor = new WhereEditor();
    }

    public WhereObjectPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout(0, 15));
        this.add((Component)this.m_desc, "North");
        this.m_wherePanel = new JPanel();
        this.m_wherePanel.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_labelWHERE, (Component)this.m_whereEditor.getDefaultComponent(), (String)"&WHERE");
        this.m_labelWHERE.setText("<html><b><u>W</u>HERE</b></html>");
        this.m_wherePanel.add((Component)this.m_labelWHERE, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_wherePanel.add((Component)this.m_whereEditor, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_wherePanel, "Center");
    }

    protected void init(SQLQueryBuilder sQLQueryBuilder, DBObject dBObject) {
        this.enableButtons(true);
        this.m_builder = sQLQueryBuilder;
        this.m_whereEditor.setTemplates(this.m_builder.listAllFromObjects(), this.m_builder.listAvailableFKs());
        WhereObject whereObject = this.m_builder.getSQLQuery().getWhereObject();
        this.m_whereEditor.init(whereObject, this.m_builder);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.m_builder != null && this.m_whereEditor.hasTextChanged()) {
            String string = this.m_whereEditor.getWhereText().trim();
            if (string != null && ModelUtil.hasLength((String)string)) {
                try {
                    SQLFragment sQLFragment = this.m_builder.parseWhereExpression(string);
                    WhereObject whereObject = sQLFragment instanceof WhereObject ? (WhereObject)sQLFragment : new WhereObject(sQLFragment);
                    this.m_builder.setWhereObject(whereObject);
                }
                catch (SQLQueryException sQLQueryException) {
                    throw new TraversalException(DBArb.getString((int)20) + sQLQueryException.getMessage());
                }
            } else {
                this.m_builder.setWhereObject(null);
            }
        }
    }
}

