/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.sql.ExpressionPanel;
import oracle.ide.db.panels.sql.FunctionComboBox;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.ExpressionEditSupport;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.completionfield.CompletionTextArea;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.FKUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SetOperation;
import oracle.javatools.db.sql.WhereObject;

public class WhereEditor
extends JPanel
implements ActionListener,
TreeSelectionListener,
MouseListener {
    public static final String AND = WhereObject.getOperatorText((int)372);
    public static final String OR = WhereObject.getOperatorText((int)373);
    private CompletionTextArea m_where;
    private JScrollPane m_scrollPane;
    private ExpressionEditSupport m_editSupport;
    private DefaultMutableTreeNode m_top;
    private DefaultTreeModel m_templatesModel;
    private JTree m_templates;
    private JLabel m_tempDesc;
    private JButton m_insertTempl;
    private JButton m_insertFunc;
    private FunctionComboBox m_functions;
    private TreeNodeMaker m_nodeMaker;
    private DBObjectRenderer m_rend;
    private String m_cachedWhere;
    private JButton m_and;
    private JButton m_or;
    private JButton m_pars;

    private void $init$() {
        this.m_where = new CompletionTextArea();
        this.m_scrollPane = new JScrollPane((Component)this.m_where, 20, 31);
        this.m_editSupport = new ExpressionEditSupport((JTextComponent)this.m_where);
        this.m_top = new DefaultMutableTreeNode("WHERE_TEMPS");
        this.m_templatesModel = new DefaultTreeModel(this.m_top);
        this.m_templates = new JTree(this.m_templatesModel);
        this.m_tempDesc = new JLabel();
        this.m_insertTempl = new JButton(IdeIcons.getIcon((int)19));
        this.m_insertFunc = new JButton(IdeIcons.getIcon((int)19));
        this.m_functions = new FunctionComboBox();
        this.m_nodeMaker = new TreeNodeMaker(false);
        this.m_rend = new DBObjectRenderer();
        this.m_and = new JButton();
        this.m_or = new JButton();
        this.m_pars = new JButton();
    }

    public WhereEditor() {
        this.$init$();
        this.m_rend.setIncludeIcon(true);
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void layoutComponents() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        this.setLayout(new GridBagLayout());
        this.m_where.setEditable(true);
        this.m_where.setLineWrap(true);
        this.m_where.setWrapStyleWord(true);
        this.add((Component)this.m_scrollPane, new GridBagConstraints(1, 0, 1, 5, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 15), 0, 0));
        this.setTemplatesLabel(UIArb.getString(117));
        this.add((Component)this.m_tempDesc, new GridBagConstraints(2, 0, 4, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        ExpressionPanel.setupButton(this.m_insertTempl, this, null, ExpressionPanel.EMPTY_INSETS);
        this.m_insertTempl.setMnemonic('c');
        this.m_insertTempl.setEnabled(false);
        toolTipManager.registerComponent(this.m_insertTempl);
        DBObjectRenderer.setToolTipText(this.m_insertTempl, UIArb.getString(200));
        this.add((Component)this.m_insertTempl, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_templates.setRootVisible(false);
        this.m_templates.setShowsRootHandles(true);
        this.m_templates.setEditable(false);
        this.m_templates.setExpandsSelectedPaths(true);
        this.m_templates.setCellRenderer(this.m_rend);
        this.m_templates.addMouseListener(this);
        this.m_templates.addTreeSelectionListener(this);
        this.m_templates.getSelectionModel().setSelectionMode(1);
        this.m_templates.setScrollsOnExpand(true);
        ToolTipManager.sharedInstance().registerComponent(this.m_templates);
        this.add((Component)new JScrollPane(this.m_templates), new GridBagConstraints(3, 1, 3, 2, 0.5, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        ExpressionPanel.setupButton(this.m_insertFunc, this, null, ExpressionPanel.EMPTY_INSETS);
        this.m_insertFunc.setMnemonic('f');
        toolTipManager.registerComponent(this.m_insertFunc);
        DBObjectRenderer.setToolTipText(this.m_insertFunc, UIArb.getString(199));
        this.add((Component)this.m_insertFunc, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_functions, new GridBagConstraints(3, 3, 3, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_and, (String)("&" + AND));
        this.m_and.addActionListener(this);
        toolTipManager.registerComponent(this.m_and);
        DBObjectRenderer.setToolTipText(this.m_and, UIArb.getString(196));
        this.add((Component)this.m_and, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_or, (String)("&" + OR));
        this.m_or.addActionListener(this);
        toolTipManager.registerComponent(this.m_or);
        DBObjectRenderer.setToolTipText(this.m_or, UIArb.getString(197));
        this.add((Component)this.m_or, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pars.setText("(...)");
        this.m_pars.addActionListener(this);
        this.m_pars.setMnemonic('9');
        toolTipManager.registerComponent(this.m_pars);
        DBObjectRenderer.setToolTipText(this.m_pars, UIArb.getString(198));
        this.add((Component)this.m_pars, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
    }

    public void setTemplatesLabel(String string) {
        ResourceUtils.resLabel((JLabel)this.m_tempDesc, (Component)this.m_templates, (String)string);
    }

    public void setTemplates(FromObject[] fromObjectArray, FKUsage[] fKUsageArray) {
        this.m_top.removeAllChildren();
        HashMap<FromObject, ArrayList<FKUsage>> hashMap = new HashMap<FromObject, ArrayList<FKUsage>>();
        int n = 0;
        while (fKUsageArray != null && n < fKUsageArray.length) {
            FromObject fromObject = fKUsageArray[n].getLeftFromObject();
            ArrayList<FKUsage> arrayList = (ArrayList<FKUsage>)hashMap.get(fromObject);
            if (arrayList == null) {
                arrayList = new ArrayList<FKUsage>();
                hashMap.put(fromObject, arrayList);
            }
            arrayList.add(fKUsageArray[n]);
            ++n;
        }
        int n2 = 0;
        while (fromObjectArray != null && n2 < fromObjectArray.length) {
            if (fromObjectArray[n2] != null && fromObjectArray[n2].getExpression() instanceof RelationUsage) {
                DefaultMutableTreeNode defaultMutableTreeNode = this.m_nodeMaker.createTreeNode((SQLFragment)fromObjectArray[n2], true);
                this.m_top.add(defaultMutableTreeNode);
                if (hashMap.containsKey(fromObjectArray[n2])) {
                    List list = (List)hashMap.get(fromObjectArray[n2]);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        defaultMutableTreeNode.add(this.m_nodeMaker.createTreeNode((SQLFragment)((FKUsage)iterator.next())));
                    }
                }
            }
            ++n2;
        }
        this.m_templatesModel.reload();
    }

    public void setFunctions(Collection collection) {
        this.m_functions.removeAllItems();
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(collection);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            this.m_functions.addItem(iterator.next());
        }
    }

    private void insertCurrentFunction() {
        Object object = this.m_functions.getSelectedItem();
        if (object instanceof SQLFragment) {
            this.addToWhere(((SQLFragment)object).getSQLText());
        } else {
            this.addToWhere(object.toString());
        }
        this.m_where.requestFocus();
    }

    private void insertCurrentTemplate() {
        Object object;
        TreePath treePath;
        if (this.m_templates != null && (treePath = this.m_templates.getSelectionPath()) != null && (object = treePath.getLastPathComponent()) != null && ((DefaultMutableTreeNode)object).isLeaf()) {
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            String string = null;
            if (object2 instanceof Column) {
                Object object3;
                FastStringBuffer fastStringBuffer = new FastStringBuffer();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getParent();
                Object object4 = object3 = defaultMutableTreeNode == null ? null : defaultMutableTreeNode.getUserObject();
                if (object3 != null && object3 instanceof FromObject) {
                    fastStringBuffer.append(((FromObject)object3).getName());
                    fastStringBuffer.append(".");
                } else {
                    Relation relation = ((Column)object2).getRelation();
                    if (relation != null) {
                        fastStringBuffer.append(relation.getName());
                    }
                }
                fastStringBuffer.append(((Column)object2).getName());
                string = fastStringBuffer.toString();
            } else if (object2 instanceof SQLFragment) {
                string = ((SQLFragment)object2).getSQLText();
            } else if (object2 instanceof DBObject) {
                string = DBUtil.getFullyQualifiedName((DBObject)((DBObject)object2));
            }
            this.addToWhere(string);
            this.m_where.requestFocus();
        }
    }

    private void addToWhere(String string) {
        this.m_editSupport.addToExpressionField(string);
    }

    public boolean hasTextChanged() {
        String string = this.m_where.getText();
        if (ModelUtil.hasLength((String)string)) {
            return ModelUtil.areDifferent((Object)this.m_cachedWhere, (Object)string);
        }
        return ModelUtil.hasLength((String)this.m_cachedWhere);
    }

    public void init(WhereObject whereObject, SQLQueryBuilder sQLQueryBuilder) {
        this.m_cachedWhere = whereObject == null ? null : whereObject.getSQLText();
        this.m_where.setText(this.m_cachedWhere);
        this.m_editSupport.clearUndo();
        if (sQLQueryBuilder != null) {
            HashSet<Object> hashSet = new HashSet<Object>();
            FromObject[] fromObjectArray = sQLQueryBuilder.listAllFromObjects();
            int n = 0;
            while (n < fromObjectArray.length) {
                hashSet.add(fromObjectArray[n]);
                ++n;
            }
            if (this.m_functions.getModel().getSize() == 0) {
                List<FunctionDefinition> list = Arrays.asList(sQLQueryBuilder.getBuiltInFunctions());
                this.setFunctions(list);
                hashSet.addAll(list);
            }
            hashSet.add(AND);
            hashSet.add(OR);
            hashSet.add(Comparison.getComparatorText((int)26));
            hashSet.add(Comparison.getComparatorText((int)27));
            hashSet.add(Comparison.getComparatorText((int)43));
            hashSet.add(Comparison.getComparatorText((int)44));
            hashSet.add(SetOperation.getSetOperator((int)704));
            hashSet.add(SetOperation.getSetOperator((int)706));
            hashSet.add(SetOperation.getSetOperator((int)705));
            hashSet.add(SetOperation.getSetOperator((int)707));
            this.m_editSupport.setInsightMap(ExpressionEditSupport.createInsightMap(fromObjectArray));
            this.m_editSupport.setInsightObjects(hashSet);
        }
    }

    public Component getDefaultComponent() {
        return this.m_where;
    }

    public String getWhereText() {
        return this.m_where.getText();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        TreePath treePath;
        Object object = mouseEvent.getSource();
        if (mouseEvent.getClickCount() % 2 == 0 && object == this.m_templates && (treePath = this.m_templates.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
            this.insertCurrentTemplate();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        this.m_templates.scrollPathToVisible(treePath);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        this.m_insertTempl.setEnabled(defaultMutableTreeNode.isLeaf());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_and) {
            this.addToWhere(AND);
        } else if (object == this.m_or) {
            this.addToWhere(OR);
        } else if (object == this.m_pars) {
            this.addToWhere("()");
        } else if (object == this.m_insertFunc) {
            this.insertCurrentFunction();
        } else if (object == this.m_insertTempl) {
            this.insertCurrentTemplate();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_and.setEnabled(bl);
        this.m_or.setEnabled(bl);
        this.m_pars.setEnabled(bl);
        this.m_templates.setEnabled(bl);
        this.m_scrollPane.setEnabled(bl);
        this.m_where.setEnabled(bl);
    }
}

