/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ide.db.panels.sql.ExpressionPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.ExpressionEditSupport;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.completionfield.CompletionTextField;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.sql.AliasInUseException;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;

public class SelectObjectsPanel
extends BaseSQLQueryBuilderPanel
implements ActionListener,
DocumentListener,
ExpressionPanel.FragmentProvider {
    public static final String FUNCTIONS_CAT = UIArb.getString(114);
    private static final String FROM_CAT = "FROM";
    private boolean m_init;
    private SQLQueryBuilder m_builder;
    private JWrappedLabel m_desc;
    private ExpressionPanel m_expPanel;
    private JPanel m_editor;
    private CompletionTextField m_expression;
    private ExpressionEditSupport m_editSupport;
    private JTextField m_alias;
    private JLabel m_expLabel;
    private JLabel m_aliasLabel;
    private JButton m_validate;
    private boolean m_commitPending;
    private SelectObject m_current;
    private boolean m_new;

    private void $init$() {
        this.m_desc = new JWrappedLabel(UIArb.getString(142));
        this.m_expression = new CompletionTextField();
        this.m_editSupport = new ExpressionEditSupport((JTextComponent)this.m_expression);
        this.m_alias = new JTextField();
        this.m_expLabel = new JLabel();
        this.m_aliasLabel = new JLabel();
        this.m_validate = new JButton();
    }

    public SelectObjectsPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.m_desc, "North");
        this.m_expPanel = new ExpressionPanel(this);
        this.add(this.m_expPanel, "Center");
    }

    public void init(SQLQueryBuilder sQLQueryBuilder, DBObject dBObject) {
        this.m_builder = sQLQueryBuilder;
        FunctionDefinition[] functionDefinitionArray = this.m_builder.getBuiltInFunctions();
        if (!this.m_init) {
            this.m_expPanel.setDBObjectProvider(this.m_pro);
            int n = 0;
            while (n < functionDefinitionArray.length) {
                this.m_expPanel.addFunction(functionDefinitionArray[n]);
                ++n;
            }
            this.m_init = true;
        }
        this.m_expPanel.clearTemplates();
        HashSet<Object> hashSet = new HashSet<Object>();
        FromObject[] fromObjectArray = this.m_builder.listAllFromObjects();
        int n = 0;
        while (n < fromObjectArray.length) {
            this.m_expPanel.addTemplate((SQLFragment)fromObjectArray[n], true);
            hashSet.add(fromObjectArray[n]);
            ++n;
        }
        hashSet.addAll(Arrays.asList(functionDefinitionArray));
        this.m_editSupport.setInsightMap(ExpressionEditSupport.createInsightMap(fromObjectArray));
        this.m_editSupport.setInsightObjects(hashSet);
        this.m_expPanel.setWizardCallbacks(this.m_wc, true);
        SelectObject selectObject = dBObject instanceof SelectObject ? (SelectObject)dBObject : null;
        this.m_expPanel.entered((SQLFragment[])this.m_builder.getSQLQuery().getSelectObjects(), (SQLFragment)selectObject);
        this.checkWizardButtons();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.m_expPanel.exited();
        if (this.m_builder != null) {
            try {
                this.m_builder.syncViewColumns();
            }
            catch (AliasInUseException aliasInUseException) {
                throw new TraversalException(aliasInUseException.getMessage());
            }
        }
    }

    private SelectObject newSelectObject() {
        SelectObject selectObject = new SelectObject();
        selectObject.setID(TemporaryObjectID.createID((DBObject)selectObject));
        return selectObject;
    }

    private void updateCurrentFrag() throws SQLQueryException {
        String string = this.m_expression.getText().trim();
        String string2 = this.m_alias.getText().trim();
        if (this.m_current != null) {
            SQLFragment sQLFragment = this.m_builder.parseSelectExpression(string);
            if (this.m_new) {
                this.m_current.setExpression(sQLFragment);
                this.m_current.setAlias(string2);
                this.m_builder.addSelectObject(this.m_current);
                this.m_new = false;
            } else {
                SelectObject selectObject = (SelectObject)this.m_current.copyTo(null);
                selectObject.setExpression(sQLFragment);
                selectObject.setAlias(string2);
                this.m_builder.replaceSelectObject(this.m_current, selectObject);
            }
            this.m_expPanel.repaint();
        }
    }

    private void enableComponents(boolean bl) {
        this.m_aliasLabel.setEnabled(bl);
        this.m_alias.setEnabled(bl);
        this.m_expLabel.setEnabled(bl);
        this.m_expression.setEnabled(bl);
        this.m_validate.setEnabled(bl);
        if (!bl) {
            this.m_alias.setText(null);
            this.m_expression.setText(null);
            this.m_commitPending = false;
        }
    }

    private void checkWizardButtons() {
        SelectObject[] selectObjectArray = this.m_builder.getSQLQuery().getSelectObjects();
        boolean bl = selectObjectArray != null && selectObjectArray.length > 0;
        this.setCanFinish(bl);
        this.enableButtons(bl);
    }

    public JPanel getEditorUI() {
        if (this.m_editor == null) {
            this.m_editor = new JPanel();
            this.m_editor.setLayout(new GridBagLayout());
            int n = 0;
            ResourceUtils.resLabel((JLabel)this.m_expLabel, (Component)this.m_expression, (String)UIArb.getString(113));
            this.m_editor.add((Component)this.m_expLabel, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
            ToolTipManager.sharedInstance().registerComponent((JComponent)this.m_expression);
            this.m_expression.getDocument().addDocumentListener(this);
            this.m_editor.add((Component)this.m_expression, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            ResourceUtils.resLabel((JLabel)this.m_aliasLabel, (Component)this.m_alias, (String)UIArb.getString(112));
            this.m_editor.add((Component)this.m_aliasLabel, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.m_alias.setColumns(30);
            this.m_alias.getDocument().addDocumentListener(this);
            this.m_editor.add((Component)this.m_alias, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.m_validate.addActionListener(this);
            ResourceUtils.resButton((AbstractButton)this.m_validate, (String)UIArb.getString(118));
            this.m_editor.add((Component)this.m_validate, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.m_editor.add((Component)Box.createVerticalBox(), new GridBagConstraints(1, n++, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.enableComponents(false);
        return this.m_editor;
    }

    public String getEditorName() {
        return UIArb.getString(145);
    }

    public String getListTitle() {
        return UIArb.getString(143);
    }

    public String getTemplateTitle() {
        return UIArb.getString(117);
    }

    public SQLFragment newFragment() {
        this.m_current = this.newSelectObject();
        this.edit((SQLFragment)this.m_current);
        this.m_commitPending = true;
        this.m_new = true;
        this.setCanFinish(true);
        this.enableButtons(true);
        return this.m_current;
    }

    public boolean removeFragment(SQLFragment sQLFragment) {
        boolean bl = false;
        if (this.m_new) {
            this.m_new = false;
            bl = true;
        } else {
            SQLFragment[] sQLFragmentArray = this.m_builder.getDependentObjects((SelectObject)sQLFragment);
            bl = sQLFragmentArray != null && sQLFragmentArray.length > 0 && !MessageDialog.confirm((Component)((Object)this), (Object)UIArb.getString(146), (String)UIArb.getString(147), null) ? false : this.m_builder.removeSelectObject((SelectObject)sQLFragment);
        }
        this.checkWizardButtons();
        return bl;
    }

    public void moveFragment(SQLFragment sQLFragment, int n) {
        this.m_builder.getSQLQuery().moveSelectObject((SelectObject)sQLFragment, n);
    }

    public void commit() throws TraversalException {
        if (this.m_commitPending) {
            SQLFragment sQLFragment = this.m_current == null ? null : this.m_current.getExpression();
            String string = sQLFragment == null ? null : sQLFragment.getSQLText();
            String string2 = this.m_expression.getText().trim();
            String string3 = this.m_current.getAlias();
            String string4 = this.m_alias.getText();
            if (ModelUtil.areDifferent((Object)string4, (Object)string3) || ModelUtil.areDifferent((Object)string2, (Object)string)) {
                try {
                    this.updateCurrentFrag();
                }
                catch (SQLQueryException sQLQueryException) {
                    throw new TraversalException(sQLQueryException.getMessage());
                }
            }
            this.m_commitPending = false;
        }
    }

    public void edit(SQLFragment sQLFragment) {
        this.m_editSupport.clearUndo();
        SelectObject selectObject = this.m_current = sQLFragment instanceof SelectObject ? (SelectObject)sQLFragment : null;
        if (this.m_current == null) {
            this.enableComponents(false);
        } else {
            this.enableComponents(true);
            this.m_alias.setText(this.m_current == null ? "" : this.m_current.getAlias());
            SQLFragment sQLFragment2 = this.m_current == null ? null : this.m_current.getExpression();
            this.m_expression.setText(sQLFragment2 == null ? "" : sQLFragment2.getSQLText());
            this.m_expression.requestFocusInWindow();
            this.m_expression.selectAll();
            this.m_commitPending = false;
        }
    }

    public void addToExpression(String string) {
        this.m_editSupport.addToExpressionField(string);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            this.updateCurrentFrag();
            String string2 = string = this.m_current == null ? null : this.m_current.getAlias();
            if (string != null && ModelUtil.areDifferent((Object)string, (Object)this.m_alias.getText())) {
                this.m_alias.setText(string);
            }
            DBObjectRenderer.setToolTipText((JComponent)this.m_expression, null);
        }
        catch (SQLQueryException sQLQueryException) {
            String string = sQLQueryException.getMessage();
            this.m_expPanel.showInvalidExpressionDialog(new TraversalException(string));
            DBObjectRenderer.setToolTipText((JComponent)this.m_expression, string);
        }
    }
}

