/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectSourcePicker;
import oracle.ide.db.panels.SelectDBObjectsPanel;
import oracle.ide.db.panels.sql.QueryTargetPicker;
import oracle.ide.db.panels.sql.QuickPickSourcePicker;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.View;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.AliasInUseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;

public class QuickPickObjectsPanel
extends SelectDBObjectsPanel {
    public static final String SETTINGS_KEY_DB = "QuickPickObjectsPanel_DB";
    public static final String SETTINGS_KEY_OTHER = "QuickPickObjectsPanel";
    private String[] m_types;
    private QueryTargetPicker m_toPick;
    private QuickPickSourcePicker m_fromPick;
    private boolean m_init;
    private SQLQueryBuilder m_builder;
    private String m_parseMessage;
    private boolean m_nondecl;
    private SchemaObject m_sObj;
    private boolean m_canAlwaysNext;

    private void $init$() {
        this.m_toPick = new QueryTargetPicker();
        this.m_canAlwaysNext = true;
    }

    public QuickPickObjectsPanel() {
        this.$init$();
        this.m_shuttle.setButtonsShown(13);
    }

    public QuickPickObjectsPanel(boolean bl) {
        this();
        this.m_canAlwaysNext = bl;
    }

    protected ItemPicker getToPicker() {
        return this.m_toPick;
    }

    protected DBObjectSourcePicker getFromPicker() {
        if (this.m_fromPick == null) {
            this.m_fromPick = new QuickPickSourcePicker(this.getProvider(), true, false);
            if (this.m_sObj instanceof View) {
                this.m_fromPick.setView((View)this.m_sObj);
            }
        }
        return this.m_fromPick;
    }

    protected String[] getAvailableTypes() {
        if (this.m_types == null) {
            this.m_types = new String[]{"TABLE", "VIEW"};
        }
        return this.m_types;
    }

    public void init(boolean bl, TraversableContext traversableContext) {
        Object object = traversableContext.get("NewObject");
        this.m_sObj = object instanceof SchemaObject ? (SchemaObject)object : null;
        this.m_builder = (SQLQueryBuilder)traversableContext.get("SQLQueryBuilder");
        Schema schema = this.m_sObj != null ? this.m_sObj.getSchema() : (Schema)traversableContext.get("Schema");
        super.init(bl, traversableContext);
        if (this.m_builder == null) {
            SQLQuery sQLQuery = null;
            if (object instanceof SQLQueryOwner) {
                sQLQuery = ((SQLQueryOwner)object).getSQLQuery();
            } else if (object instanceof SQLQuery) {
                sQLQuery = (SQLQuery)object;
            }
            try {
                this.m_builder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)this.getProvider(), (Schema)schema, (SQLQuery)sQLQuery);
            }
            catch (SQLQueryException sQLQueryException) {
                this.m_parseMessage = sQLQueryException.getMessage();
            }
            traversableContext.put("SQLQueryBuilder", (Object)this.m_builder);
        }
        if (this.m_builder == null) {
            this.m_toPick.clear();
            this.m_shuttle.setEnabled(false);
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add((Component)new JWrappedLabel(UIArb.getString(219)), "North");
            this.m_nondecl = true;
        } else {
            if (this.m_nondecl) {
                this.removeAll();
                this.layoutComponents();
                this.m_nondecl = false;
            }
            this.m_shuttle.setEnabled(true);
            this.m_toPick.setQueryBuilder(this.m_builder);
            this.m_toPick.loadQuery();
        }
    }

    public void commit(TraversableContext traversableContext) throws TraversalException {
        if (this.m_builder != null) {
            AbstractSQLQuery abstractSQLQuery = this.m_builder.getSQLQuery();
            abstractSQLQuery.setSelectObjects(this.m_toPick.getSelectList());
            Object object = traversableContext.get("NewObject");
            if (object instanceof SQLQueryOwner) {
                SQLQuery sQLQuery = ((SQLQueryOwner)object).getSQLQuery();
                if (sQLQuery != abstractSQLQuery) {
                    ((SQLQueryOwner)object).setSQLQuery((SQLQuery)abstractSQLQuery);
                }
            } else if (object instanceof SQLQuery && object != abstractSQLQuery) {
                traversableContext.put("NewObject", object);
            }
            this.m_toPick.removeNewEmptyFroms();
            try {
                this.m_builder.syncViewColumns();
            }
            catch (AliasInUseException aliasInUseException) {
                throw new TraversalException(aliasInUseException.getMessage());
            }
        }
    }

    protected boolean canFinish() {
        return true;
    }

    protected boolean canAlwaysNext() {
        return this.m_canAlwaysNext;
    }

    protected String getSettingsKey() {
        return this.getProvider() instanceof Database ? SETTINGS_KEY_DB : SETTINGS_KEY_OTHER;
    }
}

