/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.ide.Ide;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.UIArb;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.dialogs.ExceptionDialog;

public final class QueryTargetPicker
extends ReorderableListPicker {
    public static final String REMOVE_HELP_ID = null;
    private SQLQueryBuilder m_builder;
    private Map m_paths;
    private Collection m_newToMe;
    private Collection m_newFroms;

    private void $init$() {
        this.m_paths = new HashMap();
        this.m_newToMe = new ArrayList();
        this.m_newFroms = new HashSet();
    }

    public QueryTargetPicker() {
        this(new JList());
    }

    public QueryTargetPicker(JList jList) {
        super(jList);
        this.$init$();
        ToolTipManager.sharedInstance().registerComponent(jList);
    }

    public void setQueryBuilder(SQLQueryBuilder sQLQueryBuilder) {
        this.clear();
        this.m_builder = sQLQueryBuilder;
    }

    public SQLQueryBuilder getQueryBuilder() {
        return this.m_builder;
    }

    public void loadQuery() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getList().getModel();
        defaultListModel.removeAllElements();
        this.m_newToMe.clear();
        this.m_newFroms.clear();
        AbstractSQLQuery abstractSQLQuery = this.m_builder.getSQLQuery();
        SelectObject[] selectObjectArray = abstractSQLQuery.getSelectObjects();
        int n = 0;
        while (n < selectObjectArray.length) {
            defaultListModel.addElement(selectObjectArray[n]);
            ++n;
        }
    }

    private FromObject findOrCreateFromPath(List list) {
        FromObject fromObject = null;
        if (list != null && list.size() > 0) {
            if (this.m_paths.containsKey(list)) {
                fromObject = (FromObject)this.m_paths.get(list);
            } else {
                ArrayList arrayList = new ArrayList(list);
                try {
                    FromObject fromObject2 = null;
                    int n = list.size() - 1;
                    while (n >= 0) {
                        DBObject dBObject = (DBObject)list.get(n);
                        if (dBObject instanceof Relation) {
                            SQLQueryBuilder.SQLQueryObjectSet sQLQueryObjectSet = this.m_builder.constructFromObject((Relation)dBObject, false, false, null);
                            fromObject2 = fromObject = (FromObject)sQLQueryObjectSet.getObject();
                            this.m_paths.put(new ArrayList(arrayList), fromObject);
                            this.m_newFroms.add(fromObject);
                            arrayList.remove(n);
                        } else if (dBObject instanceof FKConstraint) {
                            arrayList.remove(n);
                            Relation relation = (Relation)list.get(--n);
                            FromObject fromObject3 = null;
                            boolean bl = false;
                            if (this.m_paths.containsKey(arrayList)) {
                                fromObject3 = (FromObject)this.m_paths.get(arrayList);
                                bl = true;
                            } else {
                                SQLQueryBuilder.SQLQueryObjectSet sQLQueryObjectSet = this.m_builder.constructFromObject(relation, false, false, null);
                                fromObject3 = (FromObject)sQLQueryObjectSet.getObject();
                                this.m_paths.put(new ArrayList(arrayList), fromObject3);
                                this.m_newFroms.add(fromObject3);
                            }
                            arrayList.remove(n);
                            if (fromObject2.getExpression() instanceof JoinObject) {
                                fromObject2 = ((JoinObject)fromObject2.getExpression()).getLeftExpression();
                            }
                            SQLQueryBuilder.SQLQueryObjectSet sQLQueryObjectSet = this.m_builder.constructFKJoin((FKConstraint)dBObject, fromObject3, fromObject2);
                            fromObject2 = (FromObject)fromObject3.getParent().getParent();
                            if (bl) break;
                        }
                        --n;
                    }
                }
                catch (SQLQueryException sQLQueryException) {
                    ExceptionDialog.showExceptionDialog((Component)this.getComponent(), (Throwable)sQLQueryException);
                }
            }
        }
        return fromObject;
    }

    public SelectObject[] getSelectList() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getList().getModel();
        SelectObject[] selectObjectArray = new SelectObject[defaultListModel.getSize()];
        int n = 0;
        while (n < selectObjectArray.length) {
            selectObjectArray[n] = (SelectObject)defaultListModel.get(n);
            ++n;
        }
        return selectObjectArray;
    }

    public boolean addSelectedItems(Transferable[] transferableArray) {
        int n = 0;
        while (n < transferableArray.length && this.m_builder != null) {
            if (transferableArray[n] instanceof DBObjectTransferable) {
                DBObject dBObject = ((DBObjectTransferable)transferableArray[n]).getDBObject();
                DBObject[] dBObjectArray = ((DBObjectTransferable)transferableArray[n]).getPath();
                if (dBObject instanceof Relation || dBObject instanceof Column) {
                    ArrayList<DBObject> arrayList = new ArrayList<DBObject>(Arrays.asList(dBObjectArray));
                    try {
                        if (dBObject instanceof Relation) {
                            FromObject fromObject = this.findOrCreateFromPath(arrayList);
                            if (this.m_builder.getFromObject(fromObject.getName()) != fromObject) {
                                this.m_builder.addFromObject(fromObject);
                                this.m_newFroms.add(fromObject);
                            }
                            Column[] columnArray = ((Relation)dBObject).getColumns();
                            SQLQueryBuilder.SQLQueryObjectSet sQLQueryObjectSet = this.m_builder.constructSelectObjects(columnArray, new FromObject[]{fromObject});
                            SelectObject[] selectObjectArray = sQLQueryObjectSet.getSelectObjects();
                            int n2 = 0;
                            while (n2 < selectObjectArray.length) {
                                DBObjectID dBObjectID = TemporaryObjectID.createID((DBObject)selectObjectArray[n2]);
                                selectObjectArray[n2].setID(dBObjectID);
                                ((DefaultListModel)this.getList().getModel()).addElement(selectObjectArray[n2]);
                                this.m_newToMe.add(selectObjectArray[n2]);
                                ++n2;
                            }
                        } else if (dBObject instanceof Column) {
                            arrayList.remove(dBObject);
                            FromObject fromObject = this.findOrCreateFromPath(arrayList);
                            SQLQueryBuilder.SQLQueryObjectSet sQLQueryObjectSet = this.m_builder.constructSelectObject((Column)dBObject, fromObject);
                            SelectObject selectObject = (SelectObject)sQLQueryObjectSet.getObject();
                            DBObjectID dBObjectID = TemporaryObjectID.createID((DBObject)selectObject);
                            selectObject.setID(dBObjectID);
                            ((DefaultListModel)this.getList().getModel()).addElement(selectObject);
                            this.m_newToMe.add(selectObject);
                        }
                    }
                    catch (SQLQueryException sQLQueryException) {
                        ExceptionDialog.showExceptionDialog((Component)this.getComponent(), (Throwable)sQLQueryException);
                    }
                } else if (dBObject instanceof FKConstraint) {
                    // empty if block
                }
            }
            ++n;
        }
        return true;
    }

    protected Transferable createTransferable(Object object) {
        SQLFragment sQLFragment;
        if (object instanceof SelectObject && (sQLFragment = ((SelectObject)object).getExpression()) instanceof ColumnUsage) {
            DBObjectID dBObjectID = ((ColumnUsage)sQLFragment).getObjectID();
            try {
                DBObjectTransferable dBObjectTransferable = new DBObjectTransferable(dBObjectID.resolveID());
                return dBObjectTransferable;
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
            }
        }
        return new DBObjectTransferable(null);
    }

    public void removeAllSelectableItems() {
        this.getList().setSelectionInterval(0, this.getList().getModel().getSize() - 1);
        this.removeSelectedItems();
    }

    public void removeSelectedItems() {
        ListModel listModel = this.getList().getModel();
        if (!(listModel instanceof DefaultListModel)) {
            return;
        }
        boolean bl = true;
        DefaultListModel defaultListModel = (DefaultListModel)listModel;
        Object[] objectArray = this.getList().getSelectedValues();
        int n = 0;
        while (n < objectArray.length) {
            if (!this.m_newToMe.contains(objectArray[n])) {
                bl = false;
            }
            ++n;
        }
        if (!bl) {
            bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UIArb.getString(182), (String)UIArb.getString(183), (String)REMOVE_HELP_ID, (boolean)true);
        }
        if (bl) {
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] instanceof SelectObject) {
                    this.m_builder.removeSelectObject((SelectObject)objectArray[n2]);
                    defaultListModel.removeElement(objectArray[n2]);
                }
                ++n2;
            }
        }
    }

    void clear() {
        super.removeAllSelectableItems();
    }

    void removeNewEmptyFroms() {
        FromObject[] fromObjectArray = this.m_builder.getSQLQuery().getFromObjects();
        int n = 0;
        while (n < fromObjectArray.length) {
            if (this.canRemove(fromObjectArray[n])) {
                this.m_builder.removeFromObject(fromObjectArray[n]);
                for (Map.Entry entry : this.m_paths.entrySet()) {
                    if (entry.getValue() != fromObjectArray[n]) continue;
                    this.m_paths.remove(entry.getKey());
                    break;
                }
            }
            ++n;
        }
    }

    private boolean canRemove(FromObject fromObject) {
        SQLFragment sQLFragment = fromObject.getExpression();
        if (sQLFragment instanceof JoinObject) {
            FromObject fromObject2 = ((JoinObject)sQLFragment).getLeftExpression();
            if (!this.canRemove(fromObject2)) {
                return false;
            }
            FromObject fromObject3 = ((JoinObject)sQLFragment).getRightExpression();
            return this.canRemove(fromObject3);
        }
        if (this.m_newFroms.contains(fromObject)) {
            Object[] objectArray = this.m_builder.getDependentObjects(fromObject);
            return ModelUtil.hasNonNullElement((Object[])objectArray) ^ true;
        }
        return false;
    }
}

