/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ide.db.panels.sql.ExpressionPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.ExpressionEditSupport;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.completionfield.CompletionTextField;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.View;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;

public class OrderByPanel
extends BaseSQLQueryBuilderPanel
implements ExpressionPanel.FragmentProvider,
DocumentListener,
ActionListener {
    private SQLQueryBuilder m_builder;
    private JWrappedLabel m_desc;
    private ExpressionPanel m_expPanel;
    private boolean m_init;
    private JPanel m_editor;
    private JLabel m_expLabel;
    private CompletionTextField m_exp;
    private ExpressionEditSupport m_editSupport;
    private JLabel m_ascLabel;
    private JComboBox m_asc;
    private JLabel m_nullsLabel;
    private JComboBox m_nulls;
    private JButton m_validate;
    private OrderByObject m_current;
    private boolean m_commitPending;
    private boolean m_new;

    private void $init$() {
        this.m_desc = new JWrappedLabel(UIArb.getString(205));
        this.m_expLabel = new JLabel();
        this.m_exp = new CompletionTextField();
        this.m_editSupport = new ExpressionEditSupport((JTextComponent)this.m_exp);
        this.m_ascLabel = new JLabel();
        this.m_asc = new JComboBox();
        this.m_nullsLabel = new JLabel();
        this.m_nulls = new JComboBox();
        this.m_validate = new JButton();
    }

    public OrderByPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void layoutComponents() {
        String string;
        DBObject dBObject = this.m_builder.getSQLQuery().getParent();
        String string2 = string = dBObject instanceof View ? ((View)dBObject).getQueryRestriction() : null;
        if (ModelUtil.hasLength((String)string)) {
            this.layoutMessageOnly(UIArb.format(211, string));
        } else {
            this.setLayout(new BorderLayout(0, 5));
            this.add((Component)this.m_desc, "North");
            if (this.m_expPanel == null) {
                this.m_expPanel = new ExpressionPanel(this);
            }
            this.add(this.m_expPanel, "Center");
        }
    }

    protected void init(SQLQueryBuilder sQLQueryBuilder, DBObject dBObject) {
        this.m_builder = sQLQueryBuilder;
        this.enableButtons(true);
        this.layoutComponents();
        FunctionDefinition[] functionDefinitionArray = this.m_builder.getBuiltInFunctions();
        if (!this.m_init) {
            this.m_expPanel.setDBObjectProvider(this.m_pro);
            int n = 0;
            while (n < functionDefinitionArray.length) {
                this.m_expPanel.addFunction(functionDefinitionArray[n]);
                ++n;
            }
            this.m_init = true;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        this.m_expPanel.clearTemplates();
        FromObject[] fromObjectArray = this.m_builder.listAllFromObjects();
        int n = 0;
        while (n < fromObjectArray.length) {
            this.m_expPanel.addTemplate((SQLFragment)fromObjectArray[n], true);
            hashSet.add(fromObjectArray[n]);
            ++n;
        }
        hashSet.addAll(Arrays.asList(functionDefinitionArray));
        this.m_editSupport.setInsightMap(ExpressionEditSupport.createInsightMap(fromObjectArray));
        this.m_editSupport.setInsightObjects(hashSet);
        this.m_expPanel.setWizardCallbacks(this.m_wc, true);
        OrderByObject orderByObject = dBObject instanceof OrderByObject ? (OrderByObject)dBObject : null;
        this.m_expPanel.entered((SQLFragment[])this.m_builder.getSQLQuery().getOrderByObjects(), (SQLFragment)orderByObject);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.m_expPanel.exited();
    }

    private void updateCurrentFrag() throws SQLQueryException {
        String string = this.m_exp.getText().trim();
        if (this.m_current != null) {
            OrderByObject orderByObject = new OrderByObject(this.m_current.getExpression(), this.m_current.getOrder(), this.m_current.getNullOrdering());
            SQLFragment sQLFragment = this.m_builder.parseOrderByExpression(string);
            this.m_current.setExpression(sQLFragment);
            this.m_current.setOrder((String)this.m_asc.getSelectedItem());
            this.m_current.setNullOrdering((String)this.m_nulls.getSelectedItem());
            if (this.m_new) {
                this.m_builder.addOrderByObject(this.m_current);
                this.m_new = false;
            } else {
                this.m_builder.replaceOrderByObject(orderByObject, this.m_current);
            }
        }
    }

    private void enableComponents(boolean bl) {
        this.m_expLabel.setEnabled(bl);
        this.m_exp.setEnabled(bl);
        this.m_ascLabel.setEnabled(bl);
        this.m_asc.setEnabled(bl);
        this.m_nullsLabel.setEnabled(bl);
        this.m_nulls.setEnabled(bl);
        this.m_validate.setEnabled(bl);
        if (!bl) {
            this.m_exp.setText(null);
            this.m_asc.setSelectedItem("");
            this.m_nulls.setSelectedItem("");
            this.m_commitPending = false;
        }
    }

    public SQLFragment newFragment() {
        this.m_current = new OrderByObject();
        this.edit((SQLFragment)this.m_current);
        this.m_commitPending = true;
        this.m_new = true;
        return this.m_current;
    }

    public boolean removeFragment(SQLFragment sQLFragment) {
        if (this.m_new) {
            this.m_new = false;
            return true;
        }
        return this.m_builder.removeOrderByObject((OrderByObject)sQLFragment);
    }

    public void moveFragment(SQLFragment sQLFragment, int n) {
        this.m_builder.getSQLQuery().moveOrderByObject((OrderByObject)sQLFragment, n);
    }

    public void commit() throws TraversalException {
        if (this.m_commitPending) {
            SQLFragment sQLFragment = this.m_current == null ? null : this.m_current.getExpression();
            String string = sQLFragment == null ? null : sQLFragment.getSQLText();
            String string2 = this.m_exp.getText().trim();
            if (ModelUtil.areDifferent((Object)string2, (Object)string)) {
                try {
                    this.updateCurrentFrag();
                }
                catch (SQLQueryException sQLQueryException) {
                    throw new TraversalException(UIArb.getString(116) + " " + sQLQueryException.getMessage());
                }
            } else {
                this.m_current.setNullOrdering((String)this.m_nulls.getSelectedItem());
                this.m_current.setOrder((String)this.m_asc.getSelectedItem());
            }
            this.m_commitPending = false;
        }
    }

    public void edit(SQLFragment sQLFragment) {
        this.m_editSupport.clearUndo();
        OrderByObject orderByObject = this.m_current = sQLFragment instanceof OrderByObject ? (OrderByObject)sQLFragment : null;
        if (this.m_current == null) {
            this.enableComponents(false);
        } else {
            this.enableComponents(true);
            SQLFragment sQLFragment2 = this.m_current == null ? null : this.m_current.getExpression();
            this.m_exp.getDocument().removeDocumentListener(this);
            this.m_exp.setText(sQLFragment2 == null ? "" : sQLFragment2.getSQLText());
            this.m_exp.getDocument().addDocumentListener(this);
            String string = this.m_current.getOrder();
            string = ModelUtil.hasLength((String)string) ? string.toUpperCase() : "";
            String string2 = this.m_current.getNullOrdering();
            string2 = ModelUtil.hasLength((String)string2) ? string2.toUpperCase() : "";
            this.m_asc.setSelectedItem(string);
            this.m_nulls.setSelectedItem(string2);
            this.m_exp.requestFocusInWindow();
            this.m_exp.selectAll();
            this.m_commitPending = false;
        }
    }

    public JPanel getEditorUI() {
        if (this.m_editor == null) {
            this.m_editor = new JPanel();
            this.m_editor.setLayout(new GridBagLayout());
            ToolTipManager.sharedInstance().registerComponent((JComponent)this.m_exp);
            ResourceUtils.resLabel((JLabel)this.m_expLabel, (Component)this.m_exp, (String)UIArb.getString(113));
            this.m_editor.add((Component)this.m_expLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.m_editor.add((Component)this.m_exp, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.m_validate.addActionListener(this);
            ResourceUtils.resButton((AbstractButton)this.m_validate, (String)UIArb.getString(118));
            this.m_editor.add((Component)this.m_validate, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.m_asc.addActionListener(this);
            ResourceUtils.resLabel((JLabel)this.m_ascLabel, (Component)this.m_asc, (String)UIArb.getString(207));
            this.m_editor.add((Component)this.m_ascLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.m_asc.setEditable(false);
            this.m_asc.addItem("");
            this.m_asc.addItem("ASC");
            this.m_asc.addItem("DESC");
            this.m_editor.add((Component)this.m_asc, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            ResourceUtils.resLabel((JLabel)this.m_nullsLabel, (Component)this.m_nulls, (String)UIArb.getString(208));
            this.m_editor.add((Component)this.m_nullsLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.m_nulls.addActionListener(this);
            this.m_nulls.setEditable(false);
            this.m_nulls.addItem("");
            this.m_nulls.addItem("NULLS FIRST");
            this.m_nulls.addItem("NULLS LAST");
            this.m_editor.add((Component)this.m_nulls, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.m_editor.add(Box.createVerticalGlue(), new GridBagConstraints(1, 6, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.enableComponents(false);
        return this.m_editor;
    }

    public void addToExpression(String string) {
        this.m_editSupport.addToExpressionField(string);
    }

    public String getEditorName() {
        return UIArb.getString(209);
    }

    public String getListTitle() {
        return UIArb.getString(206);
    }

    public String getTemplateTitle() {
        return UIArb.getString(117);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_validate) {
            try {
                this.updateCurrentFrag();
                DBObjectRenderer.setToolTipText((JComponent)this.m_exp, null);
                this.m_expPanel.repaint();
            }
            catch (SQLQueryException sQLQueryException) {
                String string = sQLQueryException.getMessage();
                this.m_expPanel.showInvalidExpressionDialog(new TraversalException(string));
                DBObjectRenderer.setToolTipText((JComponent)this.m_exp, string);
            }
        } else {
            this.m_commitPending = true;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }
}

