/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.ide.db.panels.sql.GroupByFromPicker;
import oracle.javatools.db.Column;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.SQLQueryBuilder;

public class GroupByToPicker
extends ReorderableListPicker {
    private SQLQueryBuilder m_builder;
    private JList m_list;
    private DefaultListModel m_model;
    private Map m_transferables;

    private void $init$() {
        this.m_transferables = new HashMap();
    }

    public GroupByToPicker() {
        super(new JList(new DefaultListModel()));
        this.$init$();
        this.m_list = super.getList();
        this.m_model = (DefaultListModel)this.m_list.getModel();
    }

    public void setBuilder(SQLQueryBuilder sQLQueryBuilder) {
        this.m_builder = sQLQueryBuilder;
        this.initList();
    }

    private void initList() {
        this.m_model.removeAllElements();
        GroupByObject groupByObject = this.m_builder.getSQLQuery().getGroupByObject();
        if (groupByObject != null) {
            FromObjectUsage[] fromObjectUsageArray = groupByObject.getExpressions();
            int n = 0;
            while (n < fromObjectUsageArray.length) {
                this.m_model.addElement(fromObjectUsageArray[n]);
                ++n;
            }
        }
    }

    public FromObjectUsage[] getExpressions() {
        int n = this.m_model.getSize();
        if (n > 0) {
            FromObjectUsage[] fromObjectUsageArray = new FromObjectUsage[n];
            int n2 = 0;
            while (n2 < fromObjectUsageArray.length) {
                fromObjectUsageArray[n2] = (FromObjectUsage)this.m_model.get(n2);
                ++n2;
            }
            return fromObjectUsageArray;
        }
        return null;
    }

    protected Transferable createTransferable(Object object) {
        if (this.m_transferables.containsKey(object)) {
            return (GroupByFromPicker.GroupByTransferable)this.m_transferables.get(object);
        }
        return null;
    }

    public boolean addSelectedItems(Transferable[] transferableArray) {
        int[] nArray = new int[transferableArray.length];
        int n = this.m_model.getSize();
        int n2 = 0;
        while (n2 < transferableArray.length) {
            Column column = ((GroupByFromPicker.GroupByTransferable)transferableArray[n2]).getColumn();
            FromObject fromObject = ((GroupByFromPicker.GroupByTransferable)transferableArray[n2]).getFromObject();
            ColumnUsage columnUsage = new ColumnUsage(column.getID(), fromObject);
            this.m_model.add(n, columnUsage);
            nArray[n2] = n++;
            this.m_transferables.put(columnUsage, transferableArray[n2]);
            ++n2;
        }
        this.m_list.setSelectedIndices(nArray);
        return true;
    }

    public boolean canAcceptFlavors(DataFlavor[] dataFlavorArray) {
        int n = 0;
        while (dataFlavorArray != null && n < dataFlavorArray.length) {
            if (dataFlavorArray[n] == GroupByFromPicker.TRANSFERABLE_FLAVOR) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

