/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ide.db.panels.sql.GroupByFromPicker;
import oracle.ide.db.panels.sql.GroupByToPicker;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.SQLQueryBuilder;

public class GroupByPanel
extends BaseSQLQueryBuilderPanel
implements ShuttleListener {
    private SQLQueryBuilder m_builder;
    private JWrappedLabel m_desc;
    private Shuttle m_shuttle;
    private GroupByFromPicker m_from;
    private GroupByToPicker m_to;
    private boolean m_layoutGroupBy;

    private void $init$() {
        this.m_desc = new JWrappedLabel();
        this.m_shuttle = new Shuttle();
    }

    public GroupByPanel() {
        this.$init$();
    }

    protected void layoutComponents() {
        if (this.m_builder != null) {
            if (this.m_builder.canSetGroupBy()) {
                if (!this.m_layoutGroupBy) {
                    this.layoutGroupBy();
                    this.m_layoutGroupBy = true;
                }
                this.m_from.setBuilder(this.m_builder);
                this.m_to.setBuilder(this.m_builder);
            } else {
                this.layoutMessageOnly(UIArb.getString(202));
                this.m_layoutGroupBy = false;
            }
        }
    }

    private void layoutGroupBy() {
        this.removeAll();
        this.setLayout(new BorderLayout(15, 0));
        this.m_desc.setText(UIArb.getString(201));
        this.add((Component)this.m_desc, "North");
        this.m_from = new GroupByFromPicker();
        this.m_to = new GroupByToPicker();
        this.m_shuttle.setFromPicker((ItemPicker)this.m_from);
        this.m_shuttle.setToPicker((ItemPicker)this.m_to);
        this.m_shuttle.addShuttleListener((ShuttleListener)this);
        this.add((Component)this.m_shuttle, "Center");
    }

    protected void init(SQLQueryBuilder sQLQueryBuilder, DBObject dBObject) {
        this.m_builder = sQLQueryBuilder;
        this.enableButtons(true);
        this.layoutComponents();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.m_builder != null && this.m_builder.canSetGroupBy()) {
            FromObjectUsage[] fromObjectUsageArray = this.m_to.getExpressions();
            if (fromObjectUsageArray != null && fromObjectUsageArray.length > 0) {
                GroupByObject groupByObject = this.m_builder.getSQLQuery().getGroupByObject();
                this.m_builder.setGroupByObject(new GroupByObject(fromObjectUsageArray, groupByObject == null ? null : groupByObject.getHaving()));
            } else {
                this.m_builder.setGroupByObject(null);
            }
        }
    }

    public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
    }

    public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
    }

    public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
    }
}

