/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.db.DBIcons;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.sql.FunctionComboBox;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SQLFragment;

public class ExpressionPanel
extends JPanel
implements FocusListener,
TreeSelectionListener,
KeyListener,
MouseListener,
ListSelectionListener,
ActionListener {
    public static final String EMPTY = "<" + UIArb.getString(111) + ">";
    private TreeNodeMaker m_nodeMaker;
    private DBObjectProvider m_dboPro;
    private FragmentProvider m_pro;
    private WizardCallbacks m_wizCallbacks;
    private boolean m_canFinish;
    private Timer m_timer;
    private boolean m_docUpdating;
    private SQLFragment m_current;
    private boolean m_ignoreList;
    private boolean m_entered;
    private JSplitPane m_expPanel;
    private JPanel m_templPanel;
    private DefaultMutableTreeNode m_top;
    private DefaultTreeModel m_templModel;
    private JTree m_templates;
    private Map m_categories;
    private FunctionComboBox m_functions;
    private JButton m_insertTemplate;
    private JButton m_insertFunction;
    private JLabel m_templateLabel;
    private JLabel m_functionLabel;
    private JPanel m_listPanel;
    private DefaultListModel m_expressionsModel;
    private JList m_expressions;
    private JButton m_new;
    private JButton m_remove;
    private JButton m_up;
    private JButton m_down;
    private JLabel m_listLabel;
    protected static final Dimension BUTTON_SIZE = new Dimension(28, 25);
    protected static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);

    private void $init$() {
        this.m_nodeMaker = new TreeNodeMaker(false);
        this.m_expressionsModel = new DefaultListModel();
        this.m_expressions = new JList(this.m_expressionsModel);
        this.m_new = new JButton();
        this.m_remove = new JButton();
        this.m_up = new JButton();
        this.m_down = new JButton();
        this.m_listLabel = new JLabel();
    }

    public ExpressionPanel(FragmentProvider fragmentProvider) {
        this.$init$();
        this.m_pro = fragmentProvider;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new GridLayout(2, 1, 0, 5));
        this.createListPanel();
        this.add(this.m_listPanel);
        this.createExpressionPanel();
        this.add(this.m_expPanel);
    }

    private void createListPanel() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        this.m_listPanel = new JPanel();
        this.m_listPanel.setLayout(new GridBagLayout());
        this.m_expressions.setSelectionMode(2);
        this.m_expressions.setCellRenderer(new DBObjectRenderer(false));
        this.m_expressions.addListSelectionListener(this);
        this.m_expressions.addKeyListener(this);
        this.m_listPanel.add((Component)new JScrollPane(this.m_expressions), new GridBagConstraints(1, 2, 1, 5, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
        ResourceUtils.resLabel((JLabel)this.m_listLabel, (Component)this.m_expressions, (String)this.m_pro.getListTitle());
        this.m_listPanel.add((Component)this.m_listLabel, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        Insets insets = new Insets(0, 0, 5, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0);
        this.m_new.setIcon(DBIcons.getIcon(0));
        DBObjectRenderer.setToolTipText(this.m_new, UIArb.getString(119));
        this.m_new.setMnemonic('=');
        ExpressionPanel.setupButton(this.m_new, this, BUTTON_SIZE, null);
        toolTipManager.registerComponent(this.m_new);
        this.m_listPanel.add((Component)this.m_new, gridBagConstraints);
        DBObjectRenderer.setToolTipText(this.m_remove, UIArb.getString(120));
        this.m_remove.setIcon(DBIcons.getIcon(1));
        this.m_remove.setMnemonic('-');
        ExpressionPanel.setupButton(this.m_remove, this, BUTTON_SIZE, null);
        toolTipManager.registerComponent(this.m_remove);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 10;
        this.m_listPanel.add((Component)this.m_remove, gridBagConstraints);
        DBObjectRenderer.setToolTipText(this.m_up, UIArb.getString(123));
        this.m_up.setIcon(ComponentArb.getIcon((int)0));
        this.m_up.setDisabledIcon(ComponentArb.getIcon((int)2));
        this.m_up.setMnemonic('u');
        ExpressionPanel.setupButton(this.m_up, this, BUTTON_SIZE, null);
        toolTipManager.registerComponent(this.m_up);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 5;
        this.m_listPanel.add((Component)this.m_up, gridBagConstraints);
        DBObjectRenderer.setToolTipText(this.m_down, UIArb.getString(124));
        this.m_down.setIcon(ComponentArb.getIcon((int)1));
        this.m_down.setDisabledIcon(ComponentArb.getIcon((int)3));
        this.m_down.setMnemonic('d');
        ExpressionPanel.setupButton(this.m_down, this, BUTTON_SIZE, null);
        toolTipManager.registerComponent(this.m_down);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 0;
        this.m_listPanel.add((Component)this.m_down, gridBagConstraints);
    }

    private void createExpressionPanel() {
        this.m_templPanel = new JPanel();
        this.m_templPanel.setLayout(new GridBagLayout());
        this.m_expPanel = new JSplitPane(1, this.m_pro.getEditorUI(), this.m_templPanel);
        this.m_expPanel.setBorder(BorderFactory.createTitledBorder(this.m_pro.getEditorName()));
    }

    private void addTemplateBits() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        this.m_templateLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.m_templateLabel, (Component)this.m_templates, (String)this.m_pro.getTemplateTitle());
        this.m_templPanel.add((Component)this.m_templateLabel, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.m_insertTemplate = new JButton(IdeIcons.getIcon((int)19));
        DBObjectRenderer.setToolTipText(this.m_insertTemplate, UIArb.getString(122));
        this.m_insertTemplate.setMnemonic('c');
        toolTipManager.registerComponent(this.m_insertTemplate);
        ExpressionPanel.setupButton(this.m_insertTemplate, this, null, EMPTY_INSETS);
        this.m_templPanel.add((Component)this.m_insertTemplate, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.m_top = new DefaultMutableTreeNode("PICKER");
        this.m_templModel = new DefaultTreeModel(this.m_top);
        this.m_templates = new JTree(this.m_templModel);
        this.m_templates.setRootVisible(false);
        this.m_templates.setShowsRootHandles(true);
        this.m_templates.setEditable(false);
        this.m_templates.setExpandsSelectedPaths(true);
        this.m_templates.setCellRenderer(new DBObjectRenderer(true));
        this.m_templates.addMouseListener(this);
        this.m_templates.addTreeSelectionListener(this);
        this.m_templates.getSelectionModel().setSelectionMode(1);
        this.m_templates.setScrollsOnExpand(true);
        this.m_templates.addFocusListener(this);
        toolTipManager.registerComponent(this.m_templates);
        this.m_templPanel.add((Component)new JScrollPane(this.m_templates), new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 5), 0, 0));
    }

    private void addFunctionBits() {
        this.m_insertFunction = new JButton(IdeIcons.getIcon((int)19));
        DBObjectRenderer.setToolTipText(this.m_insertFunction, UIArb.getString(121));
        this.m_insertFunction.setMnemonic('t');
        ToolTipManager.sharedInstance().registerComponent(this.m_insertFunction);
        ExpressionPanel.setupButton(this.m_insertFunction, this, null, EMPTY_INSETS);
        this.m_templPanel.add((Component)this.m_insertFunction, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.m_functions = new FunctionComboBox();
        this.m_templPanel.add((Component)this.m_functions, new GridBagConstraints(3, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
    }

    protected void initExpression() {
        Object e = this.m_expressions.getSelectedValue();
        this.m_current = null;
        if (e instanceof SQLFragment) {
            this.m_current = (SQLFragment)e;
        }
        this.m_pro.edit(this.m_current);
    }

    public SQLFragment[] getExpressions() {
        int n = this.m_expressionsModel.getSize();
        SQLFragment[] sQLFragmentArray = new SQLFragment[n];
        int n2 = 0;
        while (n2 < n) {
            sQLFragmentArray[n2] = (SQLFragment)this.m_expressionsModel.getElementAt(n2);
            ++n2;
        }
        return sQLFragmentArray;
    }

    public void addFunction(Object object) {
        if (this.m_functions == null) {
            this.addFunctionBits();
        }
        this.m_functions.addItem(object);
    }

    public void addTemplate(SQLFragment sQLFragment, boolean bl) {
        if (this.m_templates == null) {
            this.addTemplateBits();
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.m_nodeMaker.createTreeNode(sQLFragment, bl);
        this.m_templModel.insertNodeInto(defaultMutableTreeNode, this.m_top, this.m_top.getChildCount());
    }

    public void clearTemplates() {
        if (this.m_templModel != null) {
            this.m_top.removeAllChildren();
            this.m_templModel.reload();
        }
    }

    public void setDBObjectProvider(DBObjectProvider dBObjectProvider) {
        this.m_dboPro = dBObjectProvider;
    }

    private void addToExpression(SQLFragment sQLFragment) {
        String string = sQLFragment.getSQLText();
        this.m_pro.addToExpression(string);
    }

    private void addToExpression(Relation relation) {
        this.m_pro.addToExpression(relation.getName());
    }

    void showInvalidExpressionDialog(TraversalException traversalException) {
        MessageDialog.error((Component)this, (Object)traversalException.getMessage(), (String)UIArb.getString(115), null);
    }

    public void entered(SQLFragment[] sQLFragmentArray, SQLFragment sQLFragment) {
        this.m_expressionsModel.removeAllElements();
        int n = 0;
        while (sQLFragmentArray != null && n < sQLFragmentArray.length) {
            this.m_expressionsModel.addElement(sQLFragmentArray[n]);
            ++n;
        }
        if (this.m_templModel != null) {
            this.m_templModel.reload();
        }
        if (this.m_expressionsModel.size() > 0) {
            int n2 = this.m_expressionsModel.indexOf(sQLFragment);
            if (n2 < 0) {
                n2 = 0;
            }
            this.m_expressions.setSelectedIndex(n2);
            this.initExpression();
        }
        this.enableButtons();
        this.m_expPanel.setDividerLocation(250);
        this.m_entered = true;
    }

    public void exited() throws TraversalException {
        this.m_pro.commit();
        this.m_entered = false;
        this.m_current = null;
    }

    protected void enableButtons() {
        boolean bl;
        this.m_up.setEnabled(false);
        this.m_down.setEnabled(false);
        this.m_remove.setEnabled(false);
        int[] nArray = this.m_expressions.getSelectedIndices();
        int n = this.m_expressionsModel.getSize();
        if (n > 1 && nArray != null && nArray.length == 1) {
            if (nArray[0] == 0) {
                this.m_down.setEnabled(true);
            } else if (nArray[0] == n - 1) {
                this.m_up.setEnabled(true);
            } else {
                this.m_up.setEnabled(true);
                this.m_down.setEnabled(true);
            }
        }
        if (nArray != null && nArray.length > 0) {
            this.m_remove.setEnabled(true);
        }
        boolean bl2 = bl = nArray != null && nArray.length == 1;
        if (this.m_templates != null) {
            this.m_templateLabel.setEnabled(bl);
            this.m_templates.setEnabled(bl);
            this.m_insertTemplate.setEnabled(bl);
        }
        if (this.m_functions != null) {
            this.m_functions.setEnabled(bl);
            this.m_insertFunction.setEnabled(bl);
        }
        if (this.m_wizCallbacks != null) {
            // empty if block
        }
    }

    protected void newExpression() {
        try {
            this.m_pro.commit();
            this.m_current = this.m_pro.newFragment();
            this.m_ignoreList = true;
            try {
                this.m_expressionsModel.addElement(this.m_current);
                this.m_expressions.setSelectedValue(this.m_current, true);
            }
            finally {
                this.m_ignoreList = false;
            }
        }
        catch (TraversalException traversalException) {
            this.showInvalidExpressionDialog(traversalException);
        }
        this.enableButtons();
    }

    protected void removeSelectedExpressions() {
        int n = this.m_expressions.getSelectedIndex();
        Object[] objectArray = this.m_expressions.getSelectedValues();
        if (objectArray != null && objectArray.length > 0) {
            this.m_ignoreList = true;
            try {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (objectArray[n2] == EMPTY || this.m_pro.removeFragment((SQLFragment)objectArray[n2])) {
                        this.m_expressionsModel.removeElement(objectArray[n2]);
                        int n3 = this.m_expressionsModel.size() - 1;
                        this.m_expressions.setSelectedIndex(n > n3 ? n3 : n);
                    }
                    ++n2;
                }
            }
            finally {
                this.m_ignoreList = false;
            }
            this.initExpression();
            this.enableButtons();
        }
    }

    private void insertCurrentTemplate() {
        Object object;
        TreePath treePath;
        if (this.m_templates != null && (treePath = this.m_templates.getSelectionPath()) != null && (object = treePath.getLastPathComponent()) != null && ((DefaultMutableTreeNode)object).isLeaf()) {
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof SQLFragment) {
                this.addToExpression((SQLFragment)object2);
            } else if (object2 instanceof Relation) {
                String string = ((Relation)object2).getName();
                if (this.m_dboPro != null) {
                    string = this.m_dboPro.getExternalName(string);
                }
                this.m_pro.addToExpression(string);
            } else if (object2 instanceof Column) {
                Object object3;
                FastStringBuffer fastStringBuffer = new FastStringBuffer();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getParent();
                Object object4 = object3 = defaultMutableTreeNode == null ? null : defaultMutableTreeNode.getUserObject();
                if (object3 != null && object3 instanceof FromObject) {
                    fastStringBuffer.append(((FromObject)object3).getName());
                    fastStringBuffer.append(".");
                } else {
                    Relation relation = ((Column)object2).getRelation();
                    if (relation != null) {
                        fastStringBuffer.append(relation.getName());
                    }
                }
                String string = ((Column)object2).getName();
                if (this.m_dboPro != null) {
                    string = this.m_dboPro.getExternalName(string);
                }
                fastStringBuffer.append(string);
                this.m_pro.addToExpression(fastStringBuffer.toString());
            }
        }
    }

    private void insertCurrentFunction() {
        Object object = this.m_functions.getSelectedItem();
        String string = null;
        string = object instanceof SQLFragment ? ((SQLFragment)object).getSQLText() : object.toString();
        if (ModelUtil.hasLength((String)string)) {
            this.m_pro.addToExpression(string);
        }
    }

    public void setWizardCallbacks(WizardCallbacks wizardCallbacks, boolean bl) {
        this.m_wizCallbacks = wizardCallbacks;
        this.m_canFinish = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_remove) {
            this.removeSelectedExpressions();
        } else if (object == this.m_insertFunction) {
            this.insertCurrentFunction();
        } else if (object == this.m_insertTemplate) {
            this.insertCurrentTemplate();
        } else if (object == this.m_new) {
            this.newExpression();
        } else if (object == this.m_up) {
            SQLFragment sQLFragment = (SQLFragment)this.m_expressions.getSelectedValue();
            int n = this.m_expressions.getSelectedIndex();
            if (n > 0) {
                this.m_expressionsModel.removeElement(sQLFragment);
                this.m_expressionsModel.add(n - 1, sQLFragment);
                this.m_expressions.setSelectedValue(sQLFragment, true);
                this.m_pro.moveFragment(sQLFragment, n - 1);
            }
        } else if (object == this.m_down) {
            int n;
            SQLFragment sQLFragment = (SQLFragment)this.m_expressions.getSelectedValue();
            int n2 = this.m_expressions.getSelectedIndex();
            if (n2 < (n = this.m_expressionsModel.getSize()) - 1) {
                this.m_expressionsModel.removeElement(sQLFragment);
                this.m_expressionsModel.add(n2 + 1, sQLFragment);
                this.m_expressions.setSelectedValue(sQLFragment, true);
                this.m_pro.moveFragment(sQLFragment, n2 + 1);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.m_entered && !this.m_ignoreList && listSelectionEvent.getSource() == this.m_expressions) {
            Object e = this.m_expressions.getSelectedValue();
            try {
                if (e != this.m_current && (e != EMPTY || this.m_current != null)) {
                    this.m_pro.commit();
                    this.initExpression();
                }
            }
            catch (TraversalException traversalException) {
                this.showInvalidExpressionDialog(traversalException);
                this.m_ignoreList = true;
                try {
                    this.m_expressions.setSelectedValue(this.m_current == null ? EMPTY : (Object)this.m_current, false);
                }
                finally {
                    this.m_ignoreList = false;
                }
            }
            this.enableButtons();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (mouseEvent.getClickCount() % 2 == 0 && object == this.m_templates && this.m_templates.isEnabled()) {
            this.insertCurrentTemplate();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.m_expressions) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 127: {
                    this.removeSelectedExpressions();
                    break;
                }
                case 155: {
                    this.newExpression();
                    break;
                }
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        this.m_templates.scrollPathToVisible(treePath);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        this.m_insertTemplate.setEnabled(defaultMutableTreeNode.isLeaf());
    }

    public void focusGained(FocusEvent focusEvent) {
        int[] nArray;
        if (focusEvent.getComponent() == this.m_templates && (nArray = this.m_templates.getSelectionRows()) == null) {
            this.m_templates.setSelectionRow(0);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    protected static void setupButton(JButton jButton, ActionListener actionListener, Dimension dimension, Insets insets) {
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        if (dimension != null) {
            jButton.setMaximumSize(dimension);
            jButton.setMinimumSize(dimension);
            jButton.setPreferredSize(dimension);
        }
        if (insets != null) {
            jButton.setMargin(insets);
        }
    }

    public interface FragmentProvider {
        public SQLFragment newFragment();

        public boolean removeFragment(SQLFragment var1);

        public void moveFragment(SQLFragment var1, int var2);

        public JPanel getEditorUI();

        public void commit() throws TraversalException;

        public void edit(SQLFragment var1);

        public void addToExpression(String var1);

        public String getEditorName();

        public String getListTitle();

        public String getTemplateTitle();
    }
}

