/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JTextPane;
import oracle.ide.db.UIArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;

public abstract class BaseSQLQueryBuilderPanel
extends DefaultTraversablePanel {
    private boolean m_canFinish;
    protected WizardCallbacks m_wc;
    protected DialogCallbacks m_dc;
    protected Namespace m_namespace;
    protected DBObjectProvider m_pro;
    protected Schema m_defaultSchema;
    protected String m_parseMessage;
    private boolean m_noBuilderLayout;

    private void $init$() {
        this.m_canFinish = true;
    }

    protected BaseSQLQueryBuilderPanel() {
        this.$init$();
    }

    protected abstract void layoutComponents();

    protected void layoutNoBuilder() {
        this.layoutMessageOnly(UIArb.getString(219));
    }

    protected void layoutMessageOnly(String string) {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(string);
        jTextPane.getAccessibleContext().setAccessibleName(string);
        jTextPane.getAccessibleContext().setAccessibleDescription("");
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setEnabled(true);
        jTextPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(jTextPane, "Center");
    }

    public final void onEntry(TraversableContext traversableContext) {
        AbstractSQLQuery abstractSQLQuery;
        DBObjectProvider dBObjectProvider;
        this.m_namespace = traversableContext;
        this.m_wc = traversableContext.getWizardCallbacks();
        this.m_dc = traversableContext.getDialogCallbacks();
        Schema schema = (Schema)traversableContext.get("Schema");
        if (schema != null) {
            this.m_defaultSchema = schema;
        }
        if ((dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider")) != null) {
            this.m_pro = dBObjectProvider;
        }
        Object object = traversableContext.get("NewObject");
        SQLQuery sQLQuery = BaseSQLQueryBuilderPanel.findQuery((Namespace)traversableContext);
        SQLQueryBuilder sQLQueryBuilder = (SQLQueryBuilder)traversableContext.get("SQLQueryBuilder");
        if (!this.isQueryPanel() && sQLQueryBuilder == null && sQLQuery != null) {
            try {
                sQLQueryBuilder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)this.m_pro, (Schema)this.m_defaultSchema, (SQLQuery)sQLQuery);
                AbstractSQLQuery abstractSQLQuery2 = sQLQueryBuilder.getSQLQuery();
                if (abstractSQLQuery2 != null && object instanceof SQLQueryOwner) {
                    abstractSQLQuery2.setParent((DBObject)object);
                }
            }
            catch (SQLQueryException sQLQueryException) {
                this.m_parseMessage = sQLQueryException.getMessage();
            }
            traversableContext.put("SQLQueryBuilder", (Object)sQLQueryBuilder);
        }
        if (!this.isQueryPanel() && sQLQueryBuilder != null && (abstractSQLQuery = sQLQueryBuilder.getSQLQuery()) != sQLQuery) {
            if (object instanceof SQLQueryOwner) {
                ((SQLQueryOwner)object).setSQLQuery((SQLQuery)abstractSQLQuery);
            } else if (object instanceof SQLQuery) {
                traversableContext.put("NewObject", object);
            }
        }
        if (sQLQueryBuilder == null && this.invalidWithoutBuilder()) {
            this.removeAll();
            this.layoutNoBuilder();
            this.m_noBuilderLayout = true;
        } else {
            if (this.m_noBuilderLayout) {
                this.removeAll();
                this.layoutComponents();
                this.m_noBuilderLayout = false;
            }
            DBObject dBObject = (DBObject)traversableContext.get("DefaultChild");
            this.init(sQLQueryBuilder, dBObject);
        }
        this.validate();
    }

    protected boolean isQueryPanel() {
        return false;
    }

    protected boolean invalidWithoutBuilder() {
        return true;
    }

    protected void enableButtons(boolean bl) {
        if (this.m_wc != null) {
            this.m_wc.wizardEnableButtons(null, bl ? Boolean.TRUE : Boolean.FALSE, this.m_canFinish ? Boolean.TRUE : Boolean.FALSE);
        } else if (this.m_dc != null) {
            // empty if block
        }
    }

    protected void setCanFinish(boolean bl) {
        this.m_canFinish = bl;
    }

    protected abstract void init(SQLQueryBuilder var1, DBObject var2);

    protected static SQLQuery findQuery(Namespace namespace) {
        Object object = namespace.get("NewObject");
        SQLQuery sQLQuery = null;
        if (object instanceof SQLQuery) {
            sQLQuery = (SQLQuery)object;
        } else if (object instanceof SQLQueryOwner) {
            sQLQuery = ((SQLQueryOwner)object).getSQLQuery();
        }
        return sQLQuery;
    }
}

