/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.sql.SQLException;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.panels.DDLPanel;
import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.editor.EditorUtil;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Database;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.dialogs.ExceptionDialog;

public class PlSqlTabbedPanel
extends TabbedEditorPanel {
    public PlSqlTabbedPanel(Traversable traversable, Navigable[] navigableArray) {
        super(traversable, navigableArray, null);
    }

    protected void commitToProvider(TraversableContext traversableContext) throws TraversalException {
        DBObjectProvider dBObjectProvider;
        SchemaObject schemaObject = (SchemaObject)traversableContext.find("NewObject");
        DDLGenerator dDLGenerator = DDLPanel.getDDLGenerator(traversableContext);
        String string = this.getBufferText(schemaObject, dDLGenerator);
        if (schemaObject instanceof PlSql) {
            ((PlSql)schemaObject).setSource(string);
        }
        if (!((dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider")) instanceof Database)) {
            super.commitToProvider(traversableContext);
            return;
        }
        Schema schema = schemaObject.getSchema();
        String string2 = schemaObject.getName();
        String string3 = schemaObject.getType();
        URL uRL = this.getNodeURL(schemaObject, dBObjectProvider);
        Node node = null;
        try {
            node = NodeFactory.findOrCreate((URL)uRL);
        }
        catch (Exception exception) {
            FeedbackManager.reportException((Throwable)exception);
        }
        if (node instanceof DBObjectNode) {
            ((DBObjectNode)node).init((DBObject)schemaObject, dBObjectProvider);
        }
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            textNode.addNodeListener((NodeListener)new 1(this, dBObjectProvider, string3, schema, string2, textNode));
            TextBuffer textBuffer = null;
            try {
                textBuffer = textNode.acquireTextBuffer();
                textBuffer.beginEdit();
                textBuffer.removeToEnd(0);
                if (string != null) {
                    textBuffer.append(string.toCharArray());
                }
            }
            finally {
                if (textBuffer != null) {
                    textBuffer.endEdit();
                    textNode.releaseTextBuffer();
                }
            }
            EventQueue.invokeLater(new 2(this, textNode));
        }
    }

    protected String getBufferText(SchemaObject schemaObject, DDLGenerator dDLGenerator) {
        return dDLGenerator.getCreateDDL(schemaObject, true, false).stripPrompts().getDdl();
    }

    protected URL getNodeURL(SchemaObject schemaObject, DBObjectProvider dBObjectProvider) {
        String string = schemaObject instanceof SpecPlSql ? "Spec" : null;
        URL uRL = DBURLFactory.getURL(dBObjectProvider, schemaObject, string);
        return uRL;
    }

    final class 1
    extends NodeListener {
        private final /* synthetic */ DBObjectProvider v$pro;
        private final /* synthetic */ String v$dbType;
        private final /* synthetic */ Schema v$schema;
        private final /* synthetic */ String v$name;
        private final /* synthetic */ TextNode v$cbn;
        final /* synthetic */ PlSqlTabbedPanel this$0;

        public void nodeSaved(NodeEvent nodeEvent) {
            block7: {
                try {
                    try {
                        SchemaObject schemaObject = this.v$pro.getObject(this.v$dbType, this.v$schema, this.v$name);
                        if (schemaObject != null && this.v$pro instanceof AbstractDatabase) {
                            ((AbstractDatabase)this.v$pro).fireObjectsAdded(this.v$schema, new SchemaObject[]{schemaObject});
                        }
                    }
                    catch (DBException dBException) {
                        Throwable throwable = dBException.getCause();
                        if (throwable instanceof SQLException) {
                            SQLErrorDialog.showErrorDialog((Component)((Object)this.this$0), "Error Creating PL/SQL Subprogram", (SQLException)throwable);
                            break block7;
                        }
                        ExceptionDialog.showExceptionDialog((Component)((Object)this.this$0), (Throwable)dBException);
                    }
                }
                finally {
                    this.v$cbn.removeNodeListener((NodeListener)this);
                }
            }
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            this.v$cbn.removeNodeListener((NodeListener)this);
        }

        public 1(PlSqlTabbedPanel plSqlTabbedPanel, DBObjectProvider dBObjectProvider, String string, Schema schema, String string2, TextNode textNode) {
            this.v$cbn = textNode;
            this.v$name = string2;
            this.v$schema = schema;
            this.v$dbType = string;
            this.v$pro = dBObjectProvider;
            this.this$0 = plSqlTabbedPanel;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ TextNode v$cbn;
        final /* synthetic */ PlSqlTabbedPanel this$0;

        public void run() {
            EditorUtil.openDefaultEditorInFrame((Node)this.v$cbn);
        }

        public 2(PlSqlTabbedPanel plSqlTabbedPanel, TextNode textNode) {
            this.v$cbn = textNode;
            this.this$0 = plSqlTabbedPanel;
        }
    }
}

