/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.DBIcons;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.plsql.ParamsModel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.PlSqlParametersVerifier;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.Function;
import oracle.javatools.db.PlSqlParameter;

public class PlSqlParametersPanel
extends BaseInfoPanel {
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnUp;
    private JButton btnDown;
    private JScrollPane scrParams;
    private JTable tblParams;
    private DBObjectRenderer _renderer;
    private NonNullableComboBoxModel _mdlMode;
    private DefaultComboBoxModel _mdlType;
    private TableColumnModel _mdlCols;
    private ParamsModel _mdlParams;
    private L _listener;
    private static final String ADD_CMD = "ADD";
    private static final String REMOVE_CMD = "REMOVE";
    private static final String UP_CMD = "UP";
    private static final String DOWN_CMD = "DOWN";

    private void $init$() {
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.scrParams = new JScrollPane();
        this.tblParams = new JTable();
        this._mdlMode = new NonNullableComboBoxModel();
        this._mdlType = new DefaultComboBoxModel();
        this._mdlCols = new DefaultTableColumnModel();
        this._mdlParams = new ParamsModel();
        this._listener = new L(null);
    }

    public PlSqlParametersPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.init((DBObjectProvider)traversableContext.find("DBObjectProvider"), (DeclarativePlSql)traversableContext.find("NewObject"), (Verifier)traversableContext.find("SchemaObjectInfoVerifier"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit((DeclarativePlSql)traversableContext.find("NewObject"), (PlSqlParametersVerifier)traversableContext.find("SchemaObjectInfoVerifier"));
    }

    protected void init(DBObjectProvider dBObjectProvider, DeclarativePlSql declarativePlSql, Verifier verifier) {
        super.init(dBObjectProvider, verifier);
        this._mdlParams.init(dBObjectProvider, declarativePlSql, declarativePlSql instanceof Function);
    }

    protected void commit(DeclarativePlSql declarativePlSql, PlSqlParametersVerifier plSqlParametersVerifier) throws TraversalException {
        this._mdlParams.commit(declarativePlSql, plSqlParametersVerifier);
    }

    private void jbInit() throws Exception {
        TableColumn tableColumn = new TableColumn(0);
        tableColumn.setHeaderValue("Name");
        tableColumn.setCellRenderer(this._renderer);
        this._mdlCols.addColumn(tableColumn);
        this._mdlType.addElement("VARCHAR2");
        this._mdlType.addElement("NUMBER");
        this._mdlType.addElement("DATE");
        this._mdlType.addElement("CLOB");
        this._mdlType.addElement("BLOB");
        TableColumn tableColumn2 = new TableColumn(1);
        tableColumn2.setHeaderValue("Type");
        JComboBox jComboBox = new JComboBox(this._mdlType);
        jComboBox.setEditable(true);
        tableColumn2.setCellEditor(new DefaultCellEditor(jComboBox));
        this._mdlCols.addColumn(tableColumn2);
        PlSqlParameter.Mode[] modeArray = PlSqlParameter.Mode.values();
        int n = 0;
        while (n < modeArray.length) {
            PlSqlParameter.Mode mode = modeArray[n];
            this._mdlMode.addElement((Object)mode);
            ++n;
        }
        this._mdlMode.addElement((Object)"");
        TableColumn tableColumn3 = new TableColumn(2);
        tableColumn3.setHeaderValue("Mode");
        tableColumn3.setCellEditor(new DefaultCellEditor(new JComboBox(this._mdlMode)));
        this._mdlCols.addColumn(tableColumn3);
        TableColumn tableColumn4 = new TableColumn(3);
        tableColumn4.setHeaderValue("Default Value");
        this._mdlCols.addColumn(tableColumn4);
        this.tblParams.setModel(this._mdlParams);
        this.tblParams.setColumnModel(this._mdlCols);
        this.tblParams.getSelectionModel().addListSelectionListener(this._listener);
        this.setLayout(new BorderLayout());
        Dimension dimension = new Dimension(28, 25);
        this.btnUp.setPreferredSize(dimension);
        this.btnUp.setIcon(ComponentArb.getIcon((int)0));
        this.btnUp.setDisabledIcon(ComponentArb.getIcon((int)2));
        DBObjectRenderer.setToolTipText(this.btnUp, UIArb.getString(434));
        this.btnUp.setActionCommand(UP_CMD);
        this.btnUp.addActionListener(this._listener);
        this.btnUp.setEnabled(false);
        this.btnDown.setPreferredSize(dimension);
        this.btnDown.setIcon(ComponentArb.getIcon((int)1));
        this.btnDown.setDisabledIcon(ComponentArb.getIcon((int)3));
        DBObjectRenderer.setToolTipText(this.btnDown, UIArb.getString(435));
        this.btnDown.setActionCommand(DOWN_CMD);
        this.btnDown.addActionListener(this._listener);
        this.btnDown.setEnabled(false);
        this.btnAdd.setPreferredSize(dimension);
        this.btnAdd.setIcon(DBIcons.getIcon(0));
        DBObjectRenderer.setToolTipText(this.btnAdd, UIArb.getString(432));
        this.btnAdd.setActionCommand(ADD_CMD);
        this.btnAdd.addActionListener(this._listener);
        this.btnRemove.setPreferredSize(dimension);
        this.btnRemove.setIcon(DBIcons.getIcon(1));
        DBObjectRenderer.setToolTipText(this.btnRemove, UIArb.getString(433));
        this.btnRemove.setActionCommand(REMOVE_CMD);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(this._listener);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.btnAdd, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.btnRemove, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.btnUp, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(15, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.btnDown, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(jPanel, "East");
        this.tblParams.setSelectionMode(0);
        this.scrParams.getViewport().add((Component)this.tblParams, null);
        this.add(this.scrParams, "Center");
    }

    static JTable ra$tblParams(PlSqlParametersPanel plSqlParametersPanel) {
        return plSqlParametersPanel.tblParams;
    }

    static ParamsModel ra$_mdlParams(PlSqlParametersPanel plSqlParametersPanel) {
        return plSqlParametersPanel._mdlParams;
    }

    static JButton ra$btnRemove(PlSqlParametersPanel plSqlParametersPanel) {
        return plSqlParametersPanel.btnRemove;
    }

    static JButton ra$btnUp(PlSqlParametersPanel plSqlParametersPanel) {
        return plSqlParametersPanel.btnUp;
    }

    static JButton ra$btnDown(PlSqlParametersPanel plSqlParametersPanel) {
        return plSqlParametersPanel.btnDown;
    }

    private class L
    implements ActionListener,
    ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = PlSqlParametersPanel.ra$tblParams(PlSqlParametersPanel.this).getSelectedRow();
            this.updateButtons(n);
        }

        private void updateButtons(int n) {
            PlSqlParametersPanel.ra$btnRemove(PlSqlParametersPanel.this).setEnabled(PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).canRemoveRow(n));
            PlSqlParametersPanel.ra$btnUp(PlSqlParametersPanel.this).setEnabled(PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).canMoveRowUp(n));
            PlSqlParametersPanel.ra$btnDown(PlSqlParametersPanel.this).setEnabled(PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).canMoveRowDown(n));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = PlSqlParametersPanel.ra$tblParams(PlSqlParametersPanel.this).getSelectedRow();
            String string = actionEvent.getActionCommand();
            if (PlSqlParametersPanel.ADD_CMD.equals(string)) {
                if (n >= 0) {
                    PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).addParameter(n);
                } else {
                    PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).addParameter();
                }
            } else if (PlSqlParametersPanel.REMOVE_CMD.equals(string)) {
                PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).removeParameter(n);
            } else if (PlSqlParametersPanel.UP_CMD.equals(string)) {
                PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).moveUp(n);
            } else if (PlSqlParametersPanel.DOWN_CMD.equals(string)) {
                PlSqlParametersPanel.ra$_mdlParams(PlSqlParametersPanel.this).moveDown(n);
            }
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

