/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.ide.db.verifiers.PlSqlParametersVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.datatypes.DataType;

public class ParamsModel
extends AbstractTableModel {
    static final int NAME_POS = 0;
    static final int TYPE_POS = 1;
    static final int MODE_POS = 2;
    static final int DEFAULT_POS = 3;
    private List<PlSqlParameter> _params;
    private DBObjectProvider _prov;
    private boolean _isFunction;

    private void $init$() {
        this._params = new ArrayList<PlSqlParameter>();
    }

    public ParamsModel() {
        this.$init$();
    }

    private String getUniqueParamName() {
        String string = "param";
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        int n = this._isFunction ? 1 : 0;
        while (n < this._params.size()) {
            hashSet.add(this._params.get(n).getName());
            ++n;
        }
        return DBUtil.getUniqueName(hashSet, (String)string, (boolean)true);
    }

    public void addParameter() {
        this.addParameter(this._params.size() - 1);
    }

    public void addParameter(int n) {
        PlSqlParameter plSqlParameter = new PlSqlParameter(this.getUniqueParamName(), this._prov.getDataType("VARCHAR2"));
        plSqlParameter.setMode(PlSqlParameter.Mode.IN);
        this._params.add(++n, plSqlParameter);
        this.fireTableRowsInserted(n, n);
    }

    public boolean canRemoveRow(int n) {
        int n2 = this._isFunction ? 1 : 0;
        return n >= n2 && n < this._params.size();
    }

    public void removeParameter(int n) {
        this._params.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public boolean canMoveRowUp(int n) {
        int n2 = this._isFunction ? 1 : 0;
        return n > n2 && n < this._params.size();
    }

    public void moveUp(int n) {
        if (this.canMoveRowUp(n)) {
            PlSqlParameter plSqlParameter = this._params.remove(n);
            this._params.add(n - 1, plSqlParameter);
            this.fireTableRowsUpdated(n - 1, n);
        }
    }

    public boolean canMoveRowDown(int n) {
        int n2 = this._isFunction ? 1 : 0;
        return n >= n2 && n < this._params.size() - 1;
    }

    public void moveDown(int n) {
        if (this.canMoveRowDown(n)) {
            PlSqlParameter plSqlParameter = this._params.remove(n);
            this._params.add(n + 1, plSqlParameter);
            this.fireTableRowsUpdated(n, n + 1);
        }
    }

    public void init(DBObjectProvider dBObjectProvider, DeclarativePlSql declarativePlSql, boolean bl) {
        PlSqlParameter[] plSqlParameterArray;
        this._prov = dBObjectProvider;
        this._isFunction = bl;
        this._params.clear();
        if (bl) {
            DataType dataType = declarativePlSql.getReturnType();
            if (dataType == null) {
                dataType = this._prov.getDataType("VARCHAR2");
            }
            PlSqlParameter plSqlParameter = new PlSqlParameter("<Return>", dataType);
            this._params.add(plSqlParameter);
        }
        if ((plSqlParameterArray = declarativePlSql.getParameters()) != null) {
            PlSqlParameter[] plSqlParameterArray2 = plSqlParameterArray;
            int n = 0;
            while (n < plSqlParameterArray2.length) {
                PlSqlParameter plSqlParameter = plSqlParameterArray2[n];
                this._params.add(plSqlParameter);
                ++n;
            }
        }
    }

    public void commit(DeclarativePlSql declarativePlSql, PlSqlParametersVerifier plSqlParametersVerifier) throws TraversalException {
        int n = 0;
        DataType dataType = null;
        if (this._isFunction) {
            ++n;
            if (this._params.size() == 0) {
                throw new TraversalException("A Function must have a return type");
            }
            PlSqlParameter plSqlParameter = this._params.get(0);
            dataType = plSqlParameter.getDataType();
            plSqlParametersVerifier.verifyReturnType(dataType);
        }
        PlSqlParameter[] plSqlParameterArray = new PlSqlParameter[this._params.size() - n];
        int n2 = 0;
        while (n2 < plSqlParameterArray.length) {
            plSqlParameterArray[n2] = this._params.get(n2 + n);
            plSqlParametersVerifier.verifyParameter(plSqlParameterArray[n2]);
            ++n2;
        }
        declarativePlSql.setParameters(plSqlParameterArray);
        declarativePlSql.setReturnType(dataType);
    }

    public int getColumnCount() {
        return 4;
    }

    public int getRowCount() {
        return this._params.size();
    }

    public Object getValueAt(int n, int n2) {
        Object object = null;
        PlSqlParameter plSqlParameter = this._params.get(n);
        switch (n2) {
            case 0: {
                object = plSqlParameter.getName();
                break;
            }
            case 1: {
                DataType dataType = plSqlParameter.getDataType();
                object = dataType.getName();
                break;
            }
            case 2: {
                PlSqlParameter.Mode mode = plSqlParameter.getMode();
                object = mode != null ? (Object)mode : (Object)"";
                break;
            }
            case 3: {
                object = plSqlParameter.getDefaultValue();
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
        }
        return object;
    }

    public void setValueAt(Object object, int n, int n2) {
        PlSqlParameter plSqlParameter = this._params.get(n);
        switch (n2) {
            case 0: {
                plSqlParameter.setName((String)object);
                break;
            }
            case 1: {
                String string = plSqlParameter.getName();
                PlSqlParameter.Mode mode = plSqlParameter.getMode();
                String string2 = plSqlParameter.getDefaultValue();
                DataType dataType = this._prov.getDataType((String)object);
                plSqlParameter = new PlSqlParameter(string, dataType);
                plSqlParameter.setDefaultValue(string2);
                plSqlParameter.setMode(mode);
                this._params.set(n, plSqlParameter);
                break;
            }
            case 2: {
                plSqlParameter.setMode(object instanceof PlSqlParameter.Mode ? (PlSqlParameter.Mode)object : null);
                break;
            }
            case 3: {
                plSqlParameter.setDefaultValue((String)object);
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return !this._isFunction || n > 0 || n2 == 1;
    }
}

