/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;

public abstract class NewPlsqlPanel
extends NameAndSchemaEditor {
    private JLabel m_lblType;
    private JComboBox m_cmbType;
    private GridBagLayout m_gridBagLayout1;

    private void $init$() {
        this.m_lblType = new JLabel();
        this.m_cmbType = new JComboBox();
        this.m_gridBagLayout1 = new GridBagLayout();
    }

    public NewPlsqlPanel() {
        this.$init$();
        ResourceUtils.resLabel((JLabel)this.m_lblType, (Component)this.m_cmbType, (String)this.getTypeLabel());
        this.add(this.m_lblType, new GridBagConstraints(0, 30, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_cmbType, new GridBagConstraints(1, 30, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public abstract String getTypeLabel();

    public abstract List getTypeList(PlSql var1);

    public abstract PlSqlComboItem getDefaultComboItem();

    protected abstract void performProcess(PlSql var1, DBObjectProvider var2) throws TraversalException;

    protected final PlSqlComboItem getSelectedType() {
        return (PlSqlComboItem)this.m_cmbType.getSelectedItem();
    }

    public void onEntry(TraversableContext traversableContext) {
        PlSqlComboItem plSqlComboItem;
        PlSql plSql = (PlSql)traversableContext.find("NewObject");
        Schema[] schemaArray = (Schema[])traversableContext.find("SchemaList");
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        List list = this.getTypeList(plSql);
        if (list != null && list.size() > 0) {
            this.m_cmbType.setModel(new DefaultListComboBoxModel(list));
            if (list.size() < 2) {
                this.m_lblType.setVisible(false);
                this.m_cmbType.setVisible(false);
            }
        }
        if ((plSqlComboItem = this.getDefaultComboItem()) != null) {
            this.m_cmbType.setSelectedItem(plSqlComboItem);
        }
        super.init((SchemaObject)plSql, null, null, dBObjectProvider, schemaArray);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        PlSql plSql = (PlSql)traversableContext.find("NewObject");
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        super.commit();
        this.performProcess(plSql, dBObjectProvider);
        try {
            dBObjectProvider.validateObject((DBObject)plSql);
        }
        catch (ValidationException validationException) {
            throw new TraversalException(validationException.getMessage(), UIArb.format(105, plSql.getName()));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_cmbType) {
            if (this._listening) {
                try {
                    this.performProcess((PlSql)this.getSchemaObject(), this.getProvider());
                }
                catch (TraversalException traversalException) {}
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected final class PlSqlComboItem {
        private int m_display;
        private int m_plsql;
        private int m_extraPlsql;
        private String m_type;
        private String m_collType;

        public PlSqlComboItem(String string, int n, int n2) {
            this(string, n, n2, -1, "");
        }

        public PlSqlComboItem(String string, int n, int n2, String string2) {
            this(string, n, n2, -1, string2);
        }

        public PlSqlComboItem(String string, int n, int n2, int n3) {
            this(string, n, n2, n3, "");
        }

        public PlSqlComboItem(String string, int n, int n2, int n3, String string2) {
            this.m_type = string;
            this.m_display = n;
            this.m_plsql = n2;
            this.m_extraPlsql = n3;
            this.m_collType = string2;
        }

        public String getType() {
            return this.m_type;
        }

        public int getDisplayString() {
            return this.m_display;
        }

        public int getPlsql() {
            return this.m_plsql;
        }

        public int getExtraPlsql() {
            return this.m_extraPlsql;
        }

        public boolean isCollectionType() {
            return this.m_collType.equals("") ^ true;
        }

        public String getCollectionType() {
            return this.m_collType;
        }

        public String toString() {
            return UIArb.getString(this.getDisplayString());
        }
    }
}

