/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.mview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.MViewInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleStorageProperties;

public class MViewRightPanel
extends JPanel {
    private final String[] _buildTypeStrings;
    private final String[] _extentStrings;
    private MViewInfoVerifier m_verifier;
    OracleStorageProperties oProps;
    private Context ctx;
    private JCheckBox _useindexCheckBox;
    private JComboBox indexTablespaceComboBox;
    private JCheckBox _parallelCheckBox;
    private JTextField _parallelValue;
    private JPanel northPane;
    private JPanel centerPane;
    private JCheckBox _enableCacheCheckBox;
    private JLabel _tablespaceLabel;
    private JLabel _buildTypeLabel;
    private JComboBox _buildTypeComboBox;
    private JCheckBox _queryRewriteCheck;
    private JCheckBox _prebuiltCheckBox;
    ButtonGroup bgPrebuilt;
    private JRadioButton _reducedPrecisionRadio;
    private JRadioButton _noReducedRadio;
    ButtonGroup bg2;

    private void $init$() {
        this._buildTypeStrings = new String[]{UIArb.getString(636), UIArb.getString(637)};
        this._extentStrings = new String[]{"KB", "MB"};
        this.m_verifier = null;
        this.oProps = new OracleStorageProperties();
        this.ctx = null;
        this._useindexCheckBox = new JCheckBox();
        this.indexTablespaceComboBox = new JComboBox();
        this._parallelCheckBox = new JCheckBox();
        this._parallelValue = new JTextField();
        this.northPane = new JPanel();
        this.centerPane = new JPanel();
        this._enableCacheCheckBox = new JCheckBox();
        this._tablespaceLabel = new JLabel();
        this._buildTypeLabel = new JLabel();
        this._buildTypeComboBox = new JComboBox<String>(this._buildTypeStrings);
        this._queryRewriteCheck = new JCheckBox();
        this._prebuiltCheckBox = new JCheckBox();
        this.bgPrebuilt = new ButtonGroup();
        this._reducedPrecisionRadio = new JRadioButton();
        this._noReducedRadio = new JRadioButton();
        this.bg2 = new ButtonGroup();
    }

    public MViewRightPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean getParallelCheck() {
        return this._parallelCheckBox.isSelected();
    }

    public void setParallelCheck(boolean bl) {
        this._parallelCheckBox.setSelected(bl);
    }

    public String getParallelValue() {
        return this._parallelValue.getText();
    }

    public void setParallelValue(String string) {
        this._parallelValue.setText(string);
    }

    public boolean getEnableCache() {
        return this._enableCacheCheckBox.isSelected();
    }

    public void setEnableCache(boolean bl) {
        this._enableCacheCheckBox.setSelected(bl);
    }

    public boolean getEnableQueryRewrite() {
        return this._queryRewriteCheck.isSelected();
    }

    public void setEnableQueryRewrite(boolean bl) {
        this._queryRewriteCheck.setSelected(bl);
    }

    public boolean getUseIndex() {
        return this._useindexCheckBox.isSelected();
    }

    public void setUseIndex(boolean bl) {
        this._useindexCheckBox.setSelected(bl);
    }

    public String getBuildType() {
        return (String)this._buildTypeComboBox.getSelectedItem();
    }

    public void setBuildType(String string) {
        this._buildTypeComboBox.setSelectedItem(string);
    }

    protected void init(DBObjectProvider dBObjectProvider, MaterializedView materializedView, MViewInfoVerifier mViewInfoVerifier, Schema[] schemaArray) {
        this.m_verifier = mViewInfoVerifier;
        int n = materializedView.getParallel();
        this._parallelValue.setText(Integer.toString(n));
        if (n == 0) {
            this._parallelCheckBox.setSelected(false);
            this._parallelCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
            this._parallelValue.setEnabled(false);
        } else {
            this._parallelCheckBox.setSelected(this.m_verifier == null || this.m_verifier.canMVOParallel());
            this._parallelCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
            this._parallelValue.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
        }
        this._enableCacheCheckBox.setSelected(materializedView.isCache());
        this._enableCacheCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOEnableCache());
        this._queryRewriteCheck.setSelected(materializedView.isRewrite());
        this._queryRewriteCheck.setEnabled(this.m_verifier == null || this.m_verifier.canMVOQueryRewrite());
        if (materializedView.getBuildType() == MaterializedView.BuildType.IMMEDIATE) {
            this._buildTypeComboBox.setSelectedItem(UIArb.getString(636));
        } else if (materializedView.getBuildType() == MaterializedView.BuildType.DEFERRED) {
            this._buildTypeComboBox.setSelectedItem(UIArb.getString(637));
        }
        this._buildTypeComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
        this._buildTypeLabel.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
        this._prebuiltCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
        if (materializedView.getOnPrebuilt() != MaterializedView.PrebuiltType.NONE) {
            this._prebuiltCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
            this._prebuiltCheckBox.setSelected(true);
            this._reducedPrecisionRadio.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
            this._noReducedRadio.setEnabled(this.m_verifier == null || this.m_verifier.canMVOPrebuilt());
            if (MaterializedView.PrebuiltType.WITHOUT_REDUCED_PRECISION == materializedView.getOnPrebuilt()) {
                this._noReducedRadio.setSelected(true);
            } else {
                this._reducedPrecisionRadio.setSelected(true);
            }
        } else {
            this._prebuiltCheckBox.setSelected(false);
            this._reducedPrecisionRadio.setEnabled(false);
            this._noReducedRadio.setEnabled(false);
        }
        this.indexTablespaceComboBox.removeAllItems();
        this.indexTablespaceComboBox.addItem("");
        if (dBObjectProvider instanceof OracleDatabase) {
            OracleDatabase oracleDatabase = (OracleDatabase)dBObjectProvider;
            String[] stringArray = oracleDatabase.listTablespaces();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.indexTablespaceComboBox.addItem(stringArray[n2]);
                ++n2;
            }
        } else {
            this.indexTablespaceComboBox.setEditable(true);
        }
        this._useindexCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canUseIndex());
        if (materializedView.isUseNoIndex()) {
            this._useindexCheckBox.setSelected(false);
            this._tablespaceLabel.setEnabled(false);
            this.indexTablespaceComboBox.setEnabled(false);
            this.indexTablespaceComboBox.setSelectedItem("");
        } else {
            String string = materializedView.getTablespace();
            this._useindexCheckBox.setSelected(true);
            this._tablespaceLabel.setEnabled(this.m_verifier == null || this.m_verifier.canUseIndex());
            this.indexTablespaceComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canUseIndex());
            this.indexTablespaceComboBox.setSelectedItem(string == null ? "" : string);
        }
    }

    public void commit(MaterializedView materializedView, Schema[] schemaArray, boolean bl) throws TraversalException {
        int n = 0;
        if (this._parallelCheckBox.isSelected()) {
            String string = this._parallelValue.getText();
            try {
                n = string == null || string.equals("") ? 0 : Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        materializedView.setParallel(n);
        materializedView.setCache(this._enableCacheCheckBox.isSelected());
        materializedView.setRewrite(this._queryRewriteCheck.isSelected());
        materializedView.setUseNoIndex(true);
        if (((String)this._buildTypeComboBox.getSelectedItem()).equals(UIArb.getString(636))) {
            materializedView.setBuildType(MaterializedView.BuildType.IMMEDIATE);
        } else if (((String)this._buildTypeComboBox.getSelectedItem()).equals(UIArb.getString(637))) {
            materializedView.setBuildType(MaterializedView.BuildType.DEFERRED);
        }
        materializedView.setUseNoIndex(this._useindexCheckBox.isSelected() ^ true);
        materializedView.setTablespace((String)this.indexTablespaceComboBox.getSelectedItem());
        if (this._prebuiltCheckBox.isSelected()) {
            materializedView.setOnPrebuilt(this._reducedPrecisionRadio.isSelected() ? MaterializedView.PrebuiltType.WITH_REDUCED_PRECISION : MaterializedView.PrebuiltType.WITHOUT_REDUCED_PRECISION);
        } else {
            materializedView.setOnPrebuilt(MaterializedView.PrebuiltType.NONE);
        }
    }

    private void jbInit() throws Exception {
        this.northPane.setLayout(new GridBagLayout());
        int n = 0;
        this.northPane.add((Component)this._parallelCheckBox, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.northPane.add((Component)this._parallelValue, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 4), 0, 0));
        this.northPane.add((Component)this._enableCacheCheckBox, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.northPane.add((Component)this._queryRewriteCheck, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.northPane.add((Component)this._prebuiltCheckBox, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.northPane.add((Component)this._reducedPrecisionRadio, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 15, 0, 5), 0, 0));
        this.northPane.add((Component)this._noReducedRadio, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 15, 0, 5), 0, 0));
        this.northPane.add((Component)this._buildTypeLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.northPane.add((Component)this._buildTypeComboBox, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.northPane.add(Box.createGlue(), new GridBagConstraints(4, ++n, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPane.setLayout(new GridBagLayout());
        this.centerPane.add((Component)this._useindexCheckBox, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.centerPane.add((Component)this._tablespaceLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 5), 2, 0));
        this.centerPane.add((Component)this.indexTablespaceComboBox, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.centerPane.add(Box.createGlue(), new GridBagConstraints(4, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.northPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.centerPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.northPane.setBorder(BorderFactory.createTitledBorder(UIArb.getString(656)));
        this.centerPane.setBorder(BorderFactory.createTitledBorder(UIArb.getString(666)));
        ResourceUtils.resButton((AbstractButton)this._enableCacheCheckBox, (String)UIArb.getString(657));
        this._enableCacheCheckBox.setToolTipText(UIArb.getString(658));
        this._enableCacheCheckBox.addActionListener(new 1());
        ResourceUtils.resLabel((JLabel)this._tablespaceLabel, (Component)this.indexTablespaceComboBox, (String)UIArb.getString(667));
        ResourceUtils.resLabel((JLabel)this._buildTypeLabel, (Component)this._buildTypeComboBox, (String)UIArb.getString(659));
        ResourceUtils.resButton((AbstractButton)this._useindexCheckBox, (String)UIArb.getString(668));
        this._useindexCheckBox.setEnabled(true);
        this._useindexCheckBox.addActionListener(new 2());
        ResourceUtils.resButton((AbstractButton)this._parallelCheckBox, (String)UIArb.getString(660));
        this._parallelCheckBox.setToolTipText(UIArb.getString(661));
        this._parallelCheckBox.addActionListener(new 3());
        this._parallelValue.addActionListener(new 4());
        this._parallelValue.addKeyListener(new 5());
        this._parallelValue.setEnabled(this._parallelCheckBox.isEnabled());
        this._buildTypeComboBox.setSelectedIndex(0);
        ResourceUtils.resButton((AbstractButton)this._queryRewriteCheck, (String)UIArb.getString(662));
        ResourceUtils.resButton((AbstractButton)this._prebuiltCheckBox, (String)UIArb.getString(663));
        this._prebuiltCheckBox.addActionListener(new 6());
        ResourceUtils.resButton((AbstractButton)this._reducedPrecisionRadio, (String)UIArb.getString(664));
        ResourceUtils.resButton((AbstractButton)this._noReducedRadio, (String)UIArb.getString(665));
        this.bgPrebuilt.add(this._noReducedRadio);
        this.bgPrebuilt.add(this._reducedPrecisionRadio);
        this._noReducedRadio.setEnabled(false);
        this._reducedPrecisionRadio.setEnabled(false);
    }

    private void _useindexCheckBox_actionPerformed(ActionEvent actionEvent) {
        if (this._useindexCheckBox.isSelected()) {
            this._tablespaceLabel.setEnabled(this.m_verifier == null || this.m_verifier.canUseIndex());
            this.indexTablespaceComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canUseIndex());
        } else {
            this._tablespaceLabel.setEnabled(false);
            this.indexTablespaceComboBox.setEnabled(false);
            this.indexTablespaceComboBox.setSelectedItem("");
        }
    }

    private void _parallelValue_actionPerformed(ActionEvent actionEvent) {
    }

    private void _parallelCheckBox_actionPerformed(ActionEvent actionEvent) {
        if (this._parallelCheckBox.isSelected()) {
            this._parallelValue.setEnabled(this.m_verifier == null || this.m_verifier.canMVOParallel());
            if (this._parallelCheckBox.isSelected()) {
                this._parallelValue.setEditable(true);
            } else {
                this._parallelValue.setEditable(false);
            }
        } else {
            this._parallelValue.setEnabled(false);
            this._parallelValue.setEditable(false);
        }
    }

    private void _valueParallelRadio_actionPerformed(ActionEvent actionEvent) {
        this._parallelValue.setEditable(true);
    }

    private void _defaultParallelRadio_actionPerformed(ActionEvent actionEvent) {
        this._parallelValue.setEditable(false);
    }

    private void _cacheCheck_actionPerformed(ActionEvent actionEvent) {
    }

    private void jButton2_actionPerformed(ActionEvent actionEvent) {
    }

    private void jComboBox1_actionPerformed(ActionEvent actionEvent) {
    }

    private void _extentTextField_actionPerformed(ActionEvent actionEvent) {
    }

    private void _prebuiltCheckBox_actionPerformed(ActionEvent actionEvent) {
        if (this._prebuiltCheckBox.isSelected()) {
            this._reducedPrecisionRadio.setEnabled(true);
            this._noReducedRadio.setEnabled(true);
        } else {
            this._reducedPrecisionRadio.setEnabled(false);
            this._noReducedRadio.setEnabled(false);
        }
    }

    static void mav$_cacheCheck_actionPerformed(MViewRightPanel mViewRightPanel, ActionEvent actionEvent) {
        mViewRightPanel._cacheCheck_actionPerformed(actionEvent);
    }

    static void mav$_useindexCheckBox_actionPerformed(MViewRightPanel mViewRightPanel, ActionEvent actionEvent) {
        mViewRightPanel._useindexCheckBox_actionPerformed(actionEvent);
    }

    static void mav$_parallelCheckBox_actionPerformed(MViewRightPanel mViewRightPanel, ActionEvent actionEvent) {
        mViewRightPanel._parallelCheckBox_actionPerformed(actionEvent);
    }

    static void mav$_parallelValue_actionPerformed(MViewRightPanel mViewRightPanel, ActionEvent actionEvent) {
        mViewRightPanel._parallelValue_actionPerformed(actionEvent);
    }

    static void mav$_prebuiltCheckBox_actionPerformed(MViewRightPanel mViewRightPanel, ActionEvent actionEvent) {
        mViewRightPanel._prebuiltCheckBox_actionPerformed(actionEvent);
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MViewRightPanel.mav$_cacheCheck_actionPerformed(MViewRightPanel.this, actionEvent);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MViewRightPanel.mav$_useindexCheckBox_actionPerformed(MViewRightPanel.this, actionEvent);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MViewRightPanel.mav$_parallelCheckBox_actionPerformed(MViewRightPanel.this, actionEvent);
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MViewRightPanel.mav$_parallelValue_actionPerformed(MViewRightPanel.this, actionEvent);
        }
    }

    final class 5
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                MViewRightPanel.this.getToolkit().beep();
                keyEvent.consume();
            }
        }
    }

    final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MViewRightPanel.mav$_prebuiltCheckBox_actionPerformed(MViewRightPanel.this, actionEvent);
        }
    }
}

