/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.mview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class MViewLogHeader
extends DefaultTraversablePanel
implements ActionListener {
    private List<PanelLibrary.HeaderPanelListener> m_list;
    private final SchemaPicker _cmbOwner;
    private JComboBox _cmbMasterTable;
    boolean _create;
    boolean _firstInit;
    private boolean _listening;
    private SchemaObject _originalObject;
    private Schema[] _schemas;
    private MaterializedViewLog _schemaObject;
    private DBObjectProvider _pro;
    private SchemaObjectInfoVerifier _verifier;

    private void $init$() {
        this.m_list = new ArrayList<PanelLibrary.HeaderPanelListener>();
        this._cmbOwner = new SchemaPicker();
        this._cmbMasterTable = new JComboBox();
        this._create = true;
        this._firstInit = true;
        this._schemaObject = null;
        this._verifier = null;
    }

    public MViewLogHeader() {
        this.$init$();
        this.buildPanel((JPanel)((Object)this));
    }

    private void buildPanel(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this._cmbOwner.addActionListener(this);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._cmbOwner, (String)UIArb.getString(72));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        jPanel.add((Component)this._cmbOwner, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel();
        this._cmbMasterTable.addActionListener(this);
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._cmbMasterTable, (String)UIArb.getString(681));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15), 0, 0));
        jPanel.add((Component)this._cmbMasterTable, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private Schema[] validateSchemaPermissions(Schema[] schemaArray) {
        if (this._pro instanceof Database) {
            ArrayList<Schema> arrayList = new ArrayList<Schema>();
            String string = this._schemaObject.getType();
            int n = 0;
            while (n < schemaArray.length) {
                if (this._pro.hasPriviledge(string, schemaArray[n], this.isEditing() ? "MODIFY" : "CREATE")) {
                    arrayList.add(schemaArray[n]);
                }
                ++n;
            }
            return arrayList.toArray(new Schema[arrayList.size()]);
        }
        return schemaArray;
    }

    protected SchemaObjectInfoVerifier getVerifier() {
        return this._verifier;
    }

    protected SchemaPicker getSchemaPicker() {
        return this._cmbOwner;
    }

    protected DBObjectProvider getProvider() {
        return this._pro;
    }

    protected SchemaObject getSchemaObject() {
        return this._schemaObject;
    }

    protected boolean isEditing() {
        return this._originalObject != null;
    }

    protected void init(SchemaObject schemaObject, SchemaObject schemaObject2, SchemaObjectInfoVerifier schemaObjectInfoVerifier, DBObjectProvider dBObjectProvider, Schema[] schemaArray) {
        this._originalObject = schemaObject2;
        this._pro = dBObjectProvider;
        this._schemaObject = (MaterializedViewLog)schemaObject;
        this._schemas = schemaArray;
        this._verifier = schemaObjectInfoVerifier;
        boolean bl = this._create = schemaObject2 == null;
        if (this._create) {
            this._cmbOwner.init(this._pro, schemaObject.getSchema(), this.validateSchemaPermissions(this._schemas));
        } else {
            Schema[] schemaArray2 = new Schema[]{this._schemaObject.getSchema()};
            this._cmbOwner.init(this._pro, schemaObject.getSchema(), schemaArray2);
        }
        this.setupMasterTable();
        this._cmbOwner.setEditable(false);
        this._cmbMasterTable.setEditable(false);
        try {
            this.commit();
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
        this._listening = true;
    }

    public void commit() throws TraversalException {
        this._listening = false;
        Schema schema = this._schemaObject.getSchema();
        Schema schema2 = this._cmbOwner.getSchema();
        String string = this._schemaObject.getName();
        String string2 = (String)this._cmbMasterTable.getSelectedItem();
        if (schema != schema2) {
            HashMap<String, PropertyChangeEvent> hashMap = new HashMap<String, PropertyChangeEvent>(2);
            this._schemaObject.setSchema(schema2);
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this._schemaObject, "schema", schema, schema2);
            hashMap.put(propertyChangeEvent.getPropertyName(), propertyChangeEvent);
            this.setupMasterTable();
            string2 = (String)this._cmbMasterTable.getSelectedItem();
            this._schemaObject.setName(string2);
            this._schemaObject.setMaster(string2);
            string2 = (String)this._cmbMasterTable.getSelectedItem();
            PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(this._schemaObject, "name", string, string2);
            hashMap.put(propertyChangeEvent2.getPropertyName(), propertyChangeEvent2);
            DBObjectChange.firePropertiesChanged((SchemaObject)this._schemaObject, hashMap);
        } else if (string2 != null && !string2.equals(string)) {
            string2 = (String)this._cmbMasterTable.getSelectedItem();
            this._schemaObject.setName(string2);
            this._schemaObject.setMaster(string2);
            DBObjectChange.firePropertyChanged((SchemaObject)this._schemaObject, (PropertyChangeEvent)new PropertyChangeEvent(this._schemaObject, "name", string, string2));
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        Schema[] schemaArray = (Schema[])traversableContext.get("SchemaList");
        SchemaObject schemaObject = (SchemaObject)traversableContext.get("NewObject");
        SchemaObject schemaObject2 = (SchemaObject)traversableContext.get("OriginalObject");
        this.init(schemaObject, schemaObject2, null, dBObjectProvider, schemaArray);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._listening) {
            try {
                this.commit();
            }
            catch (TraversalException traversalException) {
                // empty catch block
            }
            this._listening = true;
        }
    }

    public final void addHeaderPanelListener(PanelLibrary.HeaderPanelListener headerPanelListener) {
        this.m_list.add(headerPanelListener);
    }

    public final boolean removeHeaderPanelListener(PanelLibrary.HeaderPanelListener headerPanelListener) {
        return this.m_list.remove(headerPanelListener);
    }

    protected final void changePanels(String string, Navigable[] navigableArray) throws TraversalException {
        for (PanelLibrary.HeaderPanelListener headerPanelListener : this.m_list) {
            headerPanelListener.panelSetChange(string, navigableArray);
        }
    }

    private void setupMasterTable() {
        this._cmbMasterTable.removeAllItems();
        if (this._create) {
            this._schemaObject.setName(null);
            this._schemaObject.setMaster(null);
            if (this._pro instanceof OracleDatabaseImpl) {
                QueryWrapper queryWrapper = new QueryWrapper((Database)this._pro, MaterializedViewLog.getCandidateTablesQuery(), new Object[]{this._schemaObject.getSchema()});
                try {
                    try {
                        ResultSet resultSet = queryWrapper.executeQuery();
                        while (resultSet.next()) {
                            this._cmbMasterTable.addItem(resultSet.getString(1));
                            if (this._schemaObject.getMaster() != null) continue;
                            this._schemaObject.setMaster(resultSet.getString(1));
                        }
                    }
                    catch (SQLException sQLException) {}
                }
                finally {
                    queryWrapper.close();
                }
            } else {
                Object[] objectArray = null;
                try {
                    objectArray = this._pro.listObjects("TABLE", this._schemaObject.getSchema());
                    Arrays.sort(objectArray);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                SchemaObject[] schemaObjectArray = null;
                String[] stringArray = new String[]{"MATERIALIZED VIEW LOG"};
                try {
                    schemaObjectArray = this._pro.listObjects(stringArray, this._schemaObject.getSchema());
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                int n = 0;
                while (n < objectArray.length) {
                    int n2 = 0;
                    while (n2 < schemaObjectArray.length) {
                        if (((String)objectArray[n]).equals(schemaObjectArray[n2].getName())) {
                            objectArray[n] = null;
                            break;
                        }
                        if (((String)objectArray[n]).equals(((MaterializedViewLog)schemaObjectArray[n2]).getLogTable())) {
                            objectArray[n] = null;
                            break;
                        }
                        ++n2;
                    }
                    ++n;
                }
                int n3 = 0;
                while (n3 < objectArray.length) {
                    if (objectArray[n3] != null) {
                        Object object;
                        Table table = null;
                        try {
                            table = (Table)this._pro.getObject("TABLE", this._schemaObject.getSchema(), (String)objectArray[n3]);
                        }
                        catch (DBException dBException) {
                            // empty catch block
                        }
                        if (table != null && (object = table.getProperty("TableType")) != Table.TableType.TRANSACTION_TEMP && object != Table.TableType.SESSION_TEMP && object != Table.TableType.EXTERNAL) {
                            this._cmbMasterTable.addItem(objectArray[n3]);
                        }
                    }
                    ++n3;
                }
            }
        } else {
            this._cmbMasterTable.addItem(this._schemaObject.getName());
        }
    }
}

