/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.mview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.MViewInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.MaterializedView;

public class MViewLeftPanel
extends JPanel
implements ListCellRenderer {
    private final String[] _typeStrings;
    private final String[] _periodStrings;
    private final String[] _withStrings;
    private MViewInfoVerifier m_verifier;
    private MaterializedView _mview;
    private JLabel _refreshPeriodLabel;
    private JComboBox _refreshPeriodComboBox;
    private JLabel _refreshMethodLabel;
    private JComboBox _refreshMethodComboBox;
    private JLabel _refreshWithLabel;
    private JComboBox _refreshWithComboBox;
    private Date _chosenDate;
    private DateFormat oracleDateFormat;
    private DateEditor _dateChooser;
    private DateEditor _nextDateChooser;
    private JLabel _refreshAtLabel;
    private JLabel _nextDateLabel;
    private JCheckBox _rollbackCheckBox;
    private ButtonGroup defaultUse;
    private JRadioButton _defaultRollbackRadio;
    private JRadioButton _useSpecificRadioButton;
    private JTextField _rollbackSegmentTextField;
    private ButtonGroup localMaster;
    private JRadioButton _localRollbackRadio;
    private JRadioButton _masterRollbackRadio;
    private JCheckBox _refreshUseConstraintCheckBox;
    private JRadioButton _enforcedRadioButton;
    private JRadioButton _trustedRadioButton;
    private ButtonGroup _conButtonGroup;
    private DefaultListCellRenderer m_rend;

    private void $init$() {
        this._typeStrings = new String[]{UIArb.getString(621), UIArb.getString(622), UIArb.getString(620), UIArb.getString(619)};
        this._periodStrings = new String[]{UIArb.getString(627), UIArb.getString(628), UIArb.getString(629), UIArb.getString(630)};
        this._withStrings = new String[]{"", UIArb.getString(624), UIArb.getString(625)};
        this.m_verifier = null;
        this._mview = null;
        this._refreshPeriodLabel = new JLabel();
        this._refreshPeriodComboBox = new JComboBox<MaterializedView.RefreshMode>(MaterializedView.RefreshMode.values());
        this._refreshMethodLabel = new JLabel();
        this._refreshMethodComboBox = new JComboBox<MaterializedView.RefreshMethod>(MaterializedView.RefreshMethod.values());
        this._refreshWithLabel = new JLabel();
        this._refreshWithComboBox = new JComboBox<String>(this._withStrings);
        this._chosenDate = new Date(3);
        this.oracleDateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        this._dateChooser = new DateEditor(this._chosenDate);
        this._nextDateChooser = new DateEditor(this._chosenDate);
        this._refreshAtLabel = new JLabel();
        this._nextDateLabel = new JLabel();
        this._rollbackCheckBox = new JCheckBox();
        this.defaultUse = new ButtonGroup();
        this._defaultRollbackRadio = new JRadioButton();
        this._useSpecificRadioButton = new JRadioButton();
        this._rollbackSegmentTextField = new JTextField();
        this.localMaster = new ButtonGroup();
        this._localRollbackRadio = new JRadioButton();
        this._masterRollbackRadio = new JRadioButton();
        this._refreshUseConstraintCheckBox = new JCheckBox();
        this._enforcedRadioButton = new JRadioButton();
        this._trustedRadioButton = new JRadioButton();
        this._conButtonGroup = new ButtonGroup();
    }

    public MViewLeftPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void init(DBObjectProvider dBObjectProvider, MaterializedView materializedView, MViewInfoVerifier mViewInfoVerifier, Schema[] schemaArray) {
        this.m_verifier = mViewInfoVerifier;
        this._mview = materializedView;
        this._refreshMethodComboBox.setSelectedItem(materializedView.getRefreshMethod());
        this._refreshPeriodComboBox.setSelectedItem(materializedView.getRefreshMode());
        MaterializedView.RefreshWith refreshWith = materializedView.getKeyType();
        if (this.m_verifier == null) {
            if (refreshWith == MaterializedView.RefreshWith.ROWID) {
                this._refreshWithComboBox.setSelectedItem(UIArb.getString(625));
            } else if (refreshWith == MaterializedView.RefreshWith.PRIMARY_KEY) {
                this._refreshWithComboBox.setSelectedItem(UIArb.getString(624));
            } else {
                this._refreshWithComboBox.setSelectedItem("");
            }
        } else {
            this.m_verifier.setupRefreshCombo(this._refreshWithComboBox, refreshWith);
        }
        this._refreshPeriodComboBox.setSelectedItem(materializedView.getRefreshMode());
        if (materializedView.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.NONE) {
            this._rollbackCheckBox.setSelected(false);
            this._masterRollbackRadio.setEnabled(false);
            this._localRollbackRadio.setEnabled(false);
            this._defaultRollbackRadio.setEnabled(false);
            this._useSpecificRadioButton.setEnabled(false);
            this._rollbackSegmentTextField.setEnabled(false);
            this._rollbackCheckBox.setEnabled(mViewInfoVerifier == null || mViewInfoVerifier.canRefreshUseRollback());
        } else {
            this._rollbackCheckBox.setEnabled(mViewInfoVerifier == null || mViewInfoVerifier.canRefreshUseRollback());
            this._rollbackCheckBox.setSelected(true);
            this._localRollbackRadio.setEnabled(mViewInfoVerifier == null || mViewInfoVerifier.canRefreshUseRollback());
            this._masterRollbackRadio.setEnabled(mViewInfoVerifier == null || mViewInfoVerifier.canRefreshUseRollback());
            this._useSpecificRadioButton.setEnabled(mViewInfoVerifier == null || mViewInfoVerifier.canRefreshUseRollback());
            this._defaultRollbackRadio.setEnabled(mViewInfoVerifier == null || mViewInfoVerifier.canRefreshUseRollback());
            this._rollbackSegmentTextField.setEnabled(false);
            if (materializedView.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.LOCAL) {
                this._localRollbackRadio.setSelected(true);
            } else {
                this._localRollbackRadio.setSelected(false);
            }
            if (materializedView.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.MASTER) {
                this._masterRollbackRadio.setSelected(true);
            } else {
                this._masterRollbackRadio.setSelected(false);
            }
            if (materializedView.getRollbackSegmentName() == null || materializedView.getRollbackSegmentName().trim().equals("")) {
                this._defaultRollbackRadio.setSelected(true);
            } else {
                this._defaultRollbackRadio.setSelected(false);
                this._useSpecificRadioButton.setSelected(true);
                this._rollbackSegmentTextField.setEnabled(mViewInfoVerifier == null || mViewInfoVerifier.canRefreshUseRollback());
                this._rollbackSegmentTextField.setText(materializedView.getRollbackSegmentName());
            }
        }
        MaterializedView.UsingConstraints usingConstraints = materializedView.getUsingConstraints();
        this._refreshUseConstraintCheckBox.setSelected(usingConstraints != null);
        this._refreshUseConstraintCheckBox.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshConstraints());
        this._enforcedRadioButton.setEnabled(this._refreshUseConstraintCheckBox.isSelected());
        this._trustedRadioButton.setEnabled(this._refreshUseConstraintCheckBox.isSelected());
        this._refreshWithLabel.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshType());
        this._refreshWithComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshType());
        this._refreshMethodLabel.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshMethod());
        this._refreshMethodComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshMethod());
        this._refreshPeriodLabel.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshWhen());
        this._refreshPeriodComboBox.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshWhen());
        if (usingConstraints == MaterializedView.UsingConstraints.TRUSTED) {
            this._trustedRadioButton.setSelected(true);
        } else {
            this._enforcedRadioButton.setSelected(true);
        }
        if (materializedView.getNextRefresh() != null) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                Date date = simpleDateFormat.parse(materializedView.getNextRefresh());
                this._dateChooser.setDate(date);
            }
            catch (ParseException parseException) {
                System.err.println(parseException.getMessage());
            }
        }
        if (materializedView.getInterval() != null) {
            // empty if block
        }
    }

    private Connection getConnection(DBObjectProvider dBObjectProvider) {
        Connection connection = null;
        if (dBObjectProvider instanceof Database) {
            connection = ((Database)dBObjectProvider).getConnection();
        }
        return connection;
    }

    public void commit(MaterializedView materializedView, Schema[] schemaArray, boolean bl) throws TraversalException {
        String string;
        materializedView.setRefreshMethod((MaterializedView.RefreshMethod)this._refreshMethodComboBox.getSelectedItem());
        MaterializedView.RefreshMode refreshMode = (MaterializedView.RefreshMode)this._refreshPeriodComboBox.getSelectedItem();
        materializedView.setRefreshMode(refreshMode);
        if (refreshMode == MaterializedView.RefreshMode.SPECIFY) {
            Date date = this.getStartDate();
            Date date2 = this.getNextDate();
            String string2 = this.oracleDateFormat.format(date);
            String string3 = this.oracleDateFormat.format(date2);
            String string4 = "dd-Mon-yyyy HH24:mi:ss";
            materializedView.setNextRefresh("TO_DATE('" + string2 + "','" + string4 + "') ");
            materializedView.setInterval("TO_DATE('" + string3 + "','" + string4 + "') ");
        }
        if ((string = this.getMethod()).equals(UIArb.getString(624))) {
            materializedView.setKeyType(MaterializedView.RefreshWith.PRIMARY_KEY);
        } else if (string.equals(UIArb.getString(625))) {
            materializedView.setKeyType(MaterializedView.RefreshWith.ROWID);
        } else {
            materializedView.setKeyType(MaterializedView.RefreshWith.UNSPECIFIED);
        }
        if (this._rollbackCheckBox.isSelected()) {
            if (this._localRollbackRadio.isSelected()) {
                materializedView.setRollbackSegmentType(MaterializedView.RollbackSegmentType.LOCAL);
            } else if (this._masterRollbackRadio.isSelected()) {
                materializedView.setRollbackSegmentType(MaterializedView.RollbackSegmentType.MASTER);
            }
            if (this._defaultRollbackRadio.isSelected()) {
                materializedView.setRollbackSegmentName(null);
            } else if (this._useSpecificRadioButton.isSelected()) {
                materializedView.setRollbackSegmentName(this._rollbackSegmentTextField.getText());
            }
        } else {
            materializedView.setRollbackSegmentName(null);
            materializedView.setRollbackSegmentType(MaterializedView.RollbackSegmentType.NONE);
        }
        if (this._refreshUseConstraintCheckBox.isSelected()) {
            if (this._enforcedRadioButton.isSelected()) {
                materializedView.setUsingConstraints(MaterializedView.UsingConstraints.ENFORCED);
            } else if (this._trustedRadioButton.isSelected()) {
                materializedView.setUsingConstraints(MaterializedView.UsingConstraints.TRUSTED);
            }
        } else {
            materializedView.setUsingConstraints(null);
        }
    }

    public String getMethod() {
        return (String)this._refreshWithComboBox.getSelectedItem();
    }

    public Date getStartDate() {
        return this._dateChooser.getDate();
    }

    public Date getNextDate() {
        return this._nextDateChooser.getDate();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.localMaster.add(this._localRollbackRadio);
        this.localMaster.add(this._masterRollbackRadio);
        this.defaultUse.add(this._defaultRollbackRadio);
        this.defaultUse.add(this._useSpecificRadioButton);
        this.setBorder(BorderFactory.createTitledBorder(UIArb.getString(642)));
        ResourceUtils.resLabel((JLabel)this._refreshPeriodLabel, (Component)this._refreshPeriodComboBox, (String)UIArb.getString(643));
        this._refreshPeriodComboBox.addActionListener(new 1());
        ResourceUtils.resLabel((JLabel)this._refreshMethodLabel, (Component)this._refreshMethodComboBox, (String)UIArb.getString(644));
        this._refreshMethodComboBox.setSelectedItem(MaterializedView.RefreshMethod.FAST);
        this._refreshMethodComboBox.removeItem(MaterializedView.RefreshMethod.NEVER);
        ResourceUtils.resLabel((JLabel)this._refreshWithLabel, (Component)this._refreshWithComboBox, (String)UIArb.getString(645));
        this._refreshWithComboBox.setSelectedIndex(0);
        this._dateChooser.setToolTipText(UIArb.getString(638));
        this._dateChooser.setDateFormat(this.oracleDateFormat);
        this._dateChooser.setEnabled(false);
        this._dateChooser.setDate(new Date());
        ResourceUtils.resLabel((JLabel)this._refreshAtLabel, (Component)this._dateChooser, (String)UIArb.getString(646));
        this._refreshAtLabel.setEnabled(false);
        this._nextDateChooser.setToolTipText(UIArb.getString(639));
        this._nextDateChooser.setDateFormat(this.oracleDateFormat);
        this._nextDateChooser.setEnabled(false);
        this._nextDateChooser.setDate(new Date());
        ResourceUtils.resLabel((JLabel)this._nextDateLabel, (Component)this._nextDateChooser, (String)UIArb.getString(647));
        this._nextDateLabel.setEnabled(false);
        ResourceUtils.resButton((AbstractButton)this._rollbackCheckBox, (String)UIArb.getString(648));
        this._rollbackCheckBox.addActionListener(new 2());
        ResourceUtils.resButton((AbstractButton)this._defaultRollbackRadio, (String)UIArb.getString(649));
        this._defaultRollbackRadio.addActionListener(new 3());
        this._defaultRollbackRadio.setEnabled(false);
        ResourceUtils.resButton((AbstractButton)this._useSpecificRadioButton, (String)UIArb.getString(650));
        this._useSpecificRadioButton.addActionListener(new 4());
        this._useSpecificRadioButton.setEnabled(false);
        this._rollbackSegmentTextField.setEnabled(false);
        ResourceUtils.resButton((AbstractButton)this._localRollbackRadio, (String)UIArb.getString(651));
        this._localRollbackRadio.setEnabled(false);
        ResourceUtils.resButton((AbstractButton)this._masterRollbackRadio, (String)UIArb.getString(652));
        this._masterRollbackRadio.setEnabled(false);
        ResourceUtils.resButton((AbstractButton)this._refreshUseConstraintCheckBox, (String)UIArb.getString(653));
        this._refreshUseConstraintCheckBox.addActionListener(new 5());
        ResourceUtils.resButton((AbstractButton)this._enforcedRadioButton, (String)UIArb.getString(654));
        ResourceUtils.resButton((AbstractButton)this._trustedRadioButton, (String)UIArb.getString(655));
        this._conButtonGroup.add(this._trustedRadioButton);
        this._conButtonGroup.add(this._enforcedRadioButton);
        this._trustedRadioButton.setEnabled(false);
        this._trustedRadioButton.addActionListener(new 6());
        this._enforcedRadioButton.setEnabled(false);
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, n, 1, 1, 0.7, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0);
        this.add((Component)this._refreshPeriodLabel, gridBagConstraints);
        this.add((Component)this._refreshPeriodComboBox, gridBagConstraints2);
        gridBagConstraints.gridy = ++n;
        gridBagConstraints2.gridy = n++;
        this.add((Component)this._refreshMethodLabel, gridBagConstraints);
        this.add((Component)this._refreshMethodComboBox, gridBagConstraints2);
        gridBagConstraints.gridy = n;
        gridBagConstraints2.gridy = n++;
        this.add((Component)this._refreshWithLabel, gridBagConstraints);
        this.add((Component)this._refreshWithComboBox, gridBagConstraints2);
        gridBagConstraints.gridy = n;
        gridBagConstraints2.gridy = n++;
        this.add((Component)this._refreshAtLabel, gridBagConstraints);
        this.add((Component)this._dateChooser, gridBagConstraints2);
        gridBagConstraints.gridy = n;
        gridBagConstraints2.gridy = n++;
        this.add((Component)this._nextDateLabel, gridBagConstraints);
        this.add((Component)this._nextDateChooser, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.insets.right = 5;
        this.add(Box.createHorizontalGlue(), gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, n, 3, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 0, 5), 0, 0);
        this.add((Component)this._rollbackCheckBox, gridBagConstraints3);
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this._masterRollbackRadio, gridBagConstraints4);
        gridBagConstraints4.gridx = 1;
        jPanel.add((Component)this._localRollbackRadio, gridBagConstraints4);
        gridBagConstraints4.insets.top = 10;
        gridBagConstraints4.gridy = 1;
        jPanel.add((Component)this._useSpecificRadioButton, gridBagConstraints4);
        gridBagConstraints4.gridx = 0;
        jPanel.add((Component)this._defaultRollbackRadio, gridBagConstraints4);
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.fill = 2;
        jPanel.add((Component)this._rollbackSegmentTextField, gridBagConstraints4);
        ++n;
        gridBagConstraints3.gridy = n++;
        gridBagConstraints3.insets.left = 15;
        gridBagConstraints3.insets.top = 5;
        this.add((Component)jPanel, gridBagConstraints3);
        JPanel jPanel2 = new JPanel();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0);
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints5.gridwidth = 2;
        jPanel2.add((Component)this._refreshUseConstraintCheckBox, gridBagConstraints5);
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.insets.left = 10;
        gridBagConstraints5.gridwidth = 1;
        jPanel2.add((Component)this._enforcedRadioButton, gridBagConstraints5);
        gridBagConstraints5.insets.left = 0;
        gridBagConstraints5.gridx = 1;
        jPanel2.add((Component)this._trustedRadioButton, gridBagConstraints5);
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.gridx = 2;
        jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints5);
        gridBagConstraints3.insets.left = 5;
        gridBagConstraints3.gridy = n++;
        gridBagConstraints3.insets.top = 15;
        this.add((Component)jPanel2, gridBagConstraints3);
        gridBagConstraints3.gridy = n;
        gridBagConstraints3.weighty = 1.0;
        this.add(Box.createVerticalGlue(), gridBagConstraints3);
    }

    private void _rollbackCheckBox_actionPerformed(ActionEvent actionEvent) {
        if (this._rollbackCheckBox.isSelected()) {
            this._defaultRollbackRadio.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            this._useSpecificRadioButton.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            this._localRollbackRadio.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            this._masterRollbackRadio.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            if (this._useSpecificRadioButton.isSelected()) {
                this._rollbackSegmentTextField.setEnabled(this.m_verifier == null || this.m_verifier.canRefreshUseRollback());
            }
        } else {
            this._defaultRollbackRadio.setEnabled(false);
            this._useSpecificRadioButton.setEnabled(false);
            this._localRollbackRadio.setEnabled(false);
            this._masterRollbackRadio.setEnabled(false);
            this._rollbackSegmentTextField.setEnabled(false);
        }
    }

    private void _useSpecificRadioButton_actionPerformed(ActionEvent actionEvent) {
        this._rollbackSegmentTextField.setEnabled(true);
    }

    private void _defaultRollbackRadio_actionPerformed(ActionEvent actionEvent) {
        this._rollbackSegmentTextField.setEnabled(false);
    }

    private void _useCheckContraints_actionPerformed(ActionEvent actionEvent) {
        if (this._refreshUseConstraintCheckBox.isSelected()) {
            this._enforcedRadioButton.setEnabled(true);
            this._trustedRadioButton.setEnabled(true);
        } else {
            this._enforcedRadioButton.setEnabled(false);
            this._trustedRadioButton.setEnabled(false);
        }
    }

    private void _refreshPeriodComboBox_actionPerformed(ActionEvent actionEvent) {
        if (this._refreshPeriodComboBox.getSelectedItem() == MaterializedView.RefreshMode.NEVER) {
            this._dateChooser.setEnabled(false);
            this._nextDateChooser.setEnabled(false);
            this._rollbackCheckBox.setSelected(false);
            this._rollbackCheckBox_actionPerformed(new ActionEvent(new Object(), 1, ""));
            this._refreshUseConstraintCheckBox.setSelected(false);
            this._useCheckContraints_actionPerformed(new ActionEvent(new Object(), 1, ""));
            this._rollbackCheckBox.setEnabled(false);
            this._refreshMethodComboBox.setEnabled(false);
            this._refreshWithLabel.setEnabled(false);
            this._refreshWithComboBox.setEnabled(false);
            this._rollbackCheckBox.setEnabled(false);
            this._refreshUseConstraintCheckBox.setEnabled(false);
            this._refreshMethodLabel.setEnabled(false);
        } else {
            this._rollbackCheckBox.setEnabled(true);
            this._refreshMethodComboBox.setEnabled(true);
            this._refreshWithLabel.setEnabled(true);
            this._refreshWithComboBox.setEnabled(true);
            this._rollbackCheckBox.setEnabled(true);
            this._refreshUseConstraintCheckBox.setEnabled(true);
            this._refreshMethodLabel.setEnabled(true);
            if (this._refreshPeriodComboBox.getSelectedItem() == MaterializedView.RefreshMode.SPECIFY) {
                this._dateChooser.setDate(new Date());
                this._dateChooser.setEnabled(true);
                this._nextDateChooser.setDate(new Date());
                this._nextDateChooser.setEnabled(true);
                this._nextDateLabel.setEnabled(true);
                this._refreshAtLabel.setEnabled(true);
            } else {
                this._dateChooser.setEnabled(false);
                this._nextDateChooser.setEnabled(false);
                this._nextDateLabel.setEnabled(false);
                this._refreshAtLabel.setEnabled(false);
            }
        }
    }

    private void _trustedRadioButton_actionPerformed(ActionEvent actionEvent) {
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (this.m_rend == null) {
            this.m_rend = new DefaultListCellRenderer();
        }
        if (object instanceof MaterializedView.RefreshMode) {
            switch (7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMode[((MaterializedView.RefreshMode)object).ordinal()]) {
                case 1: {
                    object = UIArb.getString(627);
                    break;
                }
                case 2: {
                    object = UIArb.getString(628);
                    break;
                }
                case 3: {
                    object = UIArb.getString(629);
                    break;
                }
                case 4: {
                    object = UIArb.getString(630);
                    break;
                }
            }
        } else if (object instanceof MaterializedView.RefreshMethod) {
            switch (7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMethod[((MaterializedView.RefreshMethod)object).ordinal()]) {
                case 1: {
                    object = UIArb.getString(622);
                    break;
                }
                case 2: {
                    object = UIArb.getString(620);
                    break;
                }
                case 3: {
                    object = UIArb.getString(621);
                    break;
                }
                default: {
                    object = UIArb.getString(619);
                }
            }
        }
        return this.m_rend.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
    }

    static void mav$_refreshPeriodComboBox_actionPerformed(MViewLeftPanel mViewLeftPanel, ActionEvent actionEvent) {
        mViewLeftPanel._refreshPeriodComboBox_actionPerformed(actionEvent);
    }

    static void mav$_rollbackCheckBox_actionPerformed(MViewLeftPanel mViewLeftPanel, ActionEvent actionEvent) {
        mViewLeftPanel._rollbackCheckBox_actionPerformed(actionEvent);
    }

    static void mav$_defaultRollbackRadio_actionPerformed(MViewLeftPanel mViewLeftPanel, ActionEvent actionEvent) {
        mViewLeftPanel._defaultRollbackRadio_actionPerformed(actionEvent);
    }

    static void mav$_useSpecificRadioButton_actionPerformed(MViewLeftPanel mViewLeftPanel, ActionEvent actionEvent) {
        mViewLeftPanel._useSpecificRadioButton_actionPerformed(actionEvent);
    }

    static void mav$_useCheckContraints_actionPerformed(MViewLeftPanel mViewLeftPanel, ActionEvent actionEvent) {
        mViewLeftPanel._useCheckContraints_actionPerformed(actionEvent);
    }

    static void mav$_trustedRadioButton_actionPerformed(MViewLeftPanel mViewLeftPanel, ActionEvent actionEvent) {
        mViewLeftPanel._trustedRadioButton_actionPerformed(actionEvent);
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MViewLeftPanel.mav$_refreshPeriodComboBox_actionPerformed(MViewLeftPanel.this, actionEvent);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MViewLeftPanel.mav$_rollbackCheckBox_actionPerformed(MViewLeftPanel.this, actionEvent);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MViewLeftPanel.mav$_defaultRollbackRadio_actionPerformed(MViewLeftPanel.this, actionEvent);
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MViewLeftPanel.mav$_useSpecificRadioButton_actionPerformed(MViewLeftPanel.this, actionEvent);
        }
    }

    final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MViewLeftPanel.mav$_useCheckContraints_actionPerformed(MViewLeftPanel.this, actionEvent);
        }
    }

    final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MViewLeftPanel.mav$_trustedRadioButton_actionPerformed(MViewLeftPanel.this, actionEvent);
        }
    }

    static class 7 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$ora$MaterializedView$RefreshMode;
        static final /* synthetic */ int[] $sm$oracle$javatools$db$ora$MaterializedView$RefreshMethod;

        static {
            int[] nArray = new int[MaterializedView.RefreshMethod.values().length];
            $sm$oracle$javatools$db$ora$MaterializedView$RefreshMethod = nArray;
            try {
                nArray[MaterializedView.RefreshMethod.COMPLETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMethod[MaterializedView.RefreshMethod.FORCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMethod[MaterializedView.RefreshMethod.FAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMethod[MaterializedView.RefreshMethod.NEVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            int[] nArray2 = new int[MaterializedView.RefreshMode.values().length];
            $sm$oracle$javatools$db$ora$MaterializedView$RefreshMode = nArray2;
            try {
                nArray2[MaterializedView.RefreshMode.DEMAND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMode[MaterializedView.RefreshMode.COMMIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMode[MaterializedView.RefreshMode.SPECIFY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$ora$MaterializedView$RefreshMode[MaterializedView.RefreshMode.NEVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

