/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.DBIcons;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.panels.CustomTabbedPanel;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;

public class TabbedEditorPanel
extends DefaultTraversablePanel
implements PanelLibrary.HeaderPanelListener {
    private Traversable m_top;
    protected Traversable m_middle;
    protected String m_startPage;
    private JPanel m_cardPanel;
    private CardLayout m_cardLayout;
    private Map<String, Traversable> m_mapPanelSets;
    private TraversableContext m_data;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.m_mapPanelSets = new HashMap<String, Traversable>();
    }

    protected TabbedEditorPanel(Traversable traversable, Navigable[] navigableArray, String string) {
        this.$init$();
        this.m_startPage = string;
        this.m_top = traversable;
        if (this.m_top instanceof PanelLibrary.HeaderPanel) {
            ((PanelLibrary.HeaderPanel)this.m_top).addHeaderPanelListener(this);
        }
        this.layoutComponents(this.createPanel(navigableArray));
    }

    protected Traversable createPanel(Navigable[] navigableArray) {
        CustomTabbedPanel customTabbedPanel = null;
        if (navigableArray != null) {
            if (navigableArray.length == 1 && navigableArray[0] != null) {
                customTabbedPanel = (DefaultTraversablePanel)navigableArray[0].newTraversable(null);
            } else if (navigableArray.length > 0) {
                customTabbedPanel = new CustomTabbedPanel(navigableArray);
            }
        }
        return customTabbedPanel;
    }

    public String getHelpID() {
        if (this.m_middle != null) {
            return this.m_middle.getHelpID();
        }
        return super.getHelpID();
    }

    private void layoutComponents(Traversable traversable) {
        this.setLayout(new BorderLayout(0, 10));
        if (this.m_top != null) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add(this.m_top.getComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
            JLabel jLabel = new JLabel();
            jLabel.setIcon(DBIcons.getIcon(4));
            jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
            if (traversable == null) {
                this.add(jPanel, "Center");
            } else {
                this.add(jPanel, "North");
            }
        }
        if (traversable != null) {
            this.m_cardLayout = new CardLayout();
            this.m_cardPanel = new JPanel(this.m_cardLayout);
            this.addPanelSet("DEFAULT_PANEL", traversable);
            this.add(this.m_cardPanel, "Center");
        }
    }

    private void addPanelSet(String string, Traversable traversable) {
        this.m_mapPanelSets.put(string, traversable);
        this.m_cardPanel.add(traversable.getComponent(), string);
    }

    private void showPanelSet(String string) throws TraversalException {
        Traversable traversable;
        if (this.m_middle != null) {
            this.m_middle.onExit(this.m_data);
        }
        if ((traversable = this.m_mapPanelSets.get(string)) == null) {
            if (!string.equals("DEFAULT_PANEL")) {
                throw new IllegalStateException("tried to show a non-existent panel set: " + string);
            }
        } else {
            this.m_middle = traversable;
            DBUtil.getLogger().info("Editor showing panel set " + string);
            this.m_cardLayout.show(this.m_cardPanel, string);
            this.enterPanel(traversable);
        }
    }

    protected void enterPanel(Traversable traversable) {
        traversable.onEntry(this.m_data);
    }

    static {
        $assertionsDisabled = TabbedEditorPanel.class.desiredAssertionStatus() ^ true;
    }

    public void onEntry(TraversableContext traversableContext) {
        block3: {
            this.m_data = traversableContext;
            this.enterPanel(this.m_top);
            if (this.m_middle == null) {
                try {
                    this.showPanelSet("DEFAULT_PANEL");
                }
                catch (TraversalException traversalException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)traversalException.getMessage());
                }
            }
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.m_middle != null) {
            this.m_middle.onExit(traversableContext);
        }
        this.m_top.onExit(traversableContext);
        try {
            this.commitToProvider(traversableContext);
        }
        catch (TraversalException traversalException) {
            this.enterPanel(this.m_top);
            if (this.m_middle != null) {
                this.enterPanel(this.m_middle);
            }
            throw traversalException;
        }
    }

    protected void commitToProvider(TraversableContext traversableContext) throws TraversalException {
        block13: {
            SchemaObject schemaObject = (SchemaObject)traversableContext.get("NewObject");
            SchemaObject schemaObject2 = (SchemaObject)traversableContext.get("OriginalObject");
            DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
            SchemaObject[] schemaObjectArray = (SchemaObject[])traversableContext.get("NewSecondaryDBObjects");
            if (schemaObject == null) {
                throw new IllegalArgumentException("cannot create/edit without an object");
            }
            if (dBObjectProvider == null) {
                throw new IllegalArgumentException("cannot create/edit without a provider");
            }
            boolean bl = schemaObject2 == null;
            try {
                Schema schema = schemaObject.getSchema();
                Schema schema2 = dBObjectProvider.getSchema(schema.getName());
                if (schema2 == null) {
                    dBObjectProvider.createSchema(schema, false);
                } else {
                    schemaObject.setSchema(schema2);
                }
                if (schemaObject2 == null) {
                    if (schemaObjectArray != null && schemaObjectArray.length > 0) {
                        SchemaObject[] schemaObjectArray2 = new SchemaObject[schemaObjectArray.length + 1];
                        schemaObjectArray2[0] = schemaObject;
                        System.arraycopy(schemaObjectArray, 0, schemaObjectArray2, 1, schemaObjectArray.length);
                        dBObjectProvider.createObjects(schemaObjectArray2, false);
                    } else {
                        dBObjectProvider.createObject(schemaObject, false);
                    }
                    break block13;
                }
                if (schemaObjectArray != null && schemaObjectArray.length > 0) {
                    Object[] objectArray = new SchemaObject[schemaObjectArray.length + 1];
                    Object[] objectArray2 = new SchemaObject[schemaObjectArray.length + 1];
                    objectArray[0] = schemaObject;
                    objectArray2[0] = schemaObject2;
                    int n = 1;
                    SchemaObject[] schemaObjectArray3 = schemaObjectArray;
                    int n2 = 0;
                    while (n2 < schemaObjectArray3.length) {
                        SchemaObject schemaObject3 = schemaObjectArray3[n2];
                        try {
                            objectArray[n] = schemaObject3;
                            objectArray2[n++] = dBObjectProvider.getObject(schemaObject3.getType(), schemaObject3.getSchema(), schemaObject3.getName());
                        }
                        catch (DBException dBException) {
                            // empty catch block
                        }
                        ++n2;
                    }
                    DiffEngine diffEngine = DiffEngine.getDiffEngine();
                    DiffContext diffContext = diffEngine.diff(objectArray, objectArray2);
                    dBObjectProvider.updateObjects(diffContext.getResult(), false);
                    break block13;
                }
                dBObjectProvider.updateObject(schemaObject2, schemaObject);
            }
            catch (DBException dBException) {
                this.processException(dBException, bl);
            }
        }
    }

    private void processException(DBException dBException, boolean bl) throws TraversalException {
        DBExceptionDialog.showErrorDialog((Component)IdeUtil.getMainWindow(), UIArb.getString(bl ? 75 : 74), dBException);
        throw new TraversalException(null);
    }

    public void panelSetChange(String string, Navigable[] navigableArray) throws TraversalException {
        if (!this.m_mapPanelSets.containsKey(string)) {
            Traversable traversable = this.createPanel(navigableArray);
            this.addPanelSet(string, traversable);
        }
        this.showPanelSet(string);
    }
}

