/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.SynonymInfoVerifier;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.ora.NameBasedRefID;
import oracle.javatools.dialogs.ExceptionDialog;

public class SynonymPanel
extends BaseInfoPanel
implements ActionListener {
    public static final String TABLESPACES_KEY = "Tablespaces";
    private static final String[] SYNONYM_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "SYNONYM"};
    private static final String FORSCHEMACHANGED = "ForSchemaChanged";
    private static final String OBJECTCHANGED = "ObjectChanged";
    private static final String SETOBJECTBASED = "SetObjectBased";
    private static final String SETNAMEBASED = "SetNameBased";
    protected DBObjectProvider m_prov;
    protected Synonym m_synonym;
    protected Schema m_forSchema;
    protected String m_savedName;
    private Schema[] m_schemas;
    private GridBagLayout layCenter;
    private JLabel m_lblFor;
    private JLabel m_lblForSchemaName;
    private JMultiLineLabel m_lblDanglingBlather;
    private SchemaPicker m_cmbForSchema;
    private JComboBox m_cmbObject;
    private JTextField m_txtName;
    private JRadioButton m_rdbObjectBased;
    private JRadioButton m_rdbNameBased;
    private ButtonGroup m_rbgBased;
    private DBObjectRenderer m_renderer;
    private static final DefaultComboBoxModel EMPTY_MDL_OBJECT = new NonNullableComboBoxModel();
    private Map m_schemaMap;
    private SynonymInfoVerifier m_verifier;
    private boolean m_isDefaultObject;
    private boolean m_isNewSynonymObject;
    private boolean m_active;
    private HashMap m_loadingSchemas;

    private void $init$() {
        this.m_prov = null;
        this.m_synonym = null;
        this.m_forSchema = null;
        this.m_savedName = null;
        this.m_schemas = null;
        this.layCenter = new GridBagLayout();
        this.m_lblFor = new JLabel();
        this.m_lblForSchemaName = new JLabel();
        this.m_lblDanglingBlather = new JMultiLineLabel();
        this.m_cmbForSchema = new SchemaPicker();
        this.m_cmbObject = new JComboBox();
        this.m_txtName = new JTextField();
        this.m_rdbObjectBased = new JRadioButton();
        this.m_rdbNameBased = new JRadioButton();
        this.m_rbgBased = new ButtonGroup();
        this.m_renderer = new DBObjectRenderer();
        this.m_schemaMap = new HashMap();
        this.m_isDefaultObject = true;
        this.m_isNewSynonymObject = true;
        this.m_active = false;
        this.m_loadingSchemas = new HashMap();
    }

    public SynonymPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layCenter);
        this.m_cmbForSchema.setActionCommand(FORSCHEMACHANGED);
        this.m_cmbForSchema.addActionListener(this);
        this.m_cmbForSchema.setEditable(false);
        this.m_cmbObject.setRenderer(this.m_renderer);
        this.m_cmbObject.setModel(EMPTY_MDL_OBJECT);
        this.m_cmbObject.setEditable(false);
        this.m_cmbObject.setActionCommand(OBJECTCHANGED);
        this.m_cmbObject.addActionListener(this);
        this.m_lblFor.setText(UIArb.getString(241));
        this.m_lblDanglingBlather.setPreferredAspectRatio(0.0f);
        ResourceUtils.resLabel((JLabel)this.m_lblForSchemaName, (Component)this.m_cmbForSchema, (String)UIArb.getString(242));
        ResourceUtils.resButton((AbstractButton)this.m_rdbObjectBased, (String)UIArb.getString(243));
        this.m_rdbObjectBased.setActionCommand(SETOBJECTBASED);
        this.m_rdbObjectBased.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_rdbNameBased, (String)UIArb.getString(244));
        this.m_rdbNameBased.setActionCommand(SETNAMEBASED);
        this.m_rdbNameBased.addActionListener(this);
        this.m_rbgBased.add(this.m_rdbObjectBased);
        this.m_rbgBased.add(this.m_rdbNameBased);
        this.setLayout(this.layCenter);
        int n = 0;
        this.add(this.m_lblFor, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblForSchemaName, new GridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.add(this.m_cmbForSchema, new GridBagConstraints(2, n, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add(this.m_rdbObjectBased, new GridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.add(this.m_cmbObject, new GridBagConstraints(2, n, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add(this.m_rdbNameBased, new GridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.add(this.m_txtName, new GridBagConstraints(2, n, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.m_lblDanglingBlather, new GridBagConstraints(1, ++n, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, ++n, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getHeaderTitle() {
        return UIArb.getString(239);
    }

    public String getHeaderDescription() {
        return UIArb.getString(240);
    }

    protected boolean isDangling(DBObjectID dBObjectID) {
        return false;
    }

    protected String getDanglingBlather() {
        return null;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_active = false;
        this.m_prov = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        this.m_synonym = (Synonym)traversableContext.find("NewObject");
        this.m_verifier = (SynonymInfoVerifier)traversableContext.find("SchemaObjectInfoVerifier");
        Schema[] schemaArray = (Schema[])traversableContext.find("SchemaList");
        this.init(this.m_synonym, this.m_verifier, schemaArray);
        this.m_active = true;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Synonym synonym = (Synonym)traversableContext.find("NewObject");
        if (synonym == null) {
            synonym = new Synonym();
        }
        Schema[] schemaArray = (Schema[])traversableContext.find("SchemaList");
        this.commit(synonym, schemaArray, traversableContext.getDirection() != 2);
        this.m_active = false;
    }

    private void init(Synonym synonym, SynonymInfoVerifier synonymInfoVerifier, Schema[] schemaArray) {
        super.init(this.m_prov, synonymInfoVerifier);
        this.m_schemas = schemaArray;
        this.m_renderer.setProvider(this.m_prov);
        if (this.isDangling(synonym.getReference())) {
            this.m_lblDanglingBlather.setText(this.getDanglingBlather());
        } else {
            this.m_lblDanglingBlather.setText(null);
        }
        this.m_forSchema = synonym.getSchema();
        boolean bl = true;
        DBObjectID dBObjectID = synonym.getReference();
        if (dBObjectID != null) {
            this.m_isNewSynonymObject = false;
            bl = dBObjectID instanceof NameBasedRefID;
            SchemaObject schemaObject = null;
            try {
                schemaObject = (SchemaObject)dBObjectID.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (schemaObject == null) {
                this.setForSchemaAndName(dBObjectID);
            } else {
                this.m_forSchema = schemaObject.getSchema();
            }
        }
        this.setEnabledFields(bl);
        SchemaObject schemaObject = null;
        if (dBObjectID != null) {
            try {
                DBObject dBObject = dBObjectID.resolveID();
                if (dBObject instanceof SchemaObject) {
                    schemaObject = (SchemaObject)dBObject;
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (schemaObject != null) {
            this.m_isDefaultObject = false;
            this.m_forSchema = schemaObject.getSchema();
        }
        if (bl) {
            this.m_cmbObject.setModel(EMPTY_MDL_OBJECT);
            this.m_txtName.setText(this.m_savedName);
        } else {
            if (!this.populateObjectField()) {
                bl = true;
            }
            if (this.m_cmbObject.getModel().getSize() < 1) {
                bl = true;
            }
            if (schemaObject != null) {
                this.m_cmbObject.setSelectedItem(schemaObject.getName());
            }
        }
        this.m_cmbForSchema.init(this.m_prov, this.m_forSchema, schemaArray);
        this.setEnabledFields(bl);
        this.m_lblFor.setEnabled(synonymInfoVerifier == null || synonymInfoVerifier.canChangeReference());
        this.m_lblForSchemaName.setEnabled(synonymInfoVerifier == null || synonymInfoVerifier.canChangeSchema());
        this.m_cmbForSchema.setEnabled(synonymInfoVerifier == null || synonymInfoVerifier.canChangeSchema());
        this.m_rdbNameBased.setEnabled(synonymInfoVerifier == null || synonymInfoVerifier.canChangeReference());
        this.m_rdbObjectBased.setEnabled(synonymInfoVerifier == null || synonymInfoVerifier.canChangeReference());
        this.m_cmbObject.setEnabled(!bl && (synonymInfoVerifier == null || synonymInfoVerifier.canChangeReference()));
        this.m_txtName.setEditable(bl && (synonymInfoVerifier == null || synonymInfoVerifier.canChangeReference()));
        this.m_txtName.setEnabled(bl && (synonymInfoVerifier == null || synonymInfoVerifier.canChangeReference()));
        this.m_isNewSynonymObject = false;
    }

    private void commit(Synonym synonym, Schema[] schemaArray, boolean bl) throws TraversalException {
        SynonymInfoVerifier synonymInfoVerifier = (SynonymInfoVerifier)this.getVerifier();
        this.m_forSchema = this.m_cmbForSchema.getSchema();
        String string = null;
        boolean bl2 = this.m_rdbObjectBased.isSelected();
        string = bl2 ? (String)this.m_cmbObject.getSelectedItem() : this.m_txtName.getText();
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(UIArb.getString(247));
        }
        SchemaObject schemaObject = this.findObject(string);
        if (bl2 && schemaObject != null) {
            synonym.setReference(schemaObject.getID());
        } else {
            NameBasedRefID nameBasedRefID = new NameBasedRefID(this.m_forSchema, string);
            synonym.setReference((DBObjectID)nameBasedRefID);
        }
        if (bl && synonymInfoVerifier != null) {
            synonymInfoVerifier.verifySynonym();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_active) {
            boolean bl = this.m_rdbNameBased.isSelected();
            if (FORSCHEMACHANGED.equals(actionEvent.getActionCommand())) {
                try {
                    this.m_forSchema = this.m_cmbForSchema.getSchema();
                    if (this.m_rdbObjectBased.isSelected() && !this.populateObjectField()) {
                        bl = true;
                    }
                }
                catch (TraversalException traversalException) {}
            } else if (OBJECTCHANGED.equals(actionEvent.getActionCommand())) {
                int n = this.m_cmbObject.getSelectedIndex();
                this.m_isDefaultObject = this.m_isNewSynonymObject || n == -1;
            } else if (SETOBJECTBASED.equals(actionEvent.getActionCommand())) {
                if (!this.populateObjectField()) {
                    bl = true;
                } else {
                    SchemaObject schemaObject;
                    this.m_savedName = this.m_txtName.getText();
                    if (ModelUtil.hasLength((String)this.m_savedName) && (schemaObject = this.findObject(this.m_savedName)) != null) {
                        this.m_cmbObject.setSelectedItem(schemaObject.getName());
                    }
                    this.m_txtName.setText(null);
                }
            } else {
                SchemaObject schemaObject = this.findObject((String)this.m_cmbObject.getSelectedItem());
                if (!this.m_isDefaultObject && schemaObject != null) {
                    this.m_txtName.setText(schemaObject.getName());
                } else if (this.m_savedName != null && this.m_savedName.length() > 0) {
                    this.m_txtName.setText(this.m_savedName);
                }
                bl = true;
            }
            this.setEnabledFields(bl);
        }
    }

    private void setEnabledFields(boolean bl) {
        this.m_rdbNameBased.setSelected(bl);
        this.m_rdbObjectBased.setSelected(bl ^ true);
        this.m_txtName.setEditable(bl);
        this.m_txtName.setEnabled(bl);
        this.m_cmbObject.setEnabled(bl ^ true);
    }

    private void getAllSynonymObjects(Schema schema) {
        try {
            SchemaObject[] schemaObjectArray = this.m_prov.listObjects(SYNONYM_TYPES, schema);
            SchemaObject schemaObject = this.m_verifier.getOriginalObject();
            String string = schemaObject != null ? schemaObject.getName() : null;
            Schema schema2 = schemaObject != null ? schemaObject.getSchema() : null;
            NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel();
            int n = 0;
            while (n < schemaObjectArray.length) {
                if (!(schemaObject != null && "SYNONYM".equals(schemaObjectArray[n].getType()) && ModelUtil.areEqual((Object)schema2, (Object)schema) && ModelUtil.areEqual((Object)string, (Object)schemaObjectArray[n].getName()))) {
                    nonNullableComboBoxModel.addElement(schemaObjectArray[n].getName());
                }
                ++n;
            }
            this.m_schemaMap.put(schema.getName(), nonNullableComboBoxModel);
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    private boolean setObjectModel(Schema schema) {
        DefaultComboBoxModel defaultComboBoxModel = null;
        if (this.m_verifier.canChangeReference()) {
            defaultComboBoxModel = (DefaultComboBoxModel)this.m_schemaMap.get(schema.getName());
        } else if (this.m_synonym != null) {
            defaultComboBoxModel = new NonNullableComboBoxModel();
            try {
                DBObject dBObject = this.m_synonym.getReference().resolveID();
                if (dBObject != null) {
                    defaultComboBoxModel.addElement(dBObject.getName());
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        this.m_cmbObject.setModel(defaultComboBoxModel != null ? defaultComboBoxModel : EMPTY_MDL_OBJECT);
        return defaultComboBoxModel != null;
    }

    private SchemaObject findObject(String string) {
        SchemaObject schemaObject = null;
        if (string != null) {
            int n = 0;
            while (n < SYNONYM_TYPES.length) {
                try {
                    schemaObject = this.m_prov.getObject(SYNONYM_TYPES[n], this.m_forSchema, string);
                    if (schemaObject != null) {
                        break;
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                ++n;
            }
        }
        return schemaObject;
    }

    private boolean populateObjectField() {
        Schema schema = this.m_forSchema;
        if (!this.m_schemaMap.containsKey(schema.getName())) {
            this.loadObjectModel(schema);
        }
        return this.setObjectModel(schema);
    }

    protected void setForSchemaAndName(DBObjectID dBObjectID) {
        if (dBObjectID instanceof NameBasedRefID) {
            NameBasedRefID nameBasedRefID = (NameBasedRefID)dBObjectID;
            String string = nameBasedRefID.getSchemaName();
            if (string != null) {
                try {
                    Schema schema = this.m_prov.getSchema(string);
                    this.m_forSchema = schema == null ? new Schema(string) : schema;
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            this.m_savedName = nameBasedRefID.getName();
        }
    }

    private void loadObjectModel(Schema schema) {
        if (!this.m_loadingSchemas.containsKey(schema.getName())) {
            ObjectModelLoader objectModelLoader = new ObjectModelLoader(schema);
            this.m_loadingSchemas.put(schema.getName(), objectModelLoader);
            objectModelLoader.execute();
        } else {
            ObjectModelLoader objectModelLoader = (ObjectModelLoader)this.m_loadingSchemas.get(schema.getName());
            if (objectModelLoader != null) {
                objectModelLoader.execute();
            }
        }
    }

    public String getTitle() {
        return UIArb.getString(248);
    }

    public String getProgressText() {
        return UIArb.getString(249);
    }

    static HashMap ra$m_loadingSchemas(SynonymPanel synonymPanel) {
        return synonymPanel.m_loadingSchemas;
    }

    static void mav$getAllSynonymObjects(SynonymPanel synonymPanel, Schema schema) {
        synonymPanel.getAllSynonymObjects(schema);
    }

    private class ObjectModelLoader
    implements Runnable {
        private Schema m_schema;
        private ProgressBar m_bar;

        public ObjectModelLoader() {
        }

        public ObjectModelLoader(Schema schema) {
            this.m_schema = schema;
        }

        public void execute() {
            if (SynonymPanel.this.m_prov instanceof Database) {
                this.m_bar = new ProgressBar((Component)Ide.getMainWindow(), SynonymPanel.this.getTitle(), (Runnable)this, true);
                this.m_bar.start(SynonymPanel.this.getProgressText(), this.m_schema.getName());
            } else {
                this.m_bar = null;
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProgressBar progressBar = this.m_bar;
            ObjectModelLoader objectModelLoader = this;
            synchronized (objectModelLoader) {
                if (SynonymPanel.ra$m_loadingSchemas(SynonymPanel.this).containsKey(this.m_schema.getName())) {
                    try {
                        SynonymPanel.mav$getAllSynonymObjects(SynonymPanel.this, this.m_schema);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)exception.getMessage());
                    }
                    SynonymPanel.ra$m_loadingSchemas(SynonymPanel.this).remove(this.m_schema.getName());
                }
                if (progressBar != null) {
                    progressBar.setDoneStatus();
                }
            }
        }
    }
}

